/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* An AAAA record.
*/
public class AaaaRecord {
    private String ipv6Address;
    
    /**
    * Required. Gets or sets the IPv6 address of this AAAA record in string
    * notation.
    * @return The Ipv6Address value.
    */
    public String getIpv6Address() {
        return this.ipv6Address;
    }
    
    /**
    * Required. Gets or sets the IPv6 address of this AAAA record in string
    * notation.
    * @param ipv6AddressValue The Ipv6Address value.
    */
    public void setIpv6Address(final String ipv6AddressValue) {
        this.ipv6Address = ipv6AddressValue;
    }
    
    /**
    * Initializes a new instance of the AaaaRecord class.
    *
    */
    public AaaaRecord() {
    }
    
    /**
    * Initializes a new instance of the AaaaRecord class with required
    * arguments.
    *
    * @param ipv6Address Gets or sets the IPv6 address of this AAAA record in
    * string notation.
    */
    public AaaaRecord(String ipv6Address) {
        if (ipv6Address == null) {
            throw new NullPointerException("ipv6Address");
        }
        this.setIpv6Address(ipv6Address);
    }
}
