/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* A CNAME record.
*/
public class CnameRecord {
    private String cname;
    
    /**
    * Required. Gets or sets the canonical name for this record without a
    * terminating dot.
    * @return The Cname value.
    */
    public String getCname() {
        return this.cname;
    }
    
    /**
    * Required. Gets or sets the canonical name for this record without a
    * terminating dot.
    * @param cnameValue The Cname value.
    */
    public void setCname(final String cnameValue) {
        this.cname = cnameValue;
    }
    
    /**
    * Initializes a new instance of the CnameRecord class.
    *
    */
    public CnameRecord() {
    }
    
    /**
    * Initializes a new instance of the CnameRecord class with required
    * arguments.
    *
    * @param cname Gets or sets the canonical name for this record without a
    * terminating dot.
    */
    public CnameRecord(String cname) {
        if (cname == null) {
            throw new NullPointerException("cname");
        }
        this.setCname(cname);
    }
}
