/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* An MX record.
*/
public class MxRecord {
    private String exchange;
    
    /**
    * Required. Gets or sets the domain name of the mail host, without a
    * terminating dot.
    * @return The Exchange value.
    */
    public String getExchange() {
        return this.exchange;
    }
    
    /**
    * Required. Gets or sets the domain name of the mail host, without a
    * terminating dot.
    * @param exchangeValue The Exchange value.
    */
    public void setExchange(final String exchangeValue) {
        this.exchange = exchangeValue;
    }
    
    private int preference;
    
    /**
    * Required. Gets or sets the preference metric for this record.
    * @return The Preference value.
    */
    public int getPreference() {
        return this.preference;
    }
    
    /**
    * Required. Gets or sets the preference metric for this record.
    * @param preferenceValue The Preference value.
    */
    public void setPreference(final int preferenceValue) {
        this.preference = preferenceValue;
    }
    
    /**
    * Initializes a new instance of the MxRecord class.
    *
    */
    public MxRecord() {
    }
    
    /**
    * Initializes a new instance of the MxRecord class with required arguments.
    *
    * @param preference Gets or sets the preference metric for this record.
    * @param exchange Gets or sets the domain name of the mail host, without a
    * terminating dot.
    */
    public MxRecord(int preference, String exchange) {
        if (exchange == null) {
            throw new NullPointerException("exchange");
        }
        this.setPreference(preference);
        this.setExchange(exchange);
    }
}
