/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* An NS record.
*/
public class NsRecord {
    private String nsdname;
    
    /**
    * Required. Gets or sets the name server name for this record, without a
    * terminating dot.
    * @return The Nsdname value.
    */
    public String getNsdname() {
        return this.nsdname;
    }
    
    /**
    * Required. Gets or sets the name server name for this record, without a
    * terminating dot.
    * @param nsdnameValue The Nsdname value.
    */
    public void setNsdname(final String nsdnameValue) {
        this.nsdname = nsdnameValue;
    }
    
    /**
    * Initializes a new instance of the NsRecord class.
    *
    */
    public NsRecord() {
    }
    
    /**
    * Initializes a new instance of the NsRecord class with required arguments.
    *
    * @param nsdname Gets or sets the name server name for this record, without
    * a terminating dot.
    */
    public NsRecord(String nsdname) {
        if (nsdname == null) {
            throw new NullPointerException("nsdname");
        }
        this.setNsdname(nsdname);
    }
}
