/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* Parameters supplied to create or update a RecordSet.
*/
public class RecordSetCreateOrUpdateParameters {
    private String ifNoneMatch;
    
    /**
    * Optional. Gets or sets the If-None-Match precondition. Set to '*' to
    * force Create-If-Not-Exist. Other values will be ignored.
    * @return The IfNoneMatch value.
    */
    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }
    
    /**
    * Optional. Gets or sets the If-None-Match precondition. Set to '*' to
    * force Create-If-Not-Exist. Other values will be ignored.
    * @param ifNoneMatchValue The IfNoneMatch value.
    */
    public void setIfNoneMatch(final String ifNoneMatchValue) {
        this.ifNoneMatch = ifNoneMatchValue;
    }
    
    private RecordSet recordSet;
    
    /**
    * Required. Gets or sets information about the RecordSet being created or
    * updated.
    * @return The RecordSet value.
    */
    public RecordSet getRecordSet() {
        return this.recordSet;
    }
    
    /**
    * Required. Gets or sets information about the RecordSet being created or
    * updated.
    * @param recordSetValue The RecordSet value.
    */
    public void setRecordSet(final RecordSet recordSetValue) {
        this.recordSet = recordSetValue;
    }
    
    /**
    * Initializes a new instance of the RecordSetCreateOrUpdateParameters class.
    *
    */
    public RecordSetCreateOrUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the RecordSetCreateOrUpdateParameters class
    * with required arguments.
    *
    * @param recordSet Gets or sets information about the RecordSet being
    * created or updated.
    */
    public RecordSetCreateOrUpdateParameters(RecordSet recordSet) {
        if (recordSet == null) {
            throw new NullPointerException("recordSet");
        }
        this.setRecordSet(recordSet);
    }
}
