/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;

/**
* The response to a RecordSet List operation.
*/
public class RecordSetListResponse extends OperationResponse {
    private String nextLink;
    
    /**
    * Optional. Gets or sets the continuation token for the next page.
    * @return The NextLink value.
    */
    public String getNextLink() {
        return this.nextLink;
    }
    
    /**
    * Optional. Gets or sets the continuation token for the next page.
    * @param nextLinkValue The NextLink value.
    */
    public void setNextLink(final String nextLinkValue) {
        this.nextLink = nextLinkValue;
    }
    
    private ArrayList<RecordSet> recordSets;
    
    /**
    * Required. Gets or sets information about the RecordSets in the response.
    * @return The RecordSets value.
    */
    public ArrayList<RecordSet> getRecordSets() {
        return this.recordSets;
    }
    
    /**
    * Required. Gets or sets information about the RecordSets in the response.
    * @param recordSetsValue The RecordSets value.
    */
    public void setRecordSets(final ArrayList<RecordSet> recordSetsValue) {
        this.recordSets = recordSetsValue;
    }
    
    /**
    * Initializes a new instance of the RecordSetListResponse class.
    *
    */
    public RecordSetListResponse() {
        super();
        this.setRecordSets(new LazyArrayList<RecordSet>());
    }
    
    /**
    * Initializes a new instance of the RecordSetListResponse class with
    * required arguments.
    *
    * @param recordSets Gets or sets information about the RecordSets in the
    * response.
    */
    public RecordSetListResponse(ArrayList<RecordSet> recordSets) {
        this();
        if (recordSets == null) {
            throw new NullPointerException("recordSets");
        }
        this.setRecordSets(recordSets);
    }
}
