/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

import java.util.ArrayList;

/**
* Represents the properties of the records in the RecordSet.
*/
public class RecordSetProperties {
    private ArrayList<AaaaRecord> aaaaRecords;
    
    /**
    * Optional. Gets or sets the list of AAAA records in the RecordSet.
    * @return The AaaaRecords value.
    */
    public ArrayList<AaaaRecord> getAaaaRecords() {
        return this.aaaaRecords;
    }
    
    /**
    * Optional. Gets or sets the list of AAAA records in the RecordSet.
    * @param aaaaRecordsValue The AaaaRecords value.
    */
    public void setAaaaRecords(final ArrayList<AaaaRecord> aaaaRecordsValue) {
        this.aaaaRecords = aaaaRecordsValue;
    }
    
    private ArrayList<ARecord> aRecords;
    
    /**
    * Optional. Gets or sets the list of A records in the RecordSet.
    * @return The ARecords value.
    */
    public ArrayList<ARecord> getARecords() {
        return this.aRecords;
    }
    
    /**
    * Optional. Gets or sets the list of A records in the RecordSet.
    * @param aRecordsValue The ARecords value.
    */
    public void setARecords(final ArrayList<ARecord> aRecordsValue) {
        this.aRecords = aRecordsValue;
    }
    
    private CnameRecord cnameRecord;
    
    /**
    * Optional. Gets or sets the CNAME record in the RecordSet.
    * @return The CnameRecord value.
    */
    public CnameRecord getCnameRecord() {
        return this.cnameRecord;
    }
    
    /**
    * Optional. Gets or sets the CNAME record in the RecordSet.
    * @param cnameRecordValue The CnameRecord value.
    */
    public void setCnameRecord(final CnameRecord cnameRecordValue) {
        this.cnameRecord = cnameRecordValue;
    }
    
    private ArrayList<MxRecord> mxRecords;
    
    /**
    * Optional. Gets or sets the list of MX records in the RecordSet.
    * @return The MxRecords value.
    */
    public ArrayList<MxRecord> getMxRecords() {
        return this.mxRecords;
    }
    
    /**
    * Optional. Gets or sets the list of MX records in the RecordSet.
    * @param mxRecordsValue The MxRecords value.
    */
    public void setMxRecords(final ArrayList<MxRecord> mxRecordsValue) {
        this.mxRecords = mxRecordsValue;
    }
    
    private ArrayList<NsRecord> nsRecords;
    
    /**
    * Optional. Gets or sets the list of NS records in the RecordSet.
    * @return The NsRecords value.
    */
    public ArrayList<NsRecord> getNsRecords() {
        return this.nsRecords;
    }
    
    /**
    * Optional. Gets or sets the list of NS records in the RecordSet.
    * @param nsRecordsValue The NsRecords value.
    */
    public void setNsRecords(final ArrayList<NsRecord> nsRecordsValue) {
        this.nsRecords = nsRecordsValue;
    }
    
    private ArrayList<PtrRecord> ptrRecords;
    
    /**
    * Optional. Gets or sets the list of PTR records in the RecordSet.
    * @return The PtrRecords value.
    */
    public ArrayList<PtrRecord> getPtrRecords() {
        return this.ptrRecords;
    }
    
    /**
    * Optional. Gets or sets the list of PTR records in the RecordSet.
    * @param ptrRecordsValue The PtrRecords value.
    */
    public void setPtrRecords(final ArrayList<PtrRecord> ptrRecordsValue) {
        this.ptrRecords = ptrRecordsValue;
    }
    
    private SoaRecord soaRecord;
    
    /**
    * Optional. Gets or sets the SOA record in the RecordSet.
    * @return The SoaRecord value.
    */
    public SoaRecord getSoaRecord() {
        return this.soaRecord;
    }
    
    /**
    * Optional. Gets or sets the SOA record in the RecordSet.
    * @param soaRecordValue The SoaRecord value.
    */
    public void setSoaRecord(final SoaRecord soaRecordValue) {
        this.soaRecord = soaRecordValue;
    }
    
    private ArrayList<SrvRecord> srvRecords;
    
    /**
    * Optional. Gets or sets the list of SRV records in the RecordSet.
    * @return The SrvRecords value.
    */
    public ArrayList<SrvRecord> getSrvRecords() {
        return this.srvRecords;
    }
    
    /**
    * Optional. Gets or sets the list of SRV records in the RecordSet.
    * @param srvRecordsValue The SrvRecords value.
    */
    public void setSrvRecords(final ArrayList<SrvRecord> srvRecordsValue) {
        this.srvRecords = srvRecordsValue;
    }
    
    private long ttl;
    
    /**
    * Required. Gets or sets the TTL of the records in the RecordSet.
    * @return The Ttl value.
    */
    public long getTtl() {
        return this.ttl;
    }
    
    /**
    * Required. Gets or sets the TTL of the records in the RecordSet.
    * @param ttlValue The Ttl value.
    */
    public void setTtl(final long ttlValue) {
        this.ttl = ttlValue;
    }
    
    private ArrayList<TxtRecord> txtRecords;
    
    /**
    * Optional. Gets or sets the list of TXT records in the RecordSet.
    * @return The TxtRecords value.
    */
    public ArrayList<TxtRecord> getTxtRecords() {
        return this.txtRecords;
    }
    
    /**
    * Optional. Gets or sets the list of TXT records in the RecordSet.
    * @param txtRecordsValue The TxtRecords value.
    */
    public void setTxtRecords(final ArrayList<TxtRecord> txtRecordsValue) {
        this.txtRecords = txtRecordsValue;
    }
    
    /**
    * Initializes a new instance of the RecordSetProperties class.
    *
    */
    public RecordSetProperties() {
    }
    
    /**
    * Initializes a new instance of the RecordSetProperties class with required
    * arguments.
    *
    * @param ttl Gets or sets the TTL of the records in the RecordSet.
    */
    public RecordSetProperties(long ttl) {
        this();
        this.setTtl(ttl);
    }
}
