/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* An SRV record.
*/
public class SrvRecord {
    private int port;
    
    /**
    * Required. Gets or sets the port of the service for this record.
    * @return The Port value.
    */
    public int getPort() {
        return this.port;
    }
    
    /**
    * Required. Gets or sets the port of the service for this record.
    * @param portValue The Port value.
    */
    public void setPort(final int portValue) {
        this.port = portValue;
    }
    
    private int priority;
    
    /**
    * Required. Gets or sets the priority metric for this record.
    * @return The Priority value.
    */
    public int getPriority() {
        return this.priority;
    }
    
    /**
    * Required. Gets or sets the priority metric for this record.
    * @param priorityValue The Priority value.
    */
    public void setPriority(final int priorityValue) {
        this.priority = priorityValue;
    }
    
    private String target;
    
    /**
    * Required. Gets or sets the domain name of the target for this record,
    * without a terminating dot.
    * @return The Target value.
    */
    public String getTarget() {
        return this.target;
    }
    
    /**
    * Required. Gets or sets the domain name of the target for this record,
    * without a terminating dot.
    * @param targetValue The Target value.
    */
    public void setTarget(final String targetValue) {
        this.target = targetValue;
    }
    
    private int weight;
    
    /**
    * Required. Gets or sets the weight metric for this this record.
    * @return The Weight value.
    */
    public int getWeight() {
        return this.weight;
    }
    
    /**
    * Required. Gets or sets the weight metric for this this record.
    * @param weightValue The Weight value.
    */
    public void setWeight(final int weightValue) {
        this.weight = weightValue;
    }
}
