/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* A TXT record.
*/
public class TxtRecord {
    private String value;
    
    /**
    * Required. Gets or sets the text value of this record.
    * @return The Value value.
    */
    public String getValue() {
        return this.value;
    }
    
    /**
    * Required. Gets or sets the text value of this record.
    * @param valueValue The Value value.
    */
    public void setValue(final String valueValue) {
        this.value = valueValue;
    }
    
    /**
    * Initializes a new instance of the TxtRecord class.
    *
    */
    public TxtRecord() {
    }
    
    /**
    * Initializes a new instance of the TxtRecord class with required arguments.
    *
    * @param value Gets or sets the text value of this record.
    */
    public TxtRecord(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.setValue(value);
    }
}
