/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

/**
* Parameters supplied to create a zone.
*/
public class ZoneCreateOrUpdateParameters {
    private String ifNoneMatch;
    
    /**
    * Optional. Gets or sets the If-None-Match precondition. Set to '*' to
    * force Create-If-Not-Exist. Other values will be ignored.
    * @return The IfNoneMatch value.
    */
    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }
    
    /**
    * Optional. Gets or sets the If-None-Match precondition. Set to '*' to
    * force Create-If-Not-Exist. Other values will be ignored.
    * @param ifNoneMatchValue The IfNoneMatch value.
    */
    public void setIfNoneMatch(final String ifNoneMatchValue) {
        this.ifNoneMatch = ifNoneMatchValue;
    }
    
    private Zone zone;
    
    /**
    * Required. Gets or sets information about the zone being created or
    * updated.
    * @return The Zone value.
    */
    public Zone getZone() {
        return this.zone;
    }
    
    /**
    * Required. Gets or sets information about the zone being created or
    * updated.
    * @param zoneValue The Zone value.
    */
    public void setZone(final Zone zoneValue) {
        this.zone = zoneValue;
    }
    
    /**
    * Initializes a new instance of the ZoneCreateOrUpdateParameters class.
    *
    */
    public ZoneCreateOrUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the ZoneCreateOrUpdateParameters class with
    * required arguments.
    *
    * @param zone Gets or sets information about the zone being created or
    * updated.
    */
    public ZoneCreateOrUpdateParameters(Zone zone) {
        if (zone == null) {
            throw new NullPointerException("zone");
        }
        this.setZone(zone);
    }
}
