/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;

/**
* The response to a Zone List or ListAll operation.
*/
public class ZoneListResponse extends OperationResponse {
    private String nextLink;
    
    /**
    * Optional. Gets or sets the continuation token for the next page.
    * @return The NextLink value.
    */
    public String getNextLink() {
        return this.nextLink;
    }
    
    /**
    * Optional. Gets or sets the continuation token for the next page.
    * @param nextLinkValue The NextLink value.
    */
    public void setNextLink(final String nextLinkValue) {
        this.nextLink = nextLinkValue;
    }
    
    private ArrayList<Zone> zones;
    
    /**
    * Required. Gets or sets information about the zones in the response.
    * @return The Zones value.
    */
    public ArrayList<Zone> getZones() {
        return this.zones;
    }
    
    /**
    * Required. Gets or sets information about the zones in the response.
    * @param zonesValue The Zones value.
    */
    public void setZones(final ArrayList<Zone> zonesValue) {
        this.zones = zonesValue;
    }
    
    /**
    * Initializes a new instance of the ZoneListResponse class.
    *
    */
    public ZoneListResponse() {
        super();
        this.setZones(new LazyArrayList<Zone>());
    }
    
    /**
    * Initializes a new instance of the ZoneListResponse class with required
    * arguments.
    *
    * @param zones Gets or sets information about the zones in the response.
    */
    public ZoneListResponse(ArrayList<Zone> zones) {
        this();
        if (zones == null) {
            throw new NullPointerException("zones");
        }
        this.setZones(zones);
    }
}
