/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.ApplicationGateway;
import com.microsoft.azure.management.network.models.ApplicationGatewayBackendAddress;
import com.microsoft.azure.management.network.models.ApplicationGatewayBackendAddressPool;
import com.microsoft.azure.management.network.models.ApplicationGatewayBackendHttpSettings;
import com.microsoft.azure.management.network.models.ApplicationGatewayFrontendIPConfiguration;
import com.microsoft.azure.management.network.models.ApplicationGatewayFrontendPort;
import com.microsoft.azure.management.network.models.ApplicationGatewayGetResponse;
import com.microsoft.azure.management.network.models.ApplicationGatewayHttpListener;
import com.microsoft.azure.management.network.models.ApplicationGatewayIPConfiguration;
import com.microsoft.azure.management.network.models.ApplicationGatewayListResponse;
import com.microsoft.azure.management.network.models.ApplicationGatewayPutResponse;
import com.microsoft.azure.management.network.models.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.models.ApplicationGatewaySku;
import com.microsoft.azure.management.network.models.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayPutResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations managing the
* application gateways for your subscription.
*/
public class ApplicationGatewayOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, ApplicationGatewayOperations {
    /**
    * Initializes a new instance of the ApplicationGatewayOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ApplicationGatewayOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put ApplicationGateway operation creates/updates a ApplicationGateway
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * ApplicationGateway.
    * @param parameters Required. Parameters supplied to the create/delete
    * ApplicationGateway operation
    * @return Response of Put ApplicationGateway operation
    */
    @Override
    public Future<ApplicationGatewayPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String applicationGatewayName, final ApplicationGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayPutResponse>() { 
            @Override
            public ApplicationGatewayPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, applicationGatewayName, parameters);
            }
         });
    }
    
    /**
    * The Put ApplicationGateway operation creates/updates a ApplicationGateway
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * ApplicationGateway.
    * @param parameters Required. Parameters supplied to the create/delete
    * ApplicationGateway operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of Put ApplicationGateway operation
    */
    @Override
    public ApplicationGatewayPutResponse beginCreateOrUpdating(String resourceGroupName, String applicationGatewayName, ApplicationGateway parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode applicationGatewayJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = applicationGatewayJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) applicationGatewayJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getSku() != null) {
            ObjectNode skuValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("sku", skuValue);
            
            if (parameters.getSku().getName() != null) {
                ((ObjectNode) skuValue).put("name", parameters.getSku().getName());
            }
            
            if (parameters.getSku().getTier() != null) {
                ((ObjectNode) skuValue).put("tier", parameters.getSku().getTier());
            }
            
            ((ObjectNode) skuValue).put("capacity", parameters.getSku().getCapacity());
        }
        
        if (parameters.getOperationalState() != null) {
            ((ObjectNode) propertiesValue).put("operationalState", parameters.getOperationalState());
        }
        
        if (parameters.getGatewayIPConfigurations() != null) {
            if (parameters.getGatewayIPConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getGatewayIPConfigurations()).isInitialized()) {
                ArrayNode gatewayIPConfigurationsArray = objectMapper.createArrayNode();
                for (ApplicationGatewayIPConfiguration gatewayIPConfigurationsItem : parameters.getGatewayIPConfigurations()) {
                    ObjectNode applicationGatewayIPConfigurationJsonFormatValue = objectMapper.createObjectNode();
                    gatewayIPConfigurationsArray.add(applicationGatewayIPConfigurationJsonFormatValue);
                    
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewayIPConfigurationJsonFormatValue).put("properties", propertiesValue2);
                    
                    if (gatewayIPConfigurationsItem.getSubnet() != null) {
                        ObjectNode subnetValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("subnet", subnetValue);
                        
                        if (gatewayIPConfigurationsItem.getSubnet().getId() != null) {
                            ((ObjectNode) subnetValue).put("id", gatewayIPConfigurationsItem.getSubnet().getId());
                        }
                    }
                    
                    if (gatewayIPConfigurationsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue2).put("provisioningState", gatewayIPConfigurationsItem.getProvisioningState());
                    }
                    
                    if (gatewayIPConfigurationsItem.getName() != null) {
                        ((ObjectNode) applicationGatewayIPConfigurationJsonFormatValue).put("name", gatewayIPConfigurationsItem.getName());
                    }
                    
                    if (gatewayIPConfigurationsItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewayIPConfigurationJsonFormatValue).put("etag", gatewayIPConfigurationsItem.getEtag());
                    }
                    
                    if (gatewayIPConfigurationsItem.getId() != null) {
                        ((ObjectNode) applicationGatewayIPConfigurationJsonFormatValue).put("id", gatewayIPConfigurationsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("gatewayIPConfigurations", gatewayIPConfigurationsArray);
            }
        }
        
        if (parameters.getSslCertificates() != null) {
            if (parameters.getSslCertificates() instanceof LazyCollection == false || ((LazyCollection) parameters.getSslCertificates()).isInitialized()) {
                ArrayNode sslCertificatesArray = objectMapper.createArrayNode();
                for (ApplicationGatewaySslCertificate sslCertificatesItem : parameters.getSslCertificates()) {
                    ObjectNode applicationGatewaySslCertificateJsonFormatValue = objectMapper.createObjectNode();
                    sslCertificatesArray.add(applicationGatewaySslCertificateJsonFormatValue);
                    
                    ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewaySslCertificateJsonFormatValue).put("properties", propertiesValue3);
                    
                    if (sslCertificatesItem.getData() != null) {
                        ((ObjectNode) propertiesValue3).put("data", sslCertificatesItem.getData());
                    }
                    
                    if (sslCertificatesItem.getPassword() != null) {
                        ((ObjectNode) propertiesValue3).put("password", sslCertificatesItem.getPassword());
                    }
                    
                    if (sslCertificatesItem.getPublicCertData() != null) {
                        ((ObjectNode) propertiesValue3).put("publicCertData", sslCertificatesItem.getPublicCertData());
                    }
                    
                    if (sslCertificatesItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue3).put("provisioningState", sslCertificatesItem.getProvisioningState());
                    }
                    
                    if (sslCertificatesItem.getName() != null) {
                        ((ObjectNode) applicationGatewaySslCertificateJsonFormatValue).put("name", sslCertificatesItem.getName());
                    }
                    
                    if (sslCertificatesItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewaySslCertificateJsonFormatValue).put("etag", sslCertificatesItem.getEtag());
                    }
                    
                    if (sslCertificatesItem.getId() != null) {
                        ((ObjectNode) applicationGatewaySslCertificateJsonFormatValue).put("id", sslCertificatesItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("sslCertificates", sslCertificatesArray);
            }
        }
        
        if (parameters.getFrontendIPConfigurations() != null) {
            if (parameters.getFrontendIPConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getFrontendIPConfigurations()).isInitialized()) {
                ArrayNode frontendIPConfigurationsArray = objectMapper.createArrayNode();
                for (ApplicationGatewayFrontendIPConfiguration frontendIPConfigurationsItem : parameters.getFrontendIPConfigurations()) {
                    ObjectNode applicationGatewayFrontendIPConfigurationJsonFormatValue = objectMapper.createObjectNode();
                    frontendIPConfigurationsArray.add(applicationGatewayFrontendIPConfigurationJsonFormatValue);
                    
                    ObjectNode propertiesValue4 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewayFrontendIPConfigurationJsonFormatValue).put("properties", propertiesValue4);
                    
                    if (frontendIPConfigurationsItem.getPrivateIPAddress() != null) {
                        ((ObjectNode) propertiesValue4).put("privateIPAddress", frontendIPConfigurationsItem.getPrivateIPAddress());
                    }
                    
                    if (frontendIPConfigurationsItem.getPrivateIPAllocationMethod() != null) {
                        ((ObjectNode) propertiesValue4).put("privateIPAllocationMethod", frontendIPConfigurationsItem.getPrivateIPAllocationMethod());
                    }
                    
                    if (frontendIPConfigurationsItem.getSubnet() != null) {
                        ObjectNode subnetValue2 = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue4).put("subnet", subnetValue2);
                        
                        if (frontendIPConfigurationsItem.getSubnet().getId() != null) {
                            ((ObjectNode) subnetValue2).put("id", frontendIPConfigurationsItem.getSubnet().getId());
                        }
                    }
                    
                    if (frontendIPConfigurationsItem.getPublicIPAddress() != null) {
                        ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue4).put("publicIPAddress", publicIPAddressValue);
                        
                        if (frontendIPConfigurationsItem.getPublicIPAddress().getId() != null) {
                            ((ObjectNode) publicIPAddressValue).put("id", frontendIPConfigurationsItem.getPublicIPAddress().getId());
                        }
                    }
                    
                    if (frontendIPConfigurationsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue4).put("provisioningState", frontendIPConfigurationsItem.getProvisioningState());
                    }
                    
                    if (frontendIPConfigurationsItem.getName() != null) {
                        ((ObjectNode) applicationGatewayFrontendIPConfigurationJsonFormatValue).put("name", frontendIPConfigurationsItem.getName());
                    }
                    
                    if (frontendIPConfigurationsItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewayFrontendIPConfigurationJsonFormatValue).put("etag", frontendIPConfigurationsItem.getEtag());
                    }
                    
                    if (frontendIPConfigurationsItem.getId() != null) {
                        ((ObjectNode) applicationGatewayFrontendIPConfigurationJsonFormatValue).put("id", frontendIPConfigurationsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("frontendIPConfigurations", frontendIPConfigurationsArray);
            }
        }
        
        if (parameters.getFrontendPorts() != null) {
            if (parameters.getFrontendPorts() instanceof LazyCollection == false || ((LazyCollection) parameters.getFrontendPorts()).isInitialized()) {
                ArrayNode frontendPortsArray = objectMapper.createArrayNode();
                for (ApplicationGatewayFrontendPort frontendPortsItem : parameters.getFrontendPorts()) {
                    ObjectNode applicationGatewayFrontendPortJsonFormatValue = objectMapper.createObjectNode();
                    frontendPortsArray.add(applicationGatewayFrontendPortJsonFormatValue);
                    
                    ObjectNode propertiesValue5 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewayFrontendPortJsonFormatValue).put("properties", propertiesValue5);
                    
                    ((ObjectNode) propertiesValue5).put("port", frontendPortsItem.getPort());
                    
                    if (frontendPortsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue5).put("provisioningState", frontendPortsItem.getProvisioningState());
                    }
                    
                    if (frontendPortsItem.getName() != null) {
                        ((ObjectNode) applicationGatewayFrontendPortJsonFormatValue).put("name", frontendPortsItem.getName());
                    }
                    
                    if (frontendPortsItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewayFrontendPortJsonFormatValue).put("etag", frontendPortsItem.getEtag());
                    }
                    
                    if (frontendPortsItem.getId() != null) {
                        ((ObjectNode) applicationGatewayFrontendPortJsonFormatValue).put("id", frontendPortsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("frontendPorts", frontendPortsArray);
            }
        }
        
        if (parameters.getBackendAddressPools() != null) {
            if (parameters.getBackendAddressPools() instanceof LazyCollection == false || ((LazyCollection) parameters.getBackendAddressPools()).isInitialized()) {
                ArrayNode backendAddressPoolsArray = objectMapper.createArrayNode();
                for (ApplicationGatewayBackendAddressPool backendAddressPoolsItem : parameters.getBackendAddressPools()) {
                    ObjectNode applicationGatewayBackendAddressPoolJsonFormatValue = objectMapper.createObjectNode();
                    backendAddressPoolsArray.add(applicationGatewayBackendAddressPoolJsonFormatValue);
                    
                    ObjectNode propertiesValue6 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewayBackendAddressPoolJsonFormatValue).put("properties", propertiesValue6);
                    
                    if (backendAddressPoolsItem.getBackendIPConfigurations() != null) {
                        if (backendAddressPoolsItem.getBackendIPConfigurations() instanceof LazyCollection == false || ((LazyCollection) backendAddressPoolsItem.getBackendIPConfigurations()).isInitialized()) {
                            ArrayNode backendIPConfigurationsArray = objectMapper.createArrayNode();
                            for (ResourceId backendIPConfigurationsItem : backendAddressPoolsItem.getBackendIPConfigurations()) {
                                ObjectNode resourceIdValue = objectMapper.createObjectNode();
                                backendIPConfigurationsArray.add(resourceIdValue);
                                
                                if (backendIPConfigurationsItem.getId() != null) {
                                    ((ObjectNode) resourceIdValue).put("id", backendIPConfigurationsItem.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue6).put("backendIPConfigurations", backendIPConfigurationsArray);
                        }
                    }
                    
                    if (backendAddressPoolsItem.getBackendAddresses() != null) {
                        if (backendAddressPoolsItem.getBackendAddresses() instanceof LazyCollection == false || ((LazyCollection) backendAddressPoolsItem.getBackendAddresses()).isInitialized()) {
                            ArrayNode backendAddressesArray = objectMapper.createArrayNode();
                            for (ApplicationGatewayBackendAddress backendAddressesItem : backendAddressPoolsItem.getBackendAddresses()) {
                                ObjectNode applicationGatewayBackendAddressValue = objectMapper.createObjectNode();
                                backendAddressesArray.add(applicationGatewayBackendAddressValue);
                                
                                if (backendAddressesItem.getFqdn() != null) {
                                    ((ObjectNode) applicationGatewayBackendAddressValue).put("fqdn", backendAddressesItem.getFqdn());
                                }
                                
                                if (backendAddressesItem.getIpAddress() != null) {
                                    ((ObjectNode) applicationGatewayBackendAddressValue).put("ipAddress", backendAddressesItem.getIpAddress());
                                }
                            }
                            ((ObjectNode) propertiesValue6).put("backendAddresses", backendAddressesArray);
                        }
                    }
                    
                    if (backendAddressPoolsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue6).put("provisioningState", backendAddressPoolsItem.getProvisioningState());
                    }
                    
                    if (backendAddressPoolsItem.getName() != null) {
                        ((ObjectNode) applicationGatewayBackendAddressPoolJsonFormatValue).put("name", backendAddressPoolsItem.getName());
                    }
                    
                    if (backendAddressPoolsItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewayBackendAddressPoolJsonFormatValue).put("etag", backendAddressPoolsItem.getEtag());
                    }
                    
                    if (backendAddressPoolsItem.getId() != null) {
                        ((ObjectNode) applicationGatewayBackendAddressPoolJsonFormatValue).put("id", backendAddressPoolsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("backendAddressPools", backendAddressPoolsArray);
            }
        }
        
        if (parameters.getBackendHttpSettingsCollection() != null) {
            if (parameters.getBackendHttpSettingsCollection() instanceof LazyCollection == false || ((LazyCollection) parameters.getBackendHttpSettingsCollection()).isInitialized()) {
                ArrayNode backendHttpSettingsCollectionArray = objectMapper.createArrayNode();
                for (ApplicationGatewayBackendHttpSettings backendHttpSettingsCollectionItem : parameters.getBackendHttpSettingsCollection()) {
                    ObjectNode applicationGatewayBackendHttpSettingsJsonFormatValue = objectMapper.createObjectNode();
                    backendHttpSettingsCollectionArray.add(applicationGatewayBackendHttpSettingsJsonFormatValue);
                    
                    ObjectNode propertiesValue7 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewayBackendHttpSettingsJsonFormatValue).put("properties", propertiesValue7);
                    
                    ((ObjectNode) propertiesValue7).put("port", backendHttpSettingsCollectionItem.getPort());
                    
                    if (backendHttpSettingsCollectionItem.getProtocol() != null) {
                        ((ObjectNode) propertiesValue7).put("protocol", backendHttpSettingsCollectionItem.getProtocol());
                    }
                    
                    if (backendHttpSettingsCollectionItem.getCookieBasedAffinity() != null) {
                        ((ObjectNode) propertiesValue7).put("cookieBasedAffinity", backendHttpSettingsCollectionItem.getCookieBasedAffinity());
                    }
                    
                    if (backendHttpSettingsCollectionItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue7).put("provisioningState", backendHttpSettingsCollectionItem.getProvisioningState());
                    }
                    
                    if (backendHttpSettingsCollectionItem.getName() != null) {
                        ((ObjectNode) applicationGatewayBackendHttpSettingsJsonFormatValue).put("name", backendHttpSettingsCollectionItem.getName());
                    }
                    
                    if (backendHttpSettingsCollectionItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewayBackendHttpSettingsJsonFormatValue).put("etag", backendHttpSettingsCollectionItem.getEtag());
                    }
                    
                    if (backendHttpSettingsCollectionItem.getId() != null) {
                        ((ObjectNode) applicationGatewayBackendHttpSettingsJsonFormatValue).put("id", backendHttpSettingsCollectionItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("backendHttpSettingsCollection", backendHttpSettingsCollectionArray);
            }
        }
        
        if (parameters.getHttpListeners() != null) {
            if (parameters.getHttpListeners() instanceof LazyCollection == false || ((LazyCollection) parameters.getHttpListeners()).isInitialized()) {
                ArrayNode httpListenersArray = objectMapper.createArrayNode();
                for (ApplicationGatewayHttpListener httpListenersItem : parameters.getHttpListeners()) {
                    ObjectNode applicationGatewayHttpListenerJsonFormatValue = objectMapper.createObjectNode();
                    httpListenersArray.add(applicationGatewayHttpListenerJsonFormatValue);
                    
                    ObjectNode propertiesValue8 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewayHttpListenerJsonFormatValue).put("properties", propertiesValue8);
                    
                    if (httpListenersItem.getFrontendIPConfiguration() != null) {
                        ObjectNode frontendIPConfigurationValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue8).put("frontendIPConfiguration", frontendIPConfigurationValue);
                        
                        if (httpListenersItem.getFrontendIPConfiguration().getId() != null) {
                            ((ObjectNode) frontendIPConfigurationValue).put("id", httpListenersItem.getFrontendIPConfiguration().getId());
                        }
                    }
                    
                    if (httpListenersItem.getFrontendPort() != null) {
                        ObjectNode frontendPortValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue8).put("frontendPort", frontendPortValue);
                        
                        if (httpListenersItem.getFrontendPort().getId() != null) {
                            ((ObjectNode) frontendPortValue).put("id", httpListenersItem.getFrontendPort().getId());
                        }
                    }
                    
                    if (httpListenersItem.getProtocol() != null) {
                        ((ObjectNode) propertiesValue8).put("protocol", httpListenersItem.getProtocol());
                    }
                    
                    if (httpListenersItem.getSslCertificate() != null) {
                        ObjectNode sslCertificateValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue8).put("sslCertificate", sslCertificateValue);
                        
                        if (httpListenersItem.getSslCertificate().getId() != null) {
                            ((ObjectNode) sslCertificateValue).put("id", httpListenersItem.getSslCertificate().getId());
                        }
                    }
                    
                    if (httpListenersItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue8).put("provisioningState", httpListenersItem.getProvisioningState());
                    }
                    
                    if (httpListenersItem.getName() != null) {
                        ((ObjectNode) applicationGatewayHttpListenerJsonFormatValue).put("name", httpListenersItem.getName());
                    }
                    
                    if (httpListenersItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewayHttpListenerJsonFormatValue).put("etag", httpListenersItem.getEtag());
                    }
                    
                    if (httpListenersItem.getId() != null) {
                        ((ObjectNode) applicationGatewayHttpListenerJsonFormatValue).put("id", httpListenersItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("httpListeners", httpListenersArray);
            }
        }
        
        if (parameters.getRequestRoutingRules() != null) {
            if (parameters.getRequestRoutingRules() instanceof LazyCollection == false || ((LazyCollection) parameters.getRequestRoutingRules()).isInitialized()) {
                ArrayNode requestRoutingRulesArray = objectMapper.createArrayNode();
                for (ApplicationGatewayRequestRoutingRule requestRoutingRulesItem : parameters.getRequestRoutingRules()) {
                    ObjectNode applicationGatewayRequestRoutingRuleJsonFormatValue = objectMapper.createObjectNode();
                    requestRoutingRulesArray.add(applicationGatewayRequestRoutingRuleJsonFormatValue);
                    
                    ObjectNode propertiesValue9 = objectMapper.createObjectNode();
                    ((ObjectNode) applicationGatewayRequestRoutingRuleJsonFormatValue).put("properties", propertiesValue9);
                    
                    if (requestRoutingRulesItem.getRuleType() != null) {
                        ((ObjectNode) propertiesValue9).put("ruleType", requestRoutingRulesItem.getRuleType());
                    }
                    
                    if (requestRoutingRulesItem.getBackendAddressPool() != null) {
                        ObjectNode backendAddressPoolValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue9).put("backendAddressPool", backendAddressPoolValue);
                        
                        if (requestRoutingRulesItem.getBackendAddressPool().getId() != null) {
                            ((ObjectNode) backendAddressPoolValue).put("id", requestRoutingRulesItem.getBackendAddressPool().getId());
                        }
                    }
                    
                    if (requestRoutingRulesItem.getBackendHttpSettings() != null) {
                        ObjectNode backendHttpSettingsValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue9).put("backendHttpSettings", backendHttpSettingsValue);
                        
                        if (requestRoutingRulesItem.getBackendHttpSettings().getId() != null) {
                            ((ObjectNode) backendHttpSettingsValue).put("id", requestRoutingRulesItem.getBackendHttpSettings().getId());
                        }
                    }
                    
                    if (requestRoutingRulesItem.getHttpListener() != null) {
                        ObjectNode httpListenerValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue9).put("httpListener", httpListenerValue);
                        
                        if (requestRoutingRulesItem.getHttpListener().getId() != null) {
                            ((ObjectNode) httpListenerValue).put("id", requestRoutingRulesItem.getHttpListener().getId());
                        }
                    }
                    
                    if (requestRoutingRulesItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue9).put("provisioningState", requestRoutingRulesItem.getProvisioningState());
                    }
                    
                    if (requestRoutingRulesItem.getName() != null) {
                        ((ObjectNode) applicationGatewayRequestRoutingRuleJsonFormatValue).put("name", requestRoutingRulesItem.getName());
                    }
                    
                    if (requestRoutingRulesItem.getEtag() != null) {
                        ((ObjectNode) applicationGatewayRequestRoutingRuleJsonFormatValue).put("etag", requestRoutingRulesItem.getEtag());
                    }
                    
                    if (requestRoutingRulesItem.getId() != null) {
                        ((ObjectNode) applicationGatewayRequestRoutingRuleJsonFormatValue).put("id", requestRoutingRulesItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("requestRoutingRules", requestRoutingRulesArray);
            }
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) applicationGatewayJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) applicationGatewayJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) applicationGatewayJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) applicationGatewayJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) applicationGatewayJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) applicationGatewayJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ApplicationGatewayPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ApplicationGatewayPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ApplicationGateway applicationGatewayInstance = new ApplicationGateway();
                    result.setApplicationGateway(applicationGatewayInstance);
                    
                    JsonNode propertiesValue10 = responseDoc.get("properties");
                    if (propertiesValue10 != null && propertiesValue10 instanceof NullNode == false) {
                        JsonNode skuValue2 = propertiesValue10.get("sku");
                        if (skuValue2 != null && skuValue2 instanceof NullNode == false) {
                            ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                            applicationGatewayInstance.setSku(skuInstance);
                            
                            JsonNode nameValue = skuValue2.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                skuInstance.setName(nameInstance);
                            }
                            
                            JsonNode tierValue = skuValue2.get("tier");
                            if (tierValue != null && tierValue instanceof NullNode == false) {
                                String tierInstance;
                                tierInstance = tierValue.getTextValue();
                                skuInstance.setTier(tierInstance);
                            }
                            
                            JsonNode capacityValue = skuValue2.get("capacity");
                            if (capacityValue != null && capacityValue instanceof NullNode == false) {
                                int capacityInstance;
                                capacityInstance = capacityValue.getIntValue();
                                skuInstance.setCapacity(capacityInstance);
                            }
                        }
                        
                        JsonNode operationalStateValue = propertiesValue10.get("operationalState");
                        if (operationalStateValue != null && operationalStateValue instanceof NullNode == false) {
                            String operationalStateInstance;
                            operationalStateInstance = operationalStateValue.getTextValue();
                            applicationGatewayInstance.setOperationalState(operationalStateInstance);
                        }
                        
                        JsonNode gatewayIPConfigurationsArray2 = propertiesValue10.get("gatewayIPConfigurations");
                        if (gatewayIPConfigurationsArray2 != null && gatewayIPConfigurationsArray2 instanceof NullNode == false) {
                            for (JsonNode gatewayIPConfigurationsValue : ((ArrayNode) gatewayIPConfigurationsArray2)) {
                                ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                applicationGatewayInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue11 = gatewayIPConfigurationsValue.get("properties");
                                if (propertiesValue11 != null && propertiesValue11 instanceof NullNode == false) {
                                    JsonNode subnetValue3 = propertiesValue11.get("subnet");
                                    if (subnetValue3 != null && subnetValue3 instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue3.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue11.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue2 = gatewayIPConfigurationsValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                }
                                
                                JsonNode etagValue = gatewayIPConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue2 = gatewayIPConfigurationsValue.get("id");
                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                    String idInstance2;
                                    idInstance2 = idValue2.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                                }
                            }
                        }
                        
                        JsonNode sslCertificatesArray2 = propertiesValue10.get("sslCertificates");
                        if (sslCertificatesArray2 != null && sslCertificatesArray2 instanceof NullNode == false) {
                            for (JsonNode sslCertificatesValue : ((ArrayNode) sslCertificatesArray2)) {
                                ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                applicationGatewayInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                
                                JsonNode propertiesValue12 = sslCertificatesValue.get("properties");
                                if (propertiesValue12 != null && propertiesValue12 instanceof NullNode == false) {
                                    JsonNode dataValue = propertiesValue12.get("data");
                                    if (dataValue != null && dataValue instanceof NullNode == false) {
                                        String dataInstance;
                                        dataInstance = dataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                    }
                                    
                                    JsonNode passwordValue = propertiesValue12.get("password");
                                    if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                        String passwordInstance;
                                        passwordInstance = passwordValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                    }
                                    
                                    JsonNode publicCertDataValue = propertiesValue12.get("publicCertData");
                                    if (publicCertDataValue != null && publicCertDataValue instanceof NullNode == false) {
                                        String publicCertDataInstance;
                                        publicCertDataInstance = publicCertDataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue2 = propertiesValue12.get("provisioningState");
                                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                        String provisioningStateInstance2;
                                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                
                                JsonNode nameValue3 = sslCertificatesValue.get("name");
                                if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                    String nameInstance3;
                                    nameInstance3 = nameValue3.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                }
                                
                                JsonNode etagValue2 = sslCertificatesValue.get("etag");
                                if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                    String etagInstance2;
                                    etagInstance2 = etagValue2.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                }
                                
                                JsonNode idValue3 = sslCertificatesValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode frontendIPConfigurationsArray2 = propertiesValue10.get("frontendIPConfigurations");
                        if (frontendIPConfigurationsArray2 != null && frontendIPConfigurationsArray2 instanceof NullNode == false) {
                            for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray2)) {
                                ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                applicationGatewayInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue13 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue13 != null && propertiesValue13 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue13.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue13.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue4 = propertiesValue13.get("subnet");
                                    if (subnetValue4 != null && subnetValue4 instanceof NullNode == false) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                        
                                        JsonNode idValue4 = subnetValue4.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            subnetInstance2.setId(idInstance4);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue2 = propertiesValue13.get("publicIPAddress");
                                    if (publicIPAddressValue2 != null && publicIPAddressValue2 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue5 = publicIPAddressValue2.get("id");
                                        if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                            String idInstance5;
                                            idInstance5 = idValue5.getTextValue();
                                            publicIPAddressInstance.setId(idInstance5);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue3 = propertiesValue13.get("provisioningState");
                                    if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                        String provisioningStateInstance3;
                                        provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                
                                JsonNode nameValue4 = frontendIPConfigurationsValue.get("name");
                                if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                    String nameInstance4;
                                    nameInstance4 = nameValue4.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                }
                                
                                JsonNode etagValue3 = frontendIPConfigurationsValue.get("etag");
                                if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                    String etagInstance3;
                                    etagInstance3 = etagValue3.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                }
                                
                                JsonNode idValue6 = frontendIPConfigurationsValue.get("id");
                                if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                    String idInstance6;
                                    idInstance6 = idValue6.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                                }
                            }
                        }
                        
                        JsonNode frontendPortsArray2 = propertiesValue10.get("frontendPorts");
                        if (frontendPortsArray2 != null && frontendPortsArray2 instanceof NullNode == false) {
                            for (JsonNode frontendPortsValue : ((ArrayNode) frontendPortsArray2)) {
                                ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                applicationGatewayInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                
                                JsonNode propertiesValue14 = frontendPortsValue.get("properties");
                                if (propertiesValue14 != null && propertiesValue14 instanceof NullNode == false) {
                                    JsonNode portValue = propertiesValue14.get("port");
                                    if (portValue != null && portValue instanceof NullNode == false) {
                                        int portInstance;
                                        portInstance = portValue.getIntValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue4 = propertiesValue14.get("provisioningState");
                                    if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                        String provisioningStateInstance4;
                                        provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                
                                JsonNode nameValue5 = frontendPortsValue.get("name");
                                if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                    String nameInstance5;
                                    nameInstance5 = nameValue5.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                }
                                
                                JsonNode etagValue4 = frontendPortsValue.get("etag");
                                if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                    String etagInstance4;
                                    etagInstance4 = etagValue4.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                }
                                
                                JsonNode idValue7 = frontendPortsValue.get("id");
                                if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                    String idInstance7;
                                    idInstance7 = idValue7.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                                }
                            }
                        }
                        
                        JsonNode backendAddressPoolsArray2 = propertiesValue10.get("backendAddressPools");
                        if (backendAddressPoolsArray2 != null && backendAddressPoolsArray2 instanceof NullNode == false) {
                            for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray2)) {
                                ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                applicationGatewayInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                
                                JsonNode propertiesValue15 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue15 != null && propertiesValue15 instanceof NullNode == false) {
                                    JsonNode backendIPConfigurationsArray2 = propertiesValue15.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray2 != null && backendIPConfigurationsArray2 instanceof NullNode == false) {
                                        for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray2)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                            
                                            JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                            if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                                String idInstance8;
                                                idInstance8 = idValue8.getTextValue();
                                                resourceIdInstance.setId(idInstance8);
                                            }
                                        }
                                    }
                                    
                                    JsonNode backendAddressesArray2 = propertiesValue15.get("backendAddresses");
                                    if (backendAddressesArray2 != null && backendAddressesArray2 instanceof NullNode == false) {
                                        for (JsonNode backendAddressesValue : ((ArrayNode) backendAddressesArray2)) {
                                            ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                            
                                            JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                            if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                                String fqdnInstance;
                                                fqdnInstance = fqdnValue.getTextValue();
                                                applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                            }
                                            
                                            JsonNode ipAddressValue = backendAddressesValue.get("ipAddress");
                                            if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                                                String ipAddressInstance;
                                                ipAddressInstance = ipAddressValue.getTextValue();
                                                applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue5 = propertiesValue15.get("provisioningState");
                                    if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                        String provisioningStateInstance5;
                                        provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                
                                JsonNode nameValue6 = backendAddressPoolsValue.get("name");
                                if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                    String nameInstance6;
                                    nameInstance6 = nameValue6.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                }
                                
                                JsonNode etagValue5 = backendAddressPoolsValue.get("etag");
                                if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                    String etagInstance5;
                                    etagInstance5 = etagValue5.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                }
                                
                                JsonNode idValue9 = backendAddressPoolsValue.get("id");
                                if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                    String idInstance9;
                                    idInstance9 = idValue9.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                                }
                            }
                        }
                        
                        JsonNode backendHttpSettingsCollectionArray2 = propertiesValue10.get("backendHttpSettingsCollection");
                        if (backendHttpSettingsCollectionArray2 != null && backendHttpSettingsCollectionArray2 instanceof NullNode == false) {
                            for (JsonNode backendHttpSettingsCollectionValue : ((ArrayNode) backendHttpSettingsCollectionArray2)) {
                                ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                applicationGatewayInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                
                                JsonNode propertiesValue16 = backendHttpSettingsCollectionValue.get("properties");
                                if (propertiesValue16 != null && propertiesValue16 instanceof NullNode == false) {
                                    JsonNode portValue2 = propertiesValue16.get("port");
                                    if (portValue2 != null && portValue2 instanceof NullNode == false) {
                                        int portInstance2;
                                        portInstance2 = portValue2.getIntValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                    }
                                    
                                    JsonNode protocolValue = propertiesValue16.get("protocol");
                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                        String protocolInstance;
                                        protocolInstance = protocolValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    
                                    JsonNode cookieBasedAffinityValue = propertiesValue16.get("cookieBasedAffinity");
                                    if (cookieBasedAffinityValue != null && cookieBasedAffinityValue instanceof NullNode == false) {
                                        String cookieBasedAffinityInstance;
                                        cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue6 = propertiesValue16.get("provisioningState");
                                    if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                                        String provisioningStateInstance6;
                                        provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                    }
                                }
                                
                                JsonNode nameValue7 = backendHttpSettingsCollectionValue.get("name");
                                if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                    String nameInstance7;
                                    nameInstance7 = nameValue7.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                }
                                
                                JsonNode etagValue6 = backendHttpSettingsCollectionValue.get("etag");
                                if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                                    String etagInstance6;
                                    etagInstance6 = etagValue6.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                }
                                
                                JsonNode idValue10 = backendHttpSettingsCollectionValue.get("id");
                                if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                    String idInstance10;
                                    idInstance10 = idValue10.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                                }
                            }
                        }
                        
                        JsonNode httpListenersArray2 = propertiesValue10.get("httpListeners");
                        if (httpListenersArray2 != null && httpListenersArray2 instanceof NullNode == false) {
                            for (JsonNode httpListenersValue : ((ArrayNode) httpListenersArray2)) {
                                ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                applicationGatewayInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                
                                JsonNode propertiesValue17 = httpListenersValue.get("properties");
                                if (propertiesValue17 != null && propertiesValue17 instanceof NullNode == false) {
                                    JsonNode frontendIPConfigurationValue2 = propertiesValue17.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue2 != null && frontendIPConfigurationValue2 instanceof NullNode == false) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        
                                        JsonNode idValue11 = frontendIPConfigurationValue2.get("id");
                                        if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                            String idInstance11;
                                            idInstance11 = idValue11.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance11);
                                        }
                                    }
                                    
                                    JsonNode frontendPortValue2 = propertiesValue17.get("frontendPort");
                                    if (frontendPortValue2 != null && frontendPortValue2 instanceof NullNode == false) {
                                        ResourceId frontendPortInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                        
                                        JsonNode idValue12 = frontendPortValue2.get("id");
                                        if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                            String idInstance12;
                                            idInstance12 = idValue12.getTextValue();
                                            frontendPortInstance.setId(idInstance12);
                                        }
                                    }
                                    
                                    JsonNode protocolValue2 = propertiesValue17.get("protocol");
                                    if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                        String protocolInstance2;
                                        protocolInstance2 = protocolValue2.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    
                                    JsonNode sslCertificateValue2 = propertiesValue17.get("sslCertificate");
                                    if (sslCertificateValue2 != null && sslCertificateValue2 instanceof NullNode == false) {
                                        ResourceId sslCertificateInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                        
                                        JsonNode idValue13 = sslCertificateValue2.get("id");
                                        if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                            String idInstance13;
                                            idInstance13 = idValue13.getTextValue();
                                            sslCertificateInstance.setId(idInstance13);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue7 = propertiesValue17.get("provisioningState");
                                    if (provisioningStateValue7 != null && provisioningStateValue7 instanceof NullNode == false) {
                                        String provisioningStateInstance7;
                                        provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                    }
                                }
                                
                                JsonNode nameValue8 = httpListenersValue.get("name");
                                if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                    String nameInstance8;
                                    nameInstance8 = nameValue8.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                }
                                
                                JsonNode etagValue7 = httpListenersValue.get("etag");
                                if (etagValue7 != null && etagValue7 instanceof NullNode == false) {
                                    String etagInstance7;
                                    etagInstance7 = etagValue7.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                }
                                
                                JsonNode idValue14 = httpListenersValue.get("id");
                                if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                    String idInstance14;
                                    idInstance14 = idValue14.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                                }
                            }
                        }
                        
                        JsonNode requestRoutingRulesArray2 = propertiesValue10.get("requestRoutingRules");
                        if (requestRoutingRulesArray2 != null && requestRoutingRulesArray2 instanceof NullNode == false) {
                            for (JsonNode requestRoutingRulesValue : ((ArrayNode) requestRoutingRulesArray2)) {
                                ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                applicationGatewayInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue18 = requestRoutingRulesValue.get("properties");
                                if (propertiesValue18 != null && propertiesValue18 instanceof NullNode == false) {
                                    JsonNode ruleTypeValue = propertiesValue18.get("ruleType");
                                    if (ruleTypeValue != null && ruleTypeValue instanceof NullNode == false) {
                                        String ruleTypeInstance;
                                        ruleTypeInstance = ruleTypeValue.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                    }
                                    
                                    JsonNode backendAddressPoolValue2 = propertiesValue18.get("backendAddressPool");
                                    if (backendAddressPoolValue2 != null && backendAddressPoolValue2 instanceof NullNode == false) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        
                                        JsonNode idValue15 = backendAddressPoolValue2.get("id");
                                        if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                            String idInstance15;
                                            idInstance15 = idValue15.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance15);
                                        }
                                    }
                                    
                                    JsonNode backendHttpSettingsValue2 = propertiesValue18.get("backendHttpSettings");
                                    if (backendHttpSettingsValue2 != null && backendHttpSettingsValue2 instanceof NullNode == false) {
                                        ResourceId backendHttpSettingsInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                        
                                        JsonNode idValue16 = backendHttpSettingsValue2.get("id");
                                        if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                            String idInstance16;
                                            idInstance16 = idValue16.getTextValue();
                                            backendHttpSettingsInstance.setId(idInstance16);
                                        }
                                    }
                                    
                                    JsonNode httpListenerValue2 = propertiesValue18.get("httpListener");
                                    if (httpListenerValue2 != null && httpListenerValue2 instanceof NullNode == false) {
                                        ResourceId httpListenerInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                        
                                        JsonNode idValue17 = httpListenerValue2.get("id");
                                        if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                            String idInstance17;
                                            idInstance17 = idValue17.getTextValue();
                                            httpListenerInstance.setId(idInstance17);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue8 = propertiesValue18.get("provisioningState");
                                    if (provisioningStateValue8 != null && provisioningStateValue8 instanceof NullNode == false) {
                                        String provisioningStateInstance8;
                                        provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                    }
                                }
                                
                                JsonNode nameValue9 = requestRoutingRulesValue.get("name");
                                if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                    String nameInstance9;
                                    nameInstance9 = nameValue9.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                }
                                
                                JsonNode etagValue8 = requestRoutingRulesValue.get("etag");
                                if (etagValue8 != null && etagValue8 instanceof NullNode == false) {
                                    String etagInstance8;
                                    etagInstance8 = etagValue8.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                }
                                
                                JsonNode idValue18 = requestRoutingRulesValue.get("id");
                                if (idValue18 != null && idValue18 instanceof NullNode == false) {
                                    String idInstance18;
                                    idInstance18 = idValue18.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue9 = propertiesValue10.get("provisioningState");
                        if (provisioningStateValue9 != null && provisioningStateValue9 instanceof NullNode == false) {
                            String provisioningStateInstance9;
                            provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                            applicationGatewayInstance.setProvisioningState(provisioningStateInstance9);
                        }
                    }
                    
                    JsonNode etagValue9 = responseDoc.get("etag");
                    if (etagValue9 != null && etagValue9 instanceof NullNode == false) {
                        String etagInstance9;
                        etagInstance9 = etagValue9.getTextValue();
                        applicationGatewayInstance.setEtag(etagInstance9);
                    }
                    
                    JsonNode idValue19 = responseDoc.get("id");
                    if (idValue19 != null && idValue19 instanceof NullNode == false) {
                        String idInstance19;
                        idInstance19 = idValue19.getTextValue();
                        applicationGatewayInstance.setId(idInstance19);
                    }
                    
                    JsonNode nameValue10 = responseDoc.get("name");
                    if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                        String nameInstance10;
                        nameInstance10 = nameValue10.getTextValue();
                        applicationGatewayInstance.setName(nameInstance10);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        applicationGatewayInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        applicationGatewayInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            applicationGatewayInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete applicationgateway operation deletes the specified
    * applicationgateway.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * applicationgateway.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, applicationGatewayName);
            }
         });
    }
    
    /**
    * The delete applicationgateway operation deletes the specified
    * applicationgateway.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * applicationgateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Start ApplicationGateway operation starts application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginStartAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>() { 
            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return beginStart(resourceGroupName, applicationGatewayName);
            }
         });
    }
    
    /**
    * The Start ApplicationGateway operation starts application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public VirtualNetworkGatewayPutResponse beginStart(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter(invocationId, this, "beginStartAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        url = url + "/start";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayPutResponse result = null;
            // Deserialize Response
            result = new VirtualNetworkGatewayPutResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The STOP ApplicationGateway operation stops application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginStopAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>() { 
            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return beginStop(resourceGroupName, applicationGatewayName);
            }
         });
    }
    
    /**
    * The STOP ApplicationGateway operation stops application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public VirtualNetworkGatewayPutResponse beginStop(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter(invocationId, this, "beginStopAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        url = url + "/stop";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayPutResponse result = null;
            // Deserialize Response
            result = new VirtualNetworkGatewayPutResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put ApplicationGateway operation creates/updates a ApplicationGateway
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * ApplicationGateway.
    * @param parameters Required. Parameters supplied to the create/update
    * ApplicationGateway operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String applicationGatewayName, final ApplicationGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, applicationGatewayName, parameters);
            }
         });
    }
    
    /**
    * The Put ApplicationGateway operation creates/updates a ApplicationGateway
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * ApplicationGateway.
    * @param parameters Required. Parameters supplied to the create/update
    * ApplicationGateway operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String applicationGatewayName, ApplicationGateway parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ApplicationGatewayPutResponse response = client2.getApplicationGatewaysOperations().beginCreateOrUpdatingAsync(resourceGroupName, applicationGatewayName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * applicationgateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, applicationGatewayName);
            }
         });
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * applicationgateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String applicationGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getApplicationGatewaysOperations().beginDeletingAsync(resourceGroupName, applicationGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get applicationgateway operation retreives information about the
    * specified applicationgateway.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * applicationgateway.
    * @return Response of a GET ApplicationGateway operation
    */
    @Override
    public Future<ApplicationGatewayGetResponse> getAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayGetResponse>() { 
            @Override
            public ApplicationGatewayGetResponse call() throws Exception {
                return get(resourceGroupName, applicationGatewayName);
            }
         });
    }
    
    /**
    * The Get applicationgateway operation retreives information about the
    * specified applicationgateway.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the
    * applicationgateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of a GET ApplicationGateway operation
    */
    @Override
    public ApplicationGatewayGetResponse get(String resourceGroupName, String applicationGatewayName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (applicationGatewayName == null) {
            throw new NullPointerException("applicationGatewayName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways/";
        url = url + URLEncoder.encode(applicationGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ApplicationGatewayGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ApplicationGatewayGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ApplicationGateway applicationGatewayInstance = new ApplicationGateway();
                    result.setApplicationGateway(applicationGatewayInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode skuValue = propertiesValue.get("sku");
                        if (skuValue != null && skuValue instanceof NullNode == false) {
                            ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                            applicationGatewayInstance.setSku(skuInstance);
                            
                            JsonNode nameValue = skuValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                skuInstance.setName(nameInstance);
                            }
                            
                            JsonNode tierValue = skuValue.get("tier");
                            if (tierValue != null && tierValue instanceof NullNode == false) {
                                String tierInstance;
                                tierInstance = tierValue.getTextValue();
                                skuInstance.setTier(tierInstance);
                            }
                            
                            JsonNode capacityValue = skuValue.get("capacity");
                            if (capacityValue != null && capacityValue instanceof NullNode == false) {
                                int capacityInstance;
                                capacityInstance = capacityValue.getIntValue();
                                skuInstance.setCapacity(capacityInstance);
                            }
                        }
                        
                        JsonNode operationalStateValue = propertiesValue.get("operationalState");
                        if (operationalStateValue != null && operationalStateValue instanceof NullNode == false) {
                            String operationalStateInstance;
                            operationalStateInstance = operationalStateValue.getTextValue();
                            applicationGatewayInstance.setOperationalState(operationalStateInstance);
                        }
                        
                        JsonNode gatewayIPConfigurationsArray = propertiesValue.get("gatewayIPConfigurations");
                        if (gatewayIPConfigurationsArray != null && gatewayIPConfigurationsArray instanceof NullNode == false) {
                            for (JsonNode gatewayIPConfigurationsValue : ((ArrayNode) gatewayIPConfigurationsArray)) {
                                ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                applicationGatewayInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue2 = gatewayIPConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    JsonNode subnetValue = propertiesValue2.get("subnet");
                                    if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue2 = gatewayIPConfigurationsValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                }
                                
                                JsonNode etagValue = gatewayIPConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue2 = gatewayIPConfigurationsValue.get("id");
                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                    String idInstance2;
                                    idInstance2 = idValue2.getTextValue();
                                    applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                                }
                            }
                        }
                        
                        JsonNode sslCertificatesArray = propertiesValue.get("sslCertificates");
                        if (sslCertificatesArray != null && sslCertificatesArray instanceof NullNode == false) {
                            for (JsonNode sslCertificatesValue : ((ArrayNode) sslCertificatesArray)) {
                                ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                applicationGatewayInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                
                                JsonNode propertiesValue3 = sslCertificatesValue.get("properties");
                                if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                    JsonNode dataValue = propertiesValue3.get("data");
                                    if (dataValue != null && dataValue instanceof NullNode == false) {
                                        String dataInstance;
                                        dataInstance = dataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                    }
                                    
                                    JsonNode passwordValue = propertiesValue3.get("password");
                                    if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                        String passwordInstance;
                                        passwordInstance = passwordValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                    }
                                    
                                    JsonNode publicCertDataValue = propertiesValue3.get("publicCertData");
                                    if (publicCertDataValue != null && publicCertDataValue instanceof NullNode == false) {
                                        String publicCertDataInstance;
                                        publicCertDataInstance = publicCertDataValue.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                        String provisioningStateInstance2;
                                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                
                                JsonNode nameValue3 = sslCertificatesValue.get("name");
                                if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                    String nameInstance3;
                                    nameInstance3 = nameValue3.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                }
                                
                                JsonNode etagValue2 = sslCertificatesValue.get("etag");
                                if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                    String etagInstance2;
                                    etagInstance2 = etagValue2.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                }
                                
                                JsonNode idValue3 = sslCertificatesValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                        if (frontendIPConfigurationsArray != null && frontendIPConfigurationsArray instanceof NullNode == false) {
                            for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray)) {
                                ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                applicationGatewayInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue4 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue2 = propertiesValue4.get("subnet");
                                    if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                        
                                        JsonNode idValue4 = subnetValue2.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            subnetInstance2.setId(idInstance4);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue = propertiesValue4.get("publicIPAddress");
                                    if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue5 = publicIPAddressValue.get("id");
                                        if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                            String idInstance5;
                                            idInstance5 = idValue5.getTextValue();
                                            publicIPAddressInstance.setId(idInstance5);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue3 = propertiesValue4.get("provisioningState");
                                    if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                        String provisioningStateInstance3;
                                        provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                
                                JsonNode nameValue4 = frontendIPConfigurationsValue.get("name");
                                if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                    String nameInstance4;
                                    nameInstance4 = nameValue4.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                }
                                
                                JsonNode etagValue3 = frontendIPConfigurationsValue.get("etag");
                                if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                    String etagInstance3;
                                    etagInstance3 = etagValue3.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                }
                                
                                JsonNode idValue6 = frontendIPConfigurationsValue.get("id");
                                if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                    String idInstance6;
                                    idInstance6 = idValue6.getTextValue();
                                    applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                                }
                            }
                        }
                        
                        JsonNode frontendPortsArray = propertiesValue.get("frontendPorts");
                        if (frontendPortsArray != null && frontendPortsArray instanceof NullNode == false) {
                            for (JsonNode frontendPortsValue : ((ArrayNode) frontendPortsArray)) {
                                ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                applicationGatewayInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                
                                JsonNode propertiesValue5 = frontendPortsValue.get("properties");
                                if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                    JsonNode portValue = propertiesValue5.get("port");
                                    if (portValue != null && portValue instanceof NullNode == false) {
                                        int portInstance;
                                        portInstance = portValue.getIntValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue4 = propertiesValue5.get("provisioningState");
                                    if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                        String provisioningStateInstance4;
                                        provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                
                                JsonNode nameValue5 = frontendPortsValue.get("name");
                                if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                    String nameInstance5;
                                    nameInstance5 = nameValue5.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                }
                                
                                JsonNode etagValue4 = frontendPortsValue.get("etag");
                                if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                    String etagInstance4;
                                    etagInstance4 = etagValue4.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                }
                                
                                JsonNode idValue7 = frontendPortsValue.get("id");
                                if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                    String idInstance7;
                                    idInstance7 = idValue7.getTextValue();
                                    applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                                }
                            }
                        }
                        
                        JsonNode backendAddressPoolsArray = propertiesValue.get("backendAddressPools");
                        if (backendAddressPoolsArray != null && backendAddressPoolsArray instanceof NullNode == false) {
                            for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray)) {
                                ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                applicationGatewayInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                
                                JsonNode propertiesValue6 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                    JsonNode backendIPConfigurationsArray = propertiesValue6.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray != null && backendIPConfigurationsArray instanceof NullNode == false) {
                                        for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                            
                                            JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                            if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                                String idInstance8;
                                                idInstance8 = idValue8.getTextValue();
                                                resourceIdInstance.setId(idInstance8);
                                            }
                                        }
                                    }
                                    
                                    JsonNode backendAddressesArray = propertiesValue6.get("backendAddresses");
                                    if (backendAddressesArray != null && backendAddressesArray instanceof NullNode == false) {
                                        for (JsonNode backendAddressesValue : ((ArrayNode) backendAddressesArray)) {
                                            ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                            
                                            JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                            if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                                String fqdnInstance;
                                                fqdnInstance = fqdnValue.getTextValue();
                                                applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                            }
                                            
                                            JsonNode ipAddressValue = backendAddressesValue.get("ipAddress");
                                            if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                                                String ipAddressInstance;
                                                ipAddressInstance = ipAddressValue.getTextValue();
                                                applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue5 = propertiesValue6.get("provisioningState");
                                    if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                        String provisioningStateInstance5;
                                        provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                
                                JsonNode nameValue6 = backendAddressPoolsValue.get("name");
                                if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                    String nameInstance6;
                                    nameInstance6 = nameValue6.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                }
                                
                                JsonNode etagValue5 = backendAddressPoolsValue.get("etag");
                                if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                    String etagInstance5;
                                    etagInstance5 = etagValue5.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                }
                                
                                JsonNode idValue9 = backendAddressPoolsValue.get("id");
                                if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                    String idInstance9;
                                    idInstance9 = idValue9.getTextValue();
                                    applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                                }
                            }
                        }
                        
                        JsonNode backendHttpSettingsCollectionArray = propertiesValue.get("backendHttpSettingsCollection");
                        if (backendHttpSettingsCollectionArray != null && backendHttpSettingsCollectionArray instanceof NullNode == false) {
                            for (JsonNode backendHttpSettingsCollectionValue : ((ArrayNode) backendHttpSettingsCollectionArray)) {
                                ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                applicationGatewayInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                
                                JsonNode propertiesValue7 = backendHttpSettingsCollectionValue.get("properties");
                                if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                    JsonNode portValue2 = propertiesValue7.get("port");
                                    if (portValue2 != null && portValue2 instanceof NullNode == false) {
                                        int portInstance2;
                                        portInstance2 = portValue2.getIntValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                    }
                                    
                                    JsonNode protocolValue = propertiesValue7.get("protocol");
                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                        String protocolInstance;
                                        protocolInstance = protocolValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    
                                    JsonNode cookieBasedAffinityValue = propertiesValue7.get("cookieBasedAffinity");
                                    if (cookieBasedAffinityValue != null && cookieBasedAffinityValue instanceof NullNode == false) {
                                        String cookieBasedAffinityInstance;
                                        cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue6 = propertiesValue7.get("provisioningState");
                                    if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                                        String provisioningStateInstance6;
                                        provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                        applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                    }
                                }
                                
                                JsonNode nameValue7 = backendHttpSettingsCollectionValue.get("name");
                                if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                    String nameInstance7;
                                    nameInstance7 = nameValue7.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                }
                                
                                JsonNode etagValue6 = backendHttpSettingsCollectionValue.get("etag");
                                if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                                    String etagInstance6;
                                    etagInstance6 = etagValue6.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                }
                                
                                JsonNode idValue10 = backendHttpSettingsCollectionValue.get("id");
                                if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                    String idInstance10;
                                    idInstance10 = idValue10.getTextValue();
                                    applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                                }
                            }
                        }
                        
                        JsonNode httpListenersArray = propertiesValue.get("httpListeners");
                        if (httpListenersArray != null && httpListenersArray instanceof NullNode == false) {
                            for (JsonNode httpListenersValue : ((ArrayNode) httpListenersArray)) {
                                ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                applicationGatewayInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                
                                JsonNode propertiesValue8 = httpListenersValue.get("properties");
                                if (propertiesValue8 != null && propertiesValue8 instanceof NullNode == false) {
                                    JsonNode frontendIPConfigurationValue = propertiesValue8.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue != null && frontendIPConfigurationValue instanceof NullNode == false) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        
                                        JsonNode idValue11 = frontendIPConfigurationValue.get("id");
                                        if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                            String idInstance11;
                                            idInstance11 = idValue11.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance11);
                                        }
                                    }
                                    
                                    JsonNode frontendPortValue = propertiesValue8.get("frontendPort");
                                    if (frontendPortValue != null && frontendPortValue instanceof NullNode == false) {
                                        ResourceId frontendPortInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                        
                                        JsonNode idValue12 = frontendPortValue.get("id");
                                        if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                            String idInstance12;
                                            idInstance12 = idValue12.getTextValue();
                                            frontendPortInstance.setId(idInstance12);
                                        }
                                    }
                                    
                                    JsonNode protocolValue2 = propertiesValue8.get("protocol");
                                    if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                        String protocolInstance2;
                                        protocolInstance2 = protocolValue2.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    
                                    JsonNode sslCertificateValue = propertiesValue8.get("sslCertificate");
                                    if (sslCertificateValue != null && sslCertificateValue instanceof NullNode == false) {
                                        ResourceId sslCertificateInstance = new ResourceId();
                                        applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                        
                                        JsonNode idValue13 = sslCertificateValue.get("id");
                                        if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                            String idInstance13;
                                            idInstance13 = idValue13.getTextValue();
                                            sslCertificateInstance.setId(idInstance13);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue7 = propertiesValue8.get("provisioningState");
                                    if (provisioningStateValue7 != null && provisioningStateValue7 instanceof NullNode == false) {
                                        String provisioningStateInstance7;
                                        provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                        applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                    }
                                }
                                
                                JsonNode nameValue8 = httpListenersValue.get("name");
                                if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                    String nameInstance8;
                                    nameInstance8 = nameValue8.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                }
                                
                                JsonNode etagValue7 = httpListenersValue.get("etag");
                                if (etagValue7 != null && etagValue7 instanceof NullNode == false) {
                                    String etagInstance7;
                                    etagInstance7 = etagValue7.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                }
                                
                                JsonNode idValue14 = httpListenersValue.get("id");
                                if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                    String idInstance14;
                                    idInstance14 = idValue14.getTextValue();
                                    applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                                }
                            }
                        }
                        
                        JsonNode requestRoutingRulesArray = propertiesValue.get("requestRoutingRules");
                        if (requestRoutingRulesArray != null && requestRoutingRulesArray instanceof NullNode == false) {
                            for (JsonNode requestRoutingRulesValue : ((ArrayNode) requestRoutingRulesArray)) {
                                ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                applicationGatewayInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue9 = requestRoutingRulesValue.get("properties");
                                if (propertiesValue9 != null && propertiesValue9 instanceof NullNode == false) {
                                    JsonNode ruleTypeValue = propertiesValue9.get("ruleType");
                                    if (ruleTypeValue != null && ruleTypeValue instanceof NullNode == false) {
                                        String ruleTypeInstance;
                                        ruleTypeInstance = ruleTypeValue.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                    }
                                    
                                    JsonNode backendAddressPoolValue = propertiesValue9.get("backendAddressPool");
                                    if (backendAddressPoolValue != null && backendAddressPoolValue instanceof NullNode == false) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        
                                        JsonNode idValue15 = backendAddressPoolValue.get("id");
                                        if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                            String idInstance15;
                                            idInstance15 = idValue15.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance15);
                                        }
                                    }
                                    
                                    JsonNode backendHttpSettingsValue = propertiesValue9.get("backendHttpSettings");
                                    if (backendHttpSettingsValue != null && backendHttpSettingsValue instanceof NullNode == false) {
                                        ResourceId backendHttpSettingsInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                        
                                        JsonNode idValue16 = backendHttpSettingsValue.get("id");
                                        if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                            String idInstance16;
                                            idInstance16 = idValue16.getTextValue();
                                            backendHttpSettingsInstance.setId(idInstance16);
                                        }
                                    }
                                    
                                    JsonNode httpListenerValue = propertiesValue9.get("httpListener");
                                    if (httpListenerValue != null && httpListenerValue instanceof NullNode == false) {
                                        ResourceId httpListenerInstance = new ResourceId();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                        
                                        JsonNode idValue17 = httpListenerValue.get("id");
                                        if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                            String idInstance17;
                                            idInstance17 = idValue17.getTextValue();
                                            httpListenerInstance.setId(idInstance17);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue8 = propertiesValue9.get("provisioningState");
                                    if (provisioningStateValue8 != null && provisioningStateValue8 instanceof NullNode == false) {
                                        String provisioningStateInstance8;
                                        provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                        applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                    }
                                }
                                
                                JsonNode nameValue9 = requestRoutingRulesValue.get("name");
                                if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                    String nameInstance9;
                                    nameInstance9 = nameValue9.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                }
                                
                                JsonNode etagValue8 = requestRoutingRulesValue.get("etag");
                                if (etagValue8 != null && etagValue8 instanceof NullNode == false) {
                                    String etagInstance8;
                                    etagInstance8 = etagValue8.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                }
                                
                                JsonNode idValue18 = requestRoutingRulesValue.get("id");
                                if (idValue18 != null && idValue18 instanceof NullNode == false) {
                                    String idInstance18;
                                    idInstance18 = idValue18.getTextValue();
                                    applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue9 = propertiesValue.get("provisioningState");
                        if (provisioningStateValue9 != null && provisioningStateValue9 instanceof NullNode == false) {
                            String provisioningStateInstance9;
                            provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                            applicationGatewayInstance.setProvisioningState(provisioningStateInstance9);
                        }
                    }
                    
                    JsonNode etagValue9 = responseDoc.get("etag");
                    if (etagValue9 != null && etagValue9 instanceof NullNode == false) {
                        String etagInstance9;
                        etagInstance9 = etagValue9.getTextValue();
                        applicationGatewayInstance.setEtag(etagInstance9);
                    }
                    
                    JsonNode idValue19 = responseDoc.get("id");
                    if (idValue19 != null && idValue19 instanceof NullNode == false) {
                        String idInstance19;
                        idInstance19 = idValue19.getTextValue();
                        applicationGatewayInstance.setId(idInstance19);
                    }
                    
                    JsonNode nameValue10 = responseDoc.get("name");
                    if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                        String nameInstance10;
                        nameInstance10 = nameValue10.getTextValue();
                        applicationGatewayInstance.setName(nameInstance10);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        applicationGatewayInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        applicationGatewayInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            applicationGatewayInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List ApplicationGateway opertion retrieves all the
    * applicationgateways in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public Future<ApplicationGatewayListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayListResponse>() { 
            @Override
            public ApplicationGatewayListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The List ApplicationGateway opertion retrieves all the
    * applicationgateways in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public ApplicationGatewayListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ApplicationGatewayListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ApplicationGatewayListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ApplicationGateway applicationGatewayJsonFormatInstance = new ApplicationGateway();
                            result.getApplicationGateways().add(applicationGatewayJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode skuValue = propertiesValue.get("sku");
                                if (skuValue != null && skuValue instanceof NullNode == false) {
                                    ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                                    applicationGatewayJsonFormatInstance.setSku(skuInstance);
                                    
                                    JsonNode nameValue = skuValue.get("name");
                                    if (nameValue != null && nameValue instanceof NullNode == false) {
                                        String nameInstance;
                                        nameInstance = nameValue.getTextValue();
                                        skuInstance.setName(nameInstance);
                                    }
                                    
                                    JsonNode tierValue = skuValue.get("tier");
                                    if (tierValue != null && tierValue instanceof NullNode == false) {
                                        String tierInstance;
                                        tierInstance = tierValue.getTextValue();
                                        skuInstance.setTier(tierInstance);
                                    }
                                    
                                    JsonNode capacityValue = skuValue.get("capacity");
                                    if (capacityValue != null && capacityValue instanceof NullNode == false) {
                                        int capacityInstance;
                                        capacityInstance = capacityValue.getIntValue();
                                        skuInstance.setCapacity(capacityInstance);
                                    }
                                }
                                
                                JsonNode operationalStateValue = propertiesValue.get("operationalState");
                                if (operationalStateValue != null && operationalStateValue instanceof NullNode == false) {
                                    String operationalStateInstance;
                                    operationalStateInstance = operationalStateValue.getTextValue();
                                    applicationGatewayJsonFormatInstance.setOperationalState(operationalStateInstance);
                                }
                                
                                JsonNode gatewayIPConfigurationsArray = propertiesValue.get("gatewayIPConfigurations");
                                if (gatewayIPConfigurationsArray != null && gatewayIPConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode gatewayIPConfigurationsValue : ((ArrayNode) gatewayIPConfigurationsArray)) {
                                        ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = gatewayIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue2 = gatewayIPConfigurationsValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode etagValue = gatewayIPConfigurationsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue2 = gatewayIPConfigurationsValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode sslCertificatesArray = propertiesValue.get("sslCertificates");
                                if (sslCertificatesArray != null && sslCertificatesArray instanceof NullNode == false) {
                                    for (JsonNode sslCertificatesValue : ((ArrayNode) sslCertificatesArray)) {
                                        ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                        applicationGatewayJsonFormatInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                        
                                        JsonNode propertiesValue3 = sslCertificatesValue.get("properties");
                                        if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                            JsonNode dataValue = propertiesValue3.get("data");
                                            if (dataValue != null && dataValue instanceof NullNode == false) {
                                                String dataInstance;
                                                dataInstance = dataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                            }
                                            
                                            JsonNode passwordValue = propertiesValue3.get("password");
                                            if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                                String passwordInstance;
                                                passwordInstance = passwordValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                            }
                                            
                                            JsonNode publicCertDataValue = propertiesValue3.get("publicCertData");
                                            if (publicCertDataValue != null && publicCertDataValue instanceof NullNode == false) {
                                                String publicCertDataInstance;
                                                publicCertDataInstance = publicCertDataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                                String provisioningStateInstance2;
                                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        
                                        JsonNode nameValue3 = sslCertificatesValue.get("name");
                                        if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                            String nameInstance3;
                                            nameInstance3 = nameValue3.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                        }
                                        
                                        JsonNode etagValue2 = sslCertificatesValue.get("etag");
                                        if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                            String etagInstance2;
                                            etagInstance2 = etagValue2.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        
                                        JsonNode idValue3 = sslCertificatesValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                                        }
                                    }
                                }
                                
                                JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                                if (frontendIPConfigurationsArray != null && frontendIPConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray)) {
                                        ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue4 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                            JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue2 = propertiesValue4.get("subnet");
                                            if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                                ResourceId subnetInstance2 = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                                
                                                JsonNode idValue4 = subnetValue2.get("id");
                                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                    String idInstance4;
                                                    idInstance4 = idValue4.getTextValue();
                                                    subnetInstance2.setId(idInstance4);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = propertiesValue4.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue5 = publicIPAddressValue.get("id");
                                                if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                    String idInstance5;
                                                    idInstance5 = idValue5.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance5);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue3 = propertiesValue4.get("provisioningState");
                                            if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                                String provisioningStateInstance3;
                                                provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        
                                        JsonNode nameValue4 = frontendIPConfigurationsValue.get("name");
                                        if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                            String nameInstance4;
                                            nameInstance4 = nameValue4.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                        }
                                        
                                        JsonNode etagValue3 = frontendIPConfigurationsValue.get("etag");
                                        if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                            String etagInstance3;
                                            etagInstance3 = etagValue3.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        
                                        JsonNode idValue6 = frontendIPConfigurationsValue.get("id");
                                        if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                            String idInstance6;
                                            idInstance6 = idValue6.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                                        }
                                    }
                                }
                                
                                JsonNode frontendPortsArray = propertiesValue.get("frontendPorts");
                                if (frontendPortsArray != null && frontendPortsArray instanceof NullNode == false) {
                                    for (JsonNode frontendPortsValue : ((ArrayNode) frontendPortsArray)) {
                                        ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                        applicationGatewayJsonFormatInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                        
                                        JsonNode propertiesValue5 = frontendPortsValue.get("properties");
                                        if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                            JsonNode portValue = propertiesValue5.get("port");
                                            if (portValue != null && portValue instanceof NullNode == false) {
                                                int portInstance;
                                                portInstance = portValue.getIntValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue4 = propertiesValue5.get("provisioningState");
                                            if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                                String provisioningStateInstance4;
                                                provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        
                                        JsonNode nameValue5 = frontendPortsValue.get("name");
                                        if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                            String nameInstance5;
                                            nameInstance5 = nameValue5.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                        }
                                        
                                        JsonNode etagValue4 = frontendPortsValue.get("etag");
                                        if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                            String etagInstance4;
                                            etagInstance4 = etagValue4.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        
                                        JsonNode idValue7 = frontendPortsValue.get("id");
                                        if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                            String idInstance7;
                                            idInstance7 = idValue7.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                                        }
                                    }
                                }
                                
                                JsonNode backendAddressPoolsArray = propertiesValue.get("backendAddressPools");
                                if (backendAddressPoolsArray != null && backendAddressPoolsArray instanceof NullNode == false) {
                                    for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray)) {
                                        ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                        applicationGatewayJsonFormatInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                        
                                        JsonNode propertiesValue6 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                            JsonNode backendIPConfigurationsArray = propertiesValue6.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && backendIPConfigurationsArray instanceof NullNode == false) {
                                                for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                                    if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                                        String idInstance8;
                                                        idInstance8 = idValue8.getTextValue();
                                                        resourceIdInstance.setId(idInstance8);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode backendAddressesArray = propertiesValue6.get("backendAddresses");
                                            if (backendAddressesArray != null && backendAddressesArray instanceof NullNode == false) {
                                                for (JsonNode backendAddressesValue : ((ArrayNode) backendAddressesArray)) {
                                                    ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                                    
                                                    JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                                    if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                                        String fqdnInstance;
                                                        fqdnInstance = fqdnValue.getTextValue();
                                                        applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                                    }
                                                    
                                                    JsonNode ipAddressValue = backendAddressesValue.get("ipAddress");
                                                    if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                                                        String ipAddressInstance;
                                                        ipAddressInstance = ipAddressValue.getTextValue();
                                                        applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue5 = propertiesValue6.get("provisioningState");
                                            if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                                String provisioningStateInstance5;
                                                provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        
                                        JsonNode nameValue6 = backendAddressPoolsValue.get("name");
                                        if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                            String nameInstance6;
                                            nameInstance6 = nameValue6.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                        }
                                        
                                        JsonNode etagValue5 = backendAddressPoolsValue.get("etag");
                                        if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                            String etagInstance5;
                                            etagInstance5 = etagValue5.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        
                                        JsonNode idValue9 = backendAddressPoolsValue.get("id");
                                        if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                            String idInstance9;
                                            idInstance9 = idValue9.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                                        }
                                    }
                                }
                                
                                JsonNode backendHttpSettingsCollectionArray = propertiesValue.get("backendHttpSettingsCollection");
                                if (backendHttpSettingsCollectionArray != null && backendHttpSettingsCollectionArray instanceof NullNode == false) {
                                    for (JsonNode backendHttpSettingsCollectionValue : ((ArrayNode) backendHttpSettingsCollectionArray)) {
                                        ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                        applicationGatewayJsonFormatInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                        
                                        JsonNode propertiesValue7 = backendHttpSettingsCollectionValue.get("properties");
                                        if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                            JsonNode portValue2 = propertiesValue7.get("port");
                                            if (portValue2 != null && portValue2 instanceof NullNode == false) {
                                                int portInstance2;
                                                portInstance2 = portValue2.getIntValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                            }
                                            
                                            JsonNode protocolValue = propertiesValue7.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode cookieBasedAffinityValue = propertiesValue7.get("cookieBasedAffinity");
                                            if (cookieBasedAffinityValue != null && cookieBasedAffinityValue instanceof NullNode == false) {
                                                String cookieBasedAffinityInstance;
                                                cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue6 = propertiesValue7.get("provisioningState");
                                            if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                                                String provisioningStateInstance6;
                                                provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                            }
                                        }
                                        
                                        JsonNode nameValue7 = backendHttpSettingsCollectionValue.get("name");
                                        if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                            String nameInstance7;
                                            nameInstance7 = nameValue7.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                        }
                                        
                                        JsonNode etagValue6 = backendHttpSettingsCollectionValue.get("etag");
                                        if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                                            String etagInstance6;
                                            etagInstance6 = etagValue6.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                        }
                                        
                                        JsonNode idValue10 = backendHttpSettingsCollectionValue.get("id");
                                        if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                            String idInstance10;
                                            idInstance10 = idValue10.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                                        }
                                    }
                                }
                                
                                JsonNode httpListenersArray = propertiesValue.get("httpListeners");
                                if (httpListenersArray != null && httpListenersArray instanceof NullNode == false) {
                                    for (JsonNode httpListenersValue : ((ArrayNode) httpListenersArray)) {
                                        ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                        applicationGatewayJsonFormatInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                        
                                        JsonNode propertiesValue8 = httpListenersValue.get("properties");
                                        if (propertiesValue8 != null && propertiesValue8 instanceof NullNode == false) {
                                            JsonNode frontendIPConfigurationValue = propertiesValue8.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && frontendIPConfigurationValue instanceof NullNode == false) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                
                                                JsonNode idValue11 = frontendIPConfigurationValue.get("id");
                                                if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                                    String idInstance11;
                                                    idInstance11 = idValue11.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance11);
                                                }
                                            }
                                            
                                            JsonNode frontendPortValue = propertiesValue8.get("frontendPort");
                                            if (frontendPortValue != null && frontendPortValue instanceof NullNode == false) {
                                                ResourceId frontendPortInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                                
                                                JsonNode idValue12 = frontendPortValue.get("id");
                                                if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                                    String idInstance12;
                                                    idInstance12 = idValue12.getTextValue();
                                                    frontendPortInstance.setId(idInstance12);
                                                }
                                            }
                                            
                                            JsonNode protocolValue2 = propertiesValue8.get("protocol");
                                            if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                                String protocolInstance2;
                                                protocolInstance2 = protocolValue2.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            
                                            JsonNode sslCertificateValue = propertiesValue8.get("sslCertificate");
                                            if (sslCertificateValue != null && sslCertificateValue instanceof NullNode == false) {
                                                ResourceId sslCertificateInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                                
                                                JsonNode idValue13 = sslCertificateValue.get("id");
                                                if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                                    String idInstance13;
                                                    idInstance13 = idValue13.getTextValue();
                                                    sslCertificateInstance.setId(idInstance13);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue7 = propertiesValue8.get("provisioningState");
                                            if (provisioningStateValue7 != null && provisioningStateValue7 instanceof NullNode == false) {
                                                String provisioningStateInstance7;
                                                provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                            }
                                        }
                                        
                                        JsonNode nameValue8 = httpListenersValue.get("name");
                                        if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                            String nameInstance8;
                                            nameInstance8 = nameValue8.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                        }
                                        
                                        JsonNode etagValue7 = httpListenersValue.get("etag");
                                        if (etagValue7 != null && etagValue7 instanceof NullNode == false) {
                                            String etagInstance7;
                                            etagInstance7 = etagValue7.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                        }
                                        
                                        JsonNode idValue14 = httpListenersValue.get("id");
                                        if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                            String idInstance14;
                                            idInstance14 = idValue14.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                                        }
                                    }
                                }
                                
                                JsonNode requestRoutingRulesArray = propertiesValue.get("requestRoutingRules");
                                if (requestRoutingRulesArray != null && requestRoutingRulesArray instanceof NullNode == false) {
                                    for (JsonNode requestRoutingRulesValue : ((ArrayNode) requestRoutingRulesArray)) {
                                        ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                        applicationGatewayJsonFormatInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue9 = requestRoutingRulesValue.get("properties");
                                        if (propertiesValue9 != null && propertiesValue9 instanceof NullNode == false) {
                                            JsonNode ruleTypeValue = propertiesValue9.get("ruleType");
                                            if (ruleTypeValue != null && ruleTypeValue instanceof NullNode == false) {
                                                String ruleTypeInstance;
                                                ruleTypeInstance = ruleTypeValue.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                            }
                                            
                                            JsonNode backendAddressPoolValue = propertiesValue9.get("backendAddressPool");
                                            if (backendAddressPoolValue != null && backendAddressPoolValue instanceof NullNode == false) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                
                                                JsonNode idValue15 = backendAddressPoolValue.get("id");
                                                if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                                    String idInstance15;
                                                    idInstance15 = idValue15.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance15);
                                                }
                                            }
                                            
                                            JsonNode backendHttpSettingsValue = propertiesValue9.get("backendHttpSettings");
                                            if (backendHttpSettingsValue != null && backendHttpSettingsValue instanceof NullNode == false) {
                                                ResourceId backendHttpSettingsInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                                
                                                JsonNode idValue16 = backendHttpSettingsValue.get("id");
                                                if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                                    String idInstance16;
                                                    idInstance16 = idValue16.getTextValue();
                                                    backendHttpSettingsInstance.setId(idInstance16);
                                                }
                                            }
                                            
                                            JsonNode httpListenerValue = propertiesValue9.get("httpListener");
                                            if (httpListenerValue != null && httpListenerValue instanceof NullNode == false) {
                                                ResourceId httpListenerInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                                
                                                JsonNode idValue17 = httpListenerValue.get("id");
                                                if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                                    String idInstance17;
                                                    idInstance17 = idValue17.getTextValue();
                                                    httpListenerInstance.setId(idInstance17);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue8 = propertiesValue9.get("provisioningState");
                                            if (provisioningStateValue8 != null && provisioningStateValue8 instanceof NullNode == false) {
                                                String provisioningStateInstance8;
                                                provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                            }
                                        }
                                        
                                        JsonNode nameValue9 = requestRoutingRulesValue.get("name");
                                        if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                            String nameInstance9;
                                            nameInstance9 = nameValue9.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                        }
                                        
                                        JsonNode etagValue8 = requestRoutingRulesValue.get("etag");
                                        if (etagValue8 != null && etagValue8 instanceof NullNode == false) {
                                            String etagInstance8;
                                            etagInstance8 = etagValue8.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                        }
                                        
                                        JsonNode idValue18 = requestRoutingRulesValue.get("id");
                                        if (idValue18 != null && idValue18 instanceof NullNode == false) {
                                            String idInstance18;
                                            idInstance18 = idValue18.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue9 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue9 != null && provisioningStateValue9 instanceof NullNode == false) {
                                    String provisioningStateInstance9;
                                    provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                                    applicationGatewayJsonFormatInstance.setProvisioningState(provisioningStateInstance9);
                                }
                            }
                            
                            JsonNode etagValue9 = valueValue.get("etag");
                            if (etagValue9 != null && etagValue9 instanceof NullNode == false) {
                                String etagInstance9;
                                etagInstance9 = etagValue9.getTextValue();
                                applicationGatewayJsonFormatInstance.setEtag(etagInstance9);
                            }
                            
                            JsonNode idValue19 = valueValue.get("id");
                            if (idValue19 != null && idValue19 instanceof NullNode == false) {
                                String idInstance19;
                                idInstance19 = idValue19.getTextValue();
                                applicationGatewayJsonFormatInstance.setId(idInstance19);
                            }
                            
                            JsonNode nameValue10 = valueValue.get("name");
                            if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                                String nameInstance10;
                                nameInstance10 = nameValue10.getTextValue();
                                applicationGatewayJsonFormatInstance.setName(nameInstance10);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    applicationGatewayJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List applicationgateway opertion retrieves all the
    * applicationgateways in a subscription.
    *
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public Future<ApplicationGatewayListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ApplicationGatewayListResponse>() { 
            @Override
            public ApplicationGatewayListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * The List applicationgateway opertion retrieves all the
    * applicationgateways in a subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public ApplicationGatewayListResponse listAll() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/applicationGateways";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ApplicationGatewayListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ApplicationGatewayListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            ApplicationGateway applicationGatewayJsonFormatInstance = new ApplicationGateway();
                            result.getApplicationGateways().add(applicationGatewayJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode skuValue = propertiesValue.get("sku");
                                if (skuValue != null && skuValue instanceof NullNode == false) {
                                    ApplicationGatewaySku skuInstance = new ApplicationGatewaySku();
                                    applicationGatewayJsonFormatInstance.setSku(skuInstance);
                                    
                                    JsonNode nameValue = skuValue.get("name");
                                    if (nameValue != null && nameValue instanceof NullNode == false) {
                                        String nameInstance;
                                        nameInstance = nameValue.getTextValue();
                                        skuInstance.setName(nameInstance);
                                    }
                                    
                                    JsonNode tierValue = skuValue.get("tier");
                                    if (tierValue != null && tierValue instanceof NullNode == false) {
                                        String tierInstance;
                                        tierInstance = tierValue.getTextValue();
                                        skuInstance.setTier(tierInstance);
                                    }
                                    
                                    JsonNode capacityValue = skuValue.get("capacity");
                                    if (capacityValue != null && capacityValue instanceof NullNode == false) {
                                        int capacityInstance;
                                        capacityInstance = capacityValue.getIntValue();
                                        skuInstance.setCapacity(capacityInstance);
                                    }
                                }
                                
                                JsonNode operationalStateValue = propertiesValue.get("operationalState");
                                if (operationalStateValue != null && operationalStateValue instanceof NullNode == false) {
                                    String operationalStateInstance;
                                    operationalStateInstance = operationalStateValue.getTextValue();
                                    applicationGatewayJsonFormatInstance.setOperationalState(operationalStateInstance);
                                }
                                
                                JsonNode gatewayIPConfigurationsArray = propertiesValue.get("gatewayIPConfigurations");
                                if (gatewayIPConfigurationsArray != null && gatewayIPConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode gatewayIPConfigurationsValue : ((ArrayNode) gatewayIPConfigurationsArray)) {
                                        ApplicationGatewayIPConfiguration applicationGatewayIPConfigurationJsonFormatInstance = new ApplicationGatewayIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getGatewayIPConfigurations().add(applicationGatewayIPConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = gatewayIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                applicationGatewayIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue2 = gatewayIPConfigurationsValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode etagValue = gatewayIPConfigurationsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue2 = gatewayIPConfigurationsValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            applicationGatewayIPConfigurationJsonFormatInstance.setId(idInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode sslCertificatesArray = propertiesValue.get("sslCertificates");
                                if (sslCertificatesArray != null && sslCertificatesArray instanceof NullNode == false) {
                                    for (JsonNode sslCertificatesValue : ((ArrayNode) sslCertificatesArray)) {
                                        ApplicationGatewaySslCertificate applicationGatewaySslCertificateJsonFormatInstance = new ApplicationGatewaySslCertificate();
                                        applicationGatewayJsonFormatInstance.getSslCertificates().add(applicationGatewaySslCertificateJsonFormatInstance);
                                        
                                        JsonNode propertiesValue3 = sslCertificatesValue.get("properties");
                                        if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                            JsonNode dataValue = propertiesValue3.get("data");
                                            if (dataValue != null && dataValue instanceof NullNode == false) {
                                                String dataInstance;
                                                dataInstance = dataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setData(dataInstance);
                                            }
                                            
                                            JsonNode passwordValue = propertiesValue3.get("password");
                                            if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                                String passwordInstance;
                                                passwordInstance = passwordValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPassword(passwordInstance);
                                            }
                                            
                                            JsonNode publicCertDataValue = propertiesValue3.get("publicCertData");
                                            if (publicCertDataValue != null && publicCertDataValue instanceof NullNode == false) {
                                                String publicCertDataInstance;
                                                publicCertDataInstance = publicCertDataValue.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setPublicCertData(publicCertDataInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                                String provisioningStateInstance2;
                                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                applicationGatewaySslCertificateJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        
                                        JsonNode nameValue3 = sslCertificatesValue.get("name");
                                        if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                            String nameInstance3;
                                            nameInstance3 = nameValue3.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setName(nameInstance3);
                                        }
                                        
                                        JsonNode etagValue2 = sslCertificatesValue.get("etag");
                                        if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                            String etagInstance2;
                                            etagInstance2 = etagValue2.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        
                                        JsonNode idValue3 = sslCertificatesValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            applicationGatewaySslCertificateJsonFormatInstance.setId(idInstance3);
                                        }
                                    }
                                }
                                
                                JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                                if (frontendIPConfigurationsArray != null && frontendIPConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray)) {
                                        ApplicationGatewayFrontendIPConfiguration applicationGatewayFrontendIPConfigurationJsonFormatInstance = new ApplicationGatewayFrontendIPConfiguration();
                                        applicationGatewayJsonFormatInstance.getFrontendIPConfigurations().add(applicationGatewayFrontendIPConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue4 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                            JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPrivateIPAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue2 = propertiesValue4.get("subnet");
                                            if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                                ResourceId subnetInstance2 = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setSubnet(subnetInstance2);
                                                
                                                JsonNode idValue4 = subnetValue2.get("id");
                                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                    String idInstance4;
                                                    idInstance4 = idValue4.getTextValue();
                                                    subnetInstance2.setId(idInstance4);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = propertiesValue4.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setPublicIPAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue5 = publicIPAddressValue.get("id");
                                                if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                    String idInstance5;
                                                    idInstance5 = idValue5.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance5);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue3 = propertiesValue4.get("provisioningState");
                                            if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                                String provisioningStateInstance3;
                                                provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                applicationGatewayFrontendIPConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        
                                        JsonNode nameValue4 = frontendIPConfigurationsValue.get("name");
                                        if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                            String nameInstance4;
                                            nameInstance4 = nameValue4.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setName(nameInstance4);
                                        }
                                        
                                        JsonNode etagValue3 = frontendIPConfigurationsValue.get("etag");
                                        if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                            String etagInstance3;
                                            etagInstance3 = etagValue3.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        
                                        JsonNode idValue6 = frontendIPConfigurationsValue.get("id");
                                        if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                            String idInstance6;
                                            idInstance6 = idValue6.getTextValue();
                                            applicationGatewayFrontendIPConfigurationJsonFormatInstance.setId(idInstance6);
                                        }
                                    }
                                }
                                
                                JsonNode frontendPortsArray = propertiesValue.get("frontendPorts");
                                if (frontendPortsArray != null && frontendPortsArray instanceof NullNode == false) {
                                    for (JsonNode frontendPortsValue : ((ArrayNode) frontendPortsArray)) {
                                        ApplicationGatewayFrontendPort applicationGatewayFrontendPortJsonFormatInstance = new ApplicationGatewayFrontendPort();
                                        applicationGatewayJsonFormatInstance.getFrontendPorts().add(applicationGatewayFrontendPortJsonFormatInstance);
                                        
                                        JsonNode propertiesValue5 = frontendPortsValue.get("properties");
                                        if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                            JsonNode portValue = propertiesValue5.get("port");
                                            if (portValue != null && portValue instanceof NullNode == false) {
                                                int portInstance;
                                                portInstance = portValue.getIntValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setPort(portInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue4 = propertiesValue5.get("provisioningState");
                                            if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                                String provisioningStateInstance4;
                                                provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                applicationGatewayFrontendPortJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        
                                        JsonNode nameValue5 = frontendPortsValue.get("name");
                                        if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                            String nameInstance5;
                                            nameInstance5 = nameValue5.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setName(nameInstance5);
                                        }
                                        
                                        JsonNode etagValue4 = frontendPortsValue.get("etag");
                                        if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                            String etagInstance4;
                                            etagInstance4 = etagValue4.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        
                                        JsonNode idValue7 = frontendPortsValue.get("id");
                                        if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                            String idInstance7;
                                            idInstance7 = idValue7.getTextValue();
                                            applicationGatewayFrontendPortJsonFormatInstance.setId(idInstance7);
                                        }
                                    }
                                }
                                
                                JsonNode backendAddressPoolsArray = propertiesValue.get("backendAddressPools");
                                if (backendAddressPoolsArray != null && backendAddressPoolsArray instanceof NullNode == false) {
                                    for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray)) {
                                        ApplicationGatewayBackendAddressPool applicationGatewayBackendAddressPoolJsonFormatInstance = new ApplicationGatewayBackendAddressPool();
                                        applicationGatewayJsonFormatInstance.getBackendAddressPools().add(applicationGatewayBackendAddressPoolJsonFormatInstance);
                                        
                                        JsonNode propertiesValue6 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                            JsonNode backendIPConfigurationsArray = propertiesValue6.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && backendIPConfigurationsArray instanceof NullNode == false) {
                                                for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendIPConfigurations().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue8 = backendIPConfigurationsValue.get("id");
                                                    if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                                        String idInstance8;
                                                        idInstance8 = idValue8.getTextValue();
                                                        resourceIdInstance.setId(idInstance8);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode backendAddressesArray = propertiesValue6.get("backendAddresses");
                                            if (backendAddressesArray != null && backendAddressesArray instanceof NullNode == false) {
                                                for (JsonNode backendAddressesValue : ((ArrayNode) backendAddressesArray)) {
                                                    ApplicationGatewayBackendAddress applicationGatewayBackendAddressInstance = new ApplicationGatewayBackendAddress();
                                                    applicationGatewayBackendAddressPoolJsonFormatInstance.getBackendAddresses().add(applicationGatewayBackendAddressInstance);
                                                    
                                                    JsonNode fqdnValue = backendAddressesValue.get("fqdn");
                                                    if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                                        String fqdnInstance;
                                                        fqdnInstance = fqdnValue.getTextValue();
                                                        applicationGatewayBackendAddressInstance.setFqdn(fqdnInstance);
                                                    }
                                                    
                                                    JsonNode ipAddressValue = backendAddressesValue.get("ipAddress");
                                                    if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                                                        String ipAddressInstance;
                                                        ipAddressInstance = ipAddressValue.getTextValue();
                                                        applicationGatewayBackendAddressInstance.setIpAddress(ipAddressInstance);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue5 = propertiesValue6.get("provisioningState");
                                            if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                                String provisioningStateInstance5;
                                                provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                applicationGatewayBackendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        
                                        JsonNode nameValue6 = backendAddressPoolsValue.get("name");
                                        if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                            String nameInstance6;
                                            nameInstance6 = nameValue6.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setName(nameInstance6);
                                        }
                                        
                                        JsonNode etagValue5 = backendAddressPoolsValue.get("etag");
                                        if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                            String etagInstance5;
                                            etagInstance5 = etagValue5.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        
                                        JsonNode idValue9 = backendAddressPoolsValue.get("id");
                                        if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                            String idInstance9;
                                            idInstance9 = idValue9.getTextValue();
                                            applicationGatewayBackendAddressPoolJsonFormatInstance.setId(idInstance9);
                                        }
                                    }
                                }
                                
                                JsonNode backendHttpSettingsCollectionArray = propertiesValue.get("backendHttpSettingsCollection");
                                if (backendHttpSettingsCollectionArray != null && backendHttpSettingsCollectionArray instanceof NullNode == false) {
                                    for (JsonNode backendHttpSettingsCollectionValue : ((ArrayNode) backendHttpSettingsCollectionArray)) {
                                        ApplicationGatewayBackendHttpSettings applicationGatewayBackendHttpSettingsJsonFormatInstance = new ApplicationGatewayBackendHttpSettings();
                                        applicationGatewayJsonFormatInstance.getBackendHttpSettingsCollection().add(applicationGatewayBackendHttpSettingsJsonFormatInstance);
                                        
                                        JsonNode propertiesValue7 = backendHttpSettingsCollectionValue.get("properties");
                                        if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                            JsonNode portValue2 = propertiesValue7.get("port");
                                            if (portValue2 != null && portValue2 instanceof NullNode == false) {
                                                int portInstance2;
                                                portInstance2 = portValue2.getIntValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setPort(portInstance2);
                                            }
                                            
                                            JsonNode protocolValue = propertiesValue7.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode cookieBasedAffinityValue = propertiesValue7.get("cookieBasedAffinity");
                                            if (cookieBasedAffinityValue != null && cookieBasedAffinityValue instanceof NullNode == false) {
                                                String cookieBasedAffinityInstance;
                                                cookieBasedAffinityInstance = cookieBasedAffinityValue.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setCookieBasedAffinity(cookieBasedAffinityInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue6 = propertiesValue7.get("provisioningState");
                                            if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                                                String provisioningStateInstance6;
                                                provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                                applicationGatewayBackendHttpSettingsJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                            }
                                        }
                                        
                                        JsonNode nameValue7 = backendHttpSettingsCollectionValue.get("name");
                                        if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                            String nameInstance7;
                                            nameInstance7 = nameValue7.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setName(nameInstance7);
                                        }
                                        
                                        JsonNode etagValue6 = backendHttpSettingsCollectionValue.get("etag");
                                        if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                                            String etagInstance6;
                                            etagInstance6 = etagValue6.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setEtag(etagInstance6);
                                        }
                                        
                                        JsonNode idValue10 = backendHttpSettingsCollectionValue.get("id");
                                        if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                            String idInstance10;
                                            idInstance10 = idValue10.getTextValue();
                                            applicationGatewayBackendHttpSettingsJsonFormatInstance.setId(idInstance10);
                                        }
                                    }
                                }
                                
                                JsonNode httpListenersArray = propertiesValue.get("httpListeners");
                                if (httpListenersArray != null && httpListenersArray instanceof NullNode == false) {
                                    for (JsonNode httpListenersValue : ((ArrayNode) httpListenersArray)) {
                                        ApplicationGatewayHttpListener applicationGatewayHttpListenerJsonFormatInstance = new ApplicationGatewayHttpListener();
                                        applicationGatewayJsonFormatInstance.getHttpListeners().add(applicationGatewayHttpListenerJsonFormatInstance);
                                        
                                        JsonNode propertiesValue8 = httpListenersValue.get("properties");
                                        if (propertiesValue8 != null && propertiesValue8 instanceof NullNode == false) {
                                            JsonNode frontendIPConfigurationValue = propertiesValue8.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && frontendIPConfigurationValue instanceof NullNode == false) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                
                                                JsonNode idValue11 = frontendIPConfigurationValue.get("id");
                                                if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                                    String idInstance11;
                                                    idInstance11 = idValue11.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance11);
                                                }
                                            }
                                            
                                            JsonNode frontendPortValue = propertiesValue8.get("frontendPort");
                                            if (frontendPortValue != null && frontendPortValue instanceof NullNode == false) {
                                                ResourceId frontendPortInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                                
                                                JsonNode idValue12 = frontendPortValue.get("id");
                                                if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                                    String idInstance12;
                                                    idInstance12 = idValue12.getTextValue();
                                                    frontendPortInstance.setId(idInstance12);
                                                }
                                            }
                                            
                                            JsonNode protocolValue2 = propertiesValue8.get("protocol");
                                            if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                                String protocolInstance2;
                                                protocolInstance2 = protocolValue2.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            
                                            JsonNode sslCertificateValue = propertiesValue8.get("sslCertificate");
                                            if (sslCertificateValue != null && sslCertificateValue instanceof NullNode == false) {
                                                ResourceId sslCertificateInstance = new ResourceId();
                                                applicationGatewayHttpListenerJsonFormatInstance.setSslCertificate(sslCertificateInstance);
                                                
                                                JsonNode idValue13 = sslCertificateValue.get("id");
                                                if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                                    String idInstance13;
                                                    idInstance13 = idValue13.getTextValue();
                                                    sslCertificateInstance.setId(idInstance13);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue7 = propertiesValue8.get("provisioningState");
                                            if (provisioningStateValue7 != null && provisioningStateValue7 instanceof NullNode == false) {
                                                String provisioningStateInstance7;
                                                provisioningStateInstance7 = provisioningStateValue7.getTextValue();
                                                applicationGatewayHttpListenerJsonFormatInstance.setProvisioningState(provisioningStateInstance7);
                                            }
                                        }
                                        
                                        JsonNode nameValue8 = httpListenersValue.get("name");
                                        if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                            String nameInstance8;
                                            nameInstance8 = nameValue8.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setName(nameInstance8);
                                        }
                                        
                                        JsonNode etagValue7 = httpListenersValue.get("etag");
                                        if (etagValue7 != null && etagValue7 instanceof NullNode == false) {
                                            String etagInstance7;
                                            etagInstance7 = etagValue7.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setEtag(etagInstance7);
                                        }
                                        
                                        JsonNode idValue14 = httpListenersValue.get("id");
                                        if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                            String idInstance14;
                                            idInstance14 = idValue14.getTextValue();
                                            applicationGatewayHttpListenerJsonFormatInstance.setId(idInstance14);
                                        }
                                    }
                                }
                                
                                JsonNode requestRoutingRulesArray = propertiesValue.get("requestRoutingRules");
                                if (requestRoutingRulesArray != null && requestRoutingRulesArray instanceof NullNode == false) {
                                    for (JsonNode requestRoutingRulesValue : ((ArrayNode) requestRoutingRulesArray)) {
                                        ApplicationGatewayRequestRoutingRule applicationGatewayRequestRoutingRuleJsonFormatInstance = new ApplicationGatewayRequestRoutingRule();
                                        applicationGatewayJsonFormatInstance.getRequestRoutingRules().add(applicationGatewayRequestRoutingRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue9 = requestRoutingRulesValue.get("properties");
                                        if (propertiesValue9 != null && propertiesValue9 instanceof NullNode == false) {
                                            JsonNode ruleTypeValue = propertiesValue9.get("ruleType");
                                            if (ruleTypeValue != null && ruleTypeValue instanceof NullNode == false) {
                                                String ruleTypeInstance;
                                                ruleTypeInstance = ruleTypeValue.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setRuleType(ruleTypeInstance);
                                            }
                                            
                                            JsonNode backendAddressPoolValue = propertiesValue9.get("backendAddressPool");
                                            if (backendAddressPoolValue != null && backendAddressPoolValue instanceof NullNode == false) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                
                                                JsonNode idValue15 = backendAddressPoolValue.get("id");
                                                if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                                    String idInstance15;
                                                    idInstance15 = idValue15.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance15);
                                                }
                                            }
                                            
                                            JsonNode backendHttpSettingsValue = propertiesValue9.get("backendHttpSettings");
                                            if (backendHttpSettingsValue != null && backendHttpSettingsValue instanceof NullNode == false) {
                                                ResourceId backendHttpSettingsInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setBackendHttpSettings(backendHttpSettingsInstance);
                                                
                                                JsonNode idValue16 = backendHttpSettingsValue.get("id");
                                                if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                                    String idInstance16;
                                                    idInstance16 = idValue16.getTextValue();
                                                    backendHttpSettingsInstance.setId(idInstance16);
                                                }
                                            }
                                            
                                            JsonNode httpListenerValue = propertiesValue9.get("httpListener");
                                            if (httpListenerValue != null && httpListenerValue instanceof NullNode == false) {
                                                ResourceId httpListenerInstance = new ResourceId();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setHttpListener(httpListenerInstance);
                                                
                                                JsonNode idValue17 = httpListenerValue.get("id");
                                                if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                                    String idInstance17;
                                                    idInstance17 = idValue17.getTextValue();
                                                    httpListenerInstance.setId(idInstance17);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue8 = propertiesValue9.get("provisioningState");
                                            if (provisioningStateValue8 != null && provisioningStateValue8 instanceof NullNode == false) {
                                                String provisioningStateInstance8;
                                                provisioningStateInstance8 = provisioningStateValue8.getTextValue();
                                                applicationGatewayRequestRoutingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance8);
                                            }
                                        }
                                        
                                        JsonNode nameValue9 = requestRoutingRulesValue.get("name");
                                        if (nameValue9 != null && nameValue9 instanceof NullNode == false) {
                                            String nameInstance9;
                                            nameInstance9 = nameValue9.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setName(nameInstance9);
                                        }
                                        
                                        JsonNode etagValue8 = requestRoutingRulesValue.get("etag");
                                        if (etagValue8 != null && etagValue8 instanceof NullNode == false) {
                                            String etagInstance8;
                                            etagInstance8 = etagValue8.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setEtag(etagInstance8);
                                        }
                                        
                                        JsonNode idValue18 = requestRoutingRulesValue.get("id");
                                        if (idValue18 != null && idValue18 instanceof NullNode == false) {
                                            String idInstance18;
                                            idInstance18 = idValue18.getTextValue();
                                            applicationGatewayRequestRoutingRuleJsonFormatInstance.setId(idInstance18);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue9 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue9 != null && provisioningStateValue9 instanceof NullNode == false) {
                                    String provisioningStateInstance9;
                                    provisioningStateInstance9 = provisioningStateValue9.getTextValue();
                                    applicationGatewayJsonFormatInstance.setProvisioningState(provisioningStateInstance9);
                                }
                            }
                            
                            JsonNode etagValue9 = valueValue.get("etag");
                            if (etagValue9 != null && etagValue9 instanceof NullNode == false) {
                                String etagInstance9;
                                etagInstance9 = etagValue9.getTextValue();
                                applicationGatewayJsonFormatInstance.setEtag(etagInstance9);
                            }
                            
                            JsonNode idValue19 = valueValue.get("id");
                            if (idValue19 != null && idValue19 instanceof NullNode == false) {
                                String idInstance19;
                                idInstance19 = idValue19.getTextValue();
                                applicationGatewayJsonFormatInstance.setId(idInstance19);
                            }
                            
                            JsonNode nameValue10 = valueValue.get("name");
                            if (nameValue10 != null && nameValue10 instanceof NullNode == false) {
                                String nameInstance10;
                                nameInstance10 = nameValue10.getTextValue();
                                applicationGatewayJsonFormatInstance.setName(nameInstance10);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                applicationGatewayJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    applicationGatewayJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Start ApplicationGateway operation starts application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> startAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return start(resourceGroupName, applicationGatewayName);
            }
         });
    }
    
    /**
    * The Start ApplicationGateway operation starts application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse start(String resourceGroupName, String applicationGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter(invocationId, this, "startAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualNetworkGatewayPutResponse response = client2.getApplicationGatewaysOperations().beginStartAsync(resourceGroupName, applicationGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The STOP ApplicationGateway operation stops application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> stopAsync(final String resourceGroupName, final String applicationGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return stop(resourceGroupName, applicationGatewayName);
            }
         });
    }
    
    /**
    * The STOP ApplicationGateway operation stops application gatewayin the
    * specified resource group through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param applicationGatewayName Required. The name of the application
    * gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse stop(String resourceGroupName, String applicationGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("applicationGatewayName", applicationGatewayName);
            CloudTracing.enter(invocationId, this, "stopAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualNetworkGatewayPutResponse response = client2.getApplicationGatewaysOperations().beginStopAsync(resourceGroupName, applicationGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}
