/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.BackendAddressPool;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.FrontendIpConfiguration;
import com.microsoft.azure.management.network.models.InboundNatRule;
import com.microsoft.azure.management.network.models.LoadBalancer;
import com.microsoft.azure.management.network.models.LoadBalancerGetResponse;
import com.microsoft.azure.management.network.models.LoadBalancerListResponse;
import com.microsoft.azure.management.network.models.LoadBalancerPutResponse;
import com.microsoft.azure.management.network.models.LoadBalancingRule;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.Probe;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the load
* balancers for your subscription.
*/
public class LoadBalancerOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, LoadBalancerOperations {
    /**
    * Initializes a new instance of the LoadBalancerOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    LoadBalancerOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put LoadBalancer operation creates/updates a LoadBalancer
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the create/delete
    * LoadBalancer operation
    * @return Response of a PUT Load Balancer operation
    */
    @Override
    public Future<LoadBalancerPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String loadBalancerName, final LoadBalancer parameters) {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerPutResponse>() { 
            @Override
            public LoadBalancerPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, loadBalancerName, parameters);
            }
         });
    }
    
    /**
    * The Put LoadBalancer operation creates/updates a LoadBalancer
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the create/delete
    * LoadBalancer operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of a PUT Load Balancer operation
    */
    @Override
    public LoadBalancerPutResponse beginCreateOrUpdating(String resourceGroupName, String loadBalancerName, LoadBalancer parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (loadBalancerName == null) {
            throw new NullPointerException("loadBalancerName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getInboundNatRules() != null) {
            for (InboundNatRule inboundNatRulesParameterItem : parameters.getInboundNatRules()) {
                if (inboundNatRulesParameterItem.getProtocol() == null) {
                    throw new NullPointerException("parameters.InboundNatRules.Protocol");
                }
            }
        }
        if (parameters.getLoadBalancingRules() != null) {
            for (LoadBalancingRule loadBalancingRulesParameterItem : parameters.getLoadBalancingRules()) {
                if (loadBalancingRulesParameterItem.getBackendAddressPool() == null) {
                    throw new NullPointerException("parameters.LoadBalancingRules.BackendAddressPool");
                }
                if (loadBalancingRulesParameterItem.getProtocol() == null) {
                    throw new NullPointerException("parameters.LoadBalancingRules.Protocol");
                }
            }
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProbes() != null) {
            for (Probe probesParameterItem : parameters.getProbes()) {
                if (probesParameterItem.getProtocol() == null) {
                    throw new NullPointerException("parameters.Probes.Protocol");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers/";
        url = url + URLEncoder.encode(loadBalancerName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode loadBalancerJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = loadBalancerJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) loadBalancerJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getFrontendIpConfigurations() != null) {
            if (parameters.getFrontendIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getFrontendIpConfigurations()).isInitialized()) {
                ArrayNode frontendIPConfigurationsArray = objectMapper.createArrayNode();
                for (FrontendIpConfiguration frontendIPConfigurationsItem : parameters.getFrontendIpConfigurations()) {
                    ObjectNode frontendIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                    frontendIPConfigurationsArray.add(frontendIpConfigurationJsonFormatValue);
                    
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) frontendIpConfigurationJsonFormatValue).put("properties", propertiesValue2);
                    
                    if (frontendIPConfigurationsItem.getPrivateIpAddress() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAddress", frontendIPConfigurationsItem.getPrivateIpAddress());
                    }
                    
                    if (frontendIPConfigurationsItem.getPrivateIpAllocationMethod() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAllocationMethod", frontendIPConfigurationsItem.getPrivateIpAllocationMethod());
                    }
                    
                    if (frontendIPConfigurationsItem.getSubnet() != null) {
                        ObjectNode subnetValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("subnet", subnetValue);
                        
                        if (frontendIPConfigurationsItem.getSubnet().getId() != null) {
                            ((ObjectNode) subnetValue).put("id", frontendIPConfigurationsItem.getSubnet().getId());
                        }
                    }
                    
                    if (frontendIPConfigurationsItem.getPublicIpAddress() != null) {
                        ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("publicIPAddress", publicIPAddressValue);
                        
                        if (frontendIPConfigurationsItem.getPublicIpAddress().getId() != null) {
                            ((ObjectNode) publicIPAddressValue).put("id", frontendIPConfigurationsItem.getPublicIpAddress().getId());
                        }
                    }
                    
                    if (frontendIPConfigurationsItem.getInboundNatRules() != null) {
                        if (frontendIPConfigurationsItem.getInboundNatRules() instanceof LazyCollection == false || ((LazyCollection) frontendIPConfigurationsItem.getInboundNatRules()).isInitialized()) {
                            ArrayNode inboundNatRulesArray = objectMapper.createArrayNode();
                            for (ResourceId inboundNatRulesItem : frontendIPConfigurationsItem.getInboundNatRules()) {
                                ObjectNode resourceIdValue = objectMapper.createObjectNode();
                                inboundNatRulesArray.add(resourceIdValue);
                                
                                if (inboundNatRulesItem.getId() != null) {
                                    ((ObjectNode) resourceIdValue).put("id", inboundNatRulesItem.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue2).put("inboundNatRules", inboundNatRulesArray);
                        }
                    }
                    
                    if (frontendIPConfigurationsItem.getLoadBalancingRules() != null) {
                        if (frontendIPConfigurationsItem.getLoadBalancingRules() instanceof LazyCollection == false || ((LazyCollection) frontendIPConfigurationsItem.getLoadBalancingRules()).isInitialized()) {
                            ArrayNode loadBalancingRulesArray = objectMapper.createArrayNode();
                            for (ResourceId loadBalancingRulesItem : frontendIPConfigurationsItem.getLoadBalancingRules()) {
                                ObjectNode resourceIdValue2 = objectMapper.createObjectNode();
                                loadBalancingRulesArray.add(resourceIdValue2);
                                
                                if (loadBalancingRulesItem.getId() != null) {
                                    ((ObjectNode) resourceIdValue2).put("id", loadBalancingRulesItem.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue2).put("loadBalancingRules", loadBalancingRulesArray);
                        }
                    }
                    
                    if (frontendIPConfigurationsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue2).put("provisioningState", frontendIPConfigurationsItem.getProvisioningState());
                    }
                    
                    if (frontendIPConfigurationsItem.getName() != null) {
                        ((ObjectNode) frontendIpConfigurationJsonFormatValue).put("name", frontendIPConfigurationsItem.getName());
                    }
                    
                    if (frontendIPConfigurationsItem.getEtag() != null) {
                        ((ObjectNode) frontendIpConfigurationJsonFormatValue).put("etag", frontendIPConfigurationsItem.getEtag());
                    }
                    
                    if (frontendIPConfigurationsItem.getId() != null) {
                        ((ObjectNode) frontendIpConfigurationJsonFormatValue).put("id", frontendIPConfigurationsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("frontendIPConfigurations", frontendIPConfigurationsArray);
            }
        }
        
        if (parameters.getBackendAddressPools() != null) {
            if (parameters.getBackendAddressPools() instanceof LazyCollection == false || ((LazyCollection) parameters.getBackendAddressPools()).isInitialized()) {
                ArrayNode backendAddressPoolsArray = objectMapper.createArrayNode();
                for (BackendAddressPool backendAddressPoolsItem : parameters.getBackendAddressPools()) {
                    ObjectNode backendAddressPoolJsonFormatValue = objectMapper.createObjectNode();
                    backendAddressPoolsArray.add(backendAddressPoolJsonFormatValue);
                    
                    ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                    ((ObjectNode) backendAddressPoolJsonFormatValue).put("properties", propertiesValue3);
                    
                    if (backendAddressPoolsItem.getBackendIpConfigurations() != null) {
                        if (backendAddressPoolsItem.getBackendIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) backendAddressPoolsItem.getBackendIpConfigurations()).isInitialized()) {
                            ArrayNode backendIPConfigurationsArray = objectMapper.createArrayNode();
                            for (ResourceId backendIPConfigurationsItem : backendAddressPoolsItem.getBackendIpConfigurations()) {
                                ObjectNode resourceIdValue3 = objectMapper.createObjectNode();
                                backendIPConfigurationsArray.add(resourceIdValue3);
                                
                                if (backendIPConfigurationsItem.getId() != null) {
                                    ((ObjectNode) resourceIdValue3).put("id", backendIPConfigurationsItem.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue3).put("backendIPConfigurations", backendIPConfigurationsArray);
                        }
                    }
                    
                    if (backendAddressPoolsItem.getLoadBalancingRules() != null) {
                        if (backendAddressPoolsItem.getLoadBalancingRules() instanceof LazyCollection == false || ((LazyCollection) backendAddressPoolsItem.getLoadBalancingRules()).isInitialized()) {
                            ArrayNode loadBalancingRulesArray2 = objectMapper.createArrayNode();
                            for (ResourceId loadBalancingRulesItem2 : backendAddressPoolsItem.getLoadBalancingRules()) {
                                ObjectNode resourceIdValue4 = objectMapper.createObjectNode();
                                loadBalancingRulesArray2.add(resourceIdValue4);
                                
                                if (loadBalancingRulesItem2.getId() != null) {
                                    ((ObjectNode) resourceIdValue4).put("id", loadBalancingRulesItem2.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue3).put("loadBalancingRules", loadBalancingRulesArray2);
                        }
                    }
                    
                    if (backendAddressPoolsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue3).put("provisioningState", backendAddressPoolsItem.getProvisioningState());
                    }
                    
                    if (backendAddressPoolsItem.getName() != null) {
                        ((ObjectNode) backendAddressPoolJsonFormatValue).put("name", backendAddressPoolsItem.getName());
                    }
                    
                    if (backendAddressPoolsItem.getEtag() != null) {
                        ((ObjectNode) backendAddressPoolJsonFormatValue).put("etag", backendAddressPoolsItem.getEtag());
                    }
                    
                    if (backendAddressPoolsItem.getId() != null) {
                        ((ObjectNode) backendAddressPoolJsonFormatValue).put("id", backendAddressPoolsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("backendAddressPools", backendAddressPoolsArray);
            }
        }
        
        if (parameters.getLoadBalancingRules() != null) {
            if (parameters.getLoadBalancingRules() instanceof LazyCollection == false || ((LazyCollection) parameters.getLoadBalancingRules()).isInitialized()) {
                ArrayNode loadBalancingRulesArray3 = objectMapper.createArrayNode();
                for (LoadBalancingRule loadBalancingRulesItem3 : parameters.getLoadBalancingRules()) {
                    ObjectNode loadBalancingRuleJsonFormatValue = objectMapper.createObjectNode();
                    loadBalancingRulesArray3.add(loadBalancingRuleJsonFormatValue);
                    
                    ObjectNode propertiesValue4 = objectMapper.createObjectNode();
                    ((ObjectNode) loadBalancingRuleJsonFormatValue).put("properties", propertiesValue4);
                    
                    if (loadBalancingRulesItem3.getFrontendIPConfiguration() != null) {
                        ObjectNode frontendIPConfigurationValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue4).put("frontendIPConfiguration", frontendIPConfigurationValue);
                        
                        if (loadBalancingRulesItem3.getFrontendIPConfiguration().getId() != null) {
                            ((ObjectNode) frontendIPConfigurationValue).put("id", loadBalancingRulesItem3.getFrontendIPConfiguration().getId());
                        }
                    }
                    
                    ObjectNode backendAddressPoolValue = objectMapper.createObjectNode();
                    ((ObjectNode) propertiesValue4).put("backendAddressPool", backendAddressPoolValue);
                    
                    if (loadBalancingRulesItem3.getBackendAddressPool().getId() != null) {
                        ((ObjectNode) backendAddressPoolValue).put("id", loadBalancingRulesItem3.getBackendAddressPool().getId());
                    }
                    
                    if (loadBalancingRulesItem3.getProbe() != null) {
                        ObjectNode probeValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue4).put("probe", probeValue);
                        
                        if (loadBalancingRulesItem3.getProbe().getId() != null) {
                            ((ObjectNode) probeValue).put("id", loadBalancingRulesItem3.getProbe().getId());
                        }
                    }
                    
                    ((ObjectNode) propertiesValue4).put("protocol", loadBalancingRulesItem3.getProtocol());
                    
                    if (loadBalancingRulesItem3.getLoadDistribution() != null) {
                        ((ObjectNode) propertiesValue4).put("loadDistribution", loadBalancingRulesItem3.getLoadDistribution());
                    }
                    
                    ((ObjectNode) propertiesValue4).put("frontendPort", loadBalancingRulesItem3.getFrontendPort());
                    
                    ((ObjectNode) propertiesValue4).put("backendPort", loadBalancingRulesItem3.getBackendPort());
                    
                    if (loadBalancingRulesItem3.getIdleTimeoutInMinutes() != null) {
                        ((ObjectNode) propertiesValue4).put("idleTimeoutInMinutes", loadBalancingRulesItem3.getIdleTimeoutInMinutes());
                    }
                    
                    ((ObjectNode) propertiesValue4).put("enableFloatingIP", loadBalancingRulesItem3.isEnableFloatingIP());
                    
                    if (loadBalancingRulesItem3.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue4).put("provisioningState", loadBalancingRulesItem3.getProvisioningState());
                    }
                    
                    if (loadBalancingRulesItem3.getName() != null) {
                        ((ObjectNode) loadBalancingRuleJsonFormatValue).put("name", loadBalancingRulesItem3.getName());
                    }
                    
                    if (loadBalancingRulesItem3.getEtag() != null) {
                        ((ObjectNode) loadBalancingRuleJsonFormatValue).put("etag", loadBalancingRulesItem3.getEtag());
                    }
                    
                    if (loadBalancingRulesItem3.getId() != null) {
                        ((ObjectNode) loadBalancingRuleJsonFormatValue).put("id", loadBalancingRulesItem3.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("loadBalancingRules", loadBalancingRulesArray3);
            }
        }
        
        if (parameters.getProbes() != null) {
            if (parameters.getProbes() instanceof LazyCollection == false || ((LazyCollection) parameters.getProbes()).isInitialized()) {
                ArrayNode probesArray = objectMapper.createArrayNode();
                for (Probe probesItem : parameters.getProbes()) {
                    ObjectNode probeJsonFormatValue = objectMapper.createObjectNode();
                    probesArray.add(probeJsonFormatValue);
                    
                    ObjectNode propertiesValue5 = objectMapper.createObjectNode();
                    ((ObjectNode) probeJsonFormatValue).put("properties", propertiesValue5);
                    
                    if (probesItem.getLoadBalancingRules() != null) {
                        if (probesItem.getLoadBalancingRules() instanceof LazyCollection == false || ((LazyCollection) probesItem.getLoadBalancingRules()).isInitialized()) {
                            ArrayNode loadBalancingRulesArray4 = objectMapper.createArrayNode();
                            for (ResourceId loadBalancingRulesItem4 : probesItem.getLoadBalancingRules()) {
                                ObjectNode resourceIdValue5 = objectMapper.createObjectNode();
                                loadBalancingRulesArray4.add(resourceIdValue5);
                                
                                if (loadBalancingRulesItem4.getId() != null) {
                                    ((ObjectNode) resourceIdValue5).put("id", loadBalancingRulesItem4.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue5).put("loadBalancingRules", loadBalancingRulesArray4);
                        }
                    }
                    
                    ((ObjectNode) propertiesValue5).put("protocol", probesItem.getProtocol());
                    
                    ((ObjectNode) propertiesValue5).put("port", probesItem.getPort());
                    
                    ((ObjectNode) propertiesValue5).put("intervalInSeconds", probesItem.getIntervalInSeconds());
                    
                    ((ObjectNode) propertiesValue5).put("numberOfProbes", probesItem.getNumberOfProbes());
                    
                    if (probesItem.getRequestPath() != null) {
                        ((ObjectNode) propertiesValue5).put("requestPath", probesItem.getRequestPath());
                    }
                    
                    if (probesItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue5).put("provisioningState", probesItem.getProvisioningState());
                    }
                    
                    if (probesItem.getName() != null) {
                        ((ObjectNode) probeJsonFormatValue).put("name", probesItem.getName());
                    }
                    
                    if (probesItem.getEtag() != null) {
                        ((ObjectNode) probeJsonFormatValue).put("etag", probesItem.getEtag());
                    }
                    
                    if (probesItem.getId() != null) {
                        ((ObjectNode) probeJsonFormatValue).put("id", probesItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("probes", probesArray);
            }
        }
        
        if (parameters.getInboundNatRules() != null) {
            if (parameters.getInboundNatRules() instanceof LazyCollection == false || ((LazyCollection) parameters.getInboundNatRules()).isInitialized()) {
                ArrayNode inboundNatRulesArray2 = objectMapper.createArrayNode();
                for (InboundNatRule inboundNatRulesItem2 : parameters.getInboundNatRules()) {
                    ObjectNode inboundNatRuleJsonFormatValue = objectMapper.createObjectNode();
                    inboundNatRulesArray2.add(inboundNatRuleJsonFormatValue);
                    
                    ObjectNode propertiesValue6 = objectMapper.createObjectNode();
                    ((ObjectNode) inboundNatRuleJsonFormatValue).put("properties", propertiesValue6);
                    
                    if (inboundNatRulesItem2.getFrontendIPConfiguration() != null) {
                        ObjectNode frontendIPConfigurationValue2 = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue6).put("frontendIPConfiguration", frontendIPConfigurationValue2);
                        
                        if (inboundNatRulesItem2.getFrontendIPConfiguration().getId() != null) {
                            ((ObjectNode) frontendIPConfigurationValue2).put("id", inboundNatRulesItem2.getFrontendIPConfiguration().getId());
                        }
                    }
                    
                    if (inboundNatRulesItem2.getBackendIPConfiguration() != null) {
                        ObjectNode backendIPConfigurationValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue6).put("backendIPConfiguration", backendIPConfigurationValue);
                        
                        if (inboundNatRulesItem2.getBackendIPConfiguration().getId() != null) {
                            ((ObjectNode) backendIPConfigurationValue).put("id", inboundNatRulesItem2.getBackendIPConfiguration().getId());
                        }
                    }
                    
                    ((ObjectNode) propertiesValue6).put("protocol", inboundNatRulesItem2.getProtocol());
                    
                    ((ObjectNode) propertiesValue6).put("frontendPort", inboundNatRulesItem2.getFrontendPort());
                    
                    ((ObjectNode) propertiesValue6).put("backendPort", inboundNatRulesItem2.getBackendPort());
                    
                    if (inboundNatRulesItem2.getIdleTimeoutInMinutes() != null) {
                        ((ObjectNode) propertiesValue6).put("idleTimeoutInMinutes", inboundNatRulesItem2.getIdleTimeoutInMinutes());
                    }
                    
                    ((ObjectNode) propertiesValue6).put("enableFloatingIP", inboundNatRulesItem2.isEnableFloatingIP());
                    
                    if (inboundNatRulesItem2.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue6).put("provisioningState", inboundNatRulesItem2.getProvisioningState());
                    }
                    
                    if (inboundNatRulesItem2.getName() != null) {
                        ((ObjectNode) inboundNatRuleJsonFormatValue).put("name", inboundNatRulesItem2.getName());
                    }
                    
                    if (inboundNatRulesItem2.getEtag() != null) {
                        ((ObjectNode) inboundNatRuleJsonFormatValue).put("etag", inboundNatRulesItem2.getEtag());
                    }
                    
                    if (inboundNatRulesItem2.getId() != null) {
                        ((ObjectNode) inboundNatRuleJsonFormatValue).put("id", inboundNatRulesItem2.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("inboundNatRules", inboundNatRulesArray2);
            }
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) loadBalancerJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) loadBalancerJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) loadBalancerJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) loadBalancerJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) loadBalancerJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) loadBalancerJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LoadBalancerPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LoadBalancerPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    LoadBalancer loadBalancerInstance = new LoadBalancer();
                    result.setLoadBalancer(loadBalancerInstance);
                    
                    JsonNode propertiesValue7 = responseDoc.get("properties");
                    if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                        JsonNode frontendIPConfigurationsArray2 = propertiesValue7.get("frontendIPConfigurations");
                        if (frontendIPConfigurationsArray2 != null && frontendIPConfigurationsArray2 instanceof NullNode == false) {
                            for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray2)) {
                                FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                loadBalancerInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue8 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue8 != null && propertiesValue8 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue8.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue8.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue2 = propertiesValue8.get("subnet");
                                    if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue2.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue2 = propertiesValue8.get("publicIPAddress");
                                    if (publicIPAddressValue2 != null && publicIPAddressValue2 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue2 = publicIPAddressValue2.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode inboundNatRulesArray3 = propertiesValue8.get("inboundNatRules");
                                    if (inboundNatRulesArray3 != null && inboundNatRulesArray3 instanceof NullNode == false) {
                                        for (JsonNode inboundNatRulesValue : ((ArrayNode) inboundNatRulesArray3)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                            
                                            JsonNode idValue3 = inboundNatRulesValue.get("id");
                                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                String idInstance3;
                                                idInstance3 = idValue3.getTextValue();
                                                resourceIdInstance.setId(idInstance3);
                                            }
                                        }
                                    }
                                    
                                    JsonNode loadBalancingRulesArray5 = propertiesValue8.get("loadBalancingRules");
                                    if (loadBalancingRulesArray5 != null && loadBalancingRulesArray5 instanceof NullNode == false) {
                                        for (JsonNode loadBalancingRulesValue : ((ArrayNode) loadBalancingRulesArray5)) {
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                            
                                            JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                String idInstance4;
                                                idInstance4 = idValue4.getTextValue();
                                                resourceIdInstance2.setId(idInstance4);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue8.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = frontendIPConfigurationsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = frontendIPConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue5 = frontendIPConfigurationsValue.get("id");
                                if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                    String idInstance5;
                                    idInstance5 = idValue5.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                                }
                            }
                        }
                        
                        JsonNode backendAddressPoolsArray2 = propertiesValue7.get("backendAddressPools");
                        if (backendAddressPoolsArray2 != null && backendAddressPoolsArray2 instanceof NullNode == false) {
                            for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray2)) {
                                BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                loadBalancerInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                
                                JsonNode propertiesValue9 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue9 != null && propertiesValue9 instanceof NullNode == false) {
                                    JsonNode backendIPConfigurationsArray2 = propertiesValue9.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray2 != null && backendIPConfigurationsArray2 instanceof NullNode == false) {
                                        for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray2)) {
                                            ResourceId resourceIdInstance3 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                            
                                            JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                            if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                String idInstance6;
                                                idInstance6 = idValue6.getTextValue();
                                                resourceIdInstance3.setId(idInstance6);
                                            }
                                        }
                                    }
                                    
                                    JsonNode loadBalancingRulesArray6 = propertiesValue9.get("loadBalancingRules");
                                    if (loadBalancingRulesArray6 != null && loadBalancingRulesArray6 instanceof NullNode == false) {
                                        for (JsonNode loadBalancingRulesValue2 : ((ArrayNode) loadBalancingRulesArray6)) {
                                            ResourceId resourceIdInstance4 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                            
                                            JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                            if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                String idInstance7;
                                                idInstance7 = idValue7.getTextValue();
                                                resourceIdInstance4.setId(idInstance7);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue2 = propertiesValue9.get("provisioningState");
                                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                        String provisioningStateInstance2;
                                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                
                                JsonNode nameValue2 = backendAddressPoolsValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                }
                                
                                JsonNode etagValue2 = backendAddressPoolsValue.get("etag");
                                if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                    String etagInstance2;
                                    etagInstance2 = etagValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                }
                                
                                JsonNode idValue8 = backendAddressPoolsValue.get("id");
                                if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                    String idInstance8;
                                    idInstance8 = idValue8.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setId(idInstance8);
                                }
                            }
                        }
                        
                        JsonNode loadBalancingRulesArray7 = propertiesValue7.get("loadBalancingRules");
                        if (loadBalancingRulesArray7 != null && loadBalancingRulesArray7 instanceof NullNode == false) {
                            for (JsonNode loadBalancingRulesValue3 : ((ArrayNode) loadBalancingRulesArray7)) {
                                LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                loadBalancerInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue10 = loadBalancingRulesValue3.get("properties");
                                if (propertiesValue10 != null && propertiesValue10 instanceof NullNode == false) {
                                    JsonNode frontendIPConfigurationValue3 = propertiesValue10.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue3 != null && frontendIPConfigurationValue3 instanceof NullNode == false) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        
                                        JsonNode idValue9 = frontendIPConfigurationValue3.get("id");
                                        if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                            String idInstance9;
                                            idInstance9 = idValue9.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance9);
                                        }
                                    }
                                    
                                    JsonNode backendAddressPoolValue2 = propertiesValue10.get("backendAddressPool");
                                    if (backendAddressPoolValue2 != null && backendAddressPoolValue2 instanceof NullNode == false) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        
                                        JsonNode idValue10 = backendAddressPoolValue2.get("id");
                                        if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                            String idInstance10;
                                            idInstance10 = idValue10.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance10);
                                        }
                                    }
                                    
                                    JsonNode probeValue2 = propertiesValue10.get("probe");
                                    if (probeValue2 != null && probeValue2 instanceof NullNode == false) {
                                        ResourceId probeInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                        
                                        JsonNode idValue11 = probeValue2.get("id");
                                        if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                            String idInstance11;
                                            idInstance11 = idValue11.getTextValue();
                                            probeInstance.setId(idInstance11);
                                        }
                                    }
                                    
                                    JsonNode protocolValue = propertiesValue10.get("protocol");
                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                        String protocolInstance;
                                        protocolInstance = protocolValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    
                                    JsonNode loadDistributionValue = propertiesValue10.get("loadDistribution");
                                    if (loadDistributionValue != null && loadDistributionValue instanceof NullNode == false) {
                                        String loadDistributionInstance;
                                        loadDistributionInstance = loadDistributionValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                    }
                                    
                                    JsonNode frontendPortValue = propertiesValue10.get("frontendPort");
                                    if (frontendPortValue != null && frontendPortValue instanceof NullNode == false) {
                                        int frontendPortInstance;
                                        frontendPortInstance = frontendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                    }
                                    
                                    JsonNode backendPortValue = propertiesValue10.get("backendPort");
                                    if (backendPortValue != null && backendPortValue instanceof NullNode == false) {
                                        int backendPortInstance;
                                        backendPortInstance = backendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                    }
                                    
                                    JsonNode idleTimeoutInMinutesValue = propertiesValue10.get("idleTimeoutInMinutes");
                                    if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                                        int idleTimeoutInMinutesInstance;
                                        idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                    }
                                    
                                    JsonNode enableFloatingIPValue = propertiesValue10.get("enableFloatingIP");
                                    if (enableFloatingIPValue != null && enableFloatingIPValue instanceof NullNode == false) {
                                        boolean enableFloatingIPInstance;
                                        enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                        loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue3 = propertiesValue10.get("provisioningState");
                                    if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                        String provisioningStateInstance3;
                                        provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                
                                JsonNode nameValue3 = loadBalancingRulesValue3.get("name");
                                if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                    String nameInstance3;
                                    nameInstance3 = nameValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                }
                                
                                JsonNode etagValue3 = loadBalancingRulesValue3.get("etag");
                                if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                    String etagInstance3;
                                    etagInstance3 = etagValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                }
                                
                                JsonNode idValue12 = loadBalancingRulesValue3.get("id");
                                if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                    String idInstance12;
                                    idInstance12 = idValue12.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                                }
                            }
                        }
                        
                        JsonNode probesArray2 = propertiesValue7.get("probes");
                        if (probesArray2 != null && probesArray2 instanceof NullNode == false) {
                            for (JsonNode probesValue : ((ArrayNode) probesArray2)) {
                                Probe probeJsonFormatInstance = new Probe();
                                loadBalancerInstance.getProbes().add(probeJsonFormatInstance);
                                
                                JsonNode propertiesValue11 = probesValue.get("properties");
                                if (propertiesValue11 != null && propertiesValue11 instanceof NullNode == false) {
                                    JsonNode loadBalancingRulesArray8 = propertiesValue11.get("loadBalancingRules");
                                    if (loadBalancingRulesArray8 != null && loadBalancingRulesArray8 instanceof NullNode == false) {
                                        for (JsonNode loadBalancingRulesValue4 : ((ArrayNode) loadBalancingRulesArray8)) {
                                            ResourceId resourceIdInstance5 = new ResourceId();
                                            probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                            
                                            JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                            if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                                String idInstance13;
                                                idInstance13 = idValue13.getTextValue();
                                                resourceIdInstance5.setId(idInstance13);
                                            }
                                        }
                                    }
                                    
                                    JsonNode protocolValue2 = propertiesValue11.get("protocol");
                                    if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                        String protocolInstance2;
                                        protocolInstance2 = protocolValue2.getTextValue();
                                        probeJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    
                                    JsonNode portValue = propertiesValue11.get("port");
                                    if (portValue != null && portValue instanceof NullNode == false) {
                                        int portInstance;
                                        portInstance = portValue.getIntValue();
                                        probeJsonFormatInstance.setPort(portInstance);
                                    }
                                    
                                    JsonNode intervalInSecondsValue = propertiesValue11.get("intervalInSeconds");
                                    if (intervalInSecondsValue != null && intervalInSecondsValue instanceof NullNode == false) {
                                        int intervalInSecondsInstance;
                                        intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                        probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                    }
                                    
                                    JsonNode numberOfProbesValue = propertiesValue11.get("numberOfProbes");
                                    if (numberOfProbesValue != null && numberOfProbesValue instanceof NullNode == false) {
                                        int numberOfProbesInstance;
                                        numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                        probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                    }
                                    
                                    JsonNode requestPathValue = propertiesValue11.get("requestPath");
                                    if (requestPathValue != null && requestPathValue instanceof NullNode == false) {
                                        String requestPathInstance;
                                        requestPathInstance = requestPathValue.getTextValue();
                                        probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue4 = propertiesValue11.get("provisioningState");
                                    if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                        String provisioningStateInstance4;
                                        provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                
                                JsonNode nameValue4 = probesValue.get("name");
                                if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                    String nameInstance4;
                                    nameInstance4 = nameValue4.getTextValue();
                                    probeJsonFormatInstance.setName(nameInstance4);
                                }
                                
                                JsonNode etagValue4 = probesValue.get("etag");
                                if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                    String etagInstance4;
                                    etagInstance4 = etagValue4.getTextValue();
                                    probeJsonFormatInstance.setEtag(etagInstance4);
                                }
                                
                                JsonNode idValue14 = probesValue.get("id");
                                if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                    String idInstance14;
                                    idInstance14 = idValue14.getTextValue();
                                    probeJsonFormatInstance.setId(idInstance14);
                                }
                            }
                        }
                        
                        JsonNode inboundNatRulesArray4 = propertiesValue7.get("inboundNatRules");
                        if (inboundNatRulesArray4 != null && inboundNatRulesArray4 instanceof NullNode == false) {
                            for (JsonNode inboundNatRulesValue2 : ((ArrayNode) inboundNatRulesArray4)) {
                                InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                loadBalancerInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue12 = inboundNatRulesValue2.get("properties");
                                if (propertiesValue12 != null && propertiesValue12 instanceof NullNode == false) {
                                    JsonNode frontendIPConfigurationValue4 = propertiesValue12.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue4 != null && frontendIPConfigurationValue4 instanceof NullNode == false) {
                                        ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                        
                                        JsonNode idValue15 = frontendIPConfigurationValue4.get("id");
                                        if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                            String idInstance15;
                                            idInstance15 = idValue15.getTextValue();
                                            frontendIPConfigurationInstance2.setId(idInstance15);
                                        }
                                    }
                                    
                                    JsonNode backendIPConfigurationValue2 = propertiesValue12.get("backendIPConfiguration");
                                    if (backendIPConfigurationValue2 != null && backendIPConfigurationValue2 instanceof NullNode == false) {
                                        ResourceId backendIPConfigurationInstance = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                        
                                        JsonNode idValue16 = backendIPConfigurationValue2.get("id");
                                        if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                            String idInstance16;
                                            idInstance16 = idValue16.getTextValue();
                                            backendIPConfigurationInstance.setId(idInstance16);
                                        }
                                    }
                                    
                                    JsonNode protocolValue3 = propertiesValue12.get("protocol");
                                    if (protocolValue3 != null && protocolValue3 instanceof NullNode == false) {
                                        String protocolInstance3;
                                        protocolInstance3 = protocolValue3.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                    }
                                    
                                    JsonNode frontendPortValue2 = propertiesValue12.get("frontendPort");
                                    if (frontendPortValue2 != null && frontendPortValue2 instanceof NullNode == false) {
                                        int frontendPortInstance2;
                                        frontendPortInstance2 = frontendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                    }
                                    
                                    JsonNode backendPortValue2 = propertiesValue12.get("backendPort");
                                    if (backendPortValue2 != null && backendPortValue2 instanceof NullNode == false) {
                                        int backendPortInstance2;
                                        backendPortInstance2 = backendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                    }
                                    
                                    JsonNode idleTimeoutInMinutesValue2 = propertiesValue12.get("idleTimeoutInMinutes");
                                    if (idleTimeoutInMinutesValue2 != null && idleTimeoutInMinutesValue2 instanceof NullNode == false) {
                                        int idleTimeoutInMinutesInstance2;
                                        idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                    }
                                    
                                    JsonNode enableFloatingIPValue2 = propertiesValue12.get("enableFloatingIP");
                                    if (enableFloatingIPValue2 != null && enableFloatingIPValue2 instanceof NullNode == false) {
                                        boolean enableFloatingIPInstance2;
                                        enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                        inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                    }
                                    
                                    JsonNode provisioningStateValue5 = propertiesValue12.get("provisioningState");
                                    if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                        String provisioningStateInstance5;
                                        provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                
                                JsonNode nameValue5 = inboundNatRulesValue2.get("name");
                                if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                    String nameInstance5;
                                    nameInstance5 = nameValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                }
                                
                                JsonNode etagValue5 = inboundNatRulesValue2.get("etag");
                                if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                    String etagInstance5;
                                    etagInstance5 = etagValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                }
                                
                                JsonNode idValue17 = inboundNatRulesValue2.get("id");
                                if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                    String idInstance17;
                                    idInstance17 = idValue17.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setId(idInstance17);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue6 = propertiesValue7.get("provisioningState");
                        if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                            String provisioningStateInstance6;
                            provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            loadBalancerInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    
                    JsonNode etagValue6 = responseDoc.get("etag");
                    if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                        String etagInstance6;
                        etagInstance6 = etagValue6.getTextValue();
                        loadBalancerInstance.setEtag(etagInstance6);
                    }
                    
                    JsonNode idValue18 = responseDoc.get("id");
                    if (idValue18 != null && idValue18 instanceof NullNode == false) {
                        String idInstance18;
                        idInstance18 = idValue18.getTextValue();
                        loadBalancerInstance.setId(idInstance18);
                    }
                    
                    JsonNode nameValue6 = responseDoc.get("name");
                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                        String nameInstance6;
                        nameInstance6 = nameValue6.getTextValue();
                        loadBalancerInstance.setName(nameInstance6);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        loadBalancerInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        loadBalancerInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            loadBalancerInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete loadbalancer operation deletes the specified loadbalancer.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String loadBalancerName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, loadBalancerName);
            }
         });
    }
    
    /**
    * The delete loadbalancer operation deletes the specified loadbalancer.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String loadBalancerName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (loadBalancerName == null) {
            throw new NullPointerException("loadBalancerName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers/";
        url = url + URLEncoder.encode(loadBalancerName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put LoadBalancer operation creates/updates a LoadBalancer
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the create/update
    * LoadBalancer operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String loadBalancerName, final LoadBalancer parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, loadBalancerName, parameters);
            }
         });
    }
    
    /**
    * The Put LoadBalancer operation creates/updates a LoadBalancer
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the create/update
    * LoadBalancer operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String loadBalancerName, LoadBalancer parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            LoadBalancerPutResponse response = client2.getLoadBalancersOperations().beginCreateOrUpdatingAsync(resourceGroupName, loadBalancerName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String loadBalancerName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, loadBalancerName);
            }
         });
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String loadBalancerName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getLoadBalancersOperations().beginDeletingAsync(resourceGroupName, loadBalancerName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get ntework interface operation retreives information about the
    * specified network interface.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @return Response of a GET Load Balancer operation
    */
    @Override
    public Future<LoadBalancerGetResponse> getAsync(final String resourceGroupName, final String loadBalancerName) {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerGetResponse>() { 
            @Override
            public LoadBalancerGetResponse call() throws Exception {
                return get(resourceGroupName, loadBalancerName);
            }
         });
    }
    
    /**
    * The Get ntework interface operation retreives information about the
    * specified network interface.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of a GET Load Balancer operation
    */
    @Override
    public LoadBalancerGetResponse get(String resourceGroupName, String loadBalancerName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (loadBalancerName == null) {
            throw new NullPointerException("loadBalancerName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers/";
        url = url + URLEncoder.encode(loadBalancerName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LoadBalancerGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LoadBalancerGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    LoadBalancer loadBalancerInstance = new LoadBalancer();
                    result.setLoadBalancer(loadBalancerInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                        if (frontendIPConfigurationsArray != null && frontendIPConfigurationsArray instanceof NullNode == false) {
                            for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray)) {
                                FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                loadBalancerInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue2 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue = propertiesValue2.get("subnet");
                                    if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                    if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue2 = publicIPAddressValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode inboundNatRulesArray = propertiesValue2.get("inboundNatRules");
                                    if (inboundNatRulesArray != null && inboundNatRulesArray instanceof NullNode == false) {
                                        for (JsonNode inboundNatRulesValue : ((ArrayNode) inboundNatRulesArray)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                            
                                            JsonNode idValue3 = inboundNatRulesValue.get("id");
                                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                String idInstance3;
                                                idInstance3 = idValue3.getTextValue();
                                                resourceIdInstance.setId(idInstance3);
                                            }
                                        }
                                    }
                                    
                                    JsonNode loadBalancingRulesArray = propertiesValue2.get("loadBalancingRules");
                                    if (loadBalancingRulesArray != null && loadBalancingRulesArray instanceof NullNode == false) {
                                        for (JsonNode loadBalancingRulesValue : ((ArrayNode) loadBalancingRulesArray)) {
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                            
                                            JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                String idInstance4;
                                                idInstance4 = idValue4.getTextValue();
                                                resourceIdInstance2.setId(idInstance4);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = frontendIPConfigurationsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = frontendIPConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue5 = frontendIPConfigurationsValue.get("id");
                                if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                    String idInstance5;
                                    idInstance5 = idValue5.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                                }
                            }
                        }
                        
                        JsonNode backendAddressPoolsArray = propertiesValue.get("backendAddressPools");
                        if (backendAddressPoolsArray != null && backendAddressPoolsArray instanceof NullNode == false) {
                            for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray)) {
                                BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                loadBalancerInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                
                                JsonNode propertiesValue3 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                    JsonNode backendIPConfigurationsArray = propertiesValue3.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray != null && backendIPConfigurationsArray instanceof NullNode == false) {
                                        for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray)) {
                                            ResourceId resourceIdInstance3 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                            
                                            JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                            if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                String idInstance6;
                                                idInstance6 = idValue6.getTextValue();
                                                resourceIdInstance3.setId(idInstance6);
                                            }
                                        }
                                    }
                                    
                                    JsonNode loadBalancingRulesArray2 = propertiesValue3.get("loadBalancingRules");
                                    if (loadBalancingRulesArray2 != null && loadBalancingRulesArray2 instanceof NullNode == false) {
                                        for (JsonNode loadBalancingRulesValue2 : ((ArrayNode) loadBalancingRulesArray2)) {
                                            ResourceId resourceIdInstance4 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                            
                                            JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                            if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                String idInstance7;
                                                idInstance7 = idValue7.getTextValue();
                                                resourceIdInstance4.setId(idInstance7);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                        String provisioningStateInstance2;
                                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                
                                JsonNode nameValue2 = backendAddressPoolsValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                }
                                
                                JsonNode etagValue2 = backendAddressPoolsValue.get("etag");
                                if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                    String etagInstance2;
                                    etagInstance2 = etagValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                }
                                
                                JsonNode idValue8 = backendAddressPoolsValue.get("id");
                                if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                    String idInstance8;
                                    idInstance8 = idValue8.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setId(idInstance8);
                                }
                            }
                        }
                        
                        JsonNode loadBalancingRulesArray3 = propertiesValue.get("loadBalancingRules");
                        if (loadBalancingRulesArray3 != null && loadBalancingRulesArray3 instanceof NullNode == false) {
                            for (JsonNode loadBalancingRulesValue3 : ((ArrayNode) loadBalancingRulesArray3)) {
                                LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                loadBalancerInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue4 = loadBalancingRulesValue3.get("properties");
                                if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                    JsonNode frontendIPConfigurationValue = propertiesValue4.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue != null && frontendIPConfigurationValue instanceof NullNode == false) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        
                                        JsonNode idValue9 = frontendIPConfigurationValue.get("id");
                                        if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                            String idInstance9;
                                            idInstance9 = idValue9.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance9);
                                        }
                                    }
                                    
                                    JsonNode backendAddressPoolValue = propertiesValue4.get("backendAddressPool");
                                    if (backendAddressPoolValue != null && backendAddressPoolValue instanceof NullNode == false) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        
                                        JsonNode idValue10 = backendAddressPoolValue.get("id");
                                        if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                            String idInstance10;
                                            idInstance10 = idValue10.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance10);
                                        }
                                    }
                                    
                                    JsonNode probeValue = propertiesValue4.get("probe");
                                    if (probeValue != null && probeValue instanceof NullNode == false) {
                                        ResourceId probeInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                        
                                        JsonNode idValue11 = probeValue.get("id");
                                        if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                            String idInstance11;
                                            idInstance11 = idValue11.getTextValue();
                                            probeInstance.setId(idInstance11);
                                        }
                                    }
                                    
                                    JsonNode protocolValue = propertiesValue4.get("protocol");
                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                        String protocolInstance;
                                        protocolInstance = protocolValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    
                                    JsonNode loadDistributionValue = propertiesValue4.get("loadDistribution");
                                    if (loadDistributionValue != null && loadDistributionValue instanceof NullNode == false) {
                                        String loadDistributionInstance;
                                        loadDistributionInstance = loadDistributionValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                    }
                                    
                                    JsonNode frontendPortValue = propertiesValue4.get("frontendPort");
                                    if (frontendPortValue != null && frontendPortValue instanceof NullNode == false) {
                                        int frontendPortInstance;
                                        frontendPortInstance = frontendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                    }
                                    
                                    JsonNode backendPortValue = propertiesValue4.get("backendPort");
                                    if (backendPortValue != null && backendPortValue instanceof NullNode == false) {
                                        int backendPortInstance;
                                        backendPortInstance = backendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                    }
                                    
                                    JsonNode idleTimeoutInMinutesValue = propertiesValue4.get("idleTimeoutInMinutes");
                                    if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                                        int idleTimeoutInMinutesInstance;
                                        idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                    }
                                    
                                    JsonNode enableFloatingIPValue = propertiesValue4.get("enableFloatingIP");
                                    if (enableFloatingIPValue != null && enableFloatingIPValue instanceof NullNode == false) {
                                        boolean enableFloatingIPInstance;
                                        enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                        loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue3 = propertiesValue4.get("provisioningState");
                                    if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                        String provisioningStateInstance3;
                                        provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                
                                JsonNode nameValue3 = loadBalancingRulesValue3.get("name");
                                if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                    String nameInstance3;
                                    nameInstance3 = nameValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                }
                                
                                JsonNode etagValue3 = loadBalancingRulesValue3.get("etag");
                                if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                    String etagInstance3;
                                    etagInstance3 = etagValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                }
                                
                                JsonNode idValue12 = loadBalancingRulesValue3.get("id");
                                if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                    String idInstance12;
                                    idInstance12 = idValue12.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                                }
                            }
                        }
                        
                        JsonNode probesArray = propertiesValue.get("probes");
                        if (probesArray != null && probesArray instanceof NullNode == false) {
                            for (JsonNode probesValue : ((ArrayNode) probesArray)) {
                                Probe probeJsonFormatInstance = new Probe();
                                loadBalancerInstance.getProbes().add(probeJsonFormatInstance);
                                
                                JsonNode propertiesValue5 = probesValue.get("properties");
                                if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                    JsonNode loadBalancingRulesArray4 = propertiesValue5.get("loadBalancingRules");
                                    if (loadBalancingRulesArray4 != null && loadBalancingRulesArray4 instanceof NullNode == false) {
                                        for (JsonNode loadBalancingRulesValue4 : ((ArrayNode) loadBalancingRulesArray4)) {
                                            ResourceId resourceIdInstance5 = new ResourceId();
                                            probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                            
                                            JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                            if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                                String idInstance13;
                                                idInstance13 = idValue13.getTextValue();
                                                resourceIdInstance5.setId(idInstance13);
                                            }
                                        }
                                    }
                                    
                                    JsonNode protocolValue2 = propertiesValue5.get("protocol");
                                    if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                        String protocolInstance2;
                                        protocolInstance2 = protocolValue2.getTextValue();
                                        probeJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    
                                    JsonNode portValue = propertiesValue5.get("port");
                                    if (portValue != null && portValue instanceof NullNode == false) {
                                        int portInstance;
                                        portInstance = portValue.getIntValue();
                                        probeJsonFormatInstance.setPort(portInstance);
                                    }
                                    
                                    JsonNode intervalInSecondsValue = propertiesValue5.get("intervalInSeconds");
                                    if (intervalInSecondsValue != null && intervalInSecondsValue instanceof NullNode == false) {
                                        int intervalInSecondsInstance;
                                        intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                        probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                    }
                                    
                                    JsonNode numberOfProbesValue = propertiesValue5.get("numberOfProbes");
                                    if (numberOfProbesValue != null && numberOfProbesValue instanceof NullNode == false) {
                                        int numberOfProbesInstance;
                                        numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                        probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                    }
                                    
                                    JsonNode requestPathValue = propertiesValue5.get("requestPath");
                                    if (requestPathValue != null && requestPathValue instanceof NullNode == false) {
                                        String requestPathInstance;
                                        requestPathInstance = requestPathValue.getTextValue();
                                        probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue4 = propertiesValue5.get("provisioningState");
                                    if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                        String provisioningStateInstance4;
                                        provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                
                                JsonNode nameValue4 = probesValue.get("name");
                                if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                    String nameInstance4;
                                    nameInstance4 = nameValue4.getTextValue();
                                    probeJsonFormatInstance.setName(nameInstance4);
                                }
                                
                                JsonNode etagValue4 = probesValue.get("etag");
                                if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                    String etagInstance4;
                                    etagInstance4 = etagValue4.getTextValue();
                                    probeJsonFormatInstance.setEtag(etagInstance4);
                                }
                                
                                JsonNode idValue14 = probesValue.get("id");
                                if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                    String idInstance14;
                                    idInstance14 = idValue14.getTextValue();
                                    probeJsonFormatInstance.setId(idInstance14);
                                }
                            }
                        }
                        
                        JsonNode inboundNatRulesArray2 = propertiesValue.get("inboundNatRules");
                        if (inboundNatRulesArray2 != null && inboundNatRulesArray2 instanceof NullNode == false) {
                            for (JsonNode inboundNatRulesValue2 : ((ArrayNode) inboundNatRulesArray2)) {
                                InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                loadBalancerInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue6 = inboundNatRulesValue2.get("properties");
                                if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                    JsonNode frontendIPConfigurationValue2 = propertiesValue6.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue2 != null && frontendIPConfigurationValue2 instanceof NullNode == false) {
                                        ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                        
                                        JsonNode idValue15 = frontendIPConfigurationValue2.get("id");
                                        if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                            String idInstance15;
                                            idInstance15 = idValue15.getTextValue();
                                            frontendIPConfigurationInstance2.setId(idInstance15);
                                        }
                                    }
                                    
                                    JsonNode backendIPConfigurationValue = propertiesValue6.get("backendIPConfiguration");
                                    if (backendIPConfigurationValue != null && backendIPConfigurationValue instanceof NullNode == false) {
                                        ResourceId backendIPConfigurationInstance = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                        
                                        JsonNode idValue16 = backendIPConfigurationValue.get("id");
                                        if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                            String idInstance16;
                                            idInstance16 = idValue16.getTextValue();
                                            backendIPConfigurationInstance.setId(idInstance16);
                                        }
                                    }
                                    
                                    JsonNode protocolValue3 = propertiesValue6.get("protocol");
                                    if (protocolValue3 != null && protocolValue3 instanceof NullNode == false) {
                                        String protocolInstance3;
                                        protocolInstance3 = protocolValue3.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                    }
                                    
                                    JsonNode frontendPortValue2 = propertiesValue6.get("frontendPort");
                                    if (frontendPortValue2 != null && frontendPortValue2 instanceof NullNode == false) {
                                        int frontendPortInstance2;
                                        frontendPortInstance2 = frontendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                    }
                                    
                                    JsonNode backendPortValue2 = propertiesValue6.get("backendPort");
                                    if (backendPortValue2 != null && backendPortValue2 instanceof NullNode == false) {
                                        int backendPortInstance2;
                                        backendPortInstance2 = backendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                    }
                                    
                                    JsonNode idleTimeoutInMinutesValue2 = propertiesValue6.get("idleTimeoutInMinutes");
                                    if (idleTimeoutInMinutesValue2 != null && idleTimeoutInMinutesValue2 instanceof NullNode == false) {
                                        int idleTimeoutInMinutesInstance2;
                                        idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                    }
                                    
                                    JsonNode enableFloatingIPValue2 = propertiesValue6.get("enableFloatingIP");
                                    if (enableFloatingIPValue2 != null && enableFloatingIPValue2 instanceof NullNode == false) {
                                        boolean enableFloatingIPInstance2;
                                        enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                        inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                    }
                                    
                                    JsonNode provisioningStateValue5 = propertiesValue6.get("provisioningState");
                                    if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                        String provisioningStateInstance5;
                                        provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                
                                JsonNode nameValue5 = inboundNatRulesValue2.get("name");
                                if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                    String nameInstance5;
                                    nameInstance5 = nameValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                }
                                
                                JsonNode etagValue5 = inboundNatRulesValue2.get("etag");
                                if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                    String etagInstance5;
                                    etagInstance5 = etagValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                }
                                
                                JsonNode idValue17 = inboundNatRulesValue2.get("id");
                                if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                    String idInstance17;
                                    idInstance17 = idValue17.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setId(idInstance17);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue6 = propertiesValue.get("provisioningState");
                        if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                            String provisioningStateInstance6;
                            provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            loadBalancerInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    
                    JsonNode etagValue6 = responseDoc.get("etag");
                    if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                        String etagInstance6;
                        etagInstance6 = etagValue6.getTextValue();
                        loadBalancerInstance.setEtag(etagInstance6);
                    }
                    
                    JsonNode idValue18 = responseDoc.get("id");
                    if (idValue18 != null && idValue18 instanceof NullNode == false) {
                        String idInstance18;
                        idInstance18 = idValue18.getTextValue();
                        loadBalancerInstance.setId(idInstance18);
                    }
                    
                    JsonNode nameValue6 = responseDoc.get("name");
                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                        String nameInstance6;
                        nameInstance6 = nameValue6.getTextValue();
                        loadBalancerInstance.setName(nameInstance6);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        loadBalancerInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        loadBalancerInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            loadBalancerInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List loadBalancer opertion retrieves all the loadbalancers in a
    * resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public Future<LoadBalancerListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerListResponse>() { 
            @Override
            public LoadBalancerListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The List loadBalancer opertion retrieves all the loadbalancers in a
    * resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public LoadBalancerListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LoadBalancerListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LoadBalancerListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            LoadBalancer loadBalancerJsonFormatInstance = new LoadBalancer();
                            result.getLoadBalancers().add(loadBalancerJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                                if (frontendIPConfigurationsArray != null && frontendIPConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray)) {
                                        FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                        loadBalancerJsonFormatInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                    String idInstance2;
                                                    idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            
                                            JsonNode inboundNatRulesArray = propertiesValue2.get("inboundNatRules");
                                            if (inboundNatRulesArray != null && inboundNatRulesArray instanceof NullNode == false) {
                                                for (JsonNode inboundNatRulesValue : ((ArrayNode) inboundNatRulesArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue3 = inboundNatRulesValue.get("id");
                                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                        String idInstance3;
                                                        idInstance3 = idValue3.getTextValue();
                                                        resourceIdInstance.setId(idInstance3);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode loadBalancingRulesArray = propertiesValue2.get("loadBalancingRules");
                                            if (loadBalancingRulesArray != null && loadBalancingRulesArray instanceof NullNode == false) {
                                                for (JsonNode loadBalancingRulesValue : ((ArrayNode) loadBalancingRulesArray)) {
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                                    
                                                    JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                        String idInstance4;
                                                        idInstance4 = idValue4.getTextValue();
                                                        resourceIdInstance2.setId(idInstance4);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = frontendIPConfigurationsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = frontendIPConfigurationsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue5 = frontendIPConfigurationsValue.get("id");
                                        if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                            String idInstance5;
                                            idInstance5 = idValue5.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                                        }
                                    }
                                }
                                
                                JsonNode backendAddressPoolsArray = propertiesValue.get("backendAddressPools");
                                if (backendAddressPoolsArray != null && backendAddressPoolsArray instanceof NullNode == false) {
                                    for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray)) {
                                        BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                        loadBalancerJsonFormatInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                        
                                        JsonNode propertiesValue3 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                            JsonNode backendIPConfigurationsArray = propertiesValue3.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && backendIPConfigurationsArray instanceof NullNode == false) {
                                                for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray)) {
                                                    ResourceId resourceIdInstance3 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                                    
                                                    JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                                    if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                        String idInstance6;
                                                        idInstance6 = idValue6.getTextValue();
                                                        resourceIdInstance3.setId(idInstance6);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode loadBalancingRulesArray2 = propertiesValue3.get("loadBalancingRules");
                                            if (loadBalancingRulesArray2 != null && loadBalancingRulesArray2 instanceof NullNode == false) {
                                                for (JsonNode loadBalancingRulesValue2 : ((ArrayNode) loadBalancingRulesArray2)) {
                                                    ResourceId resourceIdInstance4 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                                    
                                                    JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                                    if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                        String idInstance7;
                                                        idInstance7 = idValue7.getTextValue();
                                                        resourceIdInstance4.setId(idInstance7);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                                String provisioningStateInstance2;
                                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        
                                        JsonNode nameValue2 = backendAddressPoolsValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode etagValue2 = backendAddressPoolsValue.get("etag");
                                        if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                            String etagInstance2;
                                            etagInstance2 = etagValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        
                                        JsonNode idValue8 = backendAddressPoolsValue.get("id");
                                        if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                            String idInstance8;
                                            idInstance8 = idValue8.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setId(idInstance8);
                                        }
                                    }
                                }
                                
                                JsonNode loadBalancingRulesArray3 = propertiesValue.get("loadBalancingRules");
                                if (loadBalancingRulesArray3 != null && loadBalancingRulesArray3 instanceof NullNode == false) {
                                    for (JsonNode loadBalancingRulesValue3 : ((ArrayNode) loadBalancingRulesArray3)) {
                                        LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                        loadBalancerJsonFormatInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue4 = loadBalancingRulesValue3.get("properties");
                                        if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                            JsonNode frontendIPConfigurationValue = propertiesValue4.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && frontendIPConfigurationValue instanceof NullNode == false) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                
                                                JsonNode idValue9 = frontendIPConfigurationValue.get("id");
                                                if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                                    String idInstance9;
                                                    idInstance9 = idValue9.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance9);
                                                }
                                            }
                                            
                                            JsonNode backendAddressPoolValue = propertiesValue4.get("backendAddressPool");
                                            if (backendAddressPoolValue != null && backendAddressPoolValue instanceof NullNode == false) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                
                                                JsonNode idValue10 = backendAddressPoolValue.get("id");
                                                if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                                    String idInstance10;
                                                    idInstance10 = idValue10.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance10);
                                                }
                                            }
                                            
                                            JsonNode probeValue = propertiesValue4.get("probe");
                                            if (probeValue != null && probeValue instanceof NullNode == false) {
                                                ResourceId probeInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                                
                                                JsonNode idValue11 = probeValue.get("id");
                                                if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                                    String idInstance11;
                                                    idInstance11 = idValue11.getTextValue();
                                                    probeInstance.setId(idInstance11);
                                                }
                                            }
                                            
                                            JsonNode protocolValue = propertiesValue4.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode loadDistributionValue = propertiesValue4.get("loadDistribution");
                                            if (loadDistributionValue != null && loadDistributionValue instanceof NullNode == false) {
                                                String loadDistributionInstance;
                                                loadDistributionInstance = loadDistributionValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                            }
                                            
                                            JsonNode frontendPortValue = propertiesValue4.get("frontendPort");
                                            if (frontendPortValue != null && frontendPortValue instanceof NullNode == false) {
                                                int frontendPortInstance;
                                                frontendPortInstance = frontendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                            }
                                            
                                            JsonNode backendPortValue = propertiesValue4.get("backendPort");
                                            if (backendPortValue != null && backendPortValue instanceof NullNode == false) {
                                                int backendPortInstance;
                                                backendPortInstance = backendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                            }
                                            
                                            JsonNode idleTimeoutInMinutesValue = propertiesValue4.get("idleTimeoutInMinutes");
                                            if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                                                int idleTimeoutInMinutesInstance;
                                                idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                            }
                                            
                                            JsonNode enableFloatingIPValue = propertiesValue4.get("enableFloatingIP");
                                            if (enableFloatingIPValue != null && enableFloatingIPValue instanceof NullNode == false) {
                                                boolean enableFloatingIPInstance;
                                                enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                                loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue3 = propertiesValue4.get("provisioningState");
                                            if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                                String provisioningStateInstance3;
                                                provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        
                                        JsonNode nameValue3 = loadBalancingRulesValue3.get("name");
                                        if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                            String nameInstance3;
                                            nameInstance3 = nameValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                        }
                                        
                                        JsonNode etagValue3 = loadBalancingRulesValue3.get("etag");
                                        if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                            String etagInstance3;
                                            etagInstance3 = etagValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        
                                        JsonNode idValue12 = loadBalancingRulesValue3.get("id");
                                        if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                            String idInstance12;
                                            idInstance12 = idValue12.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                                        }
                                    }
                                }
                                
                                JsonNode probesArray = propertiesValue.get("probes");
                                if (probesArray != null && probesArray instanceof NullNode == false) {
                                    for (JsonNode probesValue : ((ArrayNode) probesArray)) {
                                        Probe probeJsonFormatInstance = new Probe();
                                        loadBalancerJsonFormatInstance.getProbes().add(probeJsonFormatInstance);
                                        
                                        JsonNode propertiesValue5 = probesValue.get("properties");
                                        if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                            JsonNode loadBalancingRulesArray4 = propertiesValue5.get("loadBalancingRules");
                                            if (loadBalancingRulesArray4 != null && loadBalancingRulesArray4 instanceof NullNode == false) {
                                                for (JsonNode loadBalancingRulesValue4 : ((ArrayNode) loadBalancingRulesArray4)) {
                                                    ResourceId resourceIdInstance5 = new ResourceId();
                                                    probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                                    
                                                    JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                                    if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                                        String idInstance13;
                                                        idInstance13 = idValue13.getTextValue();
                                                        resourceIdInstance5.setId(idInstance13);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode protocolValue2 = propertiesValue5.get("protocol");
                                            if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                                String protocolInstance2;
                                                protocolInstance2 = protocolValue2.getTextValue();
                                                probeJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            
                                            JsonNode portValue = propertiesValue5.get("port");
                                            if (portValue != null && portValue instanceof NullNode == false) {
                                                int portInstance;
                                                portInstance = portValue.getIntValue();
                                                probeJsonFormatInstance.setPort(portInstance);
                                            }
                                            
                                            JsonNode intervalInSecondsValue = propertiesValue5.get("intervalInSeconds");
                                            if (intervalInSecondsValue != null && intervalInSecondsValue instanceof NullNode == false) {
                                                int intervalInSecondsInstance;
                                                intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                                probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                            }
                                            
                                            JsonNode numberOfProbesValue = propertiesValue5.get("numberOfProbes");
                                            if (numberOfProbesValue != null && numberOfProbesValue instanceof NullNode == false) {
                                                int numberOfProbesInstance;
                                                numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                                probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                            }
                                            
                                            JsonNode requestPathValue = propertiesValue5.get("requestPath");
                                            if (requestPathValue != null && requestPathValue instanceof NullNode == false) {
                                                String requestPathInstance;
                                                requestPathInstance = requestPathValue.getTextValue();
                                                probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue4 = propertiesValue5.get("provisioningState");
                                            if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                                String provisioningStateInstance4;
                                                provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        
                                        JsonNode nameValue4 = probesValue.get("name");
                                        if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                            String nameInstance4;
                                            nameInstance4 = nameValue4.getTextValue();
                                            probeJsonFormatInstance.setName(nameInstance4);
                                        }
                                        
                                        JsonNode etagValue4 = probesValue.get("etag");
                                        if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                            String etagInstance4;
                                            etagInstance4 = etagValue4.getTextValue();
                                            probeJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        
                                        JsonNode idValue14 = probesValue.get("id");
                                        if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                            String idInstance14;
                                            idInstance14 = idValue14.getTextValue();
                                            probeJsonFormatInstance.setId(idInstance14);
                                        }
                                    }
                                }
                                
                                JsonNode inboundNatRulesArray2 = propertiesValue.get("inboundNatRules");
                                if (inboundNatRulesArray2 != null && inboundNatRulesArray2 instanceof NullNode == false) {
                                    for (JsonNode inboundNatRulesValue2 : ((ArrayNode) inboundNatRulesArray2)) {
                                        InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                        loadBalancerJsonFormatInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue6 = inboundNatRulesValue2.get("properties");
                                        if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                            JsonNode frontendIPConfigurationValue2 = propertiesValue6.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue2 != null && frontendIPConfigurationValue2 instanceof NullNode == false) {
                                                ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                                
                                                JsonNode idValue15 = frontendIPConfigurationValue2.get("id");
                                                if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                                    String idInstance15;
                                                    idInstance15 = idValue15.getTextValue();
                                                    frontendIPConfigurationInstance2.setId(idInstance15);
                                                }
                                            }
                                            
                                            JsonNode backendIPConfigurationValue = propertiesValue6.get("backendIPConfiguration");
                                            if (backendIPConfigurationValue != null && backendIPConfigurationValue instanceof NullNode == false) {
                                                ResourceId backendIPConfigurationInstance = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                                
                                                JsonNode idValue16 = backendIPConfigurationValue.get("id");
                                                if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                                    String idInstance16;
                                                    idInstance16 = idValue16.getTextValue();
                                                    backendIPConfigurationInstance.setId(idInstance16);
                                                }
                                            }
                                            
                                            JsonNode protocolValue3 = propertiesValue6.get("protocol");
                                            if (protocolValue3 != null && protocolValue3 instanceof NullNode == false) {
                                                String protocolInstance3;
                                                protocolInstance3 = protocolValue3.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                            }
                                            
                                            JsonNode frontendPortValue2 = propertiesValue6.get("frontendPort");
                                            if (frontendPortValue2 != null && frontendPortValue2 instanceof NullNode == false) {
                                                int frontendPortInstance2;
                                                frontendPortInstance2 = frontendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                            }
                                            
                                            JsonNode backendPortValue2 = propertiesValue6.get("backendPort");
                                            if (backendPortValue2 != null && backendPortValue2 instanceof NullNode == false) {
                                                int backendPortInstance2;
                                                backendPortInstance2 = backendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                            }
                                            
                                            JsonNode idleTimeoutInMinutesValue2 = propertiesValue6.get("idleTimeoutInMinutes");
                                            if (idleTimeoutInMinutesValue2 != null && idleTimeoutInMinutesValue2 instanceof NullNode == false) {
                                                int idleTimeoutInMinutesInstance2;
                                                idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                            }
                                            
                                            JsonNode enableFloatingIPValue2 = propertiesValue6.get("enableFloatingIP");
                                            if (enableFloatingIPValue2 != null && enableFloatingIPValue2 instanceof NullNode == false) {
                                                boolean enableFloatingIPInstance2;
                                                enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                                inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                            }
                                            
                                            JsonNode provisioningStateValue5 = propertiesValue6.get("provisioningState");
                                            if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                                String provisioningStateInstance5;
                                                provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        
                                        JsonNode nameValue5 = inboundNatRulesValue2.get("name");
                                        if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                            String nameInstance5;
                                            nameInstance5 = nameValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                        }
                                        
                                        JsonNode etagValue5 = inboundNatRulesValue2.get("etag");
                                        if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                            String etagInstance5;
                                            etagInstance5 = etagValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        
                                        JsonNode idValue17 = inboundNatRulesValue2.get("id");
                                        if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                            String idInstance17;
                                            idInstance17 = idValue17.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setId(idInstance17);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue6 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                                    String provisioningStateInstance6;
                                    provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                    loadBalancerJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                }
                            }
                            
                            JsonNode etagValue6 = valueValue.get("etag");
                            if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                                String etagInstance6;
                                etagInstance6 = etagValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setEtag(etagInstance6);
                            }
                            
                            JsonNode idValue18 = valueValue.get("id");
                            if (idValue18 != null && idValue18 instanceof NullNode == false) {
                                String idInstance18;
                                idInstance18 = idValue18.getTextValue();
                                loadBalancerJsonFormatInstance.setId(idInstance18);
                            }
                            
                            JsonNode nameValue6 = valueValue.get("name");
                            if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                String nameInstance6;
                                nameInstance6 = nameValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setName(nameInstance6);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                loadBalancerJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                loadBalancerJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    loadBalancerJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List loadBalancer opertion retrieves all the loadbalancers in a
    * subscription.
    *
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public Future<LoadBalancerListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerListResponse>() { 
            @Override
            public LoadBalancerListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * The List loadBalancer opertion retrieves all the loadbalancers in a
    * subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListLoadBalancers Api service call
    */
    @Override
    public LoadBalancerListResponse listAll() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LoadBalancerListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LoadBalancerListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            LoadBalancer loadBalancerJsonFormatInstance = new LoadBalancer();
                            result.getLoadBalancers().add(loadBalancerJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                                if (frontendIPConfigurationsArray != null && frontendIPConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode frontendIPConfigurationsValue : ((ArrayNode) frontendIPConfigurationsArray)) {
                                        FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                        loadBalancerJsonFormatInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                    String idInstance2;
                                                    idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            
                                            JsonNode inboundNatRulesArray = propertiesValue2.get("inboundNatRules");
                                            if (inboundNatRulesArray != null && inboundNatRulesArray instanceof NullNode == false) {
                                                for (JsonNode inboundNatRulesValue : ((ArrayNode) inboundNatRulesArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue3 = inboundNatRulesValue.get("id");
                                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                        String idInstance3;
                                                        idInstance3 = idValue3.getTextValue();
                                                        resourceIdInstance.setId(idInstance3);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode loadBalancingRulesArray = propertiesValue2.get("loadBalancingRules");
                                            if (loadBalancingRulesArray != null && loadBalancingRulesArray instanceof NullNode == false) {
                                                for (JsonNode loadBalancingRulesValue : ((ArrayNode) loadBalancingRulesArray)) {
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                                    
                                                    JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                        String idInstance4;
                                                        idInstance4 = idValue4.getTextValue();
                                                        resourceIdInstance2.setId(idInstance4);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = frontendIPConfigurationsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = frontendIPConfigurationsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue5 = frontendIPConfigurationsValue.get("id");
                                        if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                            String idInstance5;
                                            idInstance5 = idValue5.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                                        }
                                    }
                                }
                                
                                JsonNode backendAddressPoolsArray = propertiesValue.get("backendAddressPools");
                                if (backendAddressPoolsArray != null && backendAddressPoolsArray instanceof NullNode == false) {
                                    for (JsonNode backendAddressPoolsValue : ((ArrayNode) backendAddressPoolsArray)) {
                                        BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                        loadBalancerJsonFormatInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                        
                                        JsonNode propertiesValue3 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                            JsonNode backendIPConfigurationsArray = propertiesValue3.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && backendIPConfigurationsArray instanceof NullNode == false) {
                                                for (JsonNode backendIPConfigurationsValue : ((ArrayNode) backendIPConfigurationsArray)) {
                                                    ResourceId resourceIdInstance3 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                                    
                                                    JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                                    if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                        String idInstance6;
                                                        idInstance6 = idValue6.getTextValue();
                                                        resourceIdInstance3.setId(idInstance6);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode loadBalancingRulesArray2 = propertiesValue3.get("loadBalancingRules");
                                            if (loadBalancingRulesArray2 != null && loadBalancingRulesArray2 instanceof NullNode == false) {
                                                for (JsonNode loadBalancingRulesValue2 : ((ArrayNode) loadBalancingRulesArray2)) {
                                                    ResourceId resourceIdInstance4 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                                    
                                                    JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                                    if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                        String idInstance7;
                                                        idInstance7 = idValue7.getTextValue();
                                                        resourceIdInstance4.setId(idInstance7);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                                String provisioningStateInstance2;
                                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        
                                        JsonNode nameValue2 = backendAddressPoolsValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode etagValue2 = backendAddressPoolsValue.get("etag");
                                        if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                            String etagInstance2;
                                            etagInstance2 = etagValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        
                                        JsonNode idValue8 = backendAddressPoolsValue.get("id");
                                        if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                            String idInstance8;
                                            idInstance8 = idValue8.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setId(idInstance8);
                                        }
                                    }
                                }
                                
                                JsonNode loadBalancingRulesArray3 = propertiesValue.get("loadBalancingRules");
                                if (loadBalancingRulesArray3 != null && loadBalancingRulesArray3 instanceof NullNode == false) {
                                    for (JsonNode loadBalancingRulesValue3 : ((ArrayNode) loadBalancingRulesArray3)) {
                                        LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                        loadBalancerJsonFormatInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue4 = loadBalancingRulesValue3.get("properties");
                                        if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                            JsonNode frontendIPConfigurationValue = propertiesValue4.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && frontendIPConfigurationValue instanceof NullNode == false) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                
                                                JsonNode idValue9 = frontendIPConfigurationValue.get("id");
                                                if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                                    String idInstance9;
                                                    idInstance9 = idValue9.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance9);
                                                }
                                            }
                                            
                                            JsonNode backendAddressPoolValue = propertiesValue4.get("backendAddressPool");
                                            if (backendAddressPoolValue != null && backendAddressPoolValue instanceof NullNode == false) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                
                                                JsonNode idValue10 = backendAddressPoolValue.get("id");
                                                if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                                    String idInstance10;
                                                    idInstance10 = idValue10.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance10);
                                                }
                                            }
                                            
                                            JsonNode probeValue = propertiesValue4.get("probe");
                                            if (probeValue != null && probeValue instanceof NullNode == false) {
                                                ResourceId probeInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                                
                                                JsonNode idValue11 = probeValue.get("id");
                                                if (idValue11 != null && idValue11 instanceof NullNode == false) {
                                                    String idInstance11;
                                                    idInstance11 = idValue11.getTextValue();
                                                    probeInstance.setId(idInstance11);
                                                }
                                            }
                                            
                                            JsonNode protocolValue = propertiesValue4.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode loadDistributionValue = propertiesValue4.get("loadDistribution");
                                            if (loadDistributionValue != null && loadDistributionValue instanceof NullNode == false) {
                                                String loadDistributionInstance;
                                                loadDistributionInstance = loadDistributionValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                            }
                                            
                                            JsonNode frontendPortValue = propertiesValue4.get("frontendPort");
                                            if (frontendPortValue != null && frontendPortValue instanceof NullNode == false) {
                                                int frontendPortInstance;
                                                frontendPortInstance = frontendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                            }
                                            
                                            JsonNode backendPortValue = propertiesValue4.get("backendPort");
                                            if (backendPortValue != null && backendPortValue instanceof NullNode == false) {
                                                int backendPortInstance;
                                                backendPortInstance = backendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                            }
                                            
                                            JsonNode idleTimeoutInMinutesValue = propertiesValue4.get("idleTimeoutInMinutes");
                                            if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                                                int idleTimeoutInMinutesInstance;
                                                idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                            }
                                            
                                            JsonNode enableFloatingIPValue = propertiesValue4.get("enableFloatingIP");
                                            if (enableFloatingIPValue != null && enableFloatingIPValue instanceof NullNode == false) {
                                                boolean enableFloatingIPInstance;
                                                enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                                loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue3 = propertiesValue4.get("provisioningState");
                                            if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                                String provisioningStateInstance3;
                                                provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        
                                        JsonNode nameValue3 = loadBalancingRulesValue3.get("name");
                                        if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                            String nameInstance3;
                                            nameInstance3 = nameValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                        }
                                        
                                        JsonNode etagValue3 = loadBalancingRulesValue3.get("etag");
                                        if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                            String etagInstance3;
                                            etagInstance3 = etagValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        
                                        JsonNode idValue12 = loadBalancingRulesValue3.get("id");
                                        if (idValue12 != null && idValue12 instanceof NullNode == false) {
                                            String idInstance12;
                                            idInstance12 = idValue12.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                                        }
                                    }
                                }
                                
                                JsonNode probesArray = propertiesValue.get("probes");
                                if (probesArray != null && probesArray instanceof NullNode == false) {
                                    for (JsonNode probesValue : ((ArrayNode) probesArray)) {
                                        Probe probeJsonFormatInstance = new Probe();
                                        loadBalancerJsonFormatInstance.getProbes().add(probeJsonFormatInstance);
                                        
                                        JsonNode propertiesValue5 = probesValue.get("properties");
                                        if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                            JsonNode loadBalancingRulesArray4 = propertiesValue5.get("loadBalancingRules");
                                            if (loadBalancingRulesArray4 != null && loadBalancingRulesArray4 instanceof NullNode == false) {
                                                for (JsonNode loadBalancingRulesValue4 : ((ArrayNode) loadBalancingRulesArray4)) {
                                                    ResourceId resourceIdInstance5 = new ResourceId();
                                                    probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                                    
                                                    JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                                    if (idValue13 != null && idValue13 instanceof NullNode == false) {
                                                        String idInstance13;
                                                        idInstance13 = idValue13.getTextValue();
                                                        resourceIdInstance5.setId(idInstance13);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode protocolValue2 = propertiesValue5.get("protocol");
                                            if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                                String protocolInstance2;
                                                protocolInstance2 = protocolValue2.getTextValue();
                                                probeJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            
                                            JsonNode portValue = propertiesValue5.get("port");
                                            if (portValue != null && portValue instanceof NullNode == false) {
                                                int portInstance;
                                                portInstance = portValue.getIntValue();
                                                probeJsonFormatInstance.setPort(portInstance);
                                            }
                                            
                                            JsonNode intervalInSecondsValue = propertiesValue5.get("intervalInSeconds");
                                            if (intervalInSecondsValue != null && intervalInSecondsValue instanceof NullNode == false) {
                                                int intervalInSecondsInstance;
                                                intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                                probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                            }
                                            
                                            JsonNode numberOfProbesValue = propertiesValue5.get("numberOfProbes");
                                            if (numberOfProbesValue != null && numberOfProbesValue instanceof NullNode == false) {
                                                int numberOfProbesInstance;
                                                numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                                probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                            }
                                            
                                            JsonNode requestPathValue = propertiesValue5.get("requestPath");
                                            if (requestPathValue != null && requestPathValue instanceof NullNode == false) {
                                                String requestPathInstance;
                                                requestPathInstance = requestPathValue.getTextValue();
                                                probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue4 = propertiesValue5.get("provisioningState");
                                            if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                                String provisioningStateInstance4;
                                                provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        
                                        JsonNode nameValue4 = probesValue.get("name");
                                        if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                            String nameInstance4;
                                            nameInstance4 = nameValue4.getTextValue();
                                            probeJsonFormatInstance.setName(nameInstance4);
                                        }
                                        
                                        JsonNode etagValue4 = probesValue.get("etag");
                                        if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                            String etagInstance4;
                                            etagInstance4 = etagValue4.getTextValue();
                                            probeJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        
                                        JsonNode idValue14 = probesValue.get("id");
                                        if (idValue14 != null && idValue14 instanceof NullNode == false) {
                                            String idInstance14;
                                            idInstance14 = idValue14.getTextValue();
                                            probeJsonFormatInstance.setId(idInstance14);
                                        }
                                    }
                                }
                                
                                JsonNode inboundNatRulesArray2 = propertiesValue.get("inboundNatRules");
                                if (inboundNatRulesArray2 != null && inboundNatRulesArray2 instanceof NullNode == false) {
                                    for (JsonNode inboundNatRulesValue2 : ((ArrayNode) inboundNatRulesArray2)) {
                                        InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                        loadBalancerJsonFormatInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue6 = inboundNatRulesValue2.get("properties");
                                        if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                            JsonNode frontendIPConfigurationValue2 = propertiesValue6.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue2 != null && frontendIPConfigurationValue2 instanceof NullNode == false) {
                                                ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                                
                                                JsonNode idValue15 = frontendIPConfigurationValue2.get("id");
                                                if (idValue15 != null && idValue15 instanceof NullNode == false) {
                                                    String idInstance15;
                                                    idInstance15 = idValue15.getTextValue();
                                                    frontendIPConfigurationInstance2.setId(idInstance15);
                                                }
                                            }
                                            
                                            JsonNode backendIPConfigurationValue = propertiesValue6.get("backendIPConfiguration");
                                            if (backendIPConfigurationValue != null && backendIPConfigurationValue instanceof NullNode == false) {
                                                ResourceId backendIPConfigurationInstance = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                                
                                                JsonNode idValue16 = backendIPConfigurationValue.get("id");
                                                if (idValue16 != null && idValue16 instanceof NullNode == false) {
                                                    String idInstance16;
                                                    idInstance16 = idValue16.getTextValue();
                                                    backendIPConfigurationInstance.setId(idInstance16);
                                                }
                                            }
                                            
                                            JsonNode protocolValue3 = propertiesValue6.get("protocol");
                                            if (protocolValue3 != null && protocolValue3 instanceof NullNode == false) {
                                                String protocolInstance3;
                                                protocolInstance3 = protocolValue3.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                            }
                                            
                                            JsonNode frontendPortValue2 = propertiesValue6.get("frontendPort");
                                            if (frontendPortValue2 != null && frontendPortValue2 instanceof NullNode == false) {
                                                int frontendPortInstance2;
                                                frontendPortInstance2 = frontendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                            }
                                            
                                            JsonNode backendPortValue2 = propertiesValue6.get("backendPort");
                                            if (backendPortValue2 != null && backendPortValue2 instanceof NullNode == false) {
                                                int backendPortInstance2;
                                                backendPortInstance2 = backendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                            }
                                            
                                            JsonNode idleTimeoutInMinutesValue2 = propertiesValue6.get("idleTimeoutInMinutes");
                                            if (idleTimeoutInMinutesValue2 != null && idleTimeoutInMinutesValue2 instanceof NullNode == false) {
                                                int idleTimeoutInMinutesInstance2;
                                                idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                            }
                                            
                                            JsonNode enableFloatingIPValue2 = propertiesValue6.get("enableFloatingIP");
                                            if (enableFloatingIPValue2 != null && enableFloatingIPValue2 instanceof NullNode == false) {
                                                boolean enableFloatingIPInstance2;
                                                enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                                inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                            }
                                            
                                            JsonNode provisioningStateValue5 = propertiesValue6.get("provisioningState");
                                            if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                                String provisioningStateInstance5;
                                                provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        
                                        JsonNode nameValue5 = inboundNatRulesValue2.get("name");
                                        if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                            String nameInstance5;
                                            nameInstance5 = nameValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                        }
                                        
                                        JsonNode etagValue5 = inboundNatRulesValue2.get("etag");
                                        if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                            String etagInstance5;
                                            etagInstance5 = etagValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        
                                        JsonNode idValue17 = inboundNatRulesValue2.get("id");
                                        if (idValue17 != null && idValue17 instanceof NullNode == false) {
                                            String idInstance17;
                                            idInstance17 = idValue17.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setId(idInstance17);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue6 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                                    String provisioningStateInstance6;
                                    provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                    loadBalancerJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                }
                            }
                            
                            JsonNode etagValue6 = valueValue.get("etag");
                            if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                                String etagInstance6;
                                etagInstance6 = etagValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setEtag(etagInstance6);
                            }
                            
                            JsonNode idValue18 = valueValue.get("id");
                            if (idValue18 != null && idValue18 instanceof NullNode == false) {
                                String idInstance18;
                                idInstance18 = idValue18.getTextValue();
                                loadBalancerJsonFormatInstance.setId(idInstance18);
                            }
                            
                            JsonNode nameValue6 = valueValue.get("name");
                            if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                String nameInstance6;
                                nameInstance6 = nameValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setName(nameInstance6);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                loadBalancerJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                loadBalancerJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    loadBalancerJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
