/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.LocalNetworkGateway;
import com.microsoft.azure.management.network.models.LocalNetworkGatewayGetResponse;
import com.microsoft.azure.management.network.models.LocalNetworkGatewayListResponse;
import com.microsoft.azure.management.network.models.LocalNetworkGatewayPutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* Virtual network Gateway for your subscription.
*/
public interface LocalNetworkGatewayOperations {
    /**
    * The Put LocalNetworkGateway operation creates/updates a local network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Local Network Gateway operation through Network resource provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutLocalNetworkGateway Api servive call
    */
    LocalNetworkGatewayPutResponse beginCreateOrUpdating(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGateway parameters) throws IOException, ServiceException;
    
    /**
    * The Put LocalNetworkGateway operation creates/updates a local network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Local Network Gateway operation through Network resource provider.
    * @return Response for PutLocalNetworkGateway Api servive call
    */
    Future<LocalNetworkGatewayPutResponse> beginCreateOrUpdatingAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGateway parameters);
    
    /**
    * The Delete LocalNetworkGateway operation deletes the specifed local
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    UpdateOperationResponse beginDeleting(String resourceGroupName, String localNetworkGatewayName) throws IOException, ServiceException;
    
    /**
    * The Delete LocalNetworkGateway operation deletes the specifed local
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    Future<UpdateOperationResponse> beginDeletingAsync(String resourceGroupName, String localNetworkGatewayName);
    
    /**
    * The Put LocalNetworkGateway operation creates/updates a local network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Local Network Gateway operation through Network resource provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGateway parameters) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * The Put LocalNetworkGateway operation creates/updates a local network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Local Network Gateway operation through Network resource provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<AzureAsyncOperationResponse> createOrUpdateAsync(String resourceGroupName, String localNetworkGatewayName, LocalNetworkGateway parameters);
    
    /**
    * The Delete LocalNetworkGateway operation deletes the specifed local
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String localNetworkGatewayName) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * The Delete LocalNetworkGateway operation deletes the specifed local
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String localNetworkGatewayName);
    
    /**
    * The Get LocalNetworkGateway operation retrieves information about the
    * specified local network gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetLocalNetworkgateway Api servive call.
    */
    LocalNetworkGatewayGetResponse get(String resourceGroupName, String localNetworkGatewayName) throws IOException, ServiceException;
    
    /**
    * The Get LocalNetworkGateway operation retrieves information about the
    * specified local network gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param localNetworkGatewayName Required. The name of the local network
    * gateway.
    * @return Response for GetLocalNetworkgateway Api servive call.
    */
    Future<LocalNetworkGatewayGetResponse> getAsync(String resourceGroupName, String localNetworkGatewayName);
    
    /**
    * The List LocalNetworkGateways opertion retrieves all the local network
    * gateways stored.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListLocalNetworkGateways Api service call
    */
    LocalNetworkGatewayListResponse list(String resourceGroupName) throws IOException, ServiceException;
    
    /**
    * The List LocalNetworkGateways opertion retrieves all the local network
    * gateways stored.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListLocalNetworkGateways Api service call
    */
    Future<LocalNetworkGatewayListResponse> listAsync(String resourceGroupName);
}
