/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.NetworkInterface;
import com.microsoft.azure.management.network.models.NetworkInterfaceDnsSettings;
import com.microsoft.azure.management.network.models.NetworkInterfaceGetResponse;
import com.microsoft.azure.management.network.models.NetworkInterfaceIpConfiguration;
import com.microsoft.azure.management.network.models.NetworkInterfaceListResponse;
import com.microsoft.azure.management.network.models.NetworkInterfacePutResponse;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* subnets for your subscription.
*/
public class NetworkInterfaceOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, NetworkInterfaceOperations {
    /**
    * Initializes a new instance of the NetworkInterfaceOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    NetworkInterfaceOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put NetworkInterface operation creates/updates a networkInterface
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @param parameters Required. Parameters supplied to the create/update
    * NetworkInterface operation
    * @return Response for PutNetworkInterface Api servive call
    */
    @Override
    public Future<NetworkInterfacePutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String networkInterfaceName, final NetworkInterface parameters) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfacePutResponse>() { 
            @Override
            public NetworkInterfacePutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, networkInterfaceName, parameters);
            }
         });
    }
    
    /**
    * The Put NetworkInterface operation creates/updates a networkInterface
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @param parameters Required. Parameters supplied to the create/update
    * NetworkInterface operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutNetworkInterface Api servive call
    */
    @Override
    public NetworkInterfacePutResponse beginCreateOrUpdating(String resourceGroupName, String networkInterfaceName, NetworkInterface parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkInterfaceName == null) {
            throw new NullPointerException("networkInterfaceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces/";
        url = url + URLEncoder.encode(networkInterfaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode networkInterfaceJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = networkInterfaceJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) networkInterfaceJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getVirtualMachine() != null) {
            ObjectNode virtualMachineValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("virtualMachine", virtualMachineValue);
            
            if (parameters.getVirtualMachine().getId() != null) {
                ((ObjectNode) virtualMachineValue).put("id", parameters.getVirtualMachine().getId());
            }
        }
        
        if (parameters.getNetworkSecurityGroup() != null) {
            ObjectNode networkSecurityGroupValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("networkSecurityGroup", networkSecurityGroupValue);
            
            if (parameters.getNetworkSecurityGroup().getId() != null) {
                ((ObjectNode) networkSecurityGroupValue).put("id", parameters.getNetworkSecurityGroup().getId());
            }
        }
        
        if (parameters.getIpConfigurations() != null) {
            if (parameters.getIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getIpConfigurations()).isInitialized()) {
                ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                for (NetworkInterfaceIpConfiguration ipConfigurationsItem : parameters.getIpConfigurations()) {
                    ObjectNode networkInterfaceIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                    ipConfigurationsArray.add(networkInterfaceIpConfigurationJsonFormatValue);
                    
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) networkInterfaceIpConfigurationJsonFormatValue).put("properties", propertiesValue2);
                    
                    if (ipConfigurationsItem.getPrivateIpAddress() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAddress", ipConfigurationsItem.getPrivateIpAddress());
                    }
                    
                    if (ipConfigurationsItem.getPrivateIpAllocationMethod() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAllocationMethod", ipConfigurationsItem.getPrivateIpAllocationMethod());
                    }
                    
                    if (ipConfigurationsItem.getSubnet() != null) {
                        ObjectNode subnetValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("subnet", subnetValue);
                        
                        if (ipConfigurationsItem.getSubnet().getId() != null) {
                            ((ObjectNode) subnetValue).put("id", ipConfigurationsItem.getSubnet().getId());
                        }
                    }
                    
                    if (ipConfigurationsItem.getPublicIpAddress() != null) {
                        ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("publicIPAddress", publicIPAddressValue);
                        
                        if (ipConfigurationsItem.getPublicIpAddress().getId() != null) {
                            ((ObjectNode) publicIPAddressValue).put("id", ipConfigurationsItem.getPublicIpAddress().getId());
                        }
                    }
                    
                    if (ipConfigurationsItem.getLoadBalancerBackendAddressPools() != null) {
                        if (ipConfigurationsItem.getLoadBalancerBackendAddressPools() instanceof LazyCollection == false || ((LazyCollection) ipConfigurationsItem.getLoadBalancerBackendAddressPools()).isInitialized()) {
                            ArrayNode loadBalancerBackendAddressPoolsArray = objectMapper.createArrayNode();
                            for (ResourceId loadBalancerBackendAddressPoolsItem : ipConfigurationsItem.getLoadBalancerBackendAddressPools()) {
                                ObjectNode resourceIdValue = objectMapper.createObjectNode();
                                loadBalancerBackendAddressPoolsArray.add(resourceIdValue);
                                
                                if (loadBalancerBackendAddressPoolsItem.getId() != null) {
                                    ((ObjectNode) resourceIdValue).put("id", loadBalancerBackendAddressPoolsItem.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue2).put("loadBalancerBackendAddressPools", loadBalancerBackendAddressPoolsArray);
                        }
                    }
                    
                    if (ipConfigurationsItem.getLoadBalancerInboundNatRules() != null) {
                        if (ipConfigurationsItem.getLoadBalancerInboundNatRules() instanceof LazyCollection == false || ((LazyCollection) ipConfigurationsItem.getLoadBalancerInboundNatRules()).isInitialized()) {
                            ArrayNode loadBalancerInboundNatRulesArray = objectMapper.createArrayNode();
                            for (ResourceId loadBalancerInboundNatRulesItem : ipConfigurationsItem.getLoadBalancerInboundNatRules()) {
                                ObjectNode resourceIdValue2 = objectMapper.createObjectNode();
                                loadBalancerInboundNatRulesArray.add(resourceIdValue2);
                                
                                if (loadBalancerInboundNatRulesItem.getId() != null) {
                                    ((ObjectNode) resourceIdValue2).put("id", loadBalancerInboundNatRulesItem.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue2).put("loadBalancerInboundNatRules", loadBalancerInboundNatRulesArray);
                        }
                    }
                    
                    if (ipConfigurationsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue2).put("provisioningState", ipConfigurationsItem.getProvisioningState());
                    }
                    
                    if (ipConfigurationsItem.getName() != null) {
                        ((ObjectNode) networkInterfaceIpConfigurationJsonFormatValue).put("name", ipConfigurationsItem.getName());
                    }
                    
                    if (ipConfigurationsItem.getEtag() != null) {
                        ((ObjectNode) networkInterfaceIpConfigurationJsonFormatValue).put("etag", ipConfigurationsItem.getEtag());
                    }
                    
                    if (ipConfigurationsItem.getId() != null) {
                        ((ObjectNode) networkInterfaceIpConfigurationJsonFormatValue).put("id", ipConfigurationsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("ipConfigurations", ipConfigurationsArray);
            }
        }
        
        if (parameters.getDnsSettings() != null) {
            ObjectNode dnsSettingsValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("dnsSettings", dnsSettingsValue);
            
            if (parameters.getDnsSettings().getDnsServers() != null) {
                if (parameters.getDnsSettings().getDnsServers() instanceof LazyCollection == false || ((LazyCollection) parameters.getDnsSettings().getDnsServers()).isInitialized()) {
                    ArrayNode dnsServersArray = objectMapper.createArrayNode();
                    for (String dnsServersItem : parameters.getDnsSettings().getDnsServers()) {
                        dnsServersArray.add(dnsServersItem);
                    }
                    ((ObjectNode) dnsSettingsValue).put("dnsServers", dnsServersArray);
                }
            }
            
            if (parameters.getDnsSettings().getAppliedDnsServers() != null) {
                if (parameters.getDnsSettings().getAppliedDnsServers() instanceof LazyCollection == false || ((LazyCollection) parameters.getDnsSettings().getAppliedDnsServers()).isInitialized()) {
                    ArrayNode appliedDnsServersArray = objectMapper.createArrayNode();
                    for (String appliedDnsServersItem : parameters.getDnsSettings().getAppliedDnsServers()) {
                        appliedDnsServersArray.add(appliedDnsServersItem);
                    }
                    ((ObjectNode) dnsSettingsValue).put("appliedDnsServers", appliedDnsServersArray);
                }
            }
            
            if (parameters.getDnsSettings().getInternalDnsNameLabel() != null) {
                ((ObjectNode) dnsSettingsValue).put("internalDnsNameLabel", parameters.getDnsSettings().getInternalDnsNameLabel());
            }
            
            if (parameters.getDnsSettings().getInternalFqdn() != null) {
                ((ObjectNode) dnsSettingsValue).put("internalFqdn", parameters.getDnsSettings().getInternalFqdn());
            }
        }
        
        if (parameters.getMacAddress() != null) {
            ((ObjectNode) propertiesValue).put("macAddress", parameters.getMacAddress());
        }
        
        if (parameters.isPrimary() != null) {
            ((ObjectNode) propertiesValue).put("primary", parameters.isPrimary());
        }
        
        ((ObjectNode) propertiesValue).put("enableIPForwarding", parameters.isEnableIPForwarding());
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) networkInterfaceJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) networkInterfaceJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) networkInterfaceJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) networkInterfaceJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) networkInterfaceJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) networkInterfaceJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkInterfacePutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkInterfacePutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NetworkInterface networkInterfaceInstance = new NetworkInterface();
                    result.setNetworkInterface(networkInterfaceInstance);
                    
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                        JsonNode virtualMachineValue2 = propertiesValue3.get("virtualMachine");
                        if (virtualMachineValue2 != null && virtualMachineValue2 instanceof NullNode == false) {
                            ResourceId virtualMachineInstance = new ResourceId();
                            networkInterfaceInstance.setVirtualMachine(virtualMachineInstance);
                            
                            JsonNode idValue = virtualMachineValue2.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                virtualMachineInstance.setId(idInstance);
                            }
                        }
                        
                        JsonNode networkSecurityGroupValue2 = propertiesValue3.get("networkSecurityGroup");
                        if (networkSecurityGroupValue2 != null && networkSecurityGroupValue2 instanceof NullNode == false) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            networkInterfaceInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            
                            JsonNode idValue2 = networkSecurityGroupValue2.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance2);
                            }
                        }
                        
                        JsonNode ipConfigurationsArray2 = propertiesValue3.get("ipConfigurations");
                        if (ipConfigurationsArray2 != null && ipConfigurationsArray2 instanceof NullNode == false) {
                            for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray2)) {
                                NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                networkInterfaceInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue4 = ipConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue2 = propertiesValue4.get("subnet");
                                    if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue3 = subnetValue2.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            subnetInstance.setId(idInstance3);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue2 = propertiesValue4.get("publicIPAddress");
                                    if (publicIPAddressValue2 != null && publicIPAddressValue2 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue4 = publicIPAddressValue2.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            publicIPAddressInstance.setId(idInstance4);
                                        }
                                    }
                                    
                                    JsonNode loadBalancerBackendAddressPoolsArray2 = propertiesValue4.get("loadBalancerBackendAddressPools");
                                    if (loadBalancerBackendAddressPoolsArray2 != null && loadBalancerBackendAddressPoolsArray2 instanceof NullNode == false) {
                                        for (JsonNode loadBalancerBackendAddressPoolsValue : ((ArrayNode) loadBalancerBackendAddressPoolsArray2)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                            
                                            JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                String idInstance5;
                                                idInstance5 = idValue5.getTextValue();
                                                resourceIdInstance.setId(idInstance5);
                                            }
                                        }
                                    }
                                    
                                    JsonNode loadBalancerInboundNatRulesArray2 = propertiesValue4.get("loadBalancerInboundNatRules");
                                    if (loadBalancerInboundNatRulesArray2 != null && loadBalancerInboundNatRulesArray2 instanceof NullNode == false) {
                                        for (JsonNode loadBalancerInboundNatRulesValue : ((ArrayNode) loadBalancerInboundNatRulesArray2)) {
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                            
                                            JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                            if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                String idInstance6;
                                                idInstance6 = idValue6.getTextValue();
                                                resourceIdInstance2.setId(idInstance6);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue4.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = ipConfigurationsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = ipConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue7 = ipConfigurationsValue.get("id");
                                if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                    String idInstance7;
                                    idInstance7 = idValue7.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                                }
                            }
                        }
                        
                        JsonNode dnsSettingsValue2 = propertiesValue3.get("dnsSettings");
                        if (dnsSettingsValue2 != null && dnsSettingsValue2 instanceof NullNode == false) {
                            NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                            networkInterfaceInstance.setDnsSettings(dnsSettingsInstance);
                            
                            JsonNode dnsServersArray2 = dnsSettingsValue2.get("dnsServers");
                            if (dnsServersArray2 != null && dnsServersArray2 instanceof NullNode == false) {
                                for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray2)) {
                                    dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                            
                            JsonNode appliedDnsServersArray2 = dnsSettingsValue2.get("appliedDnsServers");
                            if (appliedDnsServersArray2 != null && appliedDnsServersArray2 instanceof NullNode == false) {
                                for (JsonNode appliedDnsServersValue : ((ArrayNode) appliedDnsServersArray2)) {
                                    dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                }
                            }
                            
                            JsonNode internalDnsNameLabelValue = dnsSettingsValue2.get("internalDnsNameLabel");
                            if (internalDnsNameLabelValue != null && internalDnsNameLabelValue instanceof NullNode == false) {
                                String internalDnsNameLabelInstance;
                                internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                            }
                            
                            JsonNode internalFqdnValue = dnsSettingsValue2.get("internalFqdn");
                            if (internalFqdnValue != null && internalFqdnValue instanceof NullNode == false) {
                                String internalFqdnInstance;
                                internalFqdnInstance = internalFqdnValue.getTextValue();
                                dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                            }
                        }
                        
                        JsonNode macAddressValue = propertiesValue3.get("macAddress");
                        if (macAddressValue != null && macAddressValue instanceof NullNode == false) {
                            String macAddressInstance;
                            macAddressInstance = macAddressValue.getTextValue();
                            networkInterfaceInstance.setMacAddress(macAddressInstance);
                        }
                        
                        JsonNode primaryValue = propertiesValue3.get("primary");
                        if (primaryValue != null && primaryValue instanceof NullNode == false) {
                            boolean primaryInstance;
                            primaryInstance = primaryValue.getBooleanValue();
                            networkInterfaceInstance.setPrimary(primaryInstance);
                        }
                        
                        JsonNode enableIPForwardingValue = propertiesValue3.get("enableIPForwarding");
                        if (enableIPForwardingValue != null && enableIPForwardingValue instanceof NullNode == false) {
                            boolean enableIPForwardingInstance;
                            enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                            networkInterfaceInstance.setEnableIPForwarding(enableIPForwardingInstance);
                        }
                        
                        JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                            String provisioningStateInstance2;
                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            networkInterfaceInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    
                    JsonNode etagValue2 = responseDoc.get("etag");
                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                        String etagInstance2;
                        etagInstance2 = etagValue2.getTextValue();
                        networkInterfaceInstance.setEtag(etagInstance2);
                    }
                    
                    JsonNode idValue8 = responseDoc.get("id");
                    if (idValue8 != null && idValue8 instanceof NullNode == false) {
                        String idInstance8;
                        idInstance8 = idValue8.getTextValue();
                        networkInterfaceInstance.setId(idInstance8);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        networkInterfaceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        networkInterfaceInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        networkInterfaceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            networkInterfaceInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete netwokInterface operation deletes the specified
    * netwokInterface.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String networkInterfaceName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, networkInterfaceName);
            }
         });
    }
    
    /**
    * The delete netwokInterface operation deletes the specified
    * netwokInterface.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String networkInterfaceName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkInterfaceName == null) {
            throw new NullPointerException("networkInterfaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces/";
        url = url + URLEncoder.encode(networkInterfaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put NetworkInterface operation creates/updates a networkInterface
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @param parameters Required. Parameters supplied to the create/update
    * NetworkInterface operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String networkInterfaceName, final NetworkInterface parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, networkInterfaceName, parameters);
            }
         });
    }
    
    /**
    * The Put NetworkInterface operation creates/updates a networkInterface
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @param parameters Required. Parameters supplied to the create/update
    * NetworkInterface operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String networkInterfaceName, NetworkInterface parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            NetworkInterfacePutResponse response = client2.getNetworkInterfacesOperations().beginCreateOrUpdatingAsync(resourceGroupName, networkInterfaceName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String networkInterfaceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, networkInterfaceName);
            }
         });
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String networkInterfaceName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getNetworkInterfacesOperations().beginDeletingAsync(resourceGroupName, networkInterfaceName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get ntework interface operation retreives information about the
    * specified network interface.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @return Response for GetNetworkInterface Api service call
    */
    @Override
    public Future<NetworkInterfaceGetResponse> getAsync(final String resourceGroupName, final String networkInterfaceName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfaceGetResponse>() { 
            @Override
            public NetworkInterfaceGetResponse call() throws Exception {
                return get(resourceGroupName, networkInterfaceName);
            }
         });
    }
    
    /**
    * The Get ntework interface operation retreives information about the
    * specified network interface.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkInterfaceName Required. The name of the network interface.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetNetworkInterface Api service call
    */
    @Override
    public NetworkInterfaceGetResponse get(String resourceGroupName, String networkInterfaceName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkInterfaceName == null) {
            throw new NullPointerException("networkInterfaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces/";
        url = url + URLEncoder.encode(networkInterfaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkInterfaceGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkInterfaceGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NetworkInterface networkInterfaceInstance = new NetworkInterface();
                    result.setNetworkInterface(networkInterfaceInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode virtualMachineValue = propertiesValue.get("virtualMachine");
                        if (virtualMachineValue != null && virtualMachineValue instanceof NullNode == false) {
                            ResourceId virtualMachineInstance = new ResourceId();
                            networkInterfaceInstance.setVirtualMachine(virtualMachineInstance);
                            
                            JsonNode idValue = virtualMachineValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                virtualMachineInstance.setId(idInstance);
                            }
                        }
                        
                        JsonNode networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup");
                        if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            networkInterfaceInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            
                            JsonNode idValue2 = networkSecurityGroupValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance2);
                            }
                        }
                        
                        JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                        if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                            for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                networkInterfaceInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue = propertiesValue2.get("subnet");
                                    if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue3 = subnetValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            subnetInstance.setId(idInstance3);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                    if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue4 = publicIPAddressValue.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            publicIPAddressInstance.setId(idInstance4);
                                        }
                                    }
                                    
                                    JsonNode loadBalancerBackendAddressPoolsArray = propertiesValue2.get("loadBalancerBackendAddressPools");
                                    if (loadBalancerBackendAddressPoolsArray != null && loadBalancerBackendAddressPoolsArray instanceof NullNode == false) {
                                        for (JsonNode loadBalancerBackendAddressPoolsValue : ((ArrayNode) loadBalancerBackendAddressPoolsArray)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                            
                                            JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                String idInstance5;
                                                idInstance5 = idValue5.getTextValue();
                                                resourceIdInstance.setId(idInstance5);
                                            }
                                        }
                                    }
                                    
                                    JsonNode loadBalancerInboundNatRulesArray = propertiesValue2.get("loadBalancerInboundNatRules");
                                    if (loadBalancerInboundNatRulesArray != null && loadBalancerInboundNatRulesArray instanceof NullNode == false) {
                                        for (JsonNode loadBalancerInboundNatRulesValue : ((ArrayNode) loadBalancerInboundNatRulesArray)) {
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                            
                                            JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                            if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                String idInstance6;
                                                idInstance6 = idValue6.getTextValue();
                                                resourceIdInstance2.setId(idInstance6);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = ipConfigurationsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = ipConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue7 = ipConfigurationsValue.get("id");
                                if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                    String idInstance7;
                                    idInstance7 = idValue7.getTextValue();
                                    networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                                }
                            }
                        }
                        
                        JsonNode dnsSettingsValue = propertiesValue.get("dnsSettings");
                        if (dnsSettingsValue != null && dnsSettingsValue instanceof NullNode == false) {
                            NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                            networkInterfaceInstance.setDnsSettings(dnsSettingsInstance);
                            
                            JsonNode dnsServersArray = dnsSettingsValue.get("dnsServers");
                            if (dnsServersArray != null && dnsServersArray instanceof NullNode == false) {
                                for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray)) {
                                    dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                            
                            JsonNode appliedDnsServersArray = dnsSettingsValue.get("appliedDnsServers");
                            if (appliedDnsServersArray != null && appliedDnsServersArray instanceof NullNode == false) {
                                for (JsonNode appliedDnsServersValue : ((ArrayNode) appliedDnsServersArray)) {
                                    dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                }
                            }
                            
                            JsonNode internalDnsNameLabelValue = dnsSettingsValue.get("internalDnsNameLabel");
                            if (internalDnsNameLabelValue != null && internalDnsNameLabelValue instanceof NullNode == false) {
                                String internalDnsNameLabelInstance;
                                internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                            }
                            
                            JsonNode internalFqdnValue = dnsSettingsValue.get("internalFqdn");
                            if (internalFqdnValue != null && internalFqdnValue instanceof NullNode == false) {
                                String internalFqdnInstance;
                                internalFqdnInstance = internalFqdnValue.getTextValue();
                                dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                            }
                        }
                        
                        JsonNode macAddressValue = propertiesValue.get("macAddress");
                        if (macAddressValue != null && macAddressValue instanceof NullNode == false) {
                            String macAddressInstance;
                            macAddressInstance = macAddressValue.getTextValue();
                            networkInterfaceInstance.setMacAddress(macAddressInstance);
                        }
                        
                        JsonNode primaryValue = propertiesValue.get("primary");
                        if (primaryValue != null && primaryValue instanceof NullNode == false) {
                            boolean primaryInstance;
                            primaryInstance = primaryValue.getBooleanValue();
                            networkInterfaceInstance.setPrimary(primaryInstance);
                        }
                        
                        JsonNode enableIPForwardingValue = propertiesValue.get("enableIPForwarding");
                        if (enableIPForwardingValue != null && enableIPForwardingValue instanceof NullNode == false) {
                            boolean enableIPForwardingInstance;
                            enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                            networkInterfaceInstance.setEnableIPForwarding(enableIPForwardingInstance);
                        }
                        
                        JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                            String provisioningStateInstance2;
                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            networkInterfaceInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    
                    JsonNode etagValue2 = responseDoc.get("etag");
                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                        String etagInstance2;
                        etagInstance2 = etagValue2.getTextValue();
                        networkInterfaceInstance.setEtag(etagInstance2);
                    }
                    
                    JsonNode idValue8 = responseDoc.get("id");
                    if (idValue8 != null && idValue8 instanceof NullNode == false) {
                        String idInstance8;
                        idInstance8 = idValue8.getTextValue();
                        networkInterfaceInstance.setId(idInstance8);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        networkInterfaceInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        networkInterfaceInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        networkInterfaceInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            networkInterfaceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List networkInterfaces opertion retrieves all the networkInterfaces
    * in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListNetworkInterface Api service call
    */
    @Override
    public Future<NetworkInterfaceListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfaceListResponse>() { 
            @Override
            public NetworkInterfaceListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The List networkInterfaces opertion retrieves all the networkInterfaces
    * in a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListNetworkInterface Api service call
    */
    @Override
    public NetworkInterfaceListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkInterfaceListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkInterfaceListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            NetworkInterface networkInterfaceJsonFormatInstance = new NetworkInterface();
                            result.getNetworkInterfaces().add(networkInterfaceJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode virtualMachineValue = propertiesValue.get("virtualMachine");
                                if (virtualMachineValue != null && virtualMachineValue instanceof NullNode == false) {
                                    ResourceId virtualMachineInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setVirtualMachine(virtualMachineInstance);
                                    
                                    JsonNode idValue = virtualMachineValue.get("id");
                                    if (idValue != null && idValue instanceof NullNode == false) {
                                        String idInstance;
                                        idInstance = idValue.getTextValue();
                                        virtualMachineInstance.setId(idInstance);
                                    }
                                }
                                
                                JsonNode networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup");
                                if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                                    ResourceId networkSecurityGroupInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                    
                                    JsonNode idValue2 = networkSecurityGroupValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        networkSecurityGroupInstance.setId(idInstance2);
                                    }
                                }
                                
                                JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                                if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                        NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                        networkInterfaceJsonFormatInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue3 = subnetValue.get("id");
                                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                    String idInstance3;
                                                    idInstance3 = idValue3.getTextValue();
                                                    subnetInstance.setId(idInstance3);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue4 = publicIPAddressValue.get("id");
                                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                    String idInstance4;
                                                    idInstance4 = idValue4.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance4);
                                                }
                                            }
                                            
                                            JsonNode loadBalancerBackendAddressPoolsArray = propertiesValue2.get("loadBalancerBackendAddressPools");
                                            if (loadBalancerBackendAddressPoolsArray != null && loadBalancerBackendAddressPoolsArray instanceof NullNode == false) {
                                                for (JsonNode loadBalancerBackendAddressPoolsValue : ((ArrayNode) loadBalancerBackendAddressPoolsArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                        String idInstance5;
                                                        idInstance5 = idValue5.getTextValue();
                                                        resourceIdInstance.setId(idInstance5);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode loadBalancerInboundNatRulesArray = propertiesValue2.get("loadBalancerInboundNatRules");
                                            if (loadBalancerInboundNatRulesArray != null && loadBalancerInboundNatRulesArray instanceof NullNode == false) {
                                                for (JsonNode loadBalancerInboundNatRulesValue : ((ArrayNode) loadBalancerInboundNatRulesArray)) {
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                                    
                                                    JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                                    if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                        String idInstance6;
                                                        idInstance6 = idValue6.getTextValue();
                                                        resourceIdInstance2.setId(idInstance6);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = ipConfigurationsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = ipConfigurationsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue7 = ipConfigurationsValue.get("id");
                                        if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                            String idInstance7;
                                            idInstance7 = idValue7.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                                        }
                                    }
                                }
                                
                                JsonNode dnsSettingsValue = propertiesValue.get("dnsSettings");
                                if (dnsSettingsValue != null && dnsSettingsValue instanceof NullNode == false) {
                                    NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                                    networkInterfaceJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    
                                    JsonNode dnsServersArray = dnsSettingsValue.get("dnsServers");
                                    if (dnsServersArray != null && dnsServersArray instanceof NullNode == false) {
                                        for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray)) {
                                            dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode appliedDnsServersArray = dnsSettingsValue.get("appliedDnsServers");
                                    if (appliedDnsServersArray != null && appliedDnsServersArray instanceof NullNode == false) {
                                        for (JsonNode appliedDnsServersValue : ((ArrayNode) appliedDnsServersArray)) {
                                            dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode internalDnsNameLabelValue = dnsSettingsValue.get("internalDnsNameLabel");
                                    if (internalDnsNameLabelValue != null && internalDnsNameLabelValue instanceof NullNode == false) {
                                        String internalDnsNameLabelInstance;
                                        internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                                    }
                                    
                                    JsonNode internalFqdnValue = dnsSettingsValue.get("internalFqdn");
                                    if (internalFqdnValue != null && internalFqdnValue instanceof NullNode == false) {
                                        String internalFqdnInstance;
                                        internalFqdnInstance = internalFqdnValue.getTextValue();
                                        dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                                    }
                                }
                                
                                JsonNode macAddressValue = propertiesValue.get("macAddress");
                                if (macAddressValue != null && macAddressValue instanceof NullNode == false) {
                                    String macAddressInstance;
                                    macAddressInstance = macAddressValue.getTextValue();
                                    networkInterfaceJsonFormatInstance.setMacAddress(macAddressInstance);
                                }
                                
                                JsonNode primaryValue = propertiesValue.get("primary");
                                if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                    boolean primaryInstance;
                                    primaryInstance = primaryValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setPrimary(primaryInstance);
                                }
                                
                                JsonNode enableIPForwardingValue = propertiesValue.get("enableIPForwarding");
                                if (enableIPForwardingValue != null && enableIPForwardingValue instanceof NullNode == false) {
                                    boolean enableIPForwardingInstance;
                                    enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setEnableIPForwarding(enableIPForwardingInstance);
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    networkInterfaceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            
                            JsonNode etagValue2 = valueValue.get("etag");
                            if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                String etagInstance2;
                                etagInstance2 = etagValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setEtag(etagInstance2);
                            }
                            
                            JsonNode idValue8 = valueValue.get("id");
                            if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                String idInstance8;
                                idInstance8 = idValue8.getTextValue();
                                networkInterfaceJsonFormatInstance.setId(idInstance8);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    networkInterfaceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List networkInterfaces opertion retrieves all the networkInterfaces
    * in a subscription.
    *
    * @return Response for ListNetworkInterface Api service call
    */
    @Override
    public Future<NetworkInterfaceListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NetworkInterfaceListResponse>() { 
            @Override
            public NetworkInterfaceListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * The List networkInterfaces opertion retrieves all the networkInterfaces
    * in a subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListNetworkInterface Api service call
    */
    @Override
    public NetworkInterfaceListResponse listAll() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkInterfaces";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkInterfaceListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkInterfaceListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            NetworkInterface networkInterfaceJsonFormatInstance = new NetworkInterface();
                            result.getNetworkInterfaces().add(networkInterfaceJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode virtualMachineValue = propertiesValue.get("virtualMachine");
                                if (virtualMachineValue != null && virtualMachineValue instanceof NullNode == false) {
                                    ResourceId virtualMachineInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setVirtualMachine(virtualMachineInstance);
                                    
                                    JsonNode idValue = virtualMachineValue.get("id");
                                    if (idValue != null && idValue instanceof NullNode == false) {
                                        String idInstance;
                                        idInstance = idValue.getTextValue();
                                        virtualMachineInstance.setId(idInstance);
                                    }
                                }
                                
                                JsonNode networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup");
                                if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                                    ResourceId networkSecurityGroupInstance = new ResourceId();
                                    networkInterfaceJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                    
                                    JsonNode idValue2 = networkSecurityGroupValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        networkSecurityGroupInstance.setId(idInstance2);
                                    }
                                }
                                
                                JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                                if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                        NetworkInterfaceIpConfiguration networkInterfaceIpConfigurationJsonFormatInstance = new NetworkInterfaceIpConfiguration();
                                        networkInterfaceJsonFormatInstance.getIpConfigurations().add(networkInterfaceIpConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue3 = subnetValue.get("id");
                                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                    String idInstance3;
                                                    idInstance3 = idValue3.getTextValue();
                                                    subnetInstance.setId(idInstance3);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue4 = publicIPAddressValue.get("id");
                                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                                    String idInstance4;
                                                    idInstance4 = idValue4.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance4);
                                                }
                                            }
                                            
                                            JsonNode loadBalancerBackendAddressPoolsArray = propertiesValue2.get("loadBalancerBackendAddressPools");
                                            if (loadBalancerBackendAddressPoolsArray != null && loadBalancerBackendAddressPoolsArray instanceof NullNode == false) {
                                                for (JsonNode loadBalancerBackendAddressPoolsValue : ((ArrayNode) loadBalancerBackendAddressPoolsArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerBackendAddressPools().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue5 = loadBalancerBackendAddressPoolsValue.get("id");
                                                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                        String idInstance5;
                                                        idInstance5 = idValue5.getTextValue();
                                                        resourceIdInstance.setId(idInstance5);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode loadBalancerInboundNatRulesArray = propertiesValue2.get("loadBalancerInboundNatRules");
                                            if (loadBalancerInboundNatRulesArray != null && loadBalancerInboundNatRulesArray instanceof NullNode == false) {
                                                for (JsonNode loadBalancerInboundNatRulesValue : ((ArrayNode) loadBalancerInboundNatRulesArray)) {
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    networkInterfaceIpConfigurationJsonFormatInstance.getLoadBalancerInboundNatRules().add(resourceIdInstance2);
                                                    
                                                    JsonNode idValue6 = loadBalancerInboundNatRulesValue.get("id");
                                                    if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                        String idInstance6;
                                                        idInstance6 = idValue6.getTextValue();
                                                        resourceIdInstance2.setId(idInstance6);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                networkInterfaceIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = ipConfigurationsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = ipConfigurationsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue7 = ipConfigurationsValue.get("id");
                                        if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                            String idInstance7;
                                            idInstance7 = idValue7.getTextValue();
                                            networkInterfaceIpConfigurationJsonFormatInstance.setId(idInstance7);
                                        }
                                    }
                                }
                                
                                JsonNode dnsSettingsValue = propertiesValue.get("dnsSettings");
                                if (dnsSettingsValue != null && dnsSettingsValue instanceof NullNode == false) {
                                    NetworkInterfaceDnsSettings dnsSettingsInstance = new NetworkInterfaceDnsSettings();
                                    networkInterfaceJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    
                                    JsonNode dnsServersArray = dnsSettingsValue.get("dnsServers");
                                    if (dnsServersArray != null && dnsServersArray instanceof NullNode == false) {
                                        for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray)) {
                                            dnsSettingsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode appliedDnsServersArray = dnsSettingsValue.get("appliedDnsServers");
                                    if (appliedDnsServersArray != null && appliedDnsServersArray instanceof NullNode == false) {
                                        for (JsonNode appliedDnsServersValue : ((ArrayNode) appliedDnsServersArray)) {
                                            dnsSettingsInstance.getAppliedDnsServers().add(appliedDnsServersValue.getTextValue());
                                        }
                                    }
                                    
                                    JsonNode internalDnsNameLabelValue = dnsSettingsValue.get("internalDnsNameLabel");
                                    if (internalDnsNameLabelValue != null && internalDnsNameLabelValue instanceof NullNode == false) {
                                        String internalDnsNameLabelInstance;
                                        internalDnsNameLabelInstance = internalDnsNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setInternalDnsNameLabel(internalDnsNameLabelInstance);
                                    }
                                    
                                    JsonNode internalFqdnValue = dnsSettingsValue.get("internalFqdn");
                                    if (internalFqdnValue != null && internalFqdnValue instanceof NullNode == false) {
                                        String internalFqdnInstance;
                                        internalFqdnInstance = internalFqdnValue.getTextValue();
                                        dnsSettingsInstance.setInternalFqdn(internalFqdnInstance);
                                    }
                                }
                                
                                JsonNode macAddressValue = propertiesValue.get("macAddress");
                                if (macAddressValue != null && macAddressValue instanceof NullNode == false) {
                                    String macAddressInstance;
                                    macAddressInstance = macAddressValue.getTextValue();
                                    networkInterfaceJsonFormatInstance.setMacAddress(macAddressInstance);
                                }
                                
                                JsonNode primaryValue = propertiesValue.get("primary");
                                if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                    boolean primaryInstance;
                                    primaryInstance = primaryValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setPrimary(primaryInstance);
                                }
                                
                                JsonNode enableIPForwardingValue = propertiesValue.get("enableIPForwarding");
                                if (enableIPForwardingValue != null && enableIPForwardingValue instanceof NullNode == false) {
                                    boolean enableIPForwardingInstance;
                                    enableIPForwardingInstance = enableIPForwardingValue.getBooleanValue();
                                    networkInterfaceJsonFormatInstance.setEnableIPForwarding(enableIPForwardingInstance);
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    networkInterfaceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            
                            JsonNode etagValue2 = valueValue.get("etag");
                            if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                String etagInstance2;
                                etagInstance2 = etagValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setEtag(etagInstance2);
                            }
                            
                            JsonNode idValue8 = valueValue.get("id");
                            if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                String idInstance8;
                                idInstance8 = idValue8.getTextValue();
                                networkInterfaceJsonFormatInstance.setId(idInstance8);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                networkInterfaceJsonFormatInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                networkInterfaceJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    networkInterfaceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
