/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.DnsNameAvailabilityResponse;
import com.microsoft.windowsazure.core.FilterableService;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;

/**
* The Windows Azure Network management API provides a RESTful set of web
* services that interact with Windows Azure Networks service to manage your
* network resrources. The API has entities that capture the relationship
* between an end user and the Windows Azure Networks service.
*/
public interface NetworkResourceProviderClient extends Closeable, FilterableService<NetworkResourceProviderClient> {
    /**
    * Gets the API version.
    * @return The ApiVersion value.
    */
    String getApiVersion();
    
    /**
    * Gets the URI used as the base for all cloud service requests.
    * @return The BaseUri value.
    */
    URI getBaseUri();
    
    /**
    * Gets subscription credentials which uniquely identify Microsoft Azure
    * subscription. The subscription ID forms part of the URI for every
    * service call.
    * @return The Credentials value.
    */
    SubscriptionCloudCredentials getCredentials();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @return The LongRunningOperationInitialTimeout value.
    */
    int getLongRunningOperationInitialTimeout();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @param longRunningOperationInitialTimeoutValue The
    * LongRunningOperationInitialTimeout value.
    */
    void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue);
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @return The LongRunningOperationRetryTimeout value.
    */
    int getLongRunningOperationRetryTimeout();
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeoutValue The
    * LongRunningOperationRetryTimeout value.
    */
    void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue);
    /**
    * The Network Resource Provider API includes operations managing the
    * application gateways for your subscription.
    * @return The ApplicationGatewaysOperations value.
    */
    ApplicationGatewayOperations getApplicationGatewaysOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * load balancers for your subscription.
    * @return The LoadBalancersOperations value.
    */
    LoadBalancerOperations getLoadBalancersOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual network Gateway for your subscription.
    * @return The LocalNetworkGatewaysOperations value.
    */
    LocalNetworkGatewayOperations getLocalNetworkGatewaysOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * subnets for your subscription.
    * @return The NetworkInterfacesOperations value.
    */
    NetworkInterfaceOperations getNetworkInterfacesOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * NetworkSecurityGroups for your subscription.
    * @return The NetworkSecurityGroupsOperations value.
    */
    NetworkSecurityGroupOperations getNetworkSecurityGroupsOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * PublicIPAddress for your subscription.
    * @return The PublicIpAddressesOperations value.
    */
    PublicIpAddressOperations getPublicIpAddressesOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Routes for your subscription.
    * @return The RoutesOperations value.
    */
    RouteOperations getRoutesOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * RouteTables for your subscription.
    * @return The RouteTablesOperations value.
    */
    RouteTableOperations getRouteTablesOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * SecurityRules for your subscription.
    * @return The SecurityRulesOperations value.
    */
    SecurityRuleOperations getSecurityRulesOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * subnets for your subscription.
    * @return The SubnetsOperations value.
    */
    SubnetOperations getSubnetsOperations();
    
    /**
    * Operations for listing usage.
    * @return The UsagesOperations value.
    */
    UsageOperations getUsagesOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual network Gateway for your subscription.
    * @return The VirtualNetworkGatewayConnectionsOperations value.
    */
    VirtualNetworkGatewayConnectionOperations getVirtualNetworkGatewayConnectionsOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual network Gateway for your subscription.
    * @return The VirtualNetworkGatewaysOperations value.
    */
    VirtualNetworkGatewayOperations getVirtualNetworkGatewaysOperations();
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual Networks for your subscription.
    * @return The VirtualNetworksOperations value.
    */
    VirtualNetworkOperations getVirtualNetworksOperations();
    
    /**
    * Checks whether a domain name in the cloudapp.net zone is available for
    * use.
    *
    * @param location Required. The location of the domain name
    * @param domainNameLabel Required. The domain name to be verified. It must
    * conform to the following regular expression:
    * ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for CheckDnsNameAvailability Api servive call
    */
    DnsNameAvailabilityResponse checkDnsNameAvailability(String location, String domainNameLabel) throws IOException, ServiceException;
    
    /**
    * Checks whether a domain name in the cloudapp.net zone is available for
    * use.
    *
    * @param location Required. The location of the domain name
    * @param domainNameLabel Required. The domain name to be verified. It must
    * conform to the following regular expression:
    * ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
    * @return Response for CheckDnsNameAvailability Api servive call
    */
    Future<DnsNameAvailabilityResponse> checkDnsNameAvailabilityAsync(String location, String domainNameLabel);
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param azureAsyncOperation Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    AzureAsyncOperationResponse getLongRunningOperationStatus(String azureAsyncOperation) throws IOException, ServiceException;
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param azureAsyncOperation Required. Location value returned by the Begin
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<AzureAsyncOperationResponse> getLongRunningOperationStatusAsync(String azureAsyncOperation);
}
