/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.DnsNameAvailabilityResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import javax.inject.Inject;
import javax.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
* The Windows Azure Network management API provides a RESTful set of web
* services that interact with Windows Azure Networks service to manage your
* network resrources. The API has entities that capture the relationship
* between an end user and the Windows Azure Networks service.
*/
public class NetworkResourceProviderClientImpl extends ServiceClient<NetworkResourceProviderClient> implements NetworkResourceProviderClient {
    private String apiVersion;
    
    /**
    * Gets the API version.
    * @return The ApiVersion value.
    */
    public String getApiVersion() {
        return this.apiVersion;
    }
    
    private URI baseUri;
    
    /**
    * Gets the URI used as the base for all cloud service requests.
    * @return The BaseUri value.
    */
    public URI getBaseUri() {
        return this.baseUri;
    }
    
    private SubscriptionCloudCredentials credentials;
    
    /**
    * Gets subscription credentials which uniquely identify Microsoft Azure
    * subscription. The subscription ID forms part of the URI for every
    * service call.
    * @return The Credentials value.
    */
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }
    
    private int longRunningOperationInitialTimeout;
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @return The LongRunningOperationInitialTimeout value.
    */
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @param longRunningOperationInitialTimeoutValue The
    * LongRunningOperationInitialTimeout value.
    */
    public void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }
    
    private int longRunningOperationRetryTimeout;
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @return The LongRunningOperationRetryTimeout value.
    */
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeoutValue The
    * LongRunningOperationRetryTimeout value.
    */
    public void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }
    
    private ApplicationGatewayOperations applicationGateways;
    
    /**
    * The Network Resource Provider API includes operations managing the
    * application gateways for your subscription.
    * @return The ApplicationGatewaysOperations value.
    */
    public ApplicationGatewayOperations getApplicationGatewaysOperations() {
        return this.applicationGateways;
    }
    
    private LoadBalancerOperations loadBalancers;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * load balancers for your subscription.
    * @return The LoadBalancersOperations value.
    */
    public LoadBalancerOperations getLoadBalancersOperations() {
        return this.loadBalancers;
    }
    
    private LocalNetworkGatewayOperations localNetworkGateways;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual network Gateway for your subscription.
    * @return The LocalNetworkGatewaysOperations value.
    */
    public LocalNetworkGatewayOperations getLocalNetworkGatewaysOperations() {
        return this.localNetworkGateways;
    }
    
    private NetworkInterfaceOperations networkInterfaces;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * subnets for your subscription.
    * @return The NetworkInterfacesOperations value.
    */
    public NetworkInterfaceOperations getNetworkInterfacesOperations() {
        return this.networkInterfaces;
    }
    
    private NetworkSecurityGroupOperations networkSecurityGroups;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * NetworkSecurityGroups for your subscription.
    * @return The NetworkSecurityGroupsOperations value.
    */
    public NetworkSecurityGroupOperations getNetworkSecurityGroupsOperations() {
        return this.networkSecurityGroups;
    }
    
    private PublicIpAddressOperations publicIpAddresses;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * PublicIPAddress for your subscription.
    * @return The PublicIpAddressesOperations value.
    */
    public PublicIpAddressOperations getPublicIpAddressesOperations() {
        return this.publicIpAddresses;
    }
    
    private RouteOperations routes;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Routes for your subscription.
    * @return The RoutesOperations value.
    */
    public RouteOperations getRoutesOperations() {
        return this.routes;
    }
    
    private RouteTableOperations routeTables;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * RouteTables for your subscription.
    * @return The RouteTablesOperations value.
    */
    public RouteTableOperations getRouteTablesOperations() {
        return this.routeTables;
    }
    
    private SecurityRuleOperations securityRules;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * SecurityRules for your subscription.
    * @return The SecurityRulesOperations value.
    */
    public SecurityRuleOperations getSecurityRulesOperations() {
        return this.securityRules;
    }
    
    private SubnetOperations subnets;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * subnets for your subscription.
    * @return The SubnetsOperations value.
    */
    public SubnetOperations getSubnetsOperations() {
        return this.subnets;
    }
    
    private UsageOperations usages;
    
    /**
    * Operations for listing usage.
    * @return The UsagesOperations value.
    */
    public UsageOperations getUsagesOperations() {
        return this.usages;
    }
    
    private VirtualNetworkGatewayConnectionOperations virtualNetworkGatewayConnections;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual network Gateway for your subscription.
    * @return The VirtualNetworkGatewayConnectionsOperations value.
    */
    public VirtualNetworkGatewayConnectionOperations getVirtualNetworkGatewayConnectionsOperations() {
        return this.virtualNetworkGatewayConnections;
    }
    
    private VirtualNetworkGatewayOperations virtualNetworkGateways;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual network Gateway for your subscription.
    * @return The VirtualNetworkGatewaysOperations value.
    */
    public VirtualNetworkGatewayOperations getVirtualNetworkGatewaysOperations() {
        return this.virtualNetworkGateways;
    }
    
    private VirtualNetworkOperations virtualNetworks;
    
    /**
    * The Network Resource Provider API includes operations for managing the
    * Virtual Networks for your subscription.
    * @return The VirtualNetworksOperations value.
    */
    public VirtualNetworkOperations getVirtualNetworksOperations() {
        return this.virtualNetworks;
    }
    
    /**
    * Initializes a new instance of the NetworkResourceProviderClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    */
    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
        this.applicationGateways = new ApplicationGatewayOperationsImpl(this);
        this.loadBalancers = new LoadBalancerOperationsImpl(this);
        this.localNetworkGateways = new LocalNetworkGatewayOperationsImpl(this);
        this.networkInterfaces = new NetworkInterfaceOperationsImpl(this);
        this.networkSecurityGroups = new NetworkSecurityGroupOperationsImpl(this);
        this.publicIpAddresses = new PublicIpAddressOperationsImpl(this);
        this.routes = new RouteOperationsImpl(this);
        this.routeTables = new RouteTableOperationsImpl(this);
        this.securityRules = new SecurityRuleOperationsImpl(this);
        this.subnets = new SubnetOperationsImpl(this);
        this.usages = new UsageOperationsImpl(this);
        this.virtualNetworkGatewayConnections = new VirtualNetworkGatewayConnectionOperationsImpl(this);
        this.virtualNetworkGateways = new VirtualNetworkGatewayOperationsImpl(this);
        this.virtualNetworks = new VirtualNetworkOperationsImpl(this);
        this.apiVersion = "2015-05-01-preview";
        this.longRunningOperationInitialTimeout = -1;
        this.longRunningOperationRetryTimeout = -1;
    }
    
    /**
    * Initializes a new instance of the NetworkResourceProviderClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @param baseUri Optional. Gets the URI used as the base for all cloud
    * service requests.
    */
    @Inject
    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(ManagementConfiguration.SUBSCRIPTION_CLOUD_CREDENTIALS) SubscriptionCloudCredentials credentials, @Named(ManagementConfiguration.URI) URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        } else {
            this.credentials = credentials;
        }
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.azure.com/");
            }
            catch (URISyntaxException ex) {
            }
        } else {
            this.baseUri = baseUri;
        }
    }
    
    /**
    * Initializes a new instance of the NetworkResourceProviderClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    */
    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.azure.com/");
    }
    
    /**
    * Initializes a new instance of the NetworkResourceProviderClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @param baseUri Optional. Gets the URI used as the base for all cloud
    * service requests.
    * @param apiVersion Optional. Gets the API version.
    * @param longRunningOperationInitialTimeout Required. Gets or sets the
    * initial timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeout Required. Gets or sets the retry
    * timeout for Long Running Operations.
    */
    public NetworkResourceProviderClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }
    
    /**
    * Initializes a new instance of the NetworkResourceProviderClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    */
    protected NetworkResourceProviderClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new NetworkResourceProviderClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }
    
    /**
    * Checks whether a domain name in the cloudapp.net zone is available for
    * use.
    *
    * @param location Required. The location of the domain name
    * @param domainNameLabel Required. The domain name to be verified. It must
    * conform to the following regular expression:
    * ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
    * @return Response for CheckDnsNameAvailability Api servive call
    */
    @Override
    public Future<DnsNameAvailabilityResponse> checkDnsNameAvailabilityAsync(final String location, final String domainNameLabel) {
        return this.getExecutorService().submit(new Callable<DnsNameAvailabilityResponse>() { 
            @Override
            public DnsNameAvailabilityResponse call() throws Exception {
                return checkDnsNameAvailability(location, domainNameLabel);
            }
         });
    }
    
    /**
    * Checks whether a domain name in the cloudapp.net zone is available for
    * use.
    *
    * @param location Required. The location of the domain name
    * @param domainNameLabel Required. The domain name to be verified. It must
    * conform to the following regular expression:
    * ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for CheckDnsNameAvailability Api servive call
    */
    @Override
    public DnsNameAvailabilityResponse checkDnsNameAvailability(String location, String domainNameLabel) throws IOException, ServiceException {
        // Validate
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (domainNameLabel == null) {
            throw new NullPointerException("domainNameLabel");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("location", location);
            tracingParameters.put("domainNameLabel", domainNameLabel);
            CloudTracing.enter(invocationId, this, "checkDnsNameAvailabilityAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/locations/";
        url = url + URLEncoder.encode(location, "UTF-8");
        url = url + "/CheckDnsNameAvailability";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("domainNameLabel=" + URLEncoder.encode(domainNameLabel, "UTF-8"));
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DnsNameAvailabilityResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DnsNameAvailabilityResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode availableValue = responseDoc.get("available");
                    if (availableValue != null && availableValue instanceof NullNode == false) {
                        boolean availableInstance;
                        availableInstance = availableValue.getBooleanValue();
                        result.setDnsNameAvailability(availableInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param azureAsyncOperation Required. Location value returned by the Begin
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> getLongRunningOperationStatusAsync(final String azureAsyncOperation) {
        return this.getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return getLongRunningOperationStatus(azureAsyncOperation);
            }
         });
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param azureAsyncOperation Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse getLongRunningOperationStatus(String azureAsyncOperation) throws IOException, ServiceException {
        // Validate
        if (azureAsyncOperation == null) {
            throw new NullPointerException("azureAsyncOperation");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("azureAsyncOperation", azureAsyncOperation);
            CloudTracing.enter(invocationId, this, "getLongRunningOperationStatusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + azureAsyncOperation;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2015-05-01-preview");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            AzureAsyncOperationResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_ACCEPTED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new AzureAsyncOperationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        String statusInstance;
                        statusInstance = statusValue.getTextValue();
                        result.setStatus(statusInstance);
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
