/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.NetworkSecurityGroup;
import com.microsoft.azure.management.network.models.NetworkSecurityGroupGetResponse;
import com.microsoft.azure.management.network.models.NetworkSecurityGroupListResponse;
import com.microsoft.azure.management.network.models.NetworkSecurityGroupPutResponse;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.SecurityRule;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* NetworkSecurityGroups for your subscription.
*/
public class NetworkSecurityGroupOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, NetworkSecurityGroupOperations {
    /**
    * Initializes a new instance of the NetworkSecurityGroupOperationsImpl
    * class.
    *
    * @param client Reference to the service client.
    */
    NetworkSecurityGroupOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put NetworkSecurityGroup operation creates/updates a network security
    * groupin the specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param parameters Required. Parameters supplied to the create/update
    * Network Security Group operation
    * @return Response for PUT NetworkSecurityGroups Api servive call
    */
    @Override
    public Future<NetworkSecurityGroupPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String networkSecurityGroupName, final NetworkSecurityGroup parameters) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupPutResponse>() { 
            @Override
            public NetworkSecurityGroupPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, networkSecurityGroupName, parameters);
            }
         });
    }
    
    /**
    * The Put NetworkSecurityGroup operation creates/updates a network security
    * groupin the specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param parameters Required. Parameters supplied to the create/update
    * Network Security Group operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PUT NetworkSecurityGroups Api servive call
    */
    @Override
    public NetworkSecurityGroupPutResponse beginCreateOrUpdating(String resourceGroupName, String networkSecurityGroupName, NetworkSecurityGroup parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDefaultSecurityRules() != null) {
            for (SecurityRule defaultSecurityRulesParameterItem : parameters.getDefaultSecurityRules()) {
                if (defaultSecurityRulesParameterItem.getAccess() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.Access");
                }
                if (defaultSecurityRulesParameterItem.getDestinationAddressPrefix() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.DestinationAddressPrefix");
                }
                if (defaultSecurityRulesParameterItem.getDirection() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.Direction");
                }
                if (defaultSecurityRulesParameterItem.getProtocol() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.Protocol");
                }
                if (defaultSecurityRulesParameterItem.getSourceAddressPrefix() == null) {
                    throw new NullPointerException("parameters.DefaultSecurityRules.SourceAddressPrefix");
                }
            }
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getSecurityRules() != null) {
            for (SecurityRule securityRulesParameterItem : parameters.getSecurityRules()) {
                if (securityRulesParameterItem.getAccess() == null) {
                    throw new NullPointerException("parameters.SecurityRules.Access");
                }
                if (securityRulesParameterItem.getDestinationAddressPrefix() == null) {
                    throw new NullPointerException("parameters.SecurityRules.DestinationAddressPrefix");
                }
                if (securityRulesParameterItem.getDirection() == null) {
                    throw new NullPointerException("parameters.SecurityRules.Direction");
                }
                if (securityRulesParameterItem.getProtocol() == null) {
                    throw new NullPointerException("parameters.SecurityRules.Protocol");
                }
                if (securityRulesParameterItem.getSourceAddressPrefix() == null) {
                    throw new NullPointerException("parameters.SecurityRules.SourceAddressPrefix");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode networkSecurityGroupJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = networkSecurityGroupJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) networkSecurityGroupJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getSecurityRules() != null) {
            if (parameters.getSecurityRules() instanceof LazyCollection == false || ((LazyCollection) parameters.getSecurityRules()).isInitialized()) {
                ArrayNode securityRulesArray = objectMapper.createArrayNode();
                for (SecurityRule securityRulesItem : parameters.getSecurityRules()) {
                    ObjectNode securityRuleJsonFormatValue = objectMapper.createObjectNode();
                    securityRulesArray.add(securityRuleJsonFormatValue);
                    
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) securityRuleJsonFormatValue).put("properties", propertiesValue2);
                    
                    if (securityRulesItem.getDescription() != null) {
                        ((ObjectNode) propertiesValue2).put("description", securityRulesItem.getDescription());
                    }
                    
                    ((ObjectNode) propertiesValue2).put("protocol", securityRulesItem.getProtocol());
                    
                    if (securityRulesItem.getSourcePortRange() != null) {
                        ((ObjectNode) propertiesValue2).put("sourcePortRange", securityRulesItem.getSourcePortRange());
                    }
                    
                    if (securityRulesItem.getDestinationPortRange() != null) {
                        ((ObjectNode) propertiesValue2).put("destinationPortRange", securityRulesItem.getDestinationPortRange());
                    }
                    
                    ((ObjectNode) propertiesValue2).put("sourceAddressPrefix", securityRulesItem.getSourceAddressPrefix());
                    
                    ((ObjectNode) propertiesValue2).put("destinationAddressPrefix", securityRulesItem.getDestinationAddressPrefix());
                    
                    ((ObjectNode) propertiesValue2).put("access", securityRulesItem.getAccess());
                    
                    ((ObjectNode) propertiesValue2).put("priority", securityRulesItem.getPriority());
                    
                    ((ObjectNode) propertiesValue2).put("direction", securityRulesItem.getDirection());
                    
                    if (securityRulesItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue2).put("provisioningState", securityRulesItem.getProvisioningState());
                    }
                    
                    if (securityRulesItem.getName() != null) {
                        ((ObjectNode) securityRuleJsonFormatValue).put("name", securityRulesItem.getName());
                    }
                    
                    if (securityRulesItem.getEtag() != null) {
                        ((ObjectNode) securityRuleJsonFormatValue).put("etag", securityRulesItem.getEtag());
                    }
                    
                    if (securityRulesItem.getId() != null) {
                        ((ObjectNode) securityRuleJsonFormatValue).put("id", securityRulesItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("securityRules", securityRulesArray);
            }
        }
        
        if (parameters.getDefaultSecurityRules() != null) {
            if (parameters.getDefaultSecurityRules() instanceof LazyCollection == false || ((LazyCollection) parameters.getDefaultSecurityRules()).isInitialized()) {
                ArrayNode defaultSecurityRulesArray = objectMapper.createArrayNode();
                for (SecurityRule defaultSecurityRulesItem : parameters.getDefaultSecurityRules()) {
                    ObjectNode securityRuleJsonFormatValue2 = objectMapper.createObjectNode();
                    defaultSecurityRulesArray.add(securityRuleJsonFormatValue2);
                    
                    ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                    ((ObjectNode) securityRuleJsonFormatValue2).put("properties", propertiesValue3);
                    
                    if (defaultSecurityRulesItem.getDescription() != null) {
                        ((ObjectNode) propertiesValue3).put("description", defaultSecurityRulesItem.getDescription());
                    }
                    
                    ((ObjectNode) propertiesValue3).put("protocol", defaultSecurityRulesItem.getProtocol());
                    
                    if (defaultSecurityRulesItem.getSourcePortRange() != null) {
                        ((ObjectNode) propertiesValue3).put("sourcePortRange", defaultSecurityRulesItem.getSourcePortRange());
                    }
                    
                    if (defaultSecurityRulesItem.getDestinationPortRange() != null) {
                        ((ObjectNode) propertiesValue3).put("destinationPortRange", defaultSecurityRulesItem.getDestinationPortRange());
                    }
                    
                    ((ObjectNode) propertiesValue3).put("sourceAddressPrefix", defaultSecurityRulesItem.getSourceAddressPrefix());
                    
                    ((ObjectNode) propertiesValue3).put("destinationAddressPrefix", defaultSecurityRulesItem.getDestinationAddressPrefix());
                    
                    ((ObjectNode) propertiesValue3).put("access", defaultSecurityRulesItem.getAccess());
                    
                    ((ObjectNode) propertiesValue3).put("priority", defaultSecurityRulesItem.getPriority());
                    
                    ((ObjectNode) propertiesValue3).put("direction", defaultSecurityRulesItem.getDirection());
                    
                    if (defaultSecurityRulesItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue3).put("provisioningState", defaultSecurityRulesItem.getProvisioningState());
                    }
                    
                    if (defaultSecurityRulesItem.getName() != null) {
                        ((ObjectNode) securityRuleJsonFormatValue2).put("name", defaultSecurityRulesItem.getName());
                    }
                    
                    if (defaultSecurityRulesItem.getEtag() != null) {
                        ((ObjectNode) securityRuleJsonFormatValue2).put("etag", defaultSecurityRulesItem.getEtag());
                    }
                    
                    if (defaultSecurityRulesItem.getId() != null) {
                        ((ObjectNode) securityRuleJsonFormatValue2).put("id", defaultSecurityRulesItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("defaultSecurityRules", defaultSecurityRulesArray);
            }
        }
        
        if (parameters.getNetworkInterfaces() != null) {
            if (parameters.getNetworkInterfaces() instanceof LazyCollection == false || ((LazyCollection) parameters.getNetworkInterfaces()).isInitialized()) {
                ArrayNode networkInterfacesArray = objectMapper.createArrayNode();
                for (ResourceId networkInterfacesItem : parameters.getNetworkInterfaces()) {
                    ObjectNode resourceIdValue = objectMapper.createObjectNode();
                    networkInterfacesArray.add(resourceIdValue);
                    
                    if (networkInterfacesItem.getId() != null) {
                        ((ObjectNode) resourceIdValue).put("id", networkInterfacesItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("networkInterfaces", networkInterfacesArray);
            }
        }
        
        if (parameters.getSubnets() != null) {
            if (parameters.getSubnets() instanceof LazyCollection == false || ((LazyCollection) parameters.getSubnets()).isInitialized()) {
                ArrayNode subnetsArray = objectMapper.createArrayNode();
                for (ResourceId subnetsItem : parameters.getSubnets()) {
                    ObjectNode resourceIdValue2 = objectMapper.createObjectNode();
                    subnetsArray.add(resourceIdValue2);
                    
                    if (subnetsItem.getId() != null) {
                        ((ObjectNode) resourceIdValue2).put("id", subnetsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("subnets", subnetsArray);
            }
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) networkSecurityGroupJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) networkSecurityGroupJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) networkSecurityGroupJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) networkSecurityGroupJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) networkSecurityGroupJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) networkSecurityGroupJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkSecurityGroupPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NetworkSecurityGroup networkSecurityGroupInstance = new NetworkSecurityGroup();
                    result.setNetworkSecurityGroup(networkSecurityGroupInstance);
                    
                    JsonNode propertiesValue4 = responseDoc.get("properties");
                    if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                        JsonNode securityRulesArray2 = propertiesValue4.get("securityRules");
                        if (securityRulesArray2 != null && securityRulesArray2 instanceof NullNode == false) {
                            for (JsonNode securityRulesValue : ((ArrayNode) securityRulesArray2)) {
                                SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                networkSecurityGroupInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue5 = securityRulesValue.get("properties");
                                if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                    JsonNode descriptionValue = propertiesValue5.get("description");
                                    if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                        String descriptionInstance;
                                        descriptionInstance = descriptionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                    }
                                    
                                    JsonNode protocolValue = propertiesValue5.get("protocol");
                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                        String protocolInstance;
                                        protocolInstance = protocolValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    
                                    JsonNode sourcePortRangeValue = propertiesValue5.get("sourcePortRange");
                                    if (sourcePortRangeValue != null && sourcePortRangeValue instanceof NullNode == false) {
                                        String sourcePortRangeInstance;
                                        sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                    }
                                    
                                    JsonNode destinationPortRangeValue = propertiesValue5.get("destinationPortRange");
                                    if (destinationPortRangeValue != null && destinationPortRangeValue instanceof NullNode == false) {
                                        String destinationPortRangeInstance;
                                        destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                    }
                                    
                                    JsonNode sourceAddressPrefixValue = propertiesValue5.get("sourceAddressPrefix");
                                    if (sourceAddressPrefixValue != null && sourceAddressPrefixValue instanceof NullNode == false) {
                                        String sourceAddressPrefixInstance;
                                        sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                    }
                                    
                                    JsonNode destinationAddressPrefixValue = propertiesValue5.get("destinationAddressPrefix");
                                    if (destinationAddressPrefixValue != null && destinationAddressPrefixValue instanceof NullNode == false) {
                                        String destinationAddressPrefixInstance;
                                        destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                    }
                                    
                                    JsonNode accessValue = propertiesValue5.get("access");
                                    if (accessValue != null && accessValue instanceof NullNode == false) {
                                        String accessInstance;
                                        accessInstance = accessValue.getTextValue();
                                        securityRuleJsonFormatInstance.setAccess(accessInstance);
                                    }
                                    
                                    JsonNode priorityValue = propertiesValue5.get("priority");
                                    if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                        int priorityInstance;
                                        priorityInstance = priorityValue.getIntValue();
                                        securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                    }
                                    
                                    JsonNode directionValue = propertiesValue5.get("direction");
                                    if (directionValue != null && directionValue instanceof NullNode == false) {
                                        String directionInstance;
                                        directionInstance = directionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDirection(directionInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue5.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = securityRulesValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    securityRuleJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = securityRulesValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    securityRuleJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue = securityRulesValue.get("id");
                                if (idValue != null && idValue instanceof NullNode == false) {
                                    String idInstance;
                                    idInstance = idValue.getTextValue();
                                    securityRuleJsonFormatInstance.setId(idInstance);
                                }
                            }
                        }
                        
                        JsonNode defaultSecurityRulesArray2 = propertiesValue4.get("defaultSecurityRules");
                        if (defaultSecurityRulesArray2 != null && defaultSecurityRulesArray2 instanceof NullNode == false) {
                            for (JsonNode defaultSecurityRulesValue : ((ArrayNode) defaultSecurityRulesArray2)) {
                                SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                networkSecurityGroupInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                
                                JsonNode propertiesValue6 = defaultSecurityRulesValue.get("properties");
                                if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                    JsonNode descriptionValue2 = propertiesValue6.get("description");
                                    if (descriptionValue2 != null && descriptionValue2 instanceof NullNode == false) {
                                        String descriptionInstance2;
                                        descriptionInstance2 = descriptionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                    }
                                    
                                    JsonNode protocolValue2 = propertiesValue6.get("protocol");
                                    if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                        String protocolInstance2;
                                        protocolInstance2 = protocolValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                    }
                                    
                                    JsonNode sourcePortRangeValue2 = propertiesValue6.get("sourcePortRange");
                                    if (sourcePortRangeValue2 != null && sourcePortRangeValue2 instanceof NullNode == false) {
                                        String sourcePortRangeInstance2;
                                        sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                    }
                                    
                                    JsonNode destinationPortRangeValue2 = propertiesValue6.get("destinationPortRange");
                                    if (destinationPortRangeValue2 != null && destinationPortRangeValue2 instanceof NullNode == false) {
                                        String destinationPortRangeInstance2;
                                        destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                    }
                                    
                                    JsonNode sourceAddressPrefixValue2 = propertiesValue6.get("sourceAddressPrefix");
                                    if (sourceAddressPrefixValue2 != null && sourceAddressPrefixValue2 instanceof NullNode == false) {
                                        String sourceAddressPrefixInstance2;
                                        sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                    }
                                    
                                    JsonNode destinationAddressPrefixValue2 = propertiesValue6.get("destinationAddressPrefix");
                                    if (destinationAddressPrefixValue2 != null && destinationAddressPrefixValue2 instanceof NullNode == false) {
                                        String destinationAddressPrefixInstance2;
                                        destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                    }
                                    
                                    JsonNode accessValue2 = propertiesValue6.get("access");
                                    if (accessValue2 != null && accessValue2 instanceof NullNode == false) {
                                        String accessInstance2;
                                        accessInstance2 = accessValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                    }
                                    
                                    JsonNode priorityValue2 = propertiesValue6.get("priority");
                                    if (priorityValue2 != null && priorityValue2 instanceof NullNode == false) {
                                        int priorityInstance2;
                                        priorityInstance2 = priorityValue2.getIntValue();
                                        securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                    }
                                    
                                    JsonNode directionValue2 = propertiesValue6.get("direction");
                                    if (directionValue2 != null && directionValue2 instanceof NullNode == false) {
                                        String directionInstance2;
                                        directionInstance2 = directionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                    }
                                    
                                    JsonNode provisioningStateValue2 = propertiesValue6.get("provisioningState");
                                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                        String provisioningStateInstance2;
                                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                
                                JsonNode nameValue2 = defaultSecurityRulesValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setName(nameInstance2);
                                }
                                
                                JsonNode etagValue2 = defaultSecurityRulesValue.get("etag");
                                if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                    String etagInstance2;
                                    etagInstance2 = etagValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                }
                                
                                JsonNode idValue2 = defaultSecurityRulesValue.get("id");
                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                    String idInstance2;
                                    idInstance2 = idValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setId(idInstance2);
                                }
                            }
                        }
                        
                        JsonNode networkInterfacesArray2 = propertiesValue4.get("networkInterfaces");
                        if (networkInterfacesArray2 != null && networkInterfacesArray2 instanceof NullNode == false) {
                            for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray2)) {
                                ResourceId resourceIdInstance = new ResourceId();
                                networkSecurityGroupInstance.getNetworkInterfaces().add(resourceIdInstance);
                                
                                JsonNode idValue3 = networkInterfacesValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    resourceIdInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode subnetsArray2 = propertiesValue4.get("subnets");
                        if (subnetsArray2 != null && subnetsArray2 instanceof NullNode == false) {
                            for (JsonNode subnetsValue : ((ArrayNode) subnetsArray2)) {
                                ResourceId resourceIdInstance2 = new ResourceId();
                                networkSecurityGroupInstance.getSubnets().add(resourceIdInstance2);
                                
                                JsonNode idValue4 = subnetsValue.get("id");
                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                    String idInstance4;
                                    idInstance4 = idValue4.getTextValue();
                                    resourceIdInstance2.setId(idInstance4);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue3 = propertiesValue4.get("provisioningState");
                        if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                            String provisioningStateInstance3;
                            provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                            networkSecurityGroupInstance.setProvisioningState(provisioningStateInstance3);
                        }
                    }
                    
                    JsonNode etagValue3 = responseDoc.get("etag");
                    if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                        String etagInstance3;
                        etagInstance3 = etagValue3.getTextValue();
                        networkSecurityGroupInstance.setEtag(etagInstance3);
                    }
                    
                    JsonNode idValue5 = responseDoc.get("id");
                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                        String idInstance5;
                        idInstance5 = idValue5.getTextValue();
                        networkSecurityGroupInstance.setId(idInstance5);
                    }
                    
                    JsonNode nameValue3 = responseDoc.get("name");
                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                        String nameInstance3;
                        nameInstance3 = nameValue3.getTextValue();
                        networkSecurityGroupInstance.setName(nameInstance3);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        networkSecurityGroupInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        networkSecurityGroupInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            networkSecurityGroupInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Delete NetworkSecurityGroup operation deletes the specifed network
    * security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, networkSecurityGroupName);
            }
         });
    }
    
    /**
    * The Delete NetworkSecurityGroup operation deletes the specifed network
    * security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String networkSecurityGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put NetworkSecurityGroup operation creates/updates a network security
    * groupin the specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param parameters Required. Parameters supplied to the create/update
    * Network Security Group operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String networkSecurityGroupName, final NetworkSecurityGroup parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, networkSecurityGroupName, parameters);
            }
         });
    }
    
    /**
    * The Put NetworkSecurityGroup operation creates/updates a network security
    * groupin the specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param parameters Required. Parameters supplied to the create/update
    * Network Security Group operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String networkSecurityGroupName, NetworkSecurityGroup parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            NetworkSecurityGroupPutResponse response = client2.getNetworkSecurityGroupsOperations().beginCreateOrUpdatingAsync(resourceGroupName, networkSecurityGroupName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete NetworkSecurityGroup operation deletes the specifed network
    * security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, networkSecurityGroupName);
            }
         });
    }
    
    /**
    * The Delete NetworkSecurityGroup operation deletes the specifed network
    * security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String networkSecurityGroupName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getNetworkSecurityGroupsOperations().beginDeletingAsync(resourceGroupName, networkSecurityGroupName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get NetworkSecurityGroups operation retrieves information about the
    * specified network security group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @return Response for GetNetworkSecurityGroup Api service call
    */
    @Override
    public Future<NetworkSecurityGroupGetResponse> getAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupGetResponse>() { 
            @Override
            public NetworkSecurityGroupGetResponse call() throws Exception {
                return get(resourceGroupName, networkSecurityGroupName);
            }
         });
    }
    
    /**
    * The Get NetworkSecurityGroups operation retrieves information about the
    * specified network security group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetNetworkSecurityGroup Api service call
    */
    @Override
    public NetworkSecurityGroupGetResponse get(String resourceGroupName, String networkSecurityGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkSecurityGroupGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NetworkSecurityGroup networkSecurityGroupInstance = new NetworkSecurityGroup();
                    result.setNetworkSecurityGroup(networkSecurityGroupInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode securityRulesArray = propertiesValue.get("securityRules");
                        if (securityRulesArray != null && securityRulesArray instanceof NullNode == false) {
                            for (JsonNode securityRulesValue : ((ArrayNode) securityRulesArray)) {
                                SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                networkSecurityGroupInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                
                                JsonNode propertiesValue2 = securityRulesValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    JsonNode descriptionValue = propertiesValue2.get("description");
                                    if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                        String descriptionInstance;
                                        descriptionInstance = descriptionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                    }
                                    
                                    JsonNode protocolValue = propertiesValue2.get("protocol");
                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                        String protocolInstance;
                                        protocolInstance = protocolValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    
                                    JsonNode sourcePortRangeValue = propertiesValue2.get("sourcePortRange");
                                    if (sourcePortRangeValue != null && sourcePortRangeValue instanceof NullNode == false) {
                                        String sourcePortRangeInstance;
                                        sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                    }
                                    
                                    JsonNode destinationPortRangeValue = propertiesValue2.get("destinationPortRange");
                                    if (destinationPortRangeValue != null && destinationPortRangeValue instanceof NullNode == false) {
                                        String destinationPortRangeInstance;
                                        destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                    }
                                    
                                    JsonNode sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix");
                                    if (sourceAddressPrefixValue != null && sourceAddressPrefixValue instanceof NullNode == false) {
                                        String sourceAddressPrefixInstance;
                                        sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                    }
                                    
                                    JsonNode destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix");
                                    if (destinationAddressPrefixValue != null && destinationAddressPrefixValue instanceof NullNode == false) {
                                        String destinationAddressPrefixInstance;
                                        destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                    }
                                    
                                    JsonNode accessValue = propertiesValue2.get("access");
                                    if (accessValue != null && accessValue instanceof NullNode == false) {
                                        String accessInstance;
                                        accessInstance = accessValue.getTextValue();
                                        securityRuleJsonFormatInstance.setAccess(accessInstance);
                                    }
                                    
                                    JsonNode priorityValue = propertiesValue2.get("priority");
                                    if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                        int priorityInstance;
                                        priorityInstance = priorityValue.getIntValue();
                                        securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                    }
                                    
                                    JsonNode directionValue = propertiesValue2.get("direction");
                                    if (directionValue != null && directionValue instanceof NullNode == false) {
                                        String directionInstance;
                                        directionInstance = directionValue.getTextValue();
                                        securityRuleJsonFormatInstance.setDirection(directionInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = securityRulesValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    securityRuleJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = securityRulesValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    securityRuleJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue = securityRulesValue.get("id");
                                if (idValue != null && idValue instanceof NullNode == false) {
                                    String idInstance;
                                    idInstance = idValue.getTextValue();
                                    securityRuleJsonFormatInstance.setId(idInstance);
                                }
                            }
                        }
                        
                        JsonNode defaultSecurityRulesArray = propertiesValue.get("defaultSecurityRules");
                        if (defaultSecurityRulesArray != null && defaultSecurityRulesArray instanceof NullNode == false) {
                            for (JsonNode defaultSecurityRulesValue : ((ArrayNode) defaultSecurityRulesArray)) {
                                SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                networkSecurityGroupInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                
                                JsonNode propertiesValue3 = defaultSecurityRulesValue.get("properties");
                                if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                    JsonNode descriptionValue2 = propertiesValue3.get("description");
                                    if (descriptionValue2 != null && descriptionValue2 instanceof NullNode == false) {
                                        String descriptionInstance2;
                                        descriptionInstance2 = descriptionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                    }
                                    
                                    JsonNode protocolValue2 = propertiesValue3.get("protocol");
                                    if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                        String protocolInstance2;
                                        protocolInstance2 = protocolValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                    }
                                    
                                    JsonNode sourcePortRangeValue2 = propertiesValue3.get("sourcePortRange");
                                    if (sourcePortRangeValue2 != null && sourcePortRangeValue2 instanceof NullNode == false) {
                                        String sourcePortRangeInstance2;
                                        sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                    }
                                    
                                    JsonNode destinationPortRangeValue2 = propertiesValue3.get("destinationPortRange");
                                    if (destinationPortRangeValue2 != null && destinationPortRangeValue2 instanceof NullNode == false) {
                                        String destinationPortRangeInstance2;
                                        destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                    }
                                    
                                    JsonNode sourceAddressPrefixValue2 = propertiesValue3.get("sourceAddressPrefix");
                                    if (sourceAddressPrefixValue2 != null && sourceAddressPrefixValue2 instanceof NullNode == false) {
                                        String sourceAddressPrefixInstance2;
                                        sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                    }
                                    
                                    JsonNode destinationAddressPrefixValue2 = propertiesValue3.get("destinationAddressPrefix");
                                    if (destinationAddressPrefixValue2 != null && destinationAddressPrefixValue2 instanceof NullNode == false) {
                                        String destinationAddressPrefixInstance2;
                                        destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                    }
                                    
                                    JsonNode accessValue2 = propertiesValue3.get("access");
                                    if (accessValue2 != null && accessValue2 instanceof NullNode == false) {
                                        String accessInstance2;
                                        accessInstance2 = accessValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                    }
                                    
                                    JsonNode priorityValue2 = propertiesValue3.get("priority");
                                    if (priorityValue2 != null && priorityValue2 instanceof NullNode == false) {
                                        int priorityInstance2;
                                        priorityInstance2 = priorityValue2.getIntValue();
                                        securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                    }
                                    
                                    JsonNode directionValue2 = propertiesValue3.get("direction");
                                    if (directionValue2 != null && directionValue2 instanceof NullNode == false) {
                                        String directionInstance2;
                                        directionInstance2 = directionValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                    }
                                    
                                    JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                        String provisioningStateInstance2;
                                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                
                                JsonNode nameValue2 = defaultSecurityRulesValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setName(nameInstance2);
                                }
                                
                                JsonNode etagValue2 = defaultSecurityRulesValue.get("etag");
                                if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                    String etagInstance2;
                                    etagInstance2 = etagValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                }
                                
                                JsonNode idValue2 = defaultSecurityRulesValue.get("id");
                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                    String idInstance2;
                                    idInstance2 = idValue2.getTextValue();
                                    securityRuleJsonFormatInstance2.setId(idInstance2);
                                }
                            }
                        }
                        
                        JsonNode networkInterfacesArray = propertiesValue.get("networkInterfaces");
                        if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                            for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                ResourceId resourceIdInstance = new ResourceId();
                                networkSecurityGroupInstance.getNetworkInterfaces().add(resourceIdInstance);
                                
                                JsonNode idValue3 = networkInterfacesValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    resourceIdInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode subnetsArray = propertiesValue.get("subnets");
                        if (subnetsArray != null && subnetsArray instanceof NullNode == false) {
                            for (JsonNode subnetsValue : ((ArrayNode) subnetsArray)) {
                                ResourceId resourceIdInstance2 = new ResourceId();
                                networkSecurityGroupInstance.getSubnets().add(resourceIdInstance2);
                                
                                JsonNode idValue4 = subnetsValue.get("id");
                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                    String idInstance4;
                                    idInstance4 = idValue4.getTextValue();
                                    resourceIdInstance2.setId(idInstance4);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue3 = propertiesValue.get("provisioningState");
                        if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                            String provisioningStateInstance3;
                            provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                            networkSecurityGroupInstance.setProvisioningState(provisioningStateInstance3);
                        }
                    }
                    
                    JsonNode etagValue3 = responseDoc.get("etag");
                    if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                        String etagInstance3;
                        etagInstance3 = etagValue3.getTextValue();
                        networkSecurityGroupInstance.setEtag(etagInstance3);
                    }
                    
                    JsonNode idValue5 = responseDoc.get("id");
                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                        String idInstance5;
                        idInstance5 = idValue5.getTextValue();
                        networkSecurityGroupInstance.setId(idInstance5);
                    }
                    
                    JsonNode nameValue3 = responseDoc.get("name");
                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                        String nameInstance3;
                        nameInstance3 = nameValue3.getTextValue();
                        networkSecurityGroupInstance.setName(nameInstance3);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        networkSecurityGroupInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        networkSecurityGroupInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            networkSecurityGroupInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The list NetworkSecurityGroups returns all network security groups in a
    * resource group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListNetworkSecurityGroups Api servive call
    */
    @Override
    public Future<NetworkSecurityGroupListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupListResponse>() { 
            @Override
            public NetworkSecurityGroupListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The list NetworkSecurityGroups returns all network security groups in a
    * resource group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListNetworkSecurityGroups Api servive call
    */
    @Override
    public NetworkSecurityGroupListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkSecurityGroupListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            NetworkSecurityGroup networkSecurityGroupJsonFormatInstance = new NetworkSecurityGroup();
                            result.getNetworkSecurityGroups().add(networkSecurityGroupJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode securityRulesArray = propertiesValue.get("securityRules");
                                if (securityRulesArray != null && securityRulesArray instanceof NullNode == false) {
                                    for (JsonNode securityRulesValue : ((ArrayNode) securityRulesArray)) {
                                        SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = securityRulesValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode descriptionValue = propertiesValue2.get("description");
                                            if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                                String descriptionInstance;
                                                descriptionInstance = descriptionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                            }
                                            
                                            JsonNode protocolValue = propertiesValue2.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode sourcePortRangeValue = propertiesValue2.get("sourcePortRange");
                                            if (sourcePortRangeValue != null && sourcePortRangeValue instanceof NullNode == false) {
                                                String sourcePortRangeInstance;
                                                sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                            }
                                            
                                            JsonNode destinationPortRangeValue = propertiesValue2.get("destinationPortRange");
                                            if (destinationPortRangeValue != null && destinationPortRangeValue instanceof NullNode == false) {
                                                String destinationPortRangeInstance;
                                                destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                            }
                                            
                                            JsonNode sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix");
                                            if (sourceAddressPrefixValue != null && sourceAddressPrefixValue instanceof NullNode == false) {
                                                String sourceAddressPrefixInstance;
                                                sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                            }
                                            
                                            JsonNode destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix");
                                            if (destinationAddressPrefixValue != null && destinationAddressPrefixValue instanceof NullNode == false) {
                                                String destinationAddressPrefixInstance;
                                                destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                            }
                                            
                                            JsonNode accessValue = propertiesValue2.get("access");
                                            if (accessValue != null && accessValue instanceof NullNode == false) {
                                                String accessInstance;
                                                accessInstance = accessValue.getTextValue();
                                                securityRuleJsonFormatInstance.setAccess(accessInstance);
                                            }
                                            
                                            JsonNode priorityValue = propertiesValue2.get("priority");
                                            if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                                int priorityInstance;
                                                priorityInstance = priorityValue.getIntValue();
                                                securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                            }
                                            
                                            JsonNode directionValue = propertiesValue2.get("direction");
                                            if (directionValue != null && directionValue instanceof NullNode == false) {
                                                String directionInstance;
                                                directionInstance = directionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDirection(directionInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = securityRulesValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            securityRuleJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = securityRulesValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            securityRuleJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue = securityRulesValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            securityRuleJsonFormatInstance.setId(idInstance);
                                        }
                                    }
                                }
                                
                                JsonNode defaultSecurityRulesArray = propertiesValue.get("defaultSecurityRules");
                                if (defaultSecurityRulesArray != null && defaultSecurityRulesArray instanceof NullNode == false) {
                                    for (JsonNode defaultSecurityRulesValue : ((ArrayNode) defaultSecurityRulesArray)) {
                                        SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                        
                                        JsonNode propertiesValue3 = defaultSecurityRulesValue.get("properties");
                                        if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                            JsonNode descriptionValue2 = propertiesValue3.get("description");
                                            if (descriptionValue2 != null && descriptionValue2 instanceof NullNode == false) {
                                                String descriptionInstance2;
                                                descriptionInstance2 = descriptionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                            }
                                            
                                            JsonNode protocolValue2 = propertiesValue3.get("protocol");
                                            if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                                String protocolInstance2;
                                                protocolInstance2 = protocolValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                            }
                                            
                                            JsonNode sourcePortRangeValue2 = propertiesValue3.get("sourcePortRange");
                                            if (sourcePortRangeValue2 != null && sourcePortRangeValue2 instanceof NullNode == false) {
                                                String sourcePortRangeInstance2;
                                                sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                            }
                                            
                                            JsonNode destinationPortRangeValue2 = propertiesValue3.get("destinationPortRange");
                                            if (destinationPortRangeValue2 != null && destinationPortRangeValue2 instanceof NullNode == false) {
                                                String destinationPortRangeInstance2;
                                                destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                            }
                                            
                                            JsonNode sourceAddressPrefixValue2 = propertiesValue3.get("sourceAddressPrefix");
                                            if (sourceAddressPrefixValue2 != null && sourceAddressPrefixValue2 instanceof NullNode == false) {
                                                String sourceAddressPrefixInstance2;
                                                sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                            }
                                            
                                            JsonNode destinationAddressPrefixValue2 = propertiesValue3.get("destinationAddressPrefix");
                                            if (destinationAddressPrefixValue2 != null && destinationAddressPrefixValue2 instanceof NullNode == false) {
                                                String destinationAddressPrefixInstance2;
                                                destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                            }
                                            
                                            JsonNode accessValue2 = propertiesValue3.get("access");
                                            if (accessValue2 != null && accessValue2 instanceof NullNode == false) {
                                                String accessInstance2;
                                                accessInstance2 = accessValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                            }
                                            
                                            JsonNode priorityValue2 = propertiesValue3.get("priority");
                                            if (priorityValue2 != null && priorityValue2 instanceof NullNode == false) {
                                                int priorityInstance2;
                                                priorityInstance2 = priorityValue2.getIntValue();
                                                securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                            }
                                            
                                            JsonNode directionValue2 = propertiesValue3.get("direction");
                                            if (directionValue2 != null && directionValue2 instanceof NullNode == false) {
                                                String directionInstance2;
                                                directionInstance2 = directionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                            }
                                            
                                            JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                                String provisioningStateInstance2;
                                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        
                                        JsonNode nameValue2 = defaultSecurityRulesValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setName(nameInstance2);
                                        }
                                        
                                        JsonNode etagValue2 = defaultSecurityRulesValue.get("etag");
                                        if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                            String etagInstance2;
                                            etagInstance2 = etagValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                        }
                                        
                                        JsonNode idValue2 = defaultSecurityRulesValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setId(idInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode networkInterfacesArray = propertiesValue.get("networkInterfaces");
                                if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                                    for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                        ResourceId resourceIdInstance = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getNetworkInterfaces().add(resourceIdInstance);
                                        
                                        JsonNode idValue3 = networkInterfacesValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            resourceIdInstance.setId(idInstance3);
                                        }
                                    }
                                }
                                
                                JsonNode subnetsArray = propertiesValue.get("subnets");
                                if (subnetsArray != null && subnetsArray instanceof NullNode == false) {
                                    for (JsonNode subnetsValue : ((ArrayNode) subnetsArray)) {
                                        ResourceId resourceIdInstance2 = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getSubnets().add(resourceIdInstance2);
                                        
                                        JsonNode idValue4 = subnetsValue.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            resourceIdInstance2.setId(idInstance4);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue3 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                    String provisioningStateInstance3;
                                    provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                    networkSecurityGroupJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                }
                            }
                            
                            JsonNode etagValue3 = valueValue.get("etag");
                            if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                String etagInstance3;
                                etagInstance3 = etagValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setEtag(etagInstance3);
                            }
                            
                            JsonNode idValue5 = valueValue.get("id");
                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                String idInstance5;
                                idInstance5 = idValue5.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setId(idInstance5);
                            }
                            
                            JsonNode nameValue3 = valueValue.get("name");
                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                String nameInstance3;
                                nameInstance3 = nameValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setName(nameInstance3);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    networkSecurityGroupJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The list NetworkSecurityGroups returns all network security groups in a
    * subscription
    *
    * @return Response for ListNetworkSecurityGroups Api servive call
    */
    @Override
    public Future<NetworkSecurityGroupListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NetworkSecurityGroupListResponse>() { 
            @Override
            public NetworkSecurityGroupListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * The list NetworkSecurityGroups returns all network security groups in a
    * subscription
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListNetworkSecurityGroups Api servive call
    */
    @Override
    public NetworkSecurityGroupListResponse listAll() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NetworkSecurityGroupListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NetworkSecurityGroupListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            NetworkSecurityGroup networkSecurityGroupJsonFormatInstance = new NetworkSecurityGroup();
                            result.getNetworkSecurityGroups().add(networkSecurityGroupJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode securityRulesArray = propertiesValue.get("securityRules");
                                if (securityRulesArray != null && securityRulesArray instanceof NullNode == false) {
                                    for (JsonNode securityRulesValue : ((ArrayNode) securityRulesArray)) {
                                        SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getSecurityRules().add(securityRuleJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = securityRulesValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode descriptionValue = propertiesValue2.get("description");
                                            if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                                String descriptionInstance;
                                                descriptionInstance = descriptionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                            }
                                            
                                            JsonNode protocolValue = propertiesValue2.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode sourcePortRangeValue = propertiesValue2.get("sourcePortRange");
                                            if (sourcePortRangeValue != null && sourcePortRangeValue instanceof NullNode == false) {
                                                String sourcePortRangeInstance;
                                                sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                            }
                                            
                                            JsonNode destinationPortRangeValue = propertiesValue2.get("destinationPortRange");
                                            if (destinationPortRangeValue != null && destinationPortRangeValue instanceof NullNode == false) {
                                                String destinationPortRangeInstance;
                                                destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                            }
                                            
                                            JsonNode sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix");
                                            if (sourceAddressPrefixValue != null && sourceAddressPrefixValue instanceof NullNode == false) {
                                                String sourceAddressPrefixInstance;
                                                sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                            }
                                            
                                            JsonNode destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix");
                                            if (destinationAddressPrefixValue != null && destinationAddressPrefixValue instanceof NullNode == false) {
                                                String destinationAddressPrefixInstance;
                                                destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                            }
                                            
                                            JsonNode accessValue = propertiesValue2.get("access");
                                            if (accessValue != null && accessValue instanceof NullNode == false) {
                                                String accessInstance;
                                                accessInstance = accessValue.getTextValue();
                                                securityRuleJsonFormatInstance.setAccess(accessInstance);
                                            }
                                            
                                            JsonNode priorityValue = propertiesValue2.get("priority");
                                            if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                                int priorityInstance;
                                                priorityInstance = priorityValue.getIntValue();
                                                securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                            }
                                            
                                            JsonNode directionValue = propertiesValue2.get("direction");
                                            if (directionValue != null && directionValue instanceof NullNode == false) {
                                                String directionInstance;
                                                directionInstance = directionValue.getTextValue();
                                                securityRuleJsonFormatInstance.setDirection(directionInstance);
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = securityRulesValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            securityRuleJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = securityRulesValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            securityRuleJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue = securityRulesValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            securityRuleJsonFormatInstance.setId(idInstance);
                                        }
                                    }
                                }
                                
                                JsonNode defaultSecurityRulesArray = propertiesValue.get("defaultSecurityRules");
                                if (defaultSecurityRulesArray != null && defaultSecurityRulesArray instanceof NullNode == false) {
                                    for (JsonNode defaultSecurityRulesValue : ((ArrayNode) defaultSecurityRulesArray)) {
                                        SecurityRule securityRuleJsonFormatInstance2 = new SecurityRule();
                                        networkSecurityGroupJsonFormatInstance.getDefaultSecurityRules().add(securityRuleJsonFormatInstance2);
                                        
                                        JsonNode propertiesValue3 = defaultSecurityRulesValue.get("properties");
                                        if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                            JsonNode descriptionValue2 = propertiesValue3.get("description");
                                            if (descriptionValue2 != null && descriptionValue2 instanceof NullNode == false) {
                                                String descriptionInstance2;
                                                descriptionInstance2 = descriptionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDescription(descriptionInstance2);
                                            }
                                            
                                            JsonNode protocolValue2 = propertiesValue3.get("protocol");
                                            if (protocolValue2 != null && protocolValue2 instanceof NullNode == false) {
                                                String protocolInstance2;
                                                protocolInstance2 = protocolValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProtocol(protocolInstance2);
                                            }
                                            
                                            JsonNode sourcePortRangeValue2 = propertiesValue3.get("sourcePortRange");
                                            if (sourcePortRangeValue2 != null && sourcePortRangeValue2 instanceof NullNode == false) {
                                                String sourcePortRangeInstance2;
                                                sourcePortRangeInstance2 = sourcePortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourcePortRange(sourcePortRangeInstance2);
                                            }
                                            
                                            JsonNode destinationPortRangeValue2 = propertiesValue3.get("destinationPortRange");
                                            if (destinationPortRangeValue2 != null && destinationPortRangeValue2 instanceof NullNode == false) {
                                                String destinationPortRangeInstance2;
                                                destinationPortRangeInstance2 = destinationPortRangeValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationPortRange(destinationPortRangeInstance2);
                                            }
                                            
                                            JsonNode sourceAddressPrefixValue2 = propertiesValue3.get("sourceAddressPrefix");
                                            if (sourceAddressPrefixValue2 != null && sourceAddressPrefixValue2 instanceof NullNode == false) {
                                                String sourceAddressPrefixInstance2;
                                                sourceAddressPrefixInstance2 = sourceAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setSourceAddressPrefix(sourceAddressPrefixInstance2);
                                            }
                                            
                                            JsonNode destinationAddressPrefixValue2 = propertiesValue3.get("destinationAddressPrefix");
                                            if (destinationAddressPrefixValue2 != null && destinationAddressPrefixValue2 instanceof NullNode == false) {
                                                String destinationAddressPrefixInstance2;
                                                destinationAddressPrefixInstance2 = destinationAddressPrefixValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDestinationAddressPrefix(destinationAddressPrefixInstance2);
                                            }
                                            
                                            JsonNode accessValue2 = propertiesValue3.get("access");
                                            if (accessValue2 != null && accessValue2 instanceof NullNode == false) {
                                                String accessInstance2;
                                                accessInstance2 = accessValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setAccess(accessInstance2);
                                            }
                                            
                                            JsonNode priorityValue2 = propertiesValue3.get("priority");
                                            if (priorityValue2 != null && priorityValue2 instanceof NullNode == false) {
                                                int priorityInstance2;
                                                priorityInstance2 = priorityValue2.getIntValue();
                                                securityRuleJsonFormatInstance2.setPriority(priorityInstance2);
                                            }
                                            
                                            JsonNode directionValue2 = propertiesValue3.get("direction");
                                            if (directionValue2 != null && directionValue2 instanceof NullNode == false) {
                                                String directionInstance2;
                                                directionInstance2 = directionValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setDirection(directionInstance2);
                                            }
                                            
                                            JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                                String provisioningStateInstance2;
                                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                securityRuleJsonFormatInstance2.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        
                                        JsonNode nameValue2 = defaultSecurityRulesValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setName(nameInstance2);
                                        }
                                        
                                        JsonNode etagValue2 = defaultSecurityRulesValue.get("etag");
                                        if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                            String etagInstance2;
                                            etagInstance2 = etagValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setEtag(etagInstance2);
                                        }
                                        
                                        JsonNode idValue2 = defaultSecurityRulesValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            securityRuleJsonFormatInstance2.setId(idInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode networkInterfacesArray = propertiesValue.get("networkInterfaces");
                                if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                                    for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                        ResourceId resourceIdInstance = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getNetworkInterfaces().add(resourceIdInstance);
                                        
                                        JsonNode idValue3 = networkInterfacesValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            resourceIdInstance.setId(idInstance3);
                                        }
                                    }
                                }
                                
                                JsonNode subnetsArray = propertiesValue.get("subnets");
                                if (subnetsArray != null && subnetsArray instanceof NullNode == false) {
                                    for (JsonNode subnetsValue : ((ArrayNode) subnetsArray)) {
                                        ResourceId resourceIdInstance2 = new ResourceId();
                                        networkSecurityGroupJsonFormatInstance.getSubnets().add(resourceIdInstance2);
                                        
                                        JsonNode idValue4 = subnetsValue.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            resourceIdInstance2.setId(idInstance4);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue3 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                    String provisioningStateInstance3;
                                    provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                    networkSecurityGroupJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                }
                            }
                            
                            JsonNode etagValue3 = valueValue.get("etag");
                            if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                String etagInstance3;
                                etagInstance3 = etagValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setEtag(etagInstance3);
                            }
                            
                            JsonNode idValue5 = valueValue.get("id");
                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                String idInstance5;
                                idInstance5 = idValue5.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setId(idInstance5);
                            }
                            
                            JsonNode nameValue3 = valueValue.get("name");
                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                String nameInstance3;
                                nameInstance3 = nameValue3.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setName(nameInstance3);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                networkSecurityGroupJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    networkSecurityGroupJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
