/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.PublicIpAddress;
import com.microsoft.azure.management.network.models.PublicIpAddressDnsSettings;
import com.microsoft.azure.management.network.models.PublicIpAddressGetResponse;
import com.microsoft.azure.management.network.models.PublicIpAddressListResponse;
import com.microsoft.azure.management.network.models.PublicIpAddressPutResponse;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* PublicIPAddress for your subscription.
*/
public class PublicIpAddressOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, PublicIpAddressOperations {
    /**
    * Initializes a new instance of the PublicIpAddressOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    PublicIpAddressOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put PublicIPAddress operation creates/updates a stable/dynamic
    * PublicIP address
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the publicIpAddress.
    * @param parameters Required. Parameters supplied to the create/update
    * PublicIPAddress operation
    * @return Response for PutPublicIpAddress Api servive call
    */
    @Override
    public Future<PublicIpAddressPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String publicIpAddressName, final PublicIpAddress parameters) {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressPutResponse>() { 
            @Override
            public PublicIpAddressPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, publicIpAddressName, parameters);
            }
         });
    }
    
    /**
    * The Put PublicIPAddress operation creates/updates a stable/dynamic
    * PublicIP address
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the publicIpAddress.
    * @param parameters Required. Parameters supplied to the create/update
    * PublicIPAddress operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutPublicIpAddress Api servive call
    */
    @Override
    public PublicIpAddressPutResponse beginCreateOrUpdating(String resourceGroupName, String publicIpAddressName, PublicIpAddress parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (publicIpAddressName == null) {
            throw new NullPointerException("publicIpAddressName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getPublicIpAllocationMethod() == null) {
            throw new NullPointerException("parameters.PublicIpAllocationMethod");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses/";
        url = url + URLEncoder.encode(publicIpAddressName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode publicIpAddressJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = publicIpAddressJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) publicIpAddressJsonFormatValue).put("properties", propertiesValue);
        
        ((ObjectNode) propertiesValue).put("publicIPAllocationMethod", parameters.getPublicIpAllocationMethod());
        
        if (parameters.getIpConfiguration() != null) {
            ObjectNode ipConfigurationValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("ipConfiguration", ipConfigurationValue);
            
            if (parameters.getIpConfiguration().getId() != null) {
                ((ObjectNode) ipConfigurationValue).put("id", parameters.getIpConfiguration().getId());
            }
        }
        
        if (parameters.getDnsSettings() != null) {
            ObjectNode dnsSettingsValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("dnsSettings", dnsSettingsValue);
            
            if (parameters.getDnsSettings().getDomainNameLabel() != null) {
                ((ObjectNode) dnsSettingsValue).put("domainNameLabel", parameters.getDnsSettings().getDomainNameLabel());
            }
            
            if (parameters.getDnsSettings().getFqdn() != null) {
                ((ObjectNode) dnsSettingsValue).put("fqdn", parameters.getDnsSettings().getFqdn());
            }
            
            if (parameters.getDnsSettings().getReverseFqdn() != null) {
                ((ObjectNode) dnsSettingsValue).put("reverseFqdn", parameters.getDnsSettings().getReverseFqdn());
            }
        }
        
        if (parameters.getIpAddress() != null) {
            ((ObjectNode) propertiesValue).put("ipAddress", parameters.getIpAddress());
        }
        
        if (parameters.getIdleTimeoutInMinutes() != null) {
            ((ObjectNode) propertiesValue).put("idleTimeoutInMinutes", parameters.getIdleTimeoutInMinutes());
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) publicIpAddressJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) publicIpAddressJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) publicIpAddressJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) publicIpAddressJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) publicIpAddressJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) publicIpAddressJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            PublicIpAddressPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    PublicIpAddress publicIpAddressInstance = new PublicIpAddress();
                    result.setPublicIpAddress(publicIpAddressInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode publicIPAllocationMethodValue = propertiesValue2.get("publicIPAllocationMethod");
                        if (publicIPAllocationMethodValue != null && publicIPAllocationMethodValue instanceof NullNode == false) {
                            String publicIPAllocationMethodInstance;
                            publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                            publicIpAddressInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                        }
                        
                        JsonNode ipConfigurationValue2 = propertiesValue2.get("ipConfiguration");
                        if (ipConfigurationValue2 != null && ipConfigurationValue2 instanceof NullNode == false) {
                            ResourceId ipConfigurationInstance = new ResourceId();
                            publicIpAddressInstance.setIpConfiguration(ipConfigurationInstance);
                            
                            JsonNode idValue = ipConfigurationValue2.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                ipConfigurationInstance.setId(idInstance);
                            }
                        }
                        
                        JsonNode dnsSettingsValue2 = propertiesValue2.get("dnsSettings");
                        if (dnsSettingsValue2 != null && dnsSettingsValue2 instanceof NullNode == false) {
                            PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                            publicIpAddressInstance.setDnsSettings(dnsSettingsInstance);
                            
                            JsonNode domainNameLabelValue = dnsSettingsValue2.get("domainNameLabel");
                            if (domainNameLabelValue != null && domainNameLabelValue instanceof NullNode == false) {
                                String domainNameLabelInstance;
                                domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                            }
                            
                            JsonNode fqdnValue = dnsSettingsValue2.get("fqdn");
                            if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                String fqdnInstance;
                                fqdnInstance = fqdnValue.getTextValue();
                                dnsSettingsInstance.setFqdn(fqdnInstance);
                            }
                            
                            JsonNode reverseFqdnValue = dnsSettingsValue2.get("reverseFqdn");
                            if (reverseFqdnValue != null && reverseFqdnValue instanceof NullNode == false) {
                                String reverseFqdnInstance;
                                reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                            }
                        }
                        
                        JsonNode ipAddressValue = propertiesValue2.get("ipAddress");
                        if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                            String ipAddressInstance;
                            ipAddressInstance = ipAddressValue.getTextValue();
                            publicIpAddressInstance.setIpAddress(ipAddressInstance);
                        }
                        
                        JsonNode idleTimeoutInMinutesValue = propertiesValue2.get("idleTimeoutInMinutes");
                        if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                            int idleTimeoutInMinutesInstance;
                            idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                            publicIpAddressInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            publicIpAddressInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode etagValue = responseDoc.get("etag");
                    if (etagValue != null && etagValue instanceof NullNode == false) {
                        String etagInstance;
                        etagInstance = etagValue.getTextValue();
                        publicIpAddressInstance.setEtag(etagInstance);
                    }
                    
                    JsonNode idValue2 = responseDoc.get("id");
                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                        String idInstance2;
                        idInstance2 = idValue2.getTextValue();
                        publicIpAddressInstance.setId(idInstance2);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        publicIpAddressInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        publicIpAddressInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        publicIpAddressInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            publicIpAddressInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete publicIpAddress operation deletes the specified
    * publicIpAddress.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the subnet.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String publicIpAddressName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, publicIpAddressName);
            }
         });
    }
    
    /**
    * The delete publicIpAddress operation deletes the specified
    * publicIpAddress.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the subnet.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String publicIpAddressName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (publicIpAddressName == null) {
            throw new NullPointerException("publicIpAddressName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses/";
        url = url + URLEncoder.encode(publicIpAddressName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put PublicIPAddress operation creates/updates a stable/dynamic
    * PublicIP address
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the publicIpAddress.
    * @param parameters Required. Parameters supplied to the create
    * PublicIPAddress operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String publicIpAddressName, final PublicIpAddress parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, publicIpAddressName, parameters);
            }
         });
    }
    
    /**
    * The Put PublicIPAddress operation creates/updates a stable/dynamic
    * PublicIP address
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the publicIpAddress.
    * @param parameters Required. Parameters supplied to the create
    * PublicIPAddress operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String publicIpAddressName, PublicIpAddress parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            PublicIpAddressPutResponse response = client2.getPublicIpAddressesOperations().beginCreateOrUpdatingAsync(resourceGroupName, publicIpAddressName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get Role operation retrieves information about the specified virtual
    * machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the subnet.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String publicIpAddressName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, publicIpAddressName);
            }
         });
    }
    
    /**
    * The Get Role operation retrieves information about the specified virtual
    * machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the subnet.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String publicIpAddressName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getPublicIpAddressesOperations().beginDeletingAsync(resourceGroupName, publicIpAddressName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get publicIpAddress operation retreives information about the
    * specified pubicIpAddress
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the subnet.
    * @return Response for GetPublicIpAddress Api servive call
    */
    @Override
    public Future<PublicIpAddressGetResponse> getAsync(final String resourceGroupName, final String publicIpAddressName) {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressGetResponse>() { 
            @Override
            public PublicIpAddressGetResponse call() throws Exception {
                return get(resourceGroupName, publicIpAddressName);
            }
         });
    }
    
    /**
    * The Get publicIpAddress operation retreives information about the
    * specified pubicIpAddress
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param publicIpAddressName Required. The name of the subnet.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetPublicIpAddress Api servive call
    */
    @Override
    public PublicIpAddressGetResponse get(String resourceGroupName, String publicIpAddressName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (publicIpAddressName == null) {
            throw new NullPointerException("publicIpAddressName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses/";
        url = url + URLEncoder.encode(publicIpAddressName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            PublicIpAddressGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    PublicIpAddress publicIpAddressInstance = new PublicIpAddress();
                    result.setPublicIpAddress(publicIpAddressInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode publicIPAllocationMethodValue = propertiesValue.get("publicIPAllocationMethod");
                        if (publicIPAllocationMethodValue != null && publicIPAllocationMethodValue instanceof NullNode == false) {
                            String publicIPAllocationMethodInstance;
                            publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                            publicIpAddressInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                        }
                        
                        JsonNode ipConfigurationValue = propertiesValue.get("ipConfiguration");
                        if (ipConfigurationValue != null && ipConfigurationValue instanceof NullNode == false) {
                            ResourceId ipConfigurationInstance = new ResourceId();
                            publicIpAddressInstance.setIpConfiguration(ipConfigurationInstance);
                            
                            JsonNode idValue = ipConfigurationValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                ipConfigurationInstance.setId(idInstance);
                            }
                        }
                        
                        JsonNode dnsSettingsValue = propertiesValue.get("dnsSettings");
                        if (dnsSettingsValue != null && dnsSettingsValue instanceof NullNode == false) {
                            PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                            publicIpAddressInstance.setDnsSettings(dnsSettingsInstance);
                            
                            JsonNode domainNameLabelValue = dnsSettingsValue.get("domainNameLabel");
                            if (domainNameLabelValue != null && domainNameLabelValue instanceof NullNode == false) {
                                String domainNameLabelInstance;
                                domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                            }
                            
                            JsonNode fqdnValue = dnsSettingsValue.get("fqdn");
                            if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                String fqdnInstance;
                                fqdnInstance = fqdnValue.getTextValue();
                                dnsSettingsInstance.setFqdn(fqdnInstance);
                            }
                            
                            JsonNode reverseFqdnValue = dnsSettingsValue.get("reverseFqdn");
                            if (reverseFqdnValue != null && reverseFqdnValue instanceof NullNode == false) {
                                String reverseFqdnInstance;
                                reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                            }
                        }
                        
                        JsonNode ipAddressValue = propertiesValue.get("ipAddress");
                        if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                            String ipAddressInstance;
                            ipAddressInstance = ipAddressValue.getTextValue();
                            publicIpAddressInstance.setIpAddress(ipAddressInstance);
                        }
                        
                        JsonNode idleTimeoutInMinutesValue = propertiesValue.get("idleTimeoutInMinutes");
                        if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                            int idleTimeoutInMinutesInstance;
                            idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                            publicIpAddressInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            publicIpAddressInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode etagValue = responseDoc.get("etag");
                    if (etagValue != null && etagValue instanceof NullNode == false) {
                        String etagInstance;
                        etagInstance = etagValue.getTextValue();
                        publicIpAddressInstance.setEtag(etagInstance);
                    }
                    
                    JsonNode idValue2 = responseDoc.get("id");
                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                        String idInstance2;
                        idInstance2 = idValue2.getTextValue();
                        publicIpAddressInstance.setId(idInstance2);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        publicIpAddressInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        publicIpAddressInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        publicIpAddressInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            publicIpAddressInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List publicIpAddress opertion retrieves all the publicIpAddresses in
    * a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListPublicIpAddresses Api service call
    */
    @Override
    public Future<PublicIpAddressListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressListResponse>() { 
            @Override
            public PublicIpAddressListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The List publicIpAddress opertion retrieves all the publicIpAddresses in
    * a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListPublicIpAddresses Api service call
    */
    @Override
    public PublicIpAddressListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            PublicIpAddressListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            PublicIpAddress publicIpAddressJsonFormatInstance = new PublicIpAddress();
                            result.getPublicIpAddresses().add(publicIpAddressJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode publicIPAllocationMethodValue = propertiesValue.get("publicIPAllocationMethod");
                                if (publicIPAllocationMethodValue != null && publicIPAllocationMethodValue instanceof NullNode == false) {
                                    String publicIPAllocationMethodInstance;
                                    publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                                }
                                
                                JsonNode ipConfigurationValue = propertiesValue.get("ipConfiguration");
                                if (ipConfigurationValue != null && ipConfigurationValue instanceof NullNode == false) {
                                    ResourceId ipConfigurationInstance = new ResourceId();
                                    publicIpAddressJsonFormatInstance.setIpConfiguration(ipConfigurationInstance);
                                    
                                    JsonNode idValue = ipConfigurationValue.get("id");
                                    if (idValue != null && idValue instanceof NullNode == false) {
                                        String idInstance;
                                        idInstance = idValue.getTextValue();
                                        ipConfigurationInstance.setId(idInstance);
                                    }
                                }
                                
                                JsonNode dnsSettingsValue = propertiesValue.get("dnsSettings");
                                if (dnsSettingsValue != null && dnsSettingsValue instanceof NullNode == false) {
                                    PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                                    publicIpAddressJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    
                                    JsonNode domainNameLabelValue = dnsSettingsValue.get("domainNameLabel");
                                    if (domainNameLabelValue != null && domainNameLabelValue instanceof NullNode == false) {
                                        String domainNameLabelInstance;
                                        domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                                    }
                                    
                                    JsonNode fqdnValue = dnsSettingsValue.get("fqdn");
                                    if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                        String fqdnInstance;
                                        fqdnInstance = fqdnValue.getTextValue();
                                        dnsSettingsInstance.setFqdn(fqdnInstance);
                                    }
                                    
                                    JsonNode reverseFqdnValue = dnsSettingsValue.get("reverseFqdn");
                                    if (reverseFqdnValue != null && reverseFqdnValue instanceof NullNode == false) {
                                        String reverseFqdnInstance;
                                        reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                        dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                                    }
                                }
                                
                                JsonNode ipAddressValue = propertiesValue.get("ipAddress");
                                if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                                    String ipAddressInstance;
                                    ipAddressInstance = ipAddressValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setIpAddress(ipAddressInstance);
                                }
                                
                                JsonNode idleTimeoutInMinutesValue = propertiesValue.get("idleTimeoutInMinutes");
                                if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                                    int idleTimeoutInMinutesInstance;
                                    idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                    publicIpAddressJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            
                            JsonNode etagValue = valueValue.get("etag");
                            if (etagValue != null && etagValue instanceof NullNode == false) {
                                String etagInstance;
                                etagInstance = etagValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setEtag(etagInstance);
                            }
                            
                            JsonNode idValue2 = valueValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                publicIpAddressJsonFormatInstance.setId(idInstance2);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    publicIpAddressJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List publicIpAddress opertion retrieves all the publicIpAddresses in
    * a subscription.
    *
    * @return Response for ListPublicIpAddresses Api service call
    */
    @Override
    public Future<PublicIpAddressListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressListResponse>() { 
            @Override
            public PublicIpAddressListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * The List publicIpAddress opertion retrieves all the publicIpAddresses in
    * a subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListPublicIpAddresses Api service call
    */
    @Override
    public PublicIpAddressListResponse listAll() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            PublicIpAddressListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            PublicIpAddress publicIpAddressJsonFormatInstance = new PublicIpAddress();
                            result.getPublicIpAddresses().add(publicIpAddressJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode publicIPAllocationMethodValue = propertiesValue.get("publicIPAllocationMethod");
                                if (publicIPAllocationMethodValue != null && publicIPAllocationMethodValue instanceof NullNode == false) {
                                    String publicIPAllocationMethodInstance;
                                    publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                                }
                                
                                JsonNode ipConfigurationValue = propertiesValue.get("ipConfiguration");
                                if (ipConfigurationValue != null && ipConfigurationValue instanceof NullNode == false) {
                                    ResourceId ipConfigurationInstance = new ResourceId();
                                    publicIpAddressJsonFormatInstance.setIpConfiguration(ipConfigurationInstance);
                                    
                                    JsonNode idValue = ipConfigurationValue.get("id");
                                    if (idValue != null && idValue instanceof NullNode == false) {
                                        String idInstance;
                                        idInstance = idValue.getTextValue();
                                        ipConfigurationInstance.setId(idInstance);
                                    }
                                }
                                
                                JsonNode dnsSettingsValue = propertiesValue.get("dnsSettings");
                                if (dnsSettingsValue != null && dnsSettingsValue instanceof NullNode == false) {
                                    PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                                    publicIpAddressJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    
                                    JsonNode domainNameLabelValue = dnsSettingsValue.get("domainNameLabel");
                                    if (domainNameLabelValue != null && domainNameLabelValue instanceof NullNode == false) {
                                        String domainNameLabelInstance;
                                        domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                                    }
                                    
                                    JsonNode fqdnValue = dnsSettingsValue.get("fqdn");
                                    if (fqdnValue != null && fqdnValue instanceof NullNode == false) {
                                        String fqdnInstance;
                                        fqdnInstance = fqdnValue.getTextValue();
                                        dnsSettingsInstance.setFqdn(fqdnInstance);
                                    }
                                    
                                    JsonNode reverseFqdnValue = dnsSettingsValue.get("reverseFqdn");
                                    if (reverseFqdnValue != null && reverseFqdnValue instanceof NullNode == false) {
                                        String reverseFqdnInstance;
                                        reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                        dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                                    }
                                }
                                
                                JsonNode ipAddressValue = propertiesValue.get("ipAddress");
                                if (ipAddressValue != null && ipAddressValue instanceof NullNode == false) {
                                    String ipAddressInstance;
                                    ipAddressInstance = ipAddressValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setIpAddress(ipAddressInstance);
                                }
                                
                                JsonNode idleTimeoutInMinutesValue = propertiesValue.get("idleTimeoutInMinutes");
                                if (idleTimeoutInMinutesValue != null && idleTimeoutInMinutesValue instanceof NullNode == false) {
                                    int idleTimeoutInMinutesInstance;
                                    idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                    publicIpAddressJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            
                            JsonNode etagValue = valueValue.get("etag");
                            if (etagValue != null && etagValue instanceof NullNode == false) {
                                String etagInstance;
                                etagInstance = etagValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setEtag(etagInstance);
                            }
                            
                            JsonNode idValue2 = valueValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                publicIpAddressJsonFormatInstance.setId(idInstance2);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    publicIpAddressJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
