/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.SecurityRule;
import com.microsoft.azure.management.network.models.SecurityRuleGetResponse;
import com.microsoft.azure.management.network.models.SecurityRuleListResponse;
import com.microsoft.azure.management.network.models.SecurityRulePutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* SecurityRules for your subscription.
*/
public interface SecurityRuleOperations {
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PUT SecurityRule Api service call
    */
    SecurityRulePutResponse beginCreateOrUpdating(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters) throws IOException, ServiceException;
    
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @return Response for PUT SecurityRule Api service call
    */
    Future<SecurityRulePutResponse> beginCreateOrUpdatingAsync(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters);
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    UpdateOperationResponse beginDeleting(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws IOException, ServiceException;
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    Future<UpdateOperationResponse> beginDeletingAsync(String resourceGroupName, String networkSecurityGroupName, String securityRuleName);
    
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<AzureAsyncOperationResponse> createOrUpdateAsync(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters);
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String networkSecurityGroupName, String securityRuleName);
    
    /**
    * The Get NetworkSecurityRule operation retreives information about the
    * specified network security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetSecurityRule Api service call
    */
    SecurityRuleGetResponse get(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws IOException, ServiceException;
    
    /**
    * The Get NetworkSecurityRule operation retreives information about the
    * specified network security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @return Response for GetSecurityRule Api service call
    */
    Future<SecurityRuleGetResponse> getAsync(String resourceGroupName, String networkSecurityGroupName, String securityRuleName);
    
    /**
    * The List network security rule opertion retrieves all the security rules
    * in a network security group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListSecurityRule Api service callRetrieves all
    * security rules that belongs to a network security group
    */
    SecurityRuleListResponse list(String resourceGroupName, String networkSecurityGroupName) throws IOException, ServiceException;
    
    /**
    * The List network security rule opertion retrieves all the security rules
    * in a network security group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @return Response for ListSecurityRule Api service callRetrieves all
    * security rules that belongs to a network security group
    */
    Future<SecurityRuleListResponse> listAsync(String resourceGroupName, String networkSecurityGroupName);
}
