/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.SecurityRule;
import com.microsoft.azure.management.network.models.SecurityRuleGetResponse;
import com.microsoft.azure.management.network.models.SecurityRuleListResponse;
import com.microsoft.azure.management.network.models.SecurityRulePutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* SecurityRules for your subscription.
*/
public class SecurityRuleOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, SecurityRuleOperations {
    /**
    * Initializes a new instance of the SecurityRuleOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    SecurityRuleOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @return Response for PUT SecurityRule Api service call
    */
    @Override
    public Future<SecurityRulePutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName, final SecurityRule securityRuleParameters) {
        return this.getClient().getExecutorService().submit(new Callable<SecurityRulePutResponse>() { 
            @Override
            public SecurityRulePutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, networkSecurityGroupName, securityRuleName, securityRuleParameters);
            }
         });
    }
    
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PUT SecurityRule Api service call
    */
    @Override
    public SecurityRulePutResponse beginCreateOrUpdating(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (securityRuleName == null) {
            throw new NullPointerException("securityRuleName");
        }
        if (securityRuleParameters == null) {
            throw new NullPointerException("securityRuleParameters");
        }
        if (securityRuleParameters.getAccess() == null) {
            throw new NullPointerException("securityRuleParameters.Access");
        }
        if (securityRuleParameters.getDestinationAddressPrefix() == null) {
            throw new NullPointerException("securityRuleParameters.DestinationAddressPrefix");
        }
        if (securityRuleParameters.getDirection() == null) {
            throw new NullPointerException("securityRuleParameters.Direction");
        }
        if (securityRuleParameters.getProtocol() == null) {
            throw new NullPointerException("securityRuleParameters.Protocol");
        }
        if (securityRuleParameters.getSourceAddressPrefix() == null) {
            throw new NullPointerException("securityRuleParameters.SourceAddressPrefix");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            tracingParameters.put("securityRuleParameters", securityRuleParameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules/";
        url = url + URLEncoder.encode(securityRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode securityRuleJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = securityRuleJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) securityRuleJsonFormatValue).put("properties", propertiesValue);
        
        if (securityRuleParameters.getDescription() != null) {
            ((ObjectNode) propertiesValue).put("description", securityRuleParameters.getDescription());
        }
        
        ((ObjectNode) propertiesValue).put("protocol", securityRuleParameters.getProtocol());
        
        if (securityRuleParameters.getSourcePortRange() != null) {
            ((ObjectNode) propertiesValue).put("sourcePortRange", securityRuleParameters.getSourcePortRange());
        }
        
        if (securityRuleParameters.getDestinationPortRange() != null) {
            ((ObjectNode) propertiesValue).put("destinationPortRange", securityRuleParameters.getDestinationPortRange());
        }
        
        ((ObjectNode) propertiesValue).put("sourceAddressPrefix", securityRuleParameters.getSourceAddressPrefix());
        
        ((ObjectNode) propertiesValue).put("destinationAddressPrefix", securityRuleParameters.getDestinationAddressPrefix());
        
        ((ObjectNode) propertiesValue).put("access", securityRuleParameters.getAccess());
        
        ((ObjectNode) propertiesValue).put("priority", securityRuleParameters.getPriority());
        
        ((ObjectNode) propertiesValue).put("direction", securityRuleParameters.getDirection());
        
        if (securityRuleParameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", securityRuleParameters.getProvisioningState());
        }
        
        if (securityRuleParameters.getName() != null) {
            ((ObjectNode) securityRuleJsonFormatValue).put("name", securityRuleParameters.getName());
        }
        
        if (securityRuleParameters.getEtag() != null) {
            ((ObjectNode) securityRuleJsonFormatValue).put("etag", securityRuleParameters.getEtag());
        }
        
        if (securityRuleParameters.getId() != null) {
            ((ObjectNode) securityRuleJsonFormatValue).put("id", securityRuleParameters.getId());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SecurityRulePutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SecurityRulePutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SecurityRule securityRuleInstance = new SecurityRule();
                    result.setSecurityRule(securityRuleInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode descriptionValue = propertiesValue2.get("description");
                        if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                            String descriptionInstance;
                            descriptionInstance = descriptionValue.getTextValue();
                            securityRuleInstance.setDescription(descriptionInstance);
                        }
                        
                        JsonNode protocolValue = propertiesValue2.get("protocol");
                        if (protocolValue != null && protocolValue instanceof NullNode == false) {
                            String protocolInstance;
                            protocolInstance = protocolValue.getTextValue();
                            securityRuleInstance.setProtocol(protocolInstance);
                        }
                        
                        JsonNode sourcePortRangeValue = propertiesValue2.get("sourcePortRange");
                        if (sourcePortRangeValue != null && sourcePortRangeValue instanceof NullNode == false) {
                            String sourcePortRangeInstance;
                            sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                            securityRuleInstance.setSourcePortRange(sourcePortRangeInstance);
                        }
                        
                        JsonNode destinationPortRangeValue = propertiesValue2.get("destinationPortRange");
                        if (destinationPortRangeValue != null && destinationPortRangeValue instanceof NullNode == false) {
                            String destinationPortRangeInstance;
                            destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                            securityRuleInstance.setDestinationPortRange(destinationPortRangeInstance);
                        }
                        
                        JsonNode sourceAddressPrefixValue = propertiesValue2.get("sourceAddressPrefix");
                        if (sourceAddressPrefixValue != null && sourceAddressPrefixValue instanceof NullNode == false) {
                            String sourceAddressPrefixInstance;
                            sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                            securityRuleInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                        }
                        
                        JsonNode destinationAddressPrefixValue = propertiesValue2.get("destinationAddressPrefix");
                        if (destinationAddressPrefixValue != null && destinationAddressPrefixValue instanceof NullNode == false) {
                            String destinationAddressPrefixInstance;
                            destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                            securityRuleInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                        }
                        
                        JsonNode accessValue = propertiesValue2.get("access");
                        if (accessValue != null && accessValue instanceof NullNode == false) {
                            String accessInstance;
                            accessInstance = accessValue.getTextValue();
                            securityRuleInstance.setAccess(accessInstance);
                        }
                        
                        JsonNode priorityValue = propertiesValue2.get("priority");
                        if (priorityValue != null && priorityValue instanceof NullNode == false) {
                            int priorityInstance;
                            priorityInstance = priorityValue.getIntValue();
                            securityRuleInstance.setPriority(priorityInstance);
                        }
                        
                        JsonNode directionValue = propertiesValue2.get("direction");
                        if (directionValue != null && directionValue instanceof NullNode == false) {
                            String directionInstance;
                            directionInstance = directionValue.getTextValue();
                            securityRuleInstance.setDirection(directionInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            securityRuleInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        securityRuleInstance.setName(nameInstance);
                    }
                    
                    JsonNode etagValue = responseDoc.get("etag");
                    if (etagValue != null && etagValue instanceof NullNode == false) {
                        String etagInstance;
                        etagInstance = etagValue.getTextValue();
                        securityRuleInstance.setEtag(etagInstance);
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        securityRuleInstance.setId(idInstance);
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, networkSecurityGroupName, securityRuleName);
            }
         });
    }
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (securityRuleName == null) {
            throw new NullPointerException("securityRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules/";
        url = url + URLEncoder.encode(securityRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName, final SecurityRule securityRuleParameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, networkSecurityGroupName, securityRuleName, securityRuleParameters);
            }
         });
    }
    
    /**
    * The Put network security rule operation creates/updates a security rule
    * in the specified network security group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @param securityRuleParameters Required. Parameters supplied to the
    * create/update network security rule operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String networkSecurityGroupName, String securityRuleName, SecurityRule securityRuleParameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            tracingParameters.put("securityRuleParameters", securityRuleParameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            SecurityRulePutResponse response = client2.getSecurityRulesOperations().beginCreateOrUpdatingAsync(resourceGroupName, networkSecurityGroupName, securityRuleName, securityRuleParameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, networkSecurityGroupName, securityRuleName);
            }
         });
    }
    
    /**
    * The delete network security rule operation deletes the specified network
    * security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getSecurityRulesOperations().beginDeletingAsync(resourceGroupName, networkSecurityGroupName, securityRuleName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get NetworkSecurityRule operation retreives information about the
    * specified network security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @return Response for GetSecurityRule Api service call
    */
    @Override
    public Future<SecurityRuleGetResponse> getAsync(final String resourceGroupName, final String networkSecurityGroupName, final String securityRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<SecurityRuleGetResponse>() { 
            @Override
            public SecurityRuleGetResponse call() throws Exception {
                return get(resourceGroupName, networkSecurityGroupName, securityRuleName);
            }
         });
    }
    
    /**
    * The Get NetworkSecurityRule operation retreives information about the
    * specified network security rule.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @param securityRuleName Required. The name of the security rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetSecurityRule Api service call
    */
    @Override
    public SecurityRuleGetResponse get(String resourceGroupName, String networkSecurityGroupName, String securityRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        if (securityRuleName == null) {
            throw new NullPointerException("securityRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            tracingParameters.put("securityRuleName", securityRuleName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules/";
        url = url + URLEncoder.encode(securityRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SecurityRuleGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SecurityRuleGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SecurityRule securityRuleInstance = new SecurityRule();
                    result.setSecurityRule(securityRuleInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode descriptionValue = propertiesValue.get("description");
                        if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                            String descriptionInstance;
                            descriptionInstance = descriptionValue.getTextValue();
                            securityRuleInstance.setDescription(descriptionInstance);
                        }
                        
                        JsonNode protocolValue = propertiesValue.get("protocol");
                        if (protocolValue != null && protocolValue instanceof NullNode == false) {
                            String protocolInstance;
                            protocolInstance = protocolValue.getTextValue();
                            securityRuleInstance.setProtocol(protocolInstance);
                        }
                        
                        JsonNode sourcePortRangeValue = propertiesValue.get("sourcePortRange");
                        if (sourcePortRangeValue != null && sourcePortRangeValue instanceof NullNode == false) {
                            String sourcePortRangeInstance;
                            sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                            securityRuleInstance.setSourcePortRange(sourcePortRangeInstance);
                        }
                        
                        JsonNode destinationPortRangeValue = propertiesValue.get("destinationPortRange");
                        if (destinationPortRangeValue != null && destinationPortRangeValue instanceof NullNode == false) {
                            String destinationPortRangeInstance;
                            destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                            securityRuleInstance.setDestinationPortRange(destinationPortRangeInstance);
                        }
                        
                        JsonNode sourceAddressPrefixValue = propertiesValue.get("sourceAddressPrefix");
                        if (sourceAddressPrefixValue != null && sourceAddressPrefixValue instanceof NullNode == false) {
                            String sourceAddressPrefixInstance;
                            sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                            securityRuleInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                        }
                        
                        JsonNode destinationAddressPrefixValue = propertiesValue.get("destinationAddressPrefix");
                        if (destinationAddressPrefixValue != null && destinationAddressPrefixValue instanceof NullNode == false) {
                            String destinationAddressPrefixInstance;
                            destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                            securityRuleInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                        }
                        
                        JsonNode accessValue = propertiesValue.get("access");
                        if (accessValue != null && accessValue instanceof NullNode == false) {
                            String accessInstance;
                            accessInstance = accessValue.getTextValue();
                            securityRuleInstance.setAccess(accessInstance);
                        }
                        
                        JsonNode priorityValue = propertiesValue.get("priority");
                        if (priorityValue != null && priorityValue instanceof NullNode == false) {
                            int priorityInstance;
                            priorityInstance = priorityValue.getIntValue();
                            securityRuleInstance.setPriority(priorityInstance);
                        }
                        
                        JsonNode directionValue = propertiesValue.get("direction");
                        if (directionValue != null && directionValue instanceof NullNode == false) {
                            String directionInstance;
                            directionInstance = directionValue.getTextValue();
                            securityRuleInstance.setDirection(directionInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            securityRuleInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        securityRuleInstance.setName(nameInstance);
                    }
                    
                    JsonNode etagValue = responseDoc.get("etag");
                    if (etagValue != null && etagValue instanceof NullNode == false) {
                        String etagInstance;
                        etagInstance = etagValue.getTextValue();
                        securityRuleInstance.setEtag(etagInstance);
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        securityRuleInstance.setId(idInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List network security rule opertion retrieves all the security rules
    * in a network security group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @return Response for ListSecurityRule Api service callRetrieves all
    * security rules that belongs to a network security group
    */
    @Override
    public Future<SecurityRuleListResponse> listAsync(final String resourceGroupName, final String networkSecurityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<SecurityRuleListResponse>() { 
            @Override
            public SecurityRuleListResponse call() throws Exception {
                return list(resourceGroupName, networkSecurityGroupName);
            }
         });
    }
    
    /**
    * The List network security rule opertion retrieves all the security rules
    * in a network security group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param networkSecurityGroupName Required. The name of the network
    * security group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListSecurityRule Api service callRetrieves all
    * security rules that belongs to a network security group
    */
    @Override
    public SecurityRuleListResponse list(String resourceGroupName, String networkSecurityGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (networkSecurityGroupName == null) {
            throw new NullPointerException("networkSecurityGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("networkSecurityGroupName", networkSecurityGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/networkSecurityGroups/";
        url = url + URLEncoder.encode(networkSecurityGroupName, "UTF-8");
        url = url + "/securityRules";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SecurityRuleListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SecurityRuleListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            SecurityRule securityRuleJsonFormatInstance = new SecurityRule();
                            result.getSecurityRules().add(securityRuleJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode descriptionValue = propertiesValue.get("description");
                                if (descriptionValue != null && descriptionValue instanceof NullNode == false) {
                                    String descriptionInstance;
                                    descriptionInstance = descriptionValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDescription(descriptionInstance);
                                }
                                
                                JsonNode protocolValue = propertiesValue.get("protocol");
                                if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                    String protocolInstance;
                                    protocolInstance = protocolValue.getTextValue();
                                    securityRuleJsonFormatInstance.setProtocol(protocolInstance);
                                }
                                
                                JsonNode sourcePortRangeValue = propertiesValue.get("sourcePortRange");
                                if (sourcePortRangeValue != null && sourcePortRangeValue instanceof NullNode == false) {
                                    String sourcePortRangeInstance;
                                    sourcePortRangeInstance = sourcePortRangeValue.getTextValue();
                                    securityRuleJsonFormatInstance.setSourcePortRange(sourcePortRangeInstance);
                                }
                                
                                JsonNode destinationPortRangeValue = propertiesValue.get("destinationPortRange");
                                if (destinationPortRangeValue != null && destinationPortRangeValue instanceof NullNode == false) {
                                    String destinationPortRangeInstance;
                                    destinationPortRangeInstance = destinationPortRangeValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDestinationPortRange(destinationPortRangeInstance);
                                }
                                
                                JsonNode sourceAddressPrefixValue = propertiesValue.get("sourceAddressPrefix");
                                if (sourceAddressPrefixValue != null && sourceAddressPrefixValue instanceof NullNode == false) {
                                    String sourceAddressPrefixInstance;
                                    sourceAddressPrefixInstance = sourceAddressPrefixValue.getTextValue();
                                    securityRuleJsonFormatInstance.setSourceAddressPrefix(sourceAddressPrefixInstance);
                                }
                                
                                JsonNode destinationAddressPrefixValue = propertiesValue.get("destinationAddressPrefix");
                                if (destinationAddressPrefixValue != null && destinationAddressPrefixValue instanceof NullNode == false) {
                                    String destinationAddressPrefixInstance;
                                    destinationAddressPrefixInstance = destinationAddressPrefixValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDestinationAddressPrefix(destinationAddressPrefixInstance);
                                }
                                
                                JsonNode accessValue = propertiesValue.get("access");
                                if (accessValue != null && accessValue instanceof NullNode == false) {
                                    String accessInstance;
                                    accessInstance = accessValue.getTextValue();
                                    securityRuleJsonFormatInstance.setAccess(accessInstance);
                                }
                                
                                JsonNode priorityValue = propertiesValue.get("priority");
                                if (priorityValue != null && priorityValue instanceof NullNode == false) {
                                    int priorityInstance;
                                    priorityInstance = priorityValue.getIntValue();
                                    securityRuleJsonFormatInstance.setPriority(priorityInstance);
                                }
                                
                                JsonNode directionValue = propertiesValue.get("direction");
                                if (directionValue != null && directionValue instanceof NullNode == false) {
                                    String directionInstance;
                                    directionInstance = directionValue.getTextValue();
                                    securityRuleJsonFormatInstance.setDirection(directionInstance);
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    securityRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                securityRuleJsonFormatInstance.setName(nameInstance);
                            }
                            
                            JsonNode etagValue = valueValue.get("etag");
                            if (etagValue != null && etagValue instanceof NullNode == false) {
                                String etagInstance;
                                etagInstance = etagValue.getTextValue();
                                securityRuleJsonFormatInstance.setEtag(etagInstance);
                            }
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                securityRuleJsonFormatInstance.setId(idInstance);
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
