/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.Subnet;
import com.microsoft.azure.management.network.models.SubnetGetResponse;
import com.microsoft.azure.management.network.models.SubnetListResponse;
import com.microsoft.azure.management.network.models.SubnetPutResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* subnets for your subscription.
*/
public class SubnetOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, SubnetOperations {
    /**
    * Initializes a new instance of the SubnetOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    SubnetOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put Subnet operation creates/updates a subnet in thespecified virtual
    * network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @param subnetParameters Required. Parameters supplied to the
    * create/update Subnet operation
    * @return Response for PutSubnet Api service call
    */
    @Override
    public Future<SubnetPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName, final Subnet subnetParameters) {
        return this.getClient().getExecutorService().submit(new Callable<SubnetPutResponse>() { 
            @Override
            public SubnetPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, virtualNetworkName, subnetName, subnetParameters);
            }
         });
    }
    
    /**
    * The Put Subnet operation creates/updates a subnet in thespecified virtual
    * network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @param subnetParameters Required. Parameters supplied to the
    * create/update Subnet operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutSubnet Api service call
    */
    @Override
    public SubnetPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkName, String subnetName, Subnet subnetParameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        if (subnetParameters == null) {
            throw new NullPointerException("subnetParameters");
        }
        if (subnetParameters.getAddressPrefix() == null) {
            throw new NullPointerException("subnetParameters.AddressPrefix");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("subnetParameters", subnetParameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode subnetJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = subnetJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) subnetJsonFormatValue).put("properties", propertiesValue);
        
        ((ObjectNode) propertiesValue).put("addressPrefix", subnetParameters.getAddressPrefix());
        
        if (subnetParameters.getNetworkSecurityGroup() != null) {
            ObjectNode networkSecurityGroupValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("networkSecurityGroup", networkSecurityGroupValue);
            
            if (subnetParameters.getNetworkSecurityGroup().getId() != null) {
                ((ObjectNode) networkSecurityGroupValue).put("id", subnetParameters.getNetworkSecurityGroup().getId());
            }
        }
        
        if (subnetParameters.getRouteTable() != null) {
            ObjectNode routeTableValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("routeTable", routeTableValue);
            
            if (subnetParameters.getRouteTable().getId() != null) {
                ((ObjectNode) routeTableValue).put("id", subnetParameters.getRouteTable().getId());
            }
        }
        
        if (subnetParameters.getIpConfigurations() != null) {
            if (subnetParameters.getIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) subnetParameters.getIpConfigurations()).isInitialized()) {
                ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                for (ResourceId ipConfigurationsItem : subnetParameters.getIpConfigurations()) {
                    ObjectNode resourceIdValue = objectMapper.createObjectNode();
                    ipConfigurationsArray.add(resourceIdValue);
                    
                    if (ipConfigurationsItem.getId() != null) {
                        ((ObjectNode) resourceIdValue).put("id", ipConfigurationsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("ipConfigurations", ipConfigurationsArray);
            }
        }
        
        if (subnetParameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", subnetParameters.getProvisioningState());
        }
        
        if (subnetParameters.getName() != null) {
            ((ObjectNode) subnetJsonFormatValue).put("name", subnetParameters.getName());
        }
        
        if (subnetParameters.getEtag() != null) {
            ((ObjectNode) subnetJsonFormatValue).put("etag", subnetParameters.getEtag());
        }
        
        if (subnetParameters.getId() != null) {
            ((ObjectNode) subnetJsonFormatValue).put("id", subnetParameters.getId());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SubnetPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubnetPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Subnet subnetInstance = new Subnet();
                    result.setSubnet(subnetInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                        if (addressPrefixValue != null && addressPrefixValue instanceof NullNode == false) {
                            String addressPrefixInstance;
                            addressPrefixInstance = addressPrefixValue.getTextValue();
                            subnetInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        
                        JsonNode networkSecurityGroupValue2 = propertiesValue2.get("networkSecurityGroup");
                        if (networkSecurityGroupValue2 != null && networkSecurityGroupValue2 instanceof NullNode == false) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            subnetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            
                            JsonNode idValue = networkSecurityGroupValue2.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance);
                            }
                        }
                        
                        JsonNode routeTableValue2 = propertiesValue2.get("routeTable");
                        if (routeTableValue2 != null && routeTableValue2 instanceof NullNode == false) {
                            ResourceId routeTableInstance = new ResourceId();
                            subnetInstance.setRouteTable(routeTableInstance);
                            
                            JsonNode idValue2 = routeTableValue2.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                routeTableInstance.setId(idInstance2);
                            }
                        }
                        
                        JsonNode ipConfigurationsArray2 = propertiesValue2.get("ipConfigurations");
                        if (ipConfigurationsArray2 != null && ipConfigurationsArray2 instanceof NullNode == false) {
                            for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray2)) {
                                ResourceId resourceIdInstance = new ResourceId();
                                subnetInstance.getIpConfigurations().add(resourceIdInstance);
                                
                                JsonNode idValue3 = ipConfigurationsValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    resourceIdInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            subnetInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        subnetInstance.setName(nameInstance);
                    }
                    
                    JsonNode etagValue = responseDoc.get("etag");
                    if (etagValue != null && etagValue instanceof NullNode == false) {
                        String etagInstance;
                        etagInstance = etagValue.getTextValue();
                        subnetInstance.setEtag(etagInstance);
                    }
                    
                    JsonNode idValue4 = responseDoc.get("id");
                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                        String idInstance4;
                        idInstance4 = idValue4.getTextValue();
                        subnetInstance.setId(idInstance4);
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete subnet operation deletes the specified subnet.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, virtualNetworkName, subnetName);
            }
         });
    }
    
    /**
    * The delete subnet operation deletes the specified subnet.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkName, String subnetName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put Subnet operation creates/updates a subnet in thespecified virtual
    * network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @param subnetParameters Required. Parameters supplied to the
    * create/update Subnet operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName, final Subnet subnetParameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, virtualNetworkName, subnetName, subnetParameters);
            }
         });
    }
    
    /**
    * The Put Subnet operation creates/updates a subnet in thespecified virtual
    * network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @param subnetParameters Required. Parameters supplied to the
    * create/update Subnet operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkName, String subnetName, Subnet subnetParameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("subnetParameters", subnetParameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            SubnetPutResponse response = client2.getSubnetsOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The delete subnet operation deletes the specified subnet.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, virtualNetworkName, subnetName);
            }
         });
    }
    
    /**
    * The delete subnet operation deletes the specified subnet.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkName, String subnetName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getSubnetsOperations().beginDeletingAsync(resourceGroupName, virtualNetworkName, subnetName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get subnet operation retreives information about the specified subnet.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @return Response for GetSubnet Api service call
    */
    @Override
    public Future<SubnetGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<SubnetGetResponse>() { 
            @Override
            public SubnetGetResponse call() throws Exception {
                return get(resourceGroupName, virtualNetworkName, subnetName);
            }
         });
    }
    
    /**
    * The Get subnet operation retreives information about the specified subnet.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param subnetName Required. The name of the subnet.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetSubnet Api service call
    */
    @Override
    public SubnetGetResponse get(String resourceGroupName, String virtualNetworkName, String subnetName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SubnetGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubnetGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Subnet subnetInstance = new Subnet();
                    result.setSubnet(subnetInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode addressPrefixValue = propertiesValue.get("addressPrefix");
                        if (addressPrefixValue != null && addressPrefixValue instanceof NullNode == false) {
                            String addressPrefixInstance;
                            addressPrefixInstance = addressPrefixValue.getTextValue();
                            subnetInstance.setAddressPrefix(addressPrefixInstance);
                        }
                        
                        JsonNode networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup");
                        if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                            ResourceId networkSecurityGroupInstance = new ResourceId();
                            subnetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                            
                            JsonNode idValue = networkSecurityGroupValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                networkSecurityGroupInstance.setId(idInstance);
                            }
                        }
                        
                        JsonNode routeTableValue = propertiesValue.get("routeTable");
                        if (routeTableValue != null && routeTableValue instanceof NullNode == false) {
                            ResourceId routeTableInstance = new ResourceId();
                            subnetInstance.setRouteTable(routeTableInstance);
                            
                            JsonNode idValue2 = routeTableValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                routeTableInstance.setId(idInstance2);
                            }
                        }
                        
                        JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                        if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                            for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                ResourceId resourceIdInstance = new ResourceId();
                                subnetInstance.getIpConfigurations().add(resourceIdInstance);
                                
                                JsonNode idValue3 = ipConfigurationsValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    resourceIdInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            subnetInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        subnetInstance.setName(nameInstance);
                    }
                    
                    JsonNode etagValue = responseDoc.get("etag");
                    if (etagValue != null && etagValue instanceof NullNode == false) {
                        String etagInstance;
                        etagInstance = etagValue.getTextValue();
                        subnetInstance.setEtag(etagInstance);
                    }
                    
                    JsonNode idValue4 = responseDoc.get("id");
                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                        String idInstance4;
                        idInstance4 = idValue4.getTextValue();
                        subnetInstance.setId(idInstance4);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List subnets opertion retrieves all the subnets in a virtual network.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @return Response for ListSubnets Api service callRetrieves all subnet
    * that belongs to a virtual network
    */
    @Override
    public Future<SubnetListResponse> listAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<SubnetListResponse>() { 
            @Override
            public SubnetListResponse call() throws Exception {
                return list(resourceGroupName, virtualNetworkName);
            }
         });
    }
    
    /**
    * The List subnets opertion retrieves all the subnets in a virtual network.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListSubnets Api service callRetrieves all subnet
    * that belongs to a virtual network
    */
    @Override
    public SubnetListResponse list(String resourceGroupName, String virtualNetworkName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        url = url + "/subnets";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SubnetListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubnetListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            Subnet subnetJsonFormatInstance = new Subnet();
                            result.getSubnets().add(subnetJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode addressPrefixValue = propertiesValue.get("addressPrefix");
                                if (addressPrefixValue != null && addressPrefixValue instanceof NullNode == false) {
                                    String addressPrefixInstance;
                                    addressPrefixInstance = addressPrefixValue.getTextValue();
                                    subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                }
                                
                                JsonNode networkSecurityGroupValue = propertiesValue.get("networkSecurityGroup");
                                if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                                    ResourceId networkSecurityGroupInstance = new ResourceId();
                                    subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                    
                                    JsonNode idValue = networkSecurityGroupValue.get("id");
                                    if (idValue != null && idValue instanceof NullNode == false) {
                                        String idInstance;
                                        idInstance = idValue.getTextValue();
                                        networkSecurityGroupInstance.setId(idInstance);
                                    }
                                }
                                
                                JsonNode routeTableValue = propertiesValue.get("routeTable");
                                if (routeTableValue != null && routeTableValue instanceof NullNode == false) {
                                    ResourceId routeTableInstance = new ResourceId();
                                    subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                    
                                    JsonNode idValue2 = routeTableValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        routeTableInstance.setId(idInstance2);
                                    }
                                }
                                
                                JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                                if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                        ResourceId resourceIdInstance = new ResourceId();
                                        subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                        
                                        JsonNode idValue3 = ipConfigurationsValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            resourceIdInstance.setId(idInstance3);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                subnetJsonFormatInstance.setName(nameInstance);
                            }
                            
                            JsonNode etagValue = valueValue.get("etag");
                            if (etagValue != null && etagValue instanceof NullNode == false) {
                                String etagInstance;
                                etagInstance = etagValue.getTextValue();
                                subnetJsonFormatInstance.setEtag(etagInstance);
                            }
                            
                            JsonNode idValue4 = valueValue.get("id");
                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                String idInstance4;
                                idInstance4 = idValue4.getTextValue();
                                subnetJsonFormatInstance.setId(idInstance4);
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
