/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AddressSpace;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.ConnectionResetSharedKey;
import com.microsoft.azure.management.network.models.ConnectionResetSharedKeyPutResponse;
import com.microsoft.azure.management.network.models.ConnectionSharedKey;
import com.microsoft.azure.management.network.models.ConnectionSharedKeyPutResponse;
import com.microsoft.azure.management.network.models.ConnectionSharedKeyResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.LocalNetworkGateway;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGateway;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnection;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnectionGetResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnectionListResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayConnectionPutResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayIpConfiguration;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* Virtual network Gateway for your subscription.
*/
public class VirtualNetworkGatewayConnectionOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, VirtualNetworkGatewayConnectionOperations {
    /**
    * Initializes a new instance of the
    * VirtualNetworkGatewayConnectionOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    VirtualNetworkGatewayConnectionOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put VirtualNetworkGatewayConnection operation creates/updates a
    * virtual network gateway connection in the specified resource group
    * through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway conenction.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway connection operation through Network
    * resource provider.
    * @return Response for CreateOrUpdateVirtualNetworkGatewayConnection Api
    * servive call
    */
    @Override
    public Future<VirtualNetworkGatewayConnectionPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final VirtualNetworkGatewayConnection parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayConnectionPutResponse>() { 
            @Override
            public VirtualNetworkGatewayConnectionPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
         });
    }
    
    /**
    * The Put VirtualNetworkGatewayConnection operation creates/updates a
    * virtual network gateway connection in the specified resource group
    * through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway conenction.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway connection operation through Network
    * resource provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for CreateOrUpdateVirtualNetworkGatewayConnection Api
    * servive call
    */
    @Override
    public VirtualNetworkGatewayConnectionPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkGatewayConnectionName, VirtualNetworkGatewayConnection parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocalNetworkGateway2() != null) {
            if (parameters.getLocalNetworkGateway2().getLocation() == null) {
                throw new NullPointerException("parameters.LocalNetworkGateway2.Location");
            }
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getVirtualNetworkGateway1() != null) {
            if (parameters.getVirtualNetworkGateway1().getLocation() == null) {
                throw new NullPointerException("parameters.VirtualNetworkGateway1.Location");
            }
        }
        if (parameters.getVirtualNetworkGateway2() != null) {
            if (parameters.getVirtualNetworkGateway2().getLocation() == null) {
                throw new NullPointerException("parameters.VirtualNetworkGateway2.Location");
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode virtualNetworkGatewayConnectionJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = virtualNetworkGatewayConnectionJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) virtualNetworkGatewayConnectionJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getVirtualNetworkGateway1() != null) {
            ObjectNode virtualNetworkGateway1Value = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("virtualNetworkGateway1", virtualNetworkGateway1Value);
            
            if (parameters.getVirtualNetworkGateway1().getIpConfigurations() != null) {
                if (parameters.getVirtualNetworkGateway1().getIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getVirtualNetworkGateway1().getIpConfigurations()).isInitialized()) {
                    ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                    for (VirtualNetworkGatewayIpConfiguration ipConfigurationsItem : parameters.getVirtualNetworkGateway1().getIpConfigurations()) {
                        ObjectNode virtualNetworkGatewayIpConfigurationValue = objectMapper.createObjectNode();
                        ipConfigurationsArray.add(virtualNetworkGatewayIpConfigurationValue);
                        
                        if (ipConfigurationsItem.getPrivateIpAddress() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("privateIPAddress", ipConfigurationsItem.getPrivateIpAddress());
                        }
                        
                        if (ipConfigurationsItem.getPrivateIpAllocationMethod() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("privateIPAllocationMethod", ipConfigurationsItem.getPrivateIpAllocationMethod());
                        }
                        
                        if (ipConfigurationsItem.getSubnet() != null) {
                            ObjectNode subnetValue = objectMapper.createObjectNode();
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("subnet", subnetValue);
                            
                            if (ipConfigurationsItem.getSubnet().getId() != null) {
                                ((ObjectNode) subnetValue).put("id", ipConfigurationsItem.getSubnet().getId());
                            }
                        }
                        
                        if (ipConfigurationsItem.getPublicIpAddress() != null) {
                            ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("publicIPAddress", publicIPAddressValue);
                            
                            if (ipConfigurationsItem.getPublicIpAddress().getId() != null) {
                                ((ObjectNode) publicIPAddressValue).put("id", ipConfigurationsItem.getPublicIpAddress().getId());
                            }
                        }
                        
                        if (ipConfigurationsItem.getProvisioningState() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("provisioningState", ipConfigurationsItem.getProvisioningState());
                        }
                        
                        if (ipConfigurationsItem.getName() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("name", ipConfigurationsItem.getName());
                        }
                        
                        if (ipConfigurationsItem.getEtag() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("etag", ipConfigurationsItem.getEtag());
                        }
                        
                        if (ipConfigurationsItem.getId() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue).put("id", ipConfigurationsItem.getId());
                        }
                    }
                    ((ObjectNode) virtualNetworkGateway1Value).put("ipConfigurations", ipConfigurationsArray);
                }
            }
            
            if (parameters.getVirtualNetworkGateway1().getGatewayType() != null) {
                ((ObjectNode) virtualNetworkGateway1Value).put("gatewayType", parameters.getVirtualNetworkGateway1().getGatewayType());
            }
            
            if (parameters.getVirtualNetworkGateway1().getVpnType() != null) {
                ((ObjectNode) virtualNetworkGateway1Value).put("vpnType", parameters.getVirtualNetworkGateway1().getVpnType());
            }
            
            ((ObjectNode) virtualNetworkGateway1Value).put("enableBgp", parameters.getVirtualNetworkGateway1().isEnableBgp());
            
            if (parameters.getVirtualNetworkGateway1().getProvisioningState() != null) {
                ((ObjectNode) virtualNetworkGateway1Value).put("provisioningState", parameters.getVirtualNetworkGateway1().getProvisioningState());
            }
            
            if (parameters.getVirtualNetworkGateway1().getEtag() != null) {
                ((ObjectNode) virtualNetworkGateway1Value).put("etag", parameters.getVirtualNetworkGateway1().getEtag());
            }
            
            if (parameters.getVirtualNetworkGateway1().getId() != null) {
                ((ObjectNode) virtualNetworkGateway1Value).put("id", parameters.getVirtualNetworkGateway1().getId());
            }
            
            if (parameters.getVirtualNetworkGateway1().getName() != null) {
                ((ObjectNode) virtualNetworkGateway1Value).put("name", parameters.getVirtualNetworkGateway1().getName());
            }
            
            if (parameters.getVirtualNetworkGateway1().getType() != null) {
                ((ObjectNode) virtualNetworkGateway1Value).put("type", parameters.getVirtualNetworkGateway1().getType());
            }
            
            ((ObjectNode) virtualNetworkGateway1Value).put("location", parameters.getVirtualNetworkGateway1().getLocation());
            
            if (parameters.getVirtualNetworkGateway1().getTags() != null) {
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry : parameters.getVirtualNetworkGateway1().getTags().entrySet()) {
                    String tagsKey = entry.getKey();
                    String tagsValue = entry.getValue();
                    ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
                }
                ((ObjectNode) virtualNetworkGateway1Value).put("tags", tagsDictionary);
            }
        }
        
        if (parameters.getVirtualNetworkGateway2() != null) {
            ObjectNode virtualNetworkGateway2Value = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("virtualNetworkGateway2", virtualNetworkGateway2Value);
            
            if (parameters.getVirtualNetworkGateway2().getIpConfigurations() != null) {
                if (parameters.getVirtualNetworkGateway2().getIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getVirtualNetworkGateway2().getIpConfigurations()).isInitialized()) {
                    ArrayNode ipConfigurationsArray2 = objectMapper.createArrayNode();
                    for (VirtualNetworkGatewayIpConfiguration ipConfigurationsItem2 : parameters.getVirtualNetworkGateway2().getIpConfigurations()) {
                        ObjectNode virtualNetworkGatewayIpConfigurationValue2 = objectMapper.createObjectNode();
                        ipConfigurationsArray2.add(virtualNetworkGatewayIpConfigurationValue2);
                        
                        if (ipConfigurationsItem2.getPrivateIpAddress() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("privateIPAddress", ipConfigurationsItem2.getPrivateIpAddress());
                        }
                        
                        if (ipConfigurationsItem2.getPrivateIpAllocationMethod() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("privateIPAllocationMethod", ipConfigurationsItem2.getPrivateIpAllocationMethod());
                        }
                        
                        if (ipConfigurationsItem2.getSubnet() != null) {
                            ObjectNode subnetValue2 = objectMapper.createObjectNode();
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("subnet", subnetValue2);
                            
                            if (ipConfigurationsItem2.getSubnet().getId() != null) {
                                ((ObjectNode) subnetValue2).put("id", ipConfigurationsItem2.getSubnet().getId());
                            }
                        }
                        
                        if (ipConfigurationsItem2.getPublicIpAddress() != null) {
                            ObjectNode publicIPAddressValue2 = objectMapper.createObjectNode();
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("publicIPAddress", publicIPAddressValue2);
                            
                            if (ipConfigurationsItem2.getPublicIpAddress().getId() != null) {
                                ((ObjectNode) publicIPAddressValue2).put("id", ipConfigurationsItem2.getPublicIpAddress().getId());
                            }
                        }
                        
                        if (ipConfigurationsItem2.getProvisioningState() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("provisioningState", ipConfigurationsItem2.getProvisioningState());
                        }
                        
                        if (ipConfigurationsItem2.getName() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("name", ipConfigurationsItem2.getName());
                        }
                        
                        if (ipConfigurationsItem2.getEtag() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("etag", ipConfigurationsItem2.getEtag());
                        }
                        
                        if (ipConfigurationsItem2.getId() != null) {
                            ((ObjectNode) virtualNetworkGatewayIpConfigurationValue2).put("id", ipConfigurationsItem2.getId());
                        }
                    }
                    ((ObjectNode) virtualNetworkGateway2Value).put("ipConfigurations", ipConfigurationsArray2);
                }
            }
            
            if (parameters.getVirtualNetworkGateway2().getGatewayType() != null) {
                ((ObjectNode) virtualNetworkGateway2Value).put("gatewayType", parameters.getVirtualNetworkGateway2().getGatewayType());
            }
            
            if (parameters.getVirtualNetworkGateway2().getVpnType() != null) {
                ((ObjectNode) virtualNetworkGateway2Value).put("vpnType", parameters.getVirtualNetworkGateway2().getVpnType());
            }
            
            ((ObjectNode) virtualNetworkGateway2Value).put("enableBgp", parameters.getVirtualNetworkGateway2().isEnableBgp());
            
            if (parameters.getVirtualNetworkGateway2().getProvisioningState() != null) {
                ((ObjectNode) virtualNetworkGateway2Value).put("provisioningState", parameters.getVirtualNetworkGateway2().getProvisioningState());
            }
            
            if (parameters.getVirtualNetworkGateway2().getEtag() != null) {
                ((ObjectNode) virtualNetworkGateway2Value).put("etag", parameters.getVirtualNetworkGateway2().getEtag());
            }
            
            if (parameters.getVirtualNetworkGateway2().getId() != null) {
                ((ObjectNode) virtualNetworkGateway2Value).put("id", parameters.getVirtualNetworkGateway2().getId());
            }
            
            if (parameters.getVirtualNetworkGateway2().getName() != null) {
                ((ObjectNode) virtualNetworkGateway2Value).put("name", parameters.getVirtualNetworkGateway2().getName());
            }
            
            if (parameters.getVirtualNetworkGateway2().getType() != null) {
                ((ObjectNode) virtualNetworkGateway2Value).put("type", parameters.getVirtualNetworkGateway2().getType());
            }
            
            ((ObjectNode) virtualNetworkGateway2Value).put("location", parameters.getVirtualNetworkGateway2().getLocation());
            
            if (parameters.getVirtualNetworkGateway2().getTags() != null) {
                ObjectNode tagsDictionary2 = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry2 : parameters.getVirtualNetworkGateway2().getTags().entrySet()) {
                    String tagsKey2 = entry2.getKey();
                    String tagsValue2 = entry2.getValue();
                    ((ObjectNode) tagsDictionary2).put(tagsKey2, tagsValue2);
                }
                ((ObjectNode) virtualNetworkGateway2Value).put("tags", tagsDictionary2);
            }
        }
        
        if (parameters.getLocalNetworkGateway2() != null) {
            ObjectNode localNetworkGateway2Value = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("localNetworkGateway2", localNetworkGateway2Value);
            
            if (parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace() != null) {
                ObjectNode localNetworkAddressSpaceValue = objectMapper.createObjectNode();
                ((ObjectNode) localNetworkGateway2Value).put("localNetworkAddressSpace", localNetworkAddressSpaceValue);
                
                if (parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes() != null) {
                    if (parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes() instanceof LazyCollection == false || ((LazyCollection) parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes()).isInitialized()) {
                        ArrayNode addressPrefixesArray = objectMapper.createArrayNode();
                        for (String addressPrefixesItem : parameters.getLocalNetworkGateway2().getLocalNetworkAddressSpace().getAddressPrefixes()) {
                            addressPrefixesArray.add(addressPrefixesItem);
                        }
                        ((ObjectNode) localNetworkAddressSpaceValue).put("addressPrefixes", addressPrefixesArray);
                    }
                }
            }
            
            if (parameters.getLocalNetworkGateway2().getGatewayIpAddress() != null) {
                ((ObjectNode) localNetworkGateway2Value).put("gatewayIpAddress", parameters.getLocalNetworkGateway2().getGatewayIpAddress());
            }
            
            if (parameters.getLocalNetworkGateway2().getProvisioningState() != null) {
                ((ObjectNode) localNetworkGateway2Value).put("provisioningState", parameters.getLocalNetworkGateway2().getProvisioningState());
            }
            
            if (parameters.getLocalNetworkGateway2().getEtag() != null) {
                ((ObjectNode) localNetworkGateway2Value).put("etag", parameters.getLocalNetworkGateway2().getEtag());
            }
            
            if (parameters.getLocalNetworkGateway2().getId() != null) {
                ((ObjectNode) localNetworkGateway2Value).put("id", parameters.getLocalNetworkGateway2().getId());
            }
            
            if (parameters.getLocalNetworkGateway2().getName() != null) {
                ((ObjectNode) localNetworkGateway2Value).put("name", parameters.getLocalNetworkGateway2().getName());
            }
            
            if (parameters.getLocalNetworkGateway2().getType() != null) {
                ((ObjectNode) localNetworkGateway2Value).put("type", parameters.getLocalNetworkGateway2().getType());
            }
            
            ((ObjectNode) localNetworkGateway2Value).put("location", parameters.getLocalNetworkGateway2().getLocation());
            
            if (parameters.getLocalNetworkGateway2().getTags() != null) {
                ObjectNode tagsDictionary3 = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry3 : parameters.getLocalNetworkGateway2().getTags().entrySet()) {
                    String tagsKey3 = entry3.getKey();
                    String tagsValue3 = entry3.getValue();
                    ((ObjectNode) tagsDictionary3).put(tagsKey3, tagsValue3);
                }
                ((ObjectNode) localNetworkGateway2Value).put("tags", tagsDictionary3);
            }
        }
        
        if (parameters.getConnectionType() != null) {
            ((ObjectNode) propertiesValue).put("connectionType", parameters.getConnectionType());
        }
        
        ((ObjectNode) propertiesValue).put("routingWeight", parameters.getRoutingWeight());
        
        if (parameters.getSharedKey() != null) {
            ((ObjectNode) propertiesValue).put("sharedKey", parameters.getSharedKey());
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) virtualNetworkGatewayConnectionJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) virtualNetworkGatewayConnectionJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) virtualNetworkGatewayConnectionJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) virtualNetworkGatewayConnectionJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) virtualNetworkGatewayConnectionJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary4 = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry4 : parameters.getTags().entrySet()) {
                String tagsKey4 = entry4.getKey();
                String tagsValue4 = entry4.getValue();
                ((ObjectNode) tagsDictionary4).put(tagsKey4, tagsValue4);
            }
            ((ObjectNode) virtualNetworkGatewayConnectionJsonFormatValue).put("tags", tagsDictionary4);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayConnectionPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayConnectionPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualNetworkGatewayConnection virtualNetworkGatewayConnectionInstance = new VirtualNetworkGatewayConnection();
                    result.setVirtualNetworkGatewayConnection(virtualNetworkGatewayConnectionInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode virtualNetworkGateway1Value2 = propertiesValue2.get("virtualNetworkGateway1");
                        if (virtualNetworkGateway1Value2 != null && virtualNetworkGateway1Value2 instanceof NullNode == false) {
                            VirtualNetworkGateway virtualNetworkGateway1Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway1(virtualNetworkGateway1Instance);
                            
                            JsonNode ipConfigurationsArray3 = virtualNetworkGateway1Value2.get("ipConfigurations");
                            if (ipConfigurationsArray3 != null && ipConfigurationsArray3 instanceof NullNode == false) {
                                for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray3)) {
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway1Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance);
                                    
                                    JsonNode privateIPAddressValue = ipConfigurationsValue.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = ipConfigurationsValue.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue3 = ipConfigurationsValue.get("subnet");
                                    if (subnetValue3 != null && subnetValue3 instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue3.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue3 = ipConfigurationsValue.get("publicIPAddress");
                                    if (publicIPAddressValue3 != null && publicIPAddressValue3 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue2 = publicIPAddressValue3.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = ipConfigurationsValue.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                    
                                    JsonNode nameValue = ipConfigurationsValue.get("name");
                                    if (nameValue != null && nameValue instanceof NullNode == false) {
                                        String nameInstance;
                                        nameInstance = nameValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setName(nameInstance);
                                    }
                                    
                                    JsonNode etagValue = ipConfigurationsValue.get("etag");
                                    if (etagValue != null && etagValue instanceof NullNode == false) {
                                        String etagInstance;
                                        etagInstance = etagValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setEtag(etagInstance);
                                    }
                                    
                                    JsonNode idValue3 = ipConfigurationsValue.get("id");
                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                        String idInstance3;
                                        idInstance3 = idValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setId(idInstance3);
                                    }
                                }
                            }
                            
                            JsonNode gatewayTypeValue = virtualNetworkGateway1Value2.get("gatewayType");
                            if (gatewayTypeValue != null && gatewayTypeValue instanceof NullNode == false) {
                                String gatewayTypeInstance;
                                gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setGatewayType(gatewayTypeInstance);
                            }
                            
                            JsonNode vpnTypeValue = virtualNetworkGateway1Value2.get("vpnType");
                            if (vpnTypeValue != null && vpnTypeValue instanceof NullNode == false) {
                                String vpnTypeInstance;
                                vpnTypeInstance = vpnTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setVpnType(vpnTypeInstance);
                            }
                            
                            JsonNode enableBgpValue = virtualNetworkGateway1Value2.get("enableBgp");
                            if (enableBgpValue != null && enableBgpValue instanceof NullNode == false) {
                                boolean enableBgpInstance;
                                enableBgpInstance = enableBgpValue.getBooleanValue();
                                virtualNetworkGateway1Instance.setEnableBgp(enableBgpInstance);
                            }
                            
                            JsonNode provisioningStateValue2 = virtualNetworkGateway1Value2.get("provisioningState");
                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                String provisioningStateInstance2;
                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                virtualNetworkGateway1Instance.setProvisioningState(provisioningStateInstance2);
                            }
                            
                            JsonNode etagValue2 = virtualNetworkGateway1Value2.get("etag");
                            if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                String etagInstance2;
                                etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkGateway1Instance.setEtag(etagInstance2);
                            }
                            
                            JsonNode idValue4 = virtualNetworkGateway1Value2.get("id");
                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                String idInstance4;
                                idInstance4 = idValue4.getTextValue();
                                virtualNetworkGateway1Instance.setId(idInstance4);
                            }
                            
                            JsonNode nameValue2 = virtualNetworkGateway1Value2.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkGateway1Instance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = virtualNetworkGateway1Value2.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                virtualNetworkGateway1Instance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = virtualNetworkGateway1Value2.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualNetworkGateway1Instance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) virtualNetworkGateway1Value2.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey5 = property.getKey();
                                    String tagsValue5 = property.getValue().getTextValue();
                                    virtualNetworkGateway1Instance.getTags().put(tagsKey5, tagsValue5);
                                }
                            }
                        }
                        
                        JsonNode virtualNetworkGateway2Value2 = propertiesValue2.get("virtualNetworkGateway2");
                        if (virtualNetworkGateway2Value2 != null && virtualNetworkGateway2Value2 instanceof NullNode == false) {
                            VirtualNetworkGateway virtualNetworkGateway2Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway2(virtualNetworkGateway2Instance);
                            
                            JsonNode ipConfigurationsArray4 = virtualNetworkGateway2Value2.get("ipConfigurations");
                            if (ipConfigurationsArray4 != null && ipConfigurationsArray4 instanceof NullNode == false) {
                                for (JsonNode ipConfigurationsValue2 : ((ArrayNode) ipConfigurationsArray4)) {
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance2 = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway2Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance2);
                                    
                                    JsonNode privateIPAddressValue2 = ipConfigurationsValue2.get("privateIPAddress");
                                    if (privateIPAddressValue2 != null && privateIPAddressValue2 instanceof NullNode == false) {
                                        String privateIPAddressInstance2;
                                        privateIPAddressInstance2 = privateIPAddressValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAddress(privateIPAddressInstance2);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue2 = ipConfigurationsValue2.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue2 != null && privateIPAllocationMethodValue2 instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance2;
                                        privateIPAllocationMethodInstance2 = privateIPAllocationMethodValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance2);
                                    }
                                    
                                    JsonNode subnetValue4 = ipConfigurationsValue2.get("subnet");
                                    if (subnetValue4 != null && subnetValue4 instanceof NullNode == false) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setSubnet(subnetInstance2);
                                        
                                        JsonNode idValue5 = subnetValue4.get("id");
                                        if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                            String idInstance5;
                                            idInstance5 = idValue5.getTextValue();
                                            subnetInstance2.setId(idInstance5);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue4 = ipConfigurationsValue2.get("publicIPAddress");
                                    if (publicIPAddressValue4 != null && publicIPAddressValue4 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPublicIpAddress(publicIPAddressInstance2);
                                        
                                        JsonNode idValue6 = publicIPAddressValue4.get("id");
                                        if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                            String idInstance6;
                                            idInstance6 = idValue6.getTextValue();
                                            publicIPAddressInstance2.setId(idInstance6);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue3 = ipConfigurationsValue2.get("provisioningState");
                                    if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                        String provisioningStateInstance3;
                                        provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setProvisioningState(provisioningStateInstance3);
                                    }
                                    
                                    JsonNode nameValue3 = ipConfigurationsValue2.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setName(nameInstance3);
                                    }
                                    
                                    JsonNode etagValue3 = ipConfigurationsValue2.get("etag");
                                    if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                        String etagInstance3;
                                        etagInstance3 = etagValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setEtag(etagInstance3);
                                    }
                                    
                                    JsonNode idValue7 = ipConfigurationsValue2.get("id");
                                    if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                        String idInstance7;
                                        idInstance7 = idValue7.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setId(idInstance7);
                                    }
                                }
                            }
                            
                            JsonNode gatewayTypeValue2 = virtualNetworkGateway2Value2.get("gatewayType");
                            if (gatewayTypeValue2 != null && gatewayTypeValue2 instanceof NullNode == false) {
                                String gatewayTypeInstance2;
                                gatewayTypeInstance2 = gatewayTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setGatewayType(gatewayTypeInstance2);
                            }
                            
                            JsonNode vpnTypeValue2 = virtualNetworkGateway2Value2.get("vpnType");
                            if (vpnTypeValue2 != null && vpnTypeValue2 instanceof NullNode == false) {
                                String vpnTypeInstance2;
                                vpnTypeInstance2 = vpnTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setVpnType(vpnTypeInstance2);
                            }
                            
                            JsonNode enableBgpValue2 = virtualNetworkGateway2Value2.get("enableBgp");
                            if (enableBgpValue2 != null && enableBgpValue2 instanceof NullNode == false) {
                                boolean enableBgpInstance2;
                                enableBgpInstance2 = enableBgpValue2.getBooleanValue();
                                virtualNetworkGateway2Instance.setEnableBgp(enableBgpInstance2);
                            }
                            
                            JsonNode provisioningStateValue4 = virtualNetworkGateway2Value2.get("provisioningState");
                            if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                String provisioningStateInstance4;
                                provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                virtualNetworkGateway2Instance.setProvisioningState(provisioningStateInstance4);
                            }
                            
                            JsonNode etagValue4 = virtualNetworkGateway2Value2.get("etag");
                            if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                String etagInstance4;
                                etagInstance4 = etagValue4.getTextValue();
                                virtualNetworkGateway2Instance.setEtag(etagInstance4);
                            }
                            
                            JsonNode idValue8 = virtualNetworkGateway2Value2.get("id");
                            if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                String idInstance8;
                                idInstance8 = idValue8.getTextValue();
                                virtualNetworkGateway2Instance.setId(idInstance8);
                            }
                            
                            JsonNode nameValue4 = virtualNetworkGateway2Value2.get("name");
                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                String nameInstance4;
                                nameInstance4 = nameValue4.getTextValue();
                                virtualNetworkGateway2Instance.setName(nameInstance4);
                            }
                            
                            JsonNode typeValue2 = virtualNetworkGateway2Value2.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                String typeInstance2;
                                typeInstance2 = typeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setType(typeInstance2);
                            }
                            
                            JsonNode locationValue2 = virtualNetworkGateway2Value2.get("location");
                            if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                String locationInstance2;
                                locationInstance2 = locationValue2.getTextValue();
                                virtualNetworkGateway2Instance.setLocation(locationInstance2);
                            }
                            
                            JsonNode tagsSequenceElement2 = ((JsonNode) virtualNetworkGateway2Value2.get("tags"));
                            if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String tagsKey6 = property2.getKey();
                                    String tagsValue6 = property2.getValue().getTextValue();
                                    virtualNetworkGateway2Instance.getTags().put(tagsKey6, tagsValue6);
                                }
                            }
                        }
                        
                        JsonNode localNetworkGateway2Value2 = propertiesValue2.get("localNetworkGateway2");
                        if (localNetworkGateway2Value2 != null && localNetworkGateway2Value2 instanceof NullNode == false) {
                            LocalNetworkGateway localNetworkGateway2Instance = new LocalNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setLocalNetworkGateway2(localNetworkGateway2Instance);
                            
                            JsonNode localNetworkAddressSpaceValue2 = localNetworkGateway2Value2.get("localNetworkAddressSpace");
                            if (localNetworkAddressSpaceValue2 != null && localNetworkAddressSpaceValue2 instanceof NullNode == false) {
                                AddressSpace localNetworkAddressSpaceInstance = new AddressSpace();
                                localNetworkGateway2Instance.setLocalNetworkAddressSpace(localNetworkAddressSpaceInstance);
                                
                                JsonNode addressPrefixesArray2 = localNetworkAddressSpaceValue2.get("addressPrefixes");
                                if (addressPrefixesArray2 != null && addressPrefixesArray2 instanceof NullNode == false) {
                                    for (JsonNode addressPrefixesValue : ((ArrayNode) addressPrefixesArray2)) {
                                        localNetworkAddressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                    }
                                }
                            }
                            
                            JsonNode gatewayIpAddressValue = localNetworkGateway2Value2.get("gatewayIpAddress");
                            if (gatewayIpAddressValue != null && gatewayIpAddressValue instanceof NullNode == false) {
                                String gatewayIpAddressInstance;
                                gatewayIpAddressInstance = gatewayIpAddressValue.getTextValue();
                                localNetworkGateway2Instance.setGatewayIpAddress(gatewayIpAddressInstance);
                            }
                            
                            JsonNode provisioningStateValue5 = localNetworkGateway2Value2.get("provisioningState");
                            if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                String provisioningStateInstance5;
                                provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                localNetworkGateway2Instance.setProvisioningState(provisioningStateInstance5);
                            }
                            
                            JsonNode etagValue5 = localNetworkGateway2Value2.get("etag");
                            if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                String etagInstance5;
                                etagInstance5 = etagValue5.getTextValue();
                                localNetworkGateway2Instance.setEtag(etagInstance5);
                            }
                            
                            JsonNode idValue9 = localNetworkGateway2Value2.get("id");
                            if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                String idInstance9;
                                idInstance9 = idValue9.getTextValue();
                                localNetworkGateway2Instance.setId(idInstance9);
                            }
                            
                            JsonNode nameValue5 = localNetworkGateway2Value2.get("name");
                            if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                String nameInstance5;
                                nameInstance5 = nameValue5.getTextValue();
                                localNetworkGateway2Instance.setName(nameInstance5);
                            }
                            
                            JsonNode typeValue3 = localNetworkGateway2Value2.get("type");
                            if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                String typeInstance3;
                                typeInstance3 = typeValue3.getTextValue();
                                localNetworkGateway2Instance.setType(typeInstance3);
                            }
                            
                            JsonNode locationValue3 = localNetworkGateway2Value2.get("location");
                            if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                String locationInstance3;
                                locationInstance3 = locationValue3.getTextValue();
                                localNetworkGateway2Instance.setLocation(locationInstance3);
                            }
                            
                            JsonNode tagsSequenceElement3 = ((JsonNode) localNetworkGateway2Value2.get("tags"));
                            if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                while (itr3.hasNext()) {
                                    Map.Entry<String, JsonNode> property3 = itr3.next();
                                    String tagsKey7 = property3.getKey();
                                    String tagsValue7 = property3.getValue().getTextValue();
                                    localNetworkGateway2Instance.getTags().put(tagsKey7, tagsValue7);
                                }
                            }
                        }
                        
                        JsonNode connectionTypeValue = propertiesValue2.get("connectionType");
                        if (connectionTypeValue != null && connectionTypeValue instanceof NullNode == false) {
                            String connectionTypeInstance;
                            connectionTypeInstance = connectionTypeValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setConnectionType(connectionTypeInstance);
                        }
                        
                        JsonNode routingWeightValue = propertiesValue2.get("routingWeight");
                        if (routingWeightValue != null && routingWeightValue instanceof NullNode == false) {
                            int routingWeightInstance;
                            routingWeightInstance = routingWeightValue.getIntValue();
                            virtualNetworkGatewayConnectionInstance.setRoutingWeight(routingWeightInstance);
                        }
                        
                        JsonNode sharedKeyValue = propertiesValue2.get("sharedKey");
                        if (sharedKeyValue != null && sharedKeyValue instanceof NullNode == false) {
                            String sharedKeyInstance;
                            sharedKeyInstance = sharedKeyValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setSharedKey(sharedKeyInstance);
                        }
                        
                        JsonNode provisioningStateValue6 = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                            String provisioningStateInstance6;
                            provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    
                    JsonNode etagValue6 = responseDoc.get("etag");
                    if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                        String etagInstance6;
                        etagInstance6 = etagValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setEtag(etagInstance6);
                    }
                    
                    JsonNode idValue10 = responseDoc.get("id");
                    if (idValue10 != null && idValue10 instanceof NullNode == false) {
                        String idInstance10;
                        idInstance10 = idValue10.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setId(idInstance10);
                    }
                    
                    JsonNode nameValue6 = responseDoc.get("name");
                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                        String nameInstance6;
                        nameInstance6 = nameValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setName(nameInstance6);
                    }
                    
                    JsonNode typeValue4 = responseDoc.get("type");
                    if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                        String typeInstance4;
                        typeInstance4 = typeValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setType(typeInstance4);
                    }
                    
                    JsonNode locationValue4 = responseDoc.get("location");
                    if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                        String locationInstance4;
                        locationInstance4 = locationValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setLocation(locationInstance4);
                    }
                    
                    JsonNode tagsSequenceElement4 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                        while (itr4.hasNext()) {
                            Map.Entry<String, JsonNode> property4 = itr4.next();
                            String tagsKey8 = property4.getKey();
                            String tagsValue8 = property4.getValue().getTextValue();
                            virtualNetworkGatewayConnectionInstance.getTags().put(tagsKey8, tagsValue8);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Delete VirtualNetworkGatewayConnection operation deletes the specifed
    * virtual network Gateway connection through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway connection.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, virtualNetworkGatewayConnectionName);
            }
         });
    }
    
    /**
    * The Delete VirtualNetworkGatewayConnection operation deletes the specifed
    * virtual network Gateway connection through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway connection.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkGatewayConnectionName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The VirtualNetworkGatewayConnectionResetSharedKey operation resets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection reset shared key Name.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway connection shared key operation through Network
    * resource provider.
    * @return Response for PutVirtualNetworkGatewayConnectionResetSharedKey Api
    * servive call
    */
    @Override
    public Future<ConnectionResetSharedKeyPutResponse> beginResetSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionResetSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ConnectionResetSharedKeyPutResponse>() { 
            @Override
            public ConnectionResetSharedKeyPutResponse call() throws Exception {
                return beginResetSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
         });
    }
    
    /**
    * The VirtualNetworkGatewayConnectionResetSharedKey operation resets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection reset shared key Name.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway connection shared key operation through Network
    * resource provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGatewayConnectionResetSharedKey Api
    * servive call
    */
    @Override
    public ConnectionResetSharedKeyPutResponse beginResetSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionResetSharedKey parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginResetSharedKeyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        url = url + "/sharedkey/reset";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode connectionResetSharedKeyJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = connectionResetSharedKeyJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) connectionResetSharedKeyJsonFormatValue).put("properties", propertiesValue);
        
        ((ObjectNode) propertiesValue).put("keyLength", parameters.getKeyLength());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ConnectionResetSharedKeyPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_ACCEPTED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ConnectionResetSharedKeyPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ConnectionResetSharedKey connectionResetSharedKeyInstance = new ConnectionResetSharedKey();
                    result.setConnectionResetSharedKey(connectionResetSharedKeyInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode keyLengthValue = propertiesValue2.get("keyLength");
                        if (keyLengthValue != null && keyLengthValue instanceof NullNode == false) {
                            long keyLengthInstance;
                            keyLengthInstance = keyLengthValue.getLongValue();
                            connectionResetSharedKeyInstance.setKeyLength(keyLengthInstance);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put VirtualNetworkGatewayConnectionSharedKey operation sets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection name.
    * @param parameters Required. Parameters supplied to the Begin Set Virtual
    * Network Gateway conection Shared key operation throughNetwork resource
    * provider.
    * @return Response for PutVirtualNetworkGatewayConnectionSharedKey Api
    * servive call
    */
    @Override
    public Future<ConnectionSharedKeyPutResponse> beginSetSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ConnectionSharedKeyPutResponse>() { 
            @Override
            public ConnectionSharedKeyPutResponse call() throws Exception {
                return beginSetSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
         });
    }
    
    /**
    * The Put VirtualNetworkGatewayConnectionSharedKey operation sets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection name.
    * @param parameters Required. Parameters supplied to the Begin Set Virtual
    * Network Gateway conection Shared key operation throughNetwork resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGatewayConnectionSharedKey Api
    * servive call
    */
    @Override
    public ConnectionSharedKeyPutResponse beginSetSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionSharedKey parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginSetSharedKeyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        url = url + "/sharedkey";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode connectionSharedKeyJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = connectionSharedKeyJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) connectionSharedKeyJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getValue() != null) {
            ((ObjectNode) propertiesValue).put("value", parameters.getValue());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ConnectionSharedKeyPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ConnectionSharedKeyPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    ConnectionSharedKey connectionSharedKeyInstance = new ConnectionSharedKey();
                    result.setConnectionSharedKey(connectionSharedKeyInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode valueValue = propertiesValue2.get("value");
                        if (valueValue != null && valueValue instanceof NullNode == false) {
                            String valueInstance;
                            valueInstance = valueValue.getTextValue();
                            connectionSharedKeyInstance.setValue(valueInstance);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The CreateOrUpdate Virtual network Gateway connection creates a new or
    * updates an existing virtualnetwork gateway connection through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway conenction.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway connection operation through Network
    * resource provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final VirtualNetworkGatewayConnection parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
         });
    }
    
    /**
    * The CreateOrUpdate Virtual network Gateway connection creates a new or
    * updates an existing virtualnetwork gateway connection through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway conenction.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway connection operation through Network
    * resource provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkGatewayConnectionName, VirtualNetworkGatewayConnection parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualNetworkGatewayConnectionPutResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete VirtualNetworkGatewayConnection operation deletes the specifed
    * virtual network Gateway connection through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway connection.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, virtualNetworkGatewayConnectionName);
            }
         });
    }
    
    /**
    * The Delete VirtualNetworkGatewayConnection operation deletes the specifed
    * virtual network Gateway connection through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway connection.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkGatewayConnectionName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginDeletingAsync(resourceGroupName, virtualNetworkGatewayConnectionName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get VirtualNetworkGatewayConnection operation retrieves information
    * about the specified virtual network gateway connection through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway connection.
    * @return Response for GetVitualNetworkGatewayConnection Api servive call.
    */
    @Override
    public Future<VirtualNetworkGatewayConnectionGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayConnectionGetResponse>() { 
            @Override
            public VirtualNetworkGatewayConnectionGetResponse call() throws Exception {
                return get(resourceGroupName, virtualNetworkGatewayConnectionName);
            }
         });
    }
    
    /**
    * The Get VirtualNetworkGatewayConnection operation retrieves information
    * about the specified virtual network gateway connection through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The name of the
    * virtual network gateway connection.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetVitualNetworkGatewayConnection Api servive call.
    */
    @Override
    public VirtualNetworkGatewayConnectionGetResponse get(String resourceGroupName, String virtualNetworkGatewayConnectionName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new NullPointerException("virtualNetworkGatewayConnectionName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(virtualNetworkGatewayConnectionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayConnectionGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayConnectionGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualNetworkGatewayConnection virtualNetworkGatewayConnectionInstance = new VirtualNetworkGatewayConnection();
                    result.setVirtualNetworkGatewayConnection(virtualNetworkGatewayConnectionInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode virtualNetworkGateway1Value = propertiesValue.get("virtualNetworkGateway1");
                        if (virtualNetworkGateway1Value != null && virtualNetworkGateway1Value instanceof NullNode == false) {
                            VirtualNetworkGateway virtualNetworkGateway1Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway1(virtualNetworkGateway1Instance);
                            
                            JsonNode ipConfigurationsArray = virtualNetworkGateway1Value.get("ipConfigurations");
                            if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway1Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance);
                                    
                                    JsonNode privateIPAddressValue = ipConfigurationsValue.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = ipConfigurationsValue.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue = ipConfigurationsValue.get("subnet");
                                    if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue = ipConfigurationsValue.get("publicIPAddress");
                                    if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue2 = publicIPAddressValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = ipConfigurationsValue.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                    
                                    JsonNode nameValue = ipConfigurationsValue.get("name");
                                    if (nameValue != null && nameValue instanceof NullNode == false) {
                                        String nameInstance;
                                        nameInstance = nameValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setName(nameInstance);
                                    }
                                    
                                    JsonNode etagValue = ipConfigurationsValue.get("etag");
                                    if (etagValue != null && etagValue instanceof NullNode == false) {
                                        String etagInstance;
                                        etagInstance = etagValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setEtag(etagInstance);
                                    }
                                    
                                    JsonNode idValue3 = ipConfigurationsValue.get("id");
                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                        String idInstance3;
                                        idInstance3 = idValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance.setId(idInstance3);
                                    }
                                }
                            }
                            
                            JsonNode gatewayTypeValue = virtualNetworkGateway1Value.get("gatewayType");
                            if (gatewayTypeValue != null && gatewayTypeValue instanceof NullNode == false) {
                                String gatewayTypeInstance;
                                gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setGatewayType(gatewayTypeInstance);
                            }
                            
                            JsonNode vpnTypeValue = virtualNetworkGateway1Value.get("vpnType");
                            if (vpnTypeValue != null && vpnTypeValue instanceof NullNode == false) {
                                String vpnTypeInstance;
                                vpnTypeInstance = vpnTypeValue.getTextValue();
                                virtualNetworkGateway1Instance.setVpnType(vpnTypeInstance);
                            }
                            
                            JsonNode enableBgpValue = virtualNetworkGateway1Value.get("enableBgp");
                            if (enableBgpValue != null && enableBgpValue instanceof NullNode == false) {
                                boolean enableBgpInstance;
                                enableBgpInstance = enableBgpValue.getBooleanValue();
                                virtualNetworkGateway1Instance.setEnableBgp(enableBgpInstance);
                            }
                            
                            JsonNode provisioningStateValue2 = virtualNetworkGateway1Value.get("provisioningState");
                            if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                String provisioningStateInstance2;
                                provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                virtualNetworkGateway1Instance.setProvisioningState(provisioningStateInstance2);
                            }
                            
                            JsonNode etagValue2 = virtualNetworkGateway1Value.get("etag");
                            if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                String etagInstance2;
                                etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkGateway1Instance.setEtag(etagInstance2);
                            }
                            
                            JsonNode idValue4 = virtualNetworkGateway1Value.get("id");
                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                String idInstance4;
                                idInstance4 = idValue4.getTextValue();
                                virtualNetworkGateway1Instance.setId(idInstance4);
                            }
                            
                            JsonNode nameValue2 = virtualNetworkGateway1Value.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkGateway1Instance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = virtualNetworkGateway1Value.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                virtualNetworkGateway1Instance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = virtualNetworkGateway1Value.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualNetworkGateway1Instance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) virtualNetworkGateway1Value.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    virtualNetworkGateway1Instance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                        
                        JsonNode virtualNetworkGateway2Value = propertiesValue.get("virtualNetworkGateway2");
                        if (virtualNetworkGateway2Value != null && virtualNetworkGateway2Value instanceof NullNode == false) {
                            VirtualNetworkGateway virtualNetworkGateway2Instance = new VirtualNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setVirtualNetworkGateway2(virtualNetworkGateway2Instance);
                            
                            JsonNode ipConfigurationsArray2 = virtualNetworkGateway2Value.get("ipConfigurations");
                            if (ipConfigurationsArray2 != null && ipConfigurationsArray2 instanceof NullNode == false) {
                                for (JsonNode ipConfigurationsValue2 : ((ArrayNode) ipConfigurationsArray2)) {
                                    VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance2 = new VirtualNetworkGatewayIpConfiguration();
                                    virtualNetworkGateway2Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance2);
                                    
                                    JsonNode privateIPAddressValue2 = ipConfigurationsValue2.get("privateIPAddress");
                                    if (privateIPAddressValue2 != null && privateIPAddressValue2 instanceof NullNode == false) {
                                        String privateIPAddressInstance2;
                                        privateIPAddressInstance2 = privateIPAddressValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAddress(privateIPAddressInstance2);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue2 = ipConfigurationsValue2.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue2 != null && privateIPAllocationMethodValue2 instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance2;
                                        privateIPAllocationMethodInstance2 = privateIPAllocationMethodValue2.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance2);
                                    }
                                    
                                    JsonNode subnetValue2 = ipConfigurationsValue2.get("subnet");
                                    if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                        ResourceId subnetInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setSubnet(subnetInstance2);
                                        
                                        JsonNode idValue5 = subnetValue2.get("id");
                                        if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                            String idInstance5;
                                            idInstance5 = idValue5.getTextValue();
                                            subnetInstance2.setId(idInstance5);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue2 = ipConfigurationsValue2.get("publicIPAddress");
                                    if (publicIPAddressValue2 != null && publicIPAddressValue2 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance2 = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationInstance2.setPublicIpAddress(publicIPAddressInstance2);
                                        
                                        JsonNode idValue6 = publicIPAddressValue2.get("id");
                                        if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                            String idInstance6;
                                            idInstance6 = idValue6.getTextValue();
                                            publicIPAddressInstance2.setId(idInstance6);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue3 = ipConfigurationsValue2.get("provisioningState");
                                    if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                        String provisioningStateInstance3;
                                        provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setProvisioningState(provisioningStateInstance3);
                                    }
                                    
                                    JsonNode nameValue3 = ipConfigurationsValue2.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setName(nameInstance3);
                                    }
                                    
                                    JsonNode etagValue3 = ipConfigurationsValue2.get("etag");
                                    if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                        String etagInstance3;
                                        etagInstance3 = etagValue3.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setEtag(etagInstance3);
                                    }
                                    
                                    JsonNode idValue7 = ipConfigurationsValue2.get("id");
                                    if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                        String idInstance7;
                                        idInstance7 = idValue7.getTextValue();
                                        virtualNetworkGatewayIpConfigurationInstance2.setId(idInstance7);
                                    }
                                }
                            }
                            
                            JsonNode gatewayTypeValue2 = virtualNetworkGateway2Value.get("gatewayType");
                            if (gatewayTypeValue2 != null && gatewayTypeValue2 instanceof NullNode == false) {
                                String gatewayTypeInstance2;
                                gatewayTypeInstance2 = gatewayTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setGatewayType(gatewayTypeInstance2);
                            }
                            
                            JsonNode vpnTypeValue2 = virtualNetworkGateway2Value.get("vpnType");
                            if (vpnTypeValue2 != null && vpnTypeValue2 instanceof NullNode == false) {
                                String vpnTypeInstance2;
                                vpnTypeInstance2 = vpnTypeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setVpnType(vpnTypeInstance2);
                            }
                            
                            JsonNode enableBgpValue2 = virtualNetworkGateway2Value.get("enableBgp");
                            if (enableBgpValue2 != null && enableBgpValue2 instanceof NullNode == false) {
                                boolean enableBgpInstance2;
                                enableBgpInstance2 = enableBgpValue2.getBooleanValue();
                                virtualNetworkGateway2Instance.setEnableBgp(enableBgpInstance2);
                            }
                            
                            JsonNode provisioningStateValue4 = virtualNetworkGateway2Value.get("provisioningState");
                            if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                String provisioningStateInstance4;
                                provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                virtualNetworkGateway2Instance.setProvisioningState(provisioningStateInstance4);
                            }
                            
                            JsonNode etagValue4 = virtualNetworkGateway2Value.get("etag");
                            if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                String etagInstance4;
                                etagInstance4 = etagValue4.getTextValue();
                                virtualNetworkGateway2Instance.setEtag(etagInstance4);
                            }
                            
                            JsonNode idValue8 = virtualNetworkGateway2Value.get("id");
                            if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                String idInstance8;
                                idInstance8 = idValue8.getTextValue();
                                virtualNetworkGateway2Instance.setId(idInstance8);
                            }
                            
                            JsonNode nameValue4 = virtualNetworkGateway2Value.get("name");
                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                String nameInstance4;
                                nameInstance4 = nameValue4.getTextValue();
                                virtualNetworkGateway2Instance.setName(nameInstance4);
                            }
                            
                            JsonNode typeValue2 = virtualNetworkGateway2Value.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                String typeInstance2;
                                typeInstance2 = typeValue2.getTextValue();
                                virtualNetworkGateway2Instance.setType(typeInstance2);
                            }
                            
                            JsonNode locationValue2 = virtualNetworkGateway2Value.get("location");
                            if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                String locationInstance2;
                                locationInstance2 = locationValue2.getTextValue();
                                virtualNetworkGateway2Instance.setLocation(locationInstance2);
                            }
                            
                            JsonNode tagsSequenceElement2 = ((JsonNode) virtualNetworkGateway2Value.get("tags"));
                            if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String tagsKey2 = property2.getKey();
                                    String tagsValue2 = property2.getValue().getTextValue();
                                    virtualNetworkGateway2Instance.getTags().put(tagsKey2, tagsValue2);
                                }
                            }
                        }
                        
                        JsonNode localNetworkGateway2Value = propertiesValue.get("localNetworkGateway2");
                        if (localNetworkGateway2Value != null && localNetworkGateway2Value instanceof NullNode == false) {
                            LocalNetworkGateway localNetworkGateway2Instance = new LocalNetworkGateway();
                            virtualNetworkGatewayConnectionInstance.setLocalNetworkGateway2(localNetworkGateway2Instance);
                            
                            JsonNode localNetworkAddressSpaceValue = localNetworkGateway2Value.get("localNetworkAddressSpace");
                            if (localNetworkAddressSpaceValue != null && localNetworkAddressSpaceValue instanceof NullNode == false) {
                                AddressSpace localNetworkAddressSpaceInstance = new AddressSpace();
                                localNetworkGateway2Instance.setLocalNetworkAddressSpace(localNetworkAddressSpaceInstance);
                                
                                JsonNode addressPrefixesArray = localNetworkAddressSpaceValue.get("addressPrefixes");
                                if (addressPrefixesArray != null && addressPrefixesArray instanceof NullNode == false) {
                                    for (JsonNode addressPrefixesValue : ((ArrayNode) addressPrefixesArray)) {
                                        localNetworkAddressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                    }
                                }
                            }
                            
                            JsonNode gatewayIpAddressValue = localNetworkGateway2Value.get("gatewayIpAddress");
                            if (gatewayIpAddressValue != null && gatewayIpAddressValue instanceof NullNode == false) {
                                String gatewayIpAddressInstance;
                                gatewayIpAddressInstance = gatewayIpAddressValue.getTextValue();
                                localNetworkGateway2Instance.setGatewayIpAddress(gatewayIpAddressInstance);
                            }
                            
                            JsonNode provisioningStateValue5 = localNetworkGateway2Value.get("provisioningState");
                            if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                String provisioningStateInstance5;
                                provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                localNetworkGateway2Instance.setProvisioningState(provisioningStateInstance5);
                            }
                            
                            JsonNode etagValue5 = localNetworkGateway2Value.get("etag");
                            if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                String etagInstance5;
                                etagInstance5 = etagValue5.getTextValue();
                                localNetworkGateway2Instance.setEtag(etagInstance5);
                            }
                            
                            JsonNode idValue9 = localNetworkGateway2Value.get("id");
                            if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                String idInstance9;
                                idInstance9 = idValue9.getTextValue();
                                localNetworkGateway2Instance.setId(idInstance9);
                            }
                            
                            JsonNode nameValue5 = localNetworkGateway2Value.get("name");
                            if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                String nameInstance5;
                                nameInstance5 = nameValue5.getTextValue();
                                localNetworkGateway2Instance.setName(nameInstance5);
                            }
                            
                            JsonNode typeValue3 = localNetworkGateway2Value.get("type");
                            if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                String typeInstance3;
                                typeInstance3 = typeValue3.getTextValue();
                                localNetworkGateway2Instance.setType(typeInstance3);
                            }
                            
                            JsonNode locationValue3 = localNetworkGateway2Value.get("location");
                            if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                String locationInstance3;
                                locationInstance3 = locationValue3.getTextValue();
                                localNetworkGateway2Instance.setLocation(locationInstance3);
                            }
                            
                            JsonNode tagsSequenceElement3 = ((JsonNode) localNetworkGateway2Value.get("tags"));
                            if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                while (itr3.hasNext()) {
                                    Map.Entry<String, JsonNode> property3 = itr3.next();
                                    String tagsKey3 = property3.getKey();
                                    String tagsValue3 = property3.getValue().getTextValue();
                                    localNetworkGateway2Instance.getTags().put(tagsKey3, tagsValue3);
                                }
                            }
                        }
                        
                        JsonNode connectionTypeValue = propertiesValue.get("connectionType");
                        if (connectionTypeValue != null && connectionTypeValue instanceof NullNode == false) {
                            String connectionTypeInstance;
                            connectionTypeInstance = connectionTypeValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setConnectionType(connectionTypeInstance);
                        }
                        
                        JsonNode routingWeightValue = propertiesValue.get("routingWeight");
                        if (routingWeightValue != null && routingWeightValue instanceof NullNode == false) {
                            int routingWeightInstance;
                            routingWeightInstance = routingWeightValue.getIntValue();
                            virtualNetworkGatewayConnectionInstance.setRoutingWeight(routingWeightInstance);
                        }
                        
                        JsonNode sharedKeyValue = propertiesValue.get("sharedKey");
                        if (sharedKeyValue != null && sharedKeyValue instanceof NullNode == false) {
                            String sharedKeyInstance;
                            sharedKeyInstance = sharedKeyValue.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setSharedKey(sharedKeyInstance);
                        }
                        
                        JsonNode provisioningStateValue6 = propertiesValue.get("provisioningState");
                        if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                            String provisioningStateInstance6;
                            provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            virtualNetworkGatewayConnectionInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    
                    JsonNode etagValue6 = responseDoc.get("etag");
                    if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                        String etagInstance6;
                        etagInstance6 = etagValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setEtag(etagInstance6);
                    }
                    
                    JsonNode idValue10 = responseDoc.get("id");
                    if (idValue10 != null && idValue10 instanceof NullNode == false) {
                        String idInstance10;
                        idInstance10 = idValue10.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setId(idInstance10);
                    }
                    
                    JsonNode nameValue6 = responseDoc.get("name");
                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                        String nameInstance6;
                        nameInstance6 = nameValue6.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setName(nameInstance6);
                    }
                    
                    JsonNode typeValue4 = responseDoc.get("type");
                    if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                        String typeInstance4;
                        typeInstance4 = typeValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setType(typeInstance4);
                    }
                    
                    JsonNode locationValue4 = responseDoc.get("location");
                    if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                        String locationInstance4;
                        locationInstance4 = locationValue4.getTextValue();
                        virtualNetworkGatewayConnectionInstance.setLocation(locationInstance4);
                    }
                    
                    JsonNode tagsSequenceElement4 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                        while (itr4.hasNext()) {
                            Map.Entry<String, JsonNode> property4 = itr4.next();
                            String tagsKey4 = property4.getKey();
                            String tagsValue4 = property4.getValue().getTextValue();
                            virtualNetworkGatewayConnectionInstance.getTags().put(tagsKey4, tagsValue4);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get VirtualNetworkGatewayConnectionSharedKey operation retrieves
    * information about the specified virtual network gateway connection
    * shared key through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param connectionSharedKeyName Required. The virtual network gateway
    * connection shared key name.
    * @return Response for CheckConnectionSharedKey Api servive call
    */
    @Override
    public Future<ConnectionSharedKeyResponse> getSharedKeyAsync(final String resourceGroupName, final String connectionSharedKeyName) {
        return this.getClient().getExecutorService().submit(new Callable<ConnectionSharedKeyResponse>() { 
            @Override
            public ConnectionSharedKeyResponse call() throws Exception {
                return getSharedKey(resourceGroupName, connectionSharedKeyName);
            }
         });
    }
    
    /**
    * The Get VirtualNetworkGatewayConnectionSharedKey operation retrieves
    * information about the specified virtual network gateway connection
    * shared key through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param connectionSharedKeyName Required. The virtual network gateway
    * connection shared key name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for CheckConnectionSharedKey Api servive call
    */
    @Override
    public ConnectionSharedKeyResponse getSharedKey(String resourceGroupName, String connectionSharedKeyName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (connectionSharedKeyName == null) {
            throw new NullPointerException("connectionSharedKeyName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("connectionSharedKeyName", connectionSharedKeyName);
            CloudTracing.enter(invocationId, this, "getSharedKeyAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections/";
        url = url + URLEncoder.encode(connectionSharedKeyName, "UTF-8");
        url = url + "/sharedkey";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ConnectionSharedKeyResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ConnectionSharedKeyResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueValue = responseDoc.get("value");
                    if (valueValue != null && valueValue instanceof NullNode == false) {
                        String valueInstance;
                        valueInstance = valueValue.getTextValue();
                        result.setValue(valueInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List VirtualNetworkGatewayConnections operation retrieves all the
    * virtual network gateways connections created.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListVirtualNetworkGatewayConnections Api service call
    */
    @Override
    public Future<VirtualNetworkGatewayConnectionListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayConnectionListResponse>() { 
            @Override
            public VirtualNetworkGatewayConnectionListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The List VirtualNetworkGatewayConnections operation retrieves all the
    * virtual network gateways connections created.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListVirtualNetworkGatewayConnections Api service call
    */
    @Override
    public VirtualNetworkGatewayConnectionListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/connections";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayConnectionListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayConnectionListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualNetworkGatewayConnection virtualNetworkGatewayConnectionJsonFormatInstance = new VirtualNetworkGatewayConnection();
                            result.getVirtualNetworkGatewayConnections().add(virtualNetworkGatewayConnectionJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode virtualNetworkGateway1Value = propertiesValue.get("virtualNetworkGateway1");
                                if (virtualNetworkGateway1Value != null && virtualNetworkGateway1Value instanceof NullNode == false) {
                                    VirtualNetworkGateway virtualNetworkGateway1Instance = new VirtualNetworkGateway();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setVirtualNetworkGateway1(virtualNetworkGateway1Instance);
                                    
                                    JsonNode ipConfigurationsArray = virtualNetworkGateway1Value.get("ipConfigurations");
                                    if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                        for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                            VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance = new VirtualNetworkGatewayIpConfiguration();
                                            virtualNetworkGateway1Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance);
                                            
                                            JsonNode privateIPAddressValue = ipConfigurationsValue.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = ipConfigurationsValue.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue = ipConfigurationsValue.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = ipConfigurationsValue.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance.setPublicIpAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                    String idInstance2;
                                                    idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = ipConfigurationsValue.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                            
                                            JsonNode nameValue = ipConfigurationsValue.get("name");
                                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                                String nameInstance;
                                                nameInstance = nameValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setName(nameInstance);
                                            }
                                            
                                            JsonNode etagValue = ipConfigurationsValue.get("etag");
                                            if (etagValue != null && etagValue instanceof NullNode == false) {
                                                String etagInstance;
                                                etagInstance = etagValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setEtag(etagInstance);
                                            }
                                            
                                            JsonNode idValue3 = ipConfigurationsValue.get("id");
                                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                String idInstance3;
                                                idInstance3 = idValue3.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance.setId(idInstance3);
                                            }
                                        }
                                    }
                                    
                                    JsonNode gatewayTypeValue = virtualNetworkGateway1Value.get("gatewayType");
                                    if (gatewayTypeValue != null && gatewayTypeValue instanceof NullNode == false) {
                                        String gatewayTypeInstance;
                                        gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                        virtualNetworkGateway1Instance.setGatewayType(gatewayTypeInstance);
                                    }
                                    
                                    JsonNode vpnTypeValue = virtualNetworkGateway1Value.get("vpnType");
                                    if (vpnTypeValue != null && vpnTypeValue instanceof NullNode == false) {
                                        String vpnTypeInstance;
                                        vpnTypeInstance = vpnTypeValue.getTextValue();
                                        virtualNetworkGateway1Instance.setVpnType(vpnTypeInstance);
                                    }
                                    
                                    JsonNode enableBgpValue = virtualNetworkGateway1Value.get("enableBgp");
                                    if (enableBgpValue != null && enableBgpValue instanceof NullNode == false) {
                                        boolean enableBgpInstance;
                                        enableBgpInstance = enableBgpValue.getBooleanValue();
                                        virtualNetworkGateway1Instance.setEnableBgp(enableBgpInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue2 = virtualNetworkGateway1Value.get("provisioningState");
                                    if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                        String provisioningStateInstance2;
                                        provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        virtualNetworkGateway1Instance.setProvisioningState(provisioningStateInstance2);
                                    }
                                    
                                    JsonNode etagValue2 = virtualNetworkGateway1Value.get("etag");
                                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                        String etagInstance2;
                                        etagInstance2 = etagValue2.getTextValue();
                                        virtualNetworkGateway1Instance.setEtag(etagInstance2);
                                    }
                                    
                                    JsonNode idValue4 = virtualNetworkGateway1Value.get("id");
                                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                        String idInstance4;
                                        idInstance4 = idValue4.getTextValue();
                                        virtualNetworkGateway1Instance.setId(idInstance4);
                                    }
                                    
                                    JsonNode nameValue2 = virtualNetworkGateway1Value.get("name");
                                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                        String nameInstance2;
                                        nameInstance2 = nameValue2.getTextValue();
                                        virtualNetworkGateway1Instance.setName(nameInstance2);
                                    }
                                    
                                    JsonNode typeValue = virtualNetworkGateway1Value.get("type");
                                    if (typeValue != null && typeValue instanceof NullNode == false) {
                                        String typeInstance;
                                        typeInstance = typeValue.getTextValue();
                                        virtualNetworkGateway1Instance.setType(typeInstance);
                                    }
                                    
                                    JsonNode locationValue = virtualNetworkGateway1Value.get("location");
                                    if (locationValue != null && locationValue instanceof NullNode == false) {
                                        String locationInstance;
                                        locationInstance = locationValue.getTextValue();
                                        virtualNetworkGateway1Instance.setLocation(locationInstance);
                                    }
                                    
                                    JsonNode tagsSequenceElement = ((JsonNode) virtualNetworkGateway1Value.get("tags"));
                                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry<String, JsonNode> property = itr.next();
                                            String tagsKey = property.getKey();
                                            String tagsValue = property.getValue().getTextValue();
                                            virtualNetworkGateway1Instance.getTags().put(tagsKey, tagsValue);
                                        }
                                    }
                                }
                                
                                JsonNode virtualNetworkGateway2Value = propertiesValue.get("virtualNetworkGateway2");
                                if (virtualNetworkGateway2Value != null && virtualNetworkGateway2Value instanceof NullNode == false) {
                                    VirtualNetworkGateway virtualNetworkGateway2Instance = new VirtualNetworkGateway();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setVirtualNetworkGateway2(virtualNetworkGateway2Instance);
                                    
                                    JsonNode ipConfigurationsArray2 = virtualNetworkGateway2Value.get("ipConfigurations");
                                    if (ipConfigurationsArray2 != null && ipConfigurationsArray2 instanceof NullNode == false) {
                                        for (JsonNode ipConfigurationsValue2 : ((ArrayNode) ipConfigurationsArray2)) {
                                            VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationInstance2 = new VirtualNetworkGatewayIpConfiguration();
                                            virtualNetworkGateway2Instance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationInstance2);
                                            
                                            JsonNode privateIPAddressValue2 = ipConfigurationsValue2.get("privateIPAddress");
                                            if (privateIPAddressValue2 != null && privateIPAddressValue2 instanceof NullNode == false) {
                                                String privateIPAddressInstance2;
                                                privateIPAddressInstance2 = privateIPAddressValue2.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAddress(privateIPAddressInstance2);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue2 = ipConfigurationsValue2.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue2 != null && privateIPAllocationMethodValue2 instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance2;
                                                privateIPAllocationMethodInstance2 = privateIPAllocationMethodValue2.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance2);
                                            }
                                            
                                            JsonNode subnetValue2 = ipConfigurationsValue2.get("subnet");
                                            if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                                ResourceId subnetInstance2 = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance2.setSubnet(subnetInstance2);
                                                
                                                JsonNode idValue5 = subnetValue2.get("id");
                                                if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                                    String idInstance5;
                                                    idInstance5 = idValue5.getTextValue();
                                                    subnetInstance2.setId(idInstance5);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue2 = ipConfigurationsValue2.get("publicIPAddress");
                                            if (publicIPAddressValue2 != null && publicIPAddressValue2 instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance2 = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationInstance2.setPublicIpAddress(publicIPAddressInstance2);
                                                
                                                JsonNode idValue6 = publicIPAddressValue2.get("id");
                                                if (idValue6 != null && idValue6 instanceof NullNode == false) {
                                                    String idInstance6;
                                                    idInstance6 = idValue6.getTextValue();
                                                    publicIPAddressInstance2.setId(idInstance6);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue3 = ipConfigurationsValue2.get("provisioningState");
                                            if (provisioningStateValue3 != null && provisioningStateValue3 instanceof NullNode == false) {
                                                String provisioningStateInstance3;
                                                provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setProvisioningState(provisioningStateInstance3);
                                            }
                                            
                                            JsonNode nameValue3 = ipConfigurationsValue2.get("name");
                                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                                String nameInstance3;
                                                nameInstance3 = nameValue3.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setName(nameInstance3);
                                            }
                                            
                                            JsonNode etagValue3 = ipConfigurationsValue2.get("etag");
                                            if (etagValue3 != null && etagValue3 instanceof NullNode == false) {
                                                String etagInstance3;
                                                etagInstance3 = etagValue3.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setEtag(etagInstance3);
                                            }
                                            
                                            JsonNode idValue7 = ipConfigurationsValue2.get("id");
                                            if (idValue7 != null && idValue7 instanceof NullNode == false) {
                                                String idInstance7;
                                                idInstance7 = idValue7.getTextValue();
                                                virtualNetworkGatewayIpConfigurationInstance2.setId(idInstance7);
                                            }
                                        }
                                    }
                                    
                                    JsonNode gatewayTypeValue2 = virtualNetworkGateway2Value.get("gatewayType");
                                    if (gatewayTypeValue2 != null && gatewayTypeValue2 instanceof NullNode == false) {
                                        String gatewayTypeInstance2;
                                        gatewayTypeInstance2 = gatewayTypeValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setGatewayType(gatewayTypeInstance2);
                                    }
                                    
                                    JsonNode vpnTypeValue2 = virtualNetworkGateway2Value.get("vpnType");
                                    if (vpnTypeValue2 != null && vpnTypeValue2 instanceof NullNode == false) {
                                        String vpnTypeInstance2;
                                        vpnTypeInstance2 = vpnTypeValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setVpnType(vpnTypeInstance2);
                                    }
                                    
                                    JsonNode enableBgpValue2 = virtualNetworkGateway2Value.get("enableBgp");
                                    if (enableBgpValue2 != null && enableBgpValue2 instanceof NullNode == false) {
                                        boolean enableBgpInstance2;
                                        enableBgpInstance2 = enableBgpValue2.getBooleanValue();
                                        virtualNetworkGateway2Instance.setEnableBgp(enableBgpInstance2);
                                    }
                                    
                                    JsonNode provisioningStateValue4 = virtualNetworkGateway2Value.get("provisioningState");
                                    if (provisioningStateValue4 != null && provisioningStateValue4 instanceof NullNode == false) {
                                        String provisioningStateInstance4;
                                        provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        virtualNetworkGateway2Instance.setProvisioningState(provisioningStateInstance4);
                                    }
                                    
                                    JsonNode etagValue4 = virtualNetworkGateway2Value.get("etag");
                                    if (etagValue4 != null && etagValue4 instanceof NullNode == false) {
                                        String etagInstance4;
                                        etagInstance4 = etagValue4.getTextValue();
                                        virtualNetworkGateway2Instance.setEtag(etagInstance4);
                                    }
                                    
                                    JsonNode idValue8 = virtualNetworkGateway2Value.get("id");
                                    if (idValue8 != null && idValue8 instanceof NullNode == false) {
                                        String idInstance8;
                                        idInstance8 = idValue8.getTextValue();
                                        virtualNetworkGateway2Instance.setId(idInstance8);
                                    }
                                    
                                    JsonNode nameValue4 = virtualNetworkGateway2Value.get("name");
                                    if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                        String nameInstance4;
                                        nameInstance4 = nameValue4.getTextValue();
                                        virtualNetworkGateway2Instance.setName(nameInstance4);
                                    }
                                    
                                    JsonNode typeValue2 = virtualNetworkGateway2Value.get("type");
                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                        String typeInstance2;
                                        typeInstance2 = typeValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setType(typeInstance2);
                                    }
                                    
                                    JsonNode locationValue2 = virtualNetworkGateway2Value.get("location");
                                    if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                        String locationInstance2;
                                        locationInstance2 = locationValue2.getTextValue();
                                        virtualNetworkGateway2Instance.setLocation(locationInstance2);
                                    }
                                    
                                    JsonNode tagsSequenceElement2 = ((JsonNode) virtualNetworkGateway2Value.get("tags"));
                                    if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                        while (itr2.hasNext()) {
                                            Map.Entry<String, JsonNode> property2 = itr2.next();
                                            String tagsKey2 = property2.getKey();
                                            String tagsValue2 = property2.getValue().getTextValue();
                                            virtualNetworkGateway2Instance.getTags().put(tagsKey2, tagsValue2);
                                        }
                                    }
                                }
                                
                                JsonNode localNetworkGateway2Value = propertiesValue.get("localNetworkGateway2");
                                if (localNetworkGateway2Value != null && localNetworkGateway2Value instanceof NullNode == false) {
                                    LocalNetworkGateway localNetworkGateway2Instance = new LocalNetworkGateway();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setLocalNetworkGateway2(localNetworkGateway2Instance);
                                    
                                    JsonNode localNetworkAddressSpaceValue = localNetworkGateway2Value.get("localNetworkAddressSpace");
                                    if (localNetworkAddressSpaceValue != null && localNetworkAddressSpaceValue instanceof NullNode == false) {
                                        AddressSpace localNetworkAddressSpaceInstance = new AddressSpace();
                                        localNetworkGateway2Instance.setLocalNetworkAddressSpace(localNetworkAddressSpaceInstance);
                                        
                                        JsonNode addressPrefixesArray = localNetworkAddressSpaceValue.get("addressPrefixes");
                                        if (addressPrefixesArray != null && addressPrefixesArray instanceof NullNode == false) {
                                            for (JsonNode addressPrefixesValue : ((ArrayNode) addressPrefixesArray)) {
                                                localNetworkAddressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                            }
                                        }
                                    }
                                    
                                    JsonNode gatewayIpAddressValue = localNetworkGateway2Value.get("gatewayIpAddress");
                                    if (gatewayIpAddressValue != null && gatewayIpAddressValue instanceof NullNode == false) {
                                        String gatewayIpAddressInstance;
                                        gatewayIpAddressInstance = gatewayIpAddressValue.getTextValue();
                                        localNetworkGateway2Instance.setGatewayIpAddress(gatewayIpAddressInstance);
                                    }
                                    
                                    JsonNode provisioningStateValue5 = localNetworkGateway2Value.get("provisioningState");
                                    if (provisioningStateValue5 != null && provisioningStateValue5 instanceof NullNode == false) {
                                        String provisioningStateInstance5;
                                        provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        localNetworkGateway2Instance.setProvisioningState(provisioningStateInstance5);
                                    }
                                    
                                    JsonNode etagValue5 = localNetworkGateway2Value.get("etag");
                                    if (etagValue5 != null && etagValue5 instanceof NullNode == false) {
                                        String etagInstance5;
                                        etagInstance5 = etagValue5.getTextValue();
                                        localNetworkGateway2Instance.setEtag(etagInstance5);
                                    }
                                    
                                    JsonNode idValue9 = localNetworkGateway2Value.get("id");
                                    if (idValue9 != null && idValue9 instanceof NullNode == false) {
                                        String idInstance9;
                                        idInstance9 = idValue9.getTextValue();
                                        localNetworkGateway2Instance.setId(idInstance9);
                                    }
                                    
                                    JsonNode nameValue5 = localNetworkGateway2Value.get("name");
                                    if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                        String nameInstance5;
                                        nameInstance5 = nameValue5.getTextValue();
                                        localNetworkGateway2Instance.setName(nameInstance5);
                                    }
                                    
                                    JsonNode typeValue3 = localNetworkGateway2Value.get("type");
                                    if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                        String typeInstance3;
                                        typeInstance3 = typeValue3.getTextValue();
                                        localNetworkGateway2Instance.setType(typeInstance3);
                                    }
                                    
                                    JsonNode locationValue3 = localNetworkGateway2Value.get("location");
                                    if (locationValue3 != null && locationValue3 instanceof NullNode == false) {
                                        String locationInstance3;
                                        locationInstance3 = locationValue3.getTextValue();
                                        localNetworkGateway2Instance.setLocation(locationInstance3);
                                    }
                                    
                                    JsonNode tagsSequenceElement3 = ((JsonNode) localNetworkGateway2Value.get("tags"));
                                    if (tagsSequenceElement3 != null && tagsSequenceElement3 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr3 = tagsSequenceElement3.getFields();
                                        while (itr3.hasNext()) {
                                            Map.Entry<String, JsonNode> property3 = itr3.next();
                                            String tagsKey3 = property3.getKey();
                                            String tagsValue3 = property3.getValue().getTextValue();
                                            localNetworkGateway2Instance.getTags().put(tagsKey3, tagsValue3);
                                        }
                                    }
                                }
                                
                                JsonNode connectionTypeValue = propertiesValue.get("connectionType");
                                if (connectionTypeValue != null && connectionTypeValue instanceof NullNode == false) {
                                    String connectionTypeInstance;
                                    connectionTypeInstance = connectionTypeValue.getTextValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setConnectionType(connectionTypeInstance);
                                }
                                
                                JsonNode routingWeightValue = propertiesValue.get("routingWeight");
                                if (routingWeightValue != null && routingWeightValue instanceof NullNode == false) {
                                    int routingWeightInstance;
                                    routingWeightInstance = routingWeightValue.getIntValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setRoutingWeight(routingWeightInstance);
                                }
                                
                                JsonNode sharedKeyValue = propertiesValue.get("sharedKey");
                                if (sharedKeyValue != null && sharedKeyValue instanceof NullNode == false) {
                                    String sharedKeyInstance;
                                    sharedKeyInstance = sharedKeyValue.getTextValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setSharedKey(sharedKeyInstance);
                                }
                                
                                JsonNode provisioningStateValue6 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue6 != null && provisioningStateValue6 instanceof NullNode == false) {
                                    String provisioningStateInstance6;
                                    provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                }
                            }
                            
                            JsonNode etagValue6 = valueValue.get("etag");
                            if (etagValue6 != null && etagValue6 instanceof NullNode == false) {
                                String etagInstance6;
                                etagInstance6 = etagValue6.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setEtag(etagInstance6);
                            }
                            
                            JsonNode idValue10 = valueValue.get("id");
                            if (idValue10 != null && idValue10 instanceof NullNode == false) {
                                String idInstance10;
                                idInstance10 = idValue10.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setId(idInstance10);
                            }
                            
                            JsonNode nameValue6 = valueValue.get("name");
                            if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                String nameInstance6;
                                nameInstance6 = nameValue6.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setName(nameInstance6);
                            }
                            
                            JsonNode typeValue4 = valueValue.get("type");
                            if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                String typeInstance4;
                                typeInstance4 = typeValue4.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setType(typeInstance4);
                            }
                            
                            JsonNode locationValue4 = valueValue.get("location");
                            if (locationValue4 != null && locationValue4 instanceof NullNode == false) {
                                String locationInstance4;
                                locationInstance4 = locationValue4.getTextValue();
                                virtualNetworkGatewayConnectionJsonFormatInstance.setLocation(locationInstance4);
                            }
                            
                            JsonNode tagsSequenceElement4 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement4 != null && tagsSequenceElement4 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr4 = tagsSequenceElement4.getFields();
                                while (itr4.hasNext()) {
                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                    String tagsKey4 = property4.getKey();
                                    String tagsValue4 = property4.getValue().getTextValue();
                                    virtualNetworkGatewayConnectionJsonFormatInstance.getTags().put(tagsKey4, tagsValue4);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Reset VirtualNetworkGatewayConnectionSharedKey operation resets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection name.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway connection shared key operation through Network
    * resource provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> resetSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionResetSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return resetSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
         });
    }
    
    /**
    * The Reset VirtualNetworkGatewayConnectionSharedKey operation resets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection name.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway connection shared key operation through Network
    * resource provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse resetSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionResetSharedKey parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "resetSharedKeyAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ConnectionResetSharedKeyPutResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginResetSharedKeyAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Put VirtualNetworkGatewayConnectionSharedKey operation sets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection name.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway connection shared key operation through
    * Network resource provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> setSharedKeyAsync(final String resourceGroupName, final String virtualNetworkGatewayConnectionName, final ConnectionSharedKey parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return setSharedKey(resourceGroupName, virtualNetworkGatewayConnectionName, parameters);
            }
         });
    }
    
    /**
    * The Put VirtualNetworkGatewayConnectionSharedKey operation sets the
    * virtual network gateway connection shared key for passed virtual network
    * gateway connection in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayConnectionName Required. The virtual network
    * gateway connection name.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway connection shared key operation through
    * Network resource provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse setSharedKey(String resourceGroupName, String virtualNetworkGatewayConnectionName, ConnectionSharedKey parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayConnectionName", virtualNetworkGatewayConnectionName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "setSharedKeyAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ConnectionSharedKeyPutResponse response = client2.getVirtualNetworkGatewayConnectionsOperations().beginSetSharedKeyAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}
