/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGateway;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayGetResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayListResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayPutResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* Virtual network Gateway for your subscription.
*/
public interface VirtualNetworkGatewayOperations {
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    VirtualNetworkGatewayPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws IOException, ServiceException;
    
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    Future<VirtualNetworkGatewayPutResponse> beginCreateOrUpdatingAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters);
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkGatewayName) throws IOException, ServiceException;
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    Future<UpdateOperationResponse> beginDeletingAsync(String resourceGroupName, String virtualNetworkGatewayName);
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gatewayin the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    VirtualNetworkGatewayPutResponse beginReset(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws IOException, ServiceException;
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gatewayin the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    Future<VirtualNetworkGatewayPutResponse> beginResetAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters);
    
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<AzureAsyncOperationResponse> createOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters);
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String virtualNetworkGatewayName) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String virtualNetworkGatewayName);
    
    /**
    * The Get VirtualNetworkGateway operation retrieves information about the
    * specified virtual network gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetVitualNetworkgateway Api servive call.
    */
    VirtualNetworkGatewayGetResponse get(String resourceGroupName, String virtualNetworkGatewayName) throws IOException, ServiceException;
    
    /**
    * The Get VirtualNetworkGateway operation retrieves information about the
    * specified virtual network gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @return Response for GetVitualNetworkgateway Api servive call.
    */
    Future<VirtualNetworkGatewayGetResponse> getAsync(String resourceGroupName, String virtualNetworkGatewayName);
    
    /**
    * The List VirtualNetworkGateways opertion retrieves all the virtual
    * network gateways stored.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListVirtualNetworkGateways Api service call
    */
    VirtualNetworkGatewayListResponse list(String resourceGroupName) throws IOException, ServiceException;
    
    /**
    * The List VirtualNetworkGateways opertion retrieves all the virtual
    * network gateways stored.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListVirtualNetworkGateways Api service call
    */
    Future<VirtualNetworkGatewayListResponse> listAsync(String resourceGroupName);
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gateway in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    AzureAsyncOperationResponse reset(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws InterruptedException, ExecutionException, IOException;
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gateway in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<AzureAsyncOperationResponse> resetAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters);
}
