/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGateway;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayGetResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayIpConfiguration;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayListResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkGatewayPutResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* Virtual network Gateway for your subscription.
*/
public class VirtualNetworkGatewayOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, VirtualNetworkGatewayOperations {
    /**
    * Initializes a new instance of the VirtualNetworkGatewayOperationsImpl
    * class.
    *
    * @param client Reference to the service client.
    */
    VirtualNetworkGatewayOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>() { 
            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
         });
    }
    
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public VirtualNetworkGatewayPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworkgateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode virtualNetworkGatewayJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = virtualNetworkGatewayJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getIpConfigurations() != null) {
            if (parameters.getIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getIpConfigurations()).isInitialized()) {
                ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                for (VirtualNetworkGatewayIpConfiguration ipConfigurationsItem : parameters.getIpConfigurations()) {
                    ObjectNode virtualNetworkGatewayIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                    ipConfigurationsArray.add(virtualNetworkGatewayIpConfigurationJsonFormatValue);
                    
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("properties", propertiesValue2);
                    
                    if (ipConfigurationsItem.getPrivateIpAddress() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAddress", ipConfigurationsItem.getPrivateIpAddress());
                    }
                    
                    if (ipConfigurationsItem.getPrivateIpAllocationMethod() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAllocationMethod", ipConfigurationsItem.getPrivateIpAllocationMethod());
                    }
                    
                    if (ipConfigurationsItem.getSubnet() != null) {
                        ObjectNode subnetValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("subnet", subnetValue);
                        
                        if (ipConfigurationsItem.getSubnet().getId() != null) {
                            ((ObjectNode) subnetValue).put("id", ipConfigurationsItem.getSubnet().getId());
                        }
                    }
                    
                    if (ipConfigurationsItem.getPublicIpAddress() != null) {
                        ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("publicIPAddress", publicIPAddressValue);
                        
                        if (ipConfigurationsItem.getPublicIpAddress().getId() != null) {
                            ((ObjectNode) publicIPAddressValue).put("id", ipConfigurationsItem.getPublicIpAddress().getId());
                        }
                    }
                    
                    if (ipConfigurationsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue2).put("provisioningState", ipConfigurationsItem.getProvisioningState());
                    }
                    
                    if (ipConfigurationsItem.getName() != null) {
                        ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("name", ipConfigurationsItem.getName());
                    }
                    
                    if (ipConfigurationsItem.getEtag() != null) {
                        ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("etag", ipConfigurationsItem.getEtag());
                    }
                    
                    if (ipConfigurationsItem.getId() != null) {
                        ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("id", ipConfigurationsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("ipConfigurations", ipConfigurationsArray);
            }
        }
        
        if (parameters.getGatewayType() != null) {
            ((ObjectNode) propertiesValue).put("gatewayType", parameters.getGatewayType());
        }
        
        if (parameters.getVpnType() != null) {
            ((ObjectNode) propertiesValue).put("vpnType", parameters.getVpnType());
        }
        
        ((ObjectNode) propertiesValue).put("enableBgp", parameters.isEnableBgp());
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualNetworkGateway virtualNetworkGatewayInstance = new VirtualNetworkGateway();
                    result.setVirtualNetworkGateway(virtualNetworkGatewayInstance);
                    
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                        JsonNode ipConfigurationsArray2 = propertiesValue3.get("ipConfigurations");
                        if (ipConfigurationsArray2 != null && ipConfigurationsArray2 instanceof NullNode == false) {
                            for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray2)) {
                                VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                virtualNetworkGatewayInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue4 = ipConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue2 = propertiesValue4.get("subnet");
                                    if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue2.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue2 = propertiesValue4.get("publicIPAddress");
                                    if (publicIPAddressValue2 != null && publicIPAddressValue2 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue2 = publicIPAddressValue2.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue4.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = ipConfigurationsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = ipConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue3 = ipConfigurationsValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode gatewayTypeValue = propertiesValue3.get("gatewayType");
                        if (gatewayTypeValue != null && gatewayTypeValue instanceof NullNode == false) {
                            String gatewayTypeInstance;
                            gatewayTypeInstance = gatewayTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setGatewayType(gatewayTypeInstance);
                        }
                        
                        JsonNode vpnTypeValue = propertiesValue3.get("vpnType");
                        if (vpnTypeValue != null && vpnTypeValue instanceof NullNode == false) {
                            String vpnTypeInstance;
                            vpnTypeInstance = vpnTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setVpnType(vpnTypeInstance);
                        }
                        
                        JsonNode enableBgpValue = propertiesValue3.get("enableBgp");
                        if (enableBgpValue != null && enableBgpValue instanceof NullNode == false) {
                            boolean enableBgpInstance;
                            enableBgpInstance = enableBgpValue.getBooleanValue();
                            virtualNetworkGatewayInstance.setEnableBgp(enableBgpInstance);
                        }
                        
                        JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                            String provisioningStateInstance2;
                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkGatewayInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    
                    JsonNode etagValue2 = responseDoc.get("etag");
                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                        String etagInstance2;
                        etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkGatewayInstance.setEtag(etagInstance2);
                    }
                    
                    JsonNode idValue4 = responseDoc.get("id");
                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                        String idInstance4;
                        idInstance4 = idValue4.getTextValue();
                        virtualNetworkGatewayInstance.setId(idInstance4);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkGatewayInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        virtualNetworkGatewayInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualNetworkGatewayInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            virtualNetworkGatewayInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, virtualNetworkGatewayName);
            }
         });
    }
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkGatewayName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualNetworkGateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gatewayin the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public Future<VirtualNetworkGatewayPutResponse> beginResetAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayPutResponse>() { 
            @Override
            public VirtualNetworkGatewayPutResponse call() throws Exception {
                return beginReset(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
         });
    }
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gatewayin the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworkGateway Api servive call
    */
    @Override
    public VirtualNetworkGatewayPutResponse beginReset(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginResetAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworkgateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        url = url + "/reset";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode virtualNetworkGatewayJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = virtualNetworkGatewayJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getIpConfigurations() != null) {
            if (parameters.getIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) parameters.getIpConfigurations()).isInitialized()) {
                ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                for (VirtualNetworkGatewayIpConfiguration ipConfigurationsItem : parameters.getIpConfigurations()) {
                    ObjectNode virtualNetworkGatewayIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                    ipConfigurationsArray.add(virtualNetworkGatewayIpConfigurationJsonFormatValue);
                    
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("properties", propertiesValue2);
                    
                    if (ipConfigurationsItem.getPrivateIpAddress() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAddress", ipConfigurationsItem.getPrivateIpAddress());
                    }
                    
                    if (ipConfigurationsItem.getPrivateIpAllocationMethod() != null) {
                        ((ObjectNode) propertiesValue2).put("privateIPAllocationMethod", ipConfigurationsItem.getPrivateIpAllocationMethod());
                    }
                    
                    if (ipConfigurationsItem.getSubnet() != null) {
                        ObjectNode subnetValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("subnet", subnetValue);
                        
                        if (ipConfigurationsItem.getSubnet().getId() != null) {
                            ((ObjectNode) subnetValue).put("id", ipConfigurationsItem.getSubnet().getId());
                        }
                    }
                    
                    if (ipConfigurationsItem.getPublicIpAddress() != null) {
                        ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("publicIPAddress", publicIPAddressValue);
                        
                        if (ipConfigurationsItem.getPublicIpAddress().getId() != null) {
                            ((ObjectNode) publicIPAddressValue).put("id", ipConfigurationsItem.getPublicIpAddress().getId());
                        }
                    }
                    
                    if (ipConfigurationsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue2).put("provisioningState", ipConfigurationsItem.getProvisioningState());
                    }
                    
                    if (ipConfigurationsItem.getName() != null) {
                        ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("name", ipConfigurationsItem.getName());
                    }
                    
                    if (ipConfigurationsItem.getEtag() != null) {
                        ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("etag", ipConfigurationsItem.getEtag());
                    }
                    
                    if (ipConfigurationsItem.getId() != null) {
                        ((ObjectNode) virtualNetworkGatewayIpConfigurationJsonFormatValue).put("id", ipConfigurationsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("ipConfigurations", ipConfigurationsArray);
            }
        }
        
        if (parameters.getGatewayType() != null) {
            ((ObjectNode) propertiesValue).put("gatewayType", parameters.getGatewayType());
        }
        
        if (parameters.getVpnType() != null) {
            ((ObjectNode) propertiesValue).put("vpnType", parameters.getVpnType());
        }
        
        ((ObjectNode) propertiesValue).put("enableBgp", parameters.isEnableBgp());
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) virtualNetworkGatewayJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_ACCEPTED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualNetworkGateway virtualNetworkGatewayInstance = new VirtualNetworkGateway();
                    result.setVirtualNetworkGateway(virtualNetworkGatewayInstance);
                    
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                        JsonNode ipConfigurationsArray2 = propertiesValue3.get("ipConfigurations");
                        if (ipConfigurationsArray2 != null && ipConfigurationsArray2 instanceof NullNode == false) {
                            for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray2)) {
                                VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                virtualNetworkGatewayInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue4 = ipConfigurationsValue.get("properties");
                                if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue4.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue4.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue2 = propertiesValue4.get("subnet");
                                    if (subnetValue2 != null && subnetValue2 instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue2.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue2 = propertiesValue4.get("publicIPAddress");
                                    if (publicIPAddressValue2 != null && publicIPAddressValue2 instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue2 = publicIPAddressValue2.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue4.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = ipConfigurationsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = ipConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue3 = ipConfigurationsValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode gatewayTypeValue = propertiesValue3.get("gatewayType");
                        if (gatewayTypeValue != null && gatewayTypeValue instanceof NullNode == false) {
                            String gatewayTypeInstance;
                            gatewayTypeInstance = gatewayTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setGatewayType(gatewayTypeInstance);
                        }
                        
                        JsonNode vpnTypeValue = propertiesValue3.get("vpnType");
                        if (vpnTypeValue != null && vpnTypeValue instanceof NullNode == false) {
                            String vpnTypeInstance;
                            vpnTypeInstance = vpnTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setVpnType(vpnTypeInstance);
                        }
                        
                        JsonNode enableBgpValue = propertiesValue3.get("enableBgp");
                        if (enableBgpValue != null && enableBgpValue instanceof NullNode == false) {
                            boolean enableBgpInstance;
                            enableBgpInstance = enableBgpValue.getBooleanValue();
                            virtualNetworkGatewayInstance.setEnableBgp(enableBgpInstance);
                        }
                        
                        JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                            String provisioningStateInstance2;
                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkGatewayInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    
                    JsonNode etagValue2 = responseDoc.get("etag");
                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                        String etagInstance2;
                        etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkGatewayInstance.setEtag(etagInstance2);
                    }
                    
                    JsonNode idValue4 = responseDoc.get("id");
                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                        String idInstance4;
                        idInstance4 = idValue4.getTextValue();
                        virtualNetworkGatewayInstance.setId(idInstance4);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkGatewayInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        virtualNetworkGatewayInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualNetworkGatewayInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            virtualNetworkGatewayInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
         });
    }
    
    /**
    * The Put VirtualNetworkGateway operation creates/updates a virtual network
    * gateway in the specified resource group through Network resource
    * provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Create or
    * update Virtual Network Gateway operation through Network resource
    * provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualNetworkGatewayPutResponse response = client2.getVirtualNetworkGatewaysOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkGatewayName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, virtualNetworkGatewayName);
            }
         });
    }
    
    /**
    * The Delete VirtualNetworkGateway operation deletes the specifed virtual
    * network Gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkGatewayName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getVirtualNetworkGatewaysOperations().beginDeletingAsync(resourceGroupName, virtualNetworkGatewayName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get VirtualNetworkGateway operation retrieves information about the
    * specified virtual network gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @return Response for GetVitualNetworkgateway Api servive call.
    */
    @Override
    public Future<VirtualNetworkGatewayGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkGatewayName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayGetResponse>() { 
            @Override
            public VirtualNetworkGatewayGetResponse call() throws Exception {
                return get(resourceGroupName, virtualNetworkGatewayName);
            }
         });
    }
    
    /**
    * The Get VirtualNetworkGateway operation retrieves information about the
    * specified virtual network gateway through Network resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetVitualNetworkgateway Api servive call.
    */
    @Override
    public VirtualNetworkGatewayGetResponse get(String resourceGroupName, String virtualNetworkGatewayName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkGatewayName == null) {
            throw new NullPointerException("virtualNetworkGatewayName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualNetworkGateways/";
        url = url + URLEncoder.encode(virtualNetworkGatewayName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualNetworkGateway virtualNetworkGatewayInstance = new VirtualNetworkGateway();
                    result.setVirtualNetworkGateway(virtualNetworkGatewayInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                        if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                            for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                virtualNetworkGatewayInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                
                                JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                    if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                        String privateIPAddressInstance;
                                        privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    
                                    JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                    if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                        String privateIPAllocationMethodInstance;
                                        privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    
                                    JsonNode subnetValue = propertiesValue2.get("subnet");
                                    if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                        ResourceId subnetInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                    if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        
                                        JsonNode idValue2 = publicIPAddressValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = ipConfigurationsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = ipConfigurationsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue3 = ipConfigurationsValue.get("id");
                                if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                    String idInstance3;
                                    idInstance3 = idValue3.getTextValue();
                                    virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                                }
                            }
                        }
                        
                        JsonNode gatewayTypeValue = propertiesValue.get("gatewayType");
                        if (gatewayTypeValue != null && gatewayTypeValue instanceof NullNode == false) {
                            String gatewayTypeInstance;
                            gatewayTypeInstance = gatewayTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setGatewayType(gatewayTypeInstance);
                        }
                        
                        JsonNode vpnTypeValue = propertiesValue.get("vpnType");
                        if (vpnTypeValue != null && vpnTypeValue instanceof NullNode == false) {
                            String vpnTypeInstance;
                            vpnTypeInstance = vpnTypeValue.getTextValue();
                            virtualNetworkGatewayInstance.setVpnType(vpnTypeInstance);
                        }
                        
                        JsonNode enableBgpValue = propertiesValue.get("enableBgp");
                        if (enableBgpValue != null && enableBgpValue instanceof NullNode == false) {
                            boolean enableBgpInstance;
                            enableBgpInstance = enableBgpValue.getBooleanValue();
                            virtualNetworkGatewayInstance.setEnableBgp(enableBgpInstance);
                        }
                        
                        JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                            String provisioningStateInstance2;
                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkGatewayInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    
                    JsonNode etagValue2 = responseDoc.get("etag");
                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                        String etagInstance2;
                        etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkGatewayInstance.setEtag(etagInstance2);
                    }
                    
                    JsonNode idValue4 = responseDoc.get("id");
                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                        String idInstance4;
                        idInstance4 = idValue4.getTextValue();
                        virtualNetworkGatewayInstance.setId(idInstance4);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkGatewayInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        virtualNetworkGatewayInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualNetworkGatewayInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            virtualNetworkGatewayInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List VirtualNetworkGateways opertion retrieves all the virtual
    * network gateways stored.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListVirtualNetworkGateways Api service call
    */
    @Override
    public Future<VirtualNetworkGatewayListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGatewayListResponse>() { 
            @Override
            public VirtualNetworkGatewayListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The List VirtualNetworkGateways opertion retrieves all the virtual
    * network gateways stored.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListVirtualNetworkGateways Api service call
    */
    @Override
    public VirtualNetworkGatewayListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualNetworkGateways";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGatewayListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGatewayListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualNetworkGateway virtualNetworkGatewayJsonFormatInstance = new VirtualNetworkGateway();
                            result.getVirtualNetworkGateways().add(virtualNetworkGatewayJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode ipConfigurationsArray = propertiesValue.get("ipConfigurations");
                                if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                    for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                        VirtualNetworkGatewayIpConfiguration virtualNetworkGatewayIpConfigurationJsonFormatInstance = new VirtualNetworkGatewayIpConfiguration();
                                        virtualNetworkGatewayJsonFormatInstance.getIpConfigurations().add(virtualNetworkGatewayIpConfigurationJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = ipConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && privateIPAddressValue instanceof NullNode == false) {
                                                String privateIPAddressInstance;
                                                privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            
                                            JsonNode privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod");
                                            if (privateIPAllocationMethodValue != null && privateIPAllocationMethodValue instanceof NullNode == false) {
                                                String privateIPAllocationMethodInstance;
                                                privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            
                                            JsonNode subnetValue = propertiesValue2.get("subnet");
                                            if (subnetValue != null && subnetValue instanceof NullNode == false) {
                                                ResourceId subnetInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode publicIPAddressValue = propertiesValue2.get("publicIPAddress");
                                            if (publicIPAddressValue != null && publicIPAddressValue instanceof NullNode == false) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                
                                                JsonNode idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                    String idInstance2;
                                                    idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                virtualNetworkGatewayIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = ipConfigurationsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            virtualNetworkGatewayIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = ipConfigurationsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            virtualNetworkGatewayIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue3 = ipConfigurationsValue.get("id");
                                        if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                            String idInstance3;
                                            idInstance3 = idValue3.getTextValue();
                                            virtualNetworkGatewayIpConfigurationJsonFormatInstance.setId(idInstance3);
                                        }
                                    }
                                }
                                
                                JsonNode gatewayTypeValue = propertiesValue.get("gatewayType");
                                if (gatewayTypeValue != null && gatewayTypeValue instanceof NullNode == false) {
                                    String gatewayTypeInstance;
                                    gatewayTypeInstance = gatewayTypeValue.getTextValue();
                                    virtualNetworkGatewayJsonFormatInstance.setGatewayType(gatewayTypeInstance);
                                }
                                
                                JsonNode vpnTypeValue = propertiesValue.get("vpnType");
                                if (vpnTypeValue != null && vpnTypeValue instanceof NullNode == false) {
                                    String vpnTypeInstance;
                                    vpnTypeInstance = vpnTypeValue.getTextValue();
                                    virtualNetworkGatewayJsonFormatInstance.setVpnType(vpnTypeInstance);
                                }
                                
                                JsonNode enableBgpValue = propertiesValue.get("enableBgp");
                                if (enableBgpValue != null && enableBgpValue instanceof NullNode == false) {
                                    boolean enableBgpInstance;
                                    enableBgpInstance = enableBgpValue.getBooleanValue();
                                    virtualNetworkGatewayJsonFormatInstance.setEnableBgp(enableBgpInstance);
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualNetworkGatewayJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            
                            JsonNode etagValue2 = valueValue.get("etag");
                            if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                String etagInstance2;
                                etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setEtag(etagInstance2);
                            }
                            
                            JsonNode idValue4 = valueValue.get("id");
                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                String idInstance4;
                                idInstance4 = idValue4.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setId(idInstance4);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualNetworkGatewayJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    virtualNetworkGatewayJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gateway in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> resetAsync(final String resourceGroupName, final String virtualNetworkGatewayName, final VirtualNetworkGateway parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return reset(resourceGroupName, virtualNetworkGatewayName, parameters);
            }
         });
    }
    
    /**
    * The Reset VirtualNetworkGateway operation resets the primary of the
    * virtual network gateway in the specified resource group through Network
    * resource provider.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkGatewayName Required. The name of the virtual
    * network gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation through Network resource provider.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse reset(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGateway parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkGatewayName", virtualNetworkGatewayName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "resetAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualNetworkGatewayPutResponse response = client2.getVirtualNetworkGatewaysOperations().beginResetAsync(resourceGroupName, virtualNetworkGatewayName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 30;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}
