/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.models.AddressSpace;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.DhcpOptions;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.OperationStatus;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.Subnet;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetwork;
import com.microsoft.azure.management.network.models.VirtualNetworkGetResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkListResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkPutResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Resource Provider API includes operations for managing the
* Virtual Networks for your subscription.
*/
public class VirtualNetworkOperationsImpl implements ServiceOperations<NetworkResourceProviderClientImpl>, VirtualNetworkOperations {
    /**
    * Initializes a new instance of the VirtualNetworkOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    VirtualNetworkOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }
    
    private NetworkResourceProviderClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.network.NetworkResourceProviderClientImpl.
    * @return The Client value.
    */
    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Put VirtualNetwork operation creates/updates a virtual network in the
    * specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param parameters Required. Parameters supplied to the create/update
    * Virtual Network operation
    * @return Response for PutVirtualNetworks API service calls.
    */
    @Override
    public Future<VirtualNetworkPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkName, final VirtualNetwork parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkPutResponse>() { 
            @Override
            public VirtualNetworkPutResponse call() throws Exception {
                return beginCreateOrUpdating(resourceGroupName, virtualNetworkName, parameters);
            }
         });
    }
    
    /**
    * The Put VirtualNetwork operation creates/updates a virtual network in the
    * specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param parameters Required. Parameters supplied to the create/update
    * Virtual Network operation
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for PutVirtualNetworks API service calls.
    */
    @Override
    public VirtualNetworkPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkName, VirtualNetwork parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getSubnets() != null) {
            for (Subnet subnetsParameterItem : parameters.getSubnets()) {
                if (subnetsParameterItem.getAddressPrefix() == null) {
                    throw new NullPointerException("parameters.Subnets.AddressPrefix");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode virtualNetworkJsonFormatValue = objectMapper.createObjectNode();
        requestDoc = virtualNetworkJsonFormatValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) virtualNetworkJsonFormatValue).put("properties", propertiesValue);
        
        if (parameters.getAddressSpace() != null) {
            ObjectNode addressSpaceValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("addressSpace", addressSpaceValue);
            
            if (parameters.getAddressSpace().getAddressPrefixes() != null) {
                if (parameters.getAddressSpace().getAddressPrefixes() instanceof LazyCollection == false || ((LazyCollection) parameters.getAddressSpace().getAddressPrefixes()).isInitialized()) {
                    ArrayNode addressPrefixesArray = objectMapper.createArrayNode();
                    for (String addressPrefixesItem : parameters.getAddressSpace().getAddressPrefixes()) {
                        addressPrefixesArray.add(addressPrefixesItem);
                    }
                    ((ObjectNode) addressSpaceValue).put("addressPrefixes", addressPrefixesArray);
                }
            }
        }
        
        if (parameters.getDhcpOptions() != null) {
            ObjectNode dhcpOptionsValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("dhcpOptions", dhcpOptionsValue);
            
            if (parameters.getDhcpOptions().getDnsServers() != null) {
                if (parameters.getDhcpOptions().getDnsServers() instanceof LazyCollection == false || ((LazyCollection) parameters.getDhcpOptions().getDnsServers()).isInitialized()) {
                    ArrayNode dnsServersArray = objectMapper.createArrayNode();
                    for (String dnsServersItem : parameters.getDhcpOptions().getDnsServers()) {
                        dnsServersArray.add(dnsServersItem);
                    }
                    ((ObjectNode) dhcpOptionsValue).put("dnsServers", dnsServersArray);
                }
            }
        }
        
        if (parameters.getSubnets() != null) {
            if (parameters.getSubnets() instanceof LazyCollection == false || ((LazyCollection) parameters.getSubnets()).isInitialized()) {
                ArrayNode subnetsArray = objectMapper.createArrayNode();
                for (Subnet subnetsItem : parameters.getSubnets()) {
                    ObjectNode subnetJsonFormatValue = objectMapper.createObjectNode();
                    subnetsArray.add(subnetJsonFormatValue);
                    
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) subnetJsonFormatValue).put("properties", propertiesValue2);
                    
                    ((ObjectNode) propertiesValue2).put("addressPrefix", subnetsItem.getAddressPrefix());
                    
                    if (subnetsItem.getNetworkSecurityGroup() != null) {
                        ObjectNode networkSecurityGroupValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("networkSecurityGroup", networkSecurityGroupValue);
                        
                        if (subnetsItem.getNetworkSecurityGroup().getId() != null) {
                            ((ObjectNode) networkSecurityGroupValue).put("id", subnetsItem.getNetworkSecurityGroup().getId());
                        }
                    }
                    
                    if (subnetsItem.getRouteTable() != null) {
                        ObjectNode routeTableValue = objectMapper.createObjectNode();
                        ((ObjectNode) propertiesValue2).put("routeTable", routeTableValue);
                        
                        if (subnetsItem.getRouteTable().getId() != null) {
                            ((ObjectNode) routeTableValue).put("id", subnetsItem.getRouteTable().getId());
                        }
                    }
                    
                    if (subnetsItem.getIpConfigurations() != null) {
                        if (subnetsItem.getIpConfigurations() instanceof LazyCollection == false || ((LazyCollection) subnetsItem.getIpConfigurations()).isInitialized()) {
                            ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                            for (ResourceId ipConfigurationsItem : subnetsItem.getIpConfigurations()) {
                                ObjectNode resourceIdValue = objectMapper.createObjectNode();
                                ipConfigurationsArray.add(resourceIdValue);
                                
                                if (ipConfigurationsItem.getId() != null) {
                                    ((ObjectNode) resourceIdValue).put("id", ipConfigurationsItem.getId());
                                }
                            }
                            ((ObjectNode) propertiesValue2).put("ipConfigurations", ipConfigurationsArray);
                        }
                    }
                    
                    if (subnetsItem.getProvisioningState() != null) {
                        ((ObjectNode) propertiesValue2).put("provisioningState", subnetsItem.getProvisioningState());
                    }
                    
                    if (subnetsItem.getName() != null) {
                        ((ObjectNode) subnetJsonFormatValue).put("name", subnetsItem.getName());
                    }
                    
                    if (subnetsItem.getEtag() != null) {
                        ((ObjectNode) subnetJsonFormatValue).put("etag", subnetsItem.getEtag());
                    }
                    
                    if (subnetsItem.getId() != null) {
                        ((ObjectNode) subnetJsonFormatValue).put("id", subnetsItem.getId());
                    }
                }
                ((ObjectNode) propertiesValue).put("subnets", subnetsArray);
            }
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getEtag() != null) {
            ((ObjectNode) virtualNetworkJsonFormatValue).put("etag", parameters.getEtag());
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) virtualNetworkJsonFormatValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) virtualNetworkJsonFormatValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) virtualNetworkJsonFormatValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) virtualNetworkJsonFormatValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) virtualNetworkJsonFormatValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkPutResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkPutResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualNetwork virtualNetworkInstance = new VirtualNetwork();
                    result.setVirtualNetwork(virtualNetworkInstance);
                    
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                        JsonNode addressSpaceValue2 = propertiesValue3.get("addressSpace");
                        if (addressSpaceValue2 != null && addressSpaceValue2 instanceof NullNode == false) {
                            AddressSpace addressSpaceInstance = new AddressSpace();
                            virtualNetworkInstance.setAddressSpace(addressSpaceInstance);
                            
                            JsonNode addressPrefixesArray2 = addressSpaceValue2.get("addressPrefixes");
                            if (addressPrefixesArray2 != null && addressPrefixesArray2 instanceof NullNode == false) {
                                for (JsonNode addressPrefixesValue : ((ArrayNode) addressPrefixesArray2)) {
                                    addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                }
                            }
                        }
                        
                        JsonNode dhcpOptionsValue2 = propertiesValue3.get("dhcpOptions");
                        if (dhcpOptionsValue2 != null && dhcpOptionsValue2 instanceof NullNode == false) {
                            DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                            virtualNetworkInstance.setDhcpOptions(dhcpOptionsInstance);
                            
                            JsonNode dnsServersArray2 = dhcpOptionsValue2.get("dnsServers");
                            if (dnsServersArray2 != null && dnsServersArray2 instanceof NullNode == false) {
                                for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray2)) {
                                    dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                        }
                        
                        JsonNode subnetsArray2 = propertiesValue3.get("subnets");
                        if (subnetsArray2 != null && subnetsArray2 instanceof NullNode == false) {
                            for (JsonNode subnetsValue : ((ArrayNode) subnetsArray2)) {
                                Subnet subnetJsonFormatInstance = new Subnet();
                                virtualNetworkInstance.getSubnets().add(subnetJsonFormatInstance);
                                
                                JsonNode propertiesValue4 = subnetsValue.get("properties");
                                if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                    JsonNode addressPrefixValue = propertiesValue4.get("addressPrefix");
                                    if (addressPrefixValue != null && addressPrefixValue instanceof NullNode == false) {
                                        String addressPrefixInstance;
                                        addressPrefixInstance = addressPrefixValue.getTextValue();
                                        subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                    }
                                    
                                    JsonNode networkSecurityGroupValue2 = propertiesValue4.get("networkSecurityGroup");
                                    if (networkSecurityGroupValue2 != null && networkSecurityGroupValue2 instanceof NullNode == false) {
                                        ResourceId networkSecurityGroupInstance = new ResourceId();
                                        subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                        
                                        JsonNode idValue = networkSecurityGroupValue2.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            networkSecurityGroupInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode routeTableValue2 = propertiesValue4.get("routeTable");
                                    if (routeTableValue2 != null && routeTableValue2 instanceof NullNode == false) {
                                        ResourceId routeTableInstance = new ResourceId();
                                        subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                        
                                        JsonNode idValue2 = routeTableValue2.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            routeTableInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode ipConfigurationsArray2 = propertiesValue4.get("ipConfigurations");
                                    if (ipConfigurationsArray2 != null && ipConfigurationsArray2 instanceof NullNode == false) {
                                        for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray2)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                            
                                            JsonNode idValue3 = ipConfigurationsValue.get("id");
                                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                String idInstance3;
                                                idInstance3 = idValue3.getTextValue();
                                                resourceIdInstance.setId(idInstance3);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue4.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = subnetsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    subnetJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = subnetsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    subnetJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue4 = subnetsValue.get("id");
                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                    String idInstance4;
                                    idInstance4 = idValue4.getTextValue();
                                    subnetJsonFormatInstance.setId(idInstance4);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                            String provisioningStateInstance2;
                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    
                    JsonNode etagValue2 = responseDoc.get("etag");
                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                        String etagInstance2;
                        etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkInstance.setEtag(etagInstance2);
                    }
                    
                    JsonNode idValue5 = responseDoc.get("id");
                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                        String idInstance5;
                        idInstance5 = idValue5.getTextValue();
                        virtualNetworkInstance.setId(idInstance5);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        virtualNetworkInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualNetworkInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            virtualNetworkInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && codeValue instanceof NullNode == false) {
                            String codeInstance;
                            codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        
                        JsonNode messageValue = errorValue.get("message");
                        if (messageValue != null && messageValue instanceof NullNode == false) {
                            String messageInstance;
                            messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        
                        JsonNode targetValue = errorValue.get("target");
                        if (targetValue != null && targetValue instanceof NullNode == false) {
                            String targetInstance;
                            targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                    String codeInstance2;
                                    codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                
                                JsonNode targetValue2 = detailsValue.get("target");
                                if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                                    String targetInstance2;
                                    targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                
                                JsonNode messageValue2 = detailsValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    errorDetailsInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        JsonNode innerErrorValue = errorValue.get("innerError");
                        if (innerErrorValue != null && innerErrorValue instanceof NullNode == false) {
                            String innerErrorInstance;
                            innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Delete VirtualNetwork operation deletes the specifed virtual network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>() { 
            @Override
            public UpdateOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, virtualNetworkName);
            }
         });
    }
    
    /**
    * The Delete VirtualNetwork operation deletes the specifed virtual network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return If the resource provide needs to return an error to any
    * operation, it should return the appropriate HTTP error code and a
    * message body as can be seen below.The message should be localized per
    * the Accept-Language header specified in the original request such thatit
    * could be directly be exposed to users
    */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            UpdateOperationResponse result = null;
            // Deserialize Response
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Put VirtualNetwork operation creates/updates a virtual networkin the
    * specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param parameters Required. Parameters supplied to the create/update
    * Virtual Network operation
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkName, final VirtualNetwork parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>() { 
            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, virtualNetworkName, parameters);
            }
         });
    }
    
    /**
    * The Put VirtualNetwork operation creates/updates a virtual networkin the
    * specified resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @param parameters Required. Parameters supplied to the create/update
    * Virtual Network operation
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkName, VirtualNetwork parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualNetworkPutResponse response = client2.getVirtualNetworksOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete VirtualNetwork operation deletes the specifed virtual network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, virtualNetworkName);
            }
         });
    }
    
    /**
    * The Delete VirtualNetwork operation deletes the specifed virtual network
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            UpdateOperationResponse response = client2.getVirtualNetworksOperations().beginDeletingAsync(resourceGroupName, virtualNetworkName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get VirtualNetwork operation retrieves information about the
    * specified virtual network.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @return Response for GetVirtualNetworks API service calls.
    */
    @Override
    public Future<VirtualNetworkGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGetResponse>() { 
            @Override
            public VirtualNetworkGetResponse call() throws Exception {
                return get(resourceGroupName, virtualNetworkName);
            }
         });
    }
    
    /**
    * The Get VirtualNetwork operation retrieves information about the
    * specified virtual network.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param virtualNetworkName Required. The name of the virtual network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for GetVirtualNetworks API service calls.
    */
    @Override
    public VirtualNetworkGetResponse get(String resourceGroupName, String virtualNetworkName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualNetwork virtualNetworkInstance = new VirtualNetwork();
                    result.setVirtualNetwork(virtualNetworkInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode addressSpaceValue = propertiesValue.get("addressSpace");
                        if (addressSpaceValue != null && addressSpaceValue instanceof NullNode == false) {
                            AddressSpace addressSpaceInstance = new AddressSpace();
                            virtualNetworkInstance.setAddressSpace(addressSpaceInstance);
                            
                            JsonNode addressPrefixesArray = addressSpaceValue.get("addressPrefixes");
                            if (addressPrefixesArray != null && addressPrefixesArray instanceof NullNode == false) {
                                for (JsonNode addressPrefixesValue : ((ArrayNode) addressPrefixesArray)) {
                                    addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                }
                            }
                        }
                        
                        JsonNode dhcpOptionsValue = propertiesValue.get("dhcpOptions");
                        if (dhcpOptionsValue != null && dhcpOptionsValue instanceof NullNode == false) {
                            DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                            virtualNetworkInstance.setDhcpOptions(dhcpOptionsInstance);
                            
                            JsonNode dnsServersArray = dhcpOptionsValue.get("dnsServers");
                            if (dnsServersArray != null && dnsServersArray instanceof NullNode == false) {
                                for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray)) {
                                    dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                        }
                        
                        JsonNode subnetsArray = propertiesValue.get("subnets");
                        if (subnetsArray != null && subnetsArray instanceof NullNode == false) {
                            for (JsonNode subnetsValue : ((ArrayNode) subnetsArray)) {
                                Subnet subnetJsonFormatInstance = new Subnet();
                                virtualNetworkInstance.getSubnets().add(subnetJsonFormatInstance);
                                
                                JsonNode propertiesValue2 = subnetsValue.get("properties");
                                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                    JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                    if (addressPrefixValue != null && addressPrefixValue instanceof NullNode == false) {
                                        String addressPrefixInstance;
                                        addressPrefixInstance = addressPrefixValue.getTextValue();
                                        subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                    }
                                    
                                    JsonNode networkSecurityGroupValue = propertiesValue2.get("networkSecurityGroup");
                                    if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                                        ResourceId networkSecurityGroupInstance = new ResourceId();
                                        subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                        
                                        JsonNode idValue = networkSecurityGroupValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            networkSecurityGroupInstance.setId(idInstance);
                                        }
                                    }
                                    
                                    JsonNode routeTableValue = propertiesValue2.get("routeTable");
                                    if (routeTableValue != null && routeTableValue instanceof NullNode == false) {
                                        ResourceId routeTableInstance = new ResourceId();
                                        subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                        
                                        JsonNode idValue2 = routeTableValue.get("id");
                                        if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                            String idInstance2;
                                            idInstance2 = idValue2.getTextValue();
                                            routeTableInstance.setId(idInstance2);
                                        }
                                    }
                                    
                                    JsonNode ipConfigurationsArray = propertiesValue2.get("ipConfigurations");
                                    if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                        for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                            
                                            JsonNode idValue3 = ipConfigurationsValue.get("id");
                                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                String idInstance3;
                                                idInstance3 = idValue3.getTextValue();
                                                resourceIdInstance.setId(idInstance3);
                                            }
                                        }
                                    }
                                    
                                    JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                    if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                        String provisioningStateInstance;
                                        provisioningStateInstance = provisioningStateValue.getTextValue();
                                        subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                
                                JsonNode nameValue = subnetsValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    subnetJsonFormatInstance.setName(nameInstance);
                                }
                                
                                JsonNode etagValue = subnetsValue.get("etag");
                                if (etagValue != null && etagValue instanceof NullNode == false) {
                                    String etagInstance;
                                    etagInstance = etagValue.getTextValue();
                                    subnetJsonFormatInstance.setEtag(etagInstance);
                                }
                                
                                JsonNode idValue4 = subnetsValue.get("id");
                                if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                    String idInstance4;
                                    idInstance4 = idValue4.getTextValue();
                                    subnetJsonFormatInstance.setId(idInstance4);
                                }
                            }
                        }
                        
                        JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                            String provisioningStateInstance2;
                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    
                    JsonNode etagValue2 = responseDoc.get("etag");
                    if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                        String etagInstance2;
                        etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkInstance.setEtag(etagInstance2);
                    }
                    
                    JsonNode idValue5 = responseDoc.get("id");
                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                        String idInstance5;
                        idInstance5 = idValue5.getTextValue();
                        virtualNetworkInstance.setId(idInstance5);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        virtualNetworkInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualNetworkInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            virtualNetworkInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The list VirtualNetwork returns all Virtual Networks in a resource group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return Response for ListVirtualNetworks Api servive call
    */
    @Override
    public Future<VirtualNetworkListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkListResponse>() { 
            @Override
            public VirtualNetworkListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The list VirtualNetwork returns all Virtual Networks in a resource group
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListVirtualNetworks Api servive call
    */
    @Override
    public VirtualNetworkListResponse list(String resourceGroupName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualNetwork virtualNetworkJsonFormatInstance = new VirtualNetwork();
                            result.getVirtualNetworks().add(virtualNetworkJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode addressSpaceValue = propertiesValue.get("addressSpace");
                                if (addressSpaceValue != null && addressSpaceValue instanceof NullNode == false) {
                                    AddressSpace addressSpaceInstance = new AddressSpace();
                                    virtualNetworkJsonFormatInstance.setAddressSpace(addressSpaceInstance);
                                    
                                    JsonNode addressPrefixesArray = addressSpaceValue.get("addressPrefixes");
                                    if (addressPrefixesArray != null && addressPrefixesArray instanceof NullNode == false) {
                                        for (JsonNode addressPrefixesValue : ((ArrayNode) addressPrefixesArray)) {
                                            addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                        }
                                    }
                                }
                                
                                JsonNode dhcpOptionsValue = propertiesValue.get("dhcpOptions");
                                if (dhcpOptionsValue != null && dhcpOptionsValue instanceof NullNode == false) {
                                    DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                                    virtualNetworkJsonFormatInstance.setDhcpOptions(dhcpOptionsInstance);
                                    
                                    JsonNode dnsServersArray = dhcpOptionsValue.get("dnsServers");
                                    if (dnsServersArray != null && dnsServersArray instanceof NullNode == false) {
                                        for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray)) {
                                            dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                }
                                
                                JsonNode subnetsArray = propertiesValue.get("subnets");
                                if (subnetsArray != null && subnetsArray instanceof NullNode == false) {
                                    for (JsonNode subnetsValue : ((ArrayNode) subnetsArray)) {
                                        Subnet subnetJsonFormatInstance = new Subnet();
                                        virtualNetworkJsonFormatInstance.getSubnets().add(subnetJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = subnetsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                            if (addressPrefixValue != null && addressPrefixValue instanceof NullNode == false) {
                                                String addressPrefixInstance;
                                                addressPrefixInstance = addressPrefixValue.getTextValue();
                                                subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                            }
                                            
                                            JsonNode networkSecurityGroupValue = propertiesValue2.get("networkSecurityGroup");
                                            if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                                                ResourceId networkSecurityGroupInstance = new ResourceId();
                                                subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                                
                                                JsonNode idValue = networkSecurityGroupValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    networkSecurityGroupInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode routeTableValue = propertiesValue2.get("routeTable");
                                            if (routeTableValue != null && routeTableValue instanceof NullNode == false) {
                                                ResourceId routeTableInstance = new ResourceId();
                                                subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                                
                                                JsonNode idValue2 = routeTableValue.get("id");
                                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                    String idInstance2;
                                                    idInstance2 = idValue2.getTextValue();
                                                    routeTableInstance.setId(idInstance2);
                                                }
                                            }
                                            
                                            JsonNode ipConfigurationsArray = propertiesValue2.get("ipConfigurations");
                                            if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                                for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue3 = ipConfigurationsValue.get("id");
                                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                        String idInstance3;
                                                        idInstance3 = idValue3.getTextValue();
                                                        resourceIdInstance.setId(idInstance3);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = subnetsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            subnetJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = subnetsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            subnetJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue4 = subnetsValue.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            subnetJsonFormatInstance.setId(idInstance4);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualNetworkJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            
                            JsonNode etagValue2 = valueValue.get("etag");
                            if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                String etagInstance2;
                                etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setEtag(etagInstance2);
                            }
                            
                            JsonNode idValue5 = valueValue.get("id");
                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                String idInstance5;
                                idInstance5 = idValue5.getTextValue();
                                virtualNetworkJsonFormatInstance.setId(idInstance5);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    virtualNetworkJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The list VirtualNetwork returns all Virtual Networks in a subscription
    *
    * @return Response for ListVirtualNetworks Api servive call
    */
    @Override
    public Future<VirtualNetworkListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkListResponse>() { 
            @Override
            public VirtualNetworkListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * The list VirtualNetwork returns all Virtual Networks in a subscription
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response for ListVirtualNetworks Api servive call
    */
    @Override
    public VirtualNetworkListResponse listAll() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualNetworkListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualNetwork virtualNetworkJsonFormatInstance = new VirtualNetwork();
                            result.getVirtualNetworks().add(virtualNetworkJsonFormatInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode addressSpaceValue = propertiesValue.get("addressSpace");
                                if (addressSpaceValue != null && addressSpaceValue instanceof NullNode == false) {
                                    AddressSpace addressSpaceInstance = new AddressSpace();
                                    virtualNetworkJsonFormatInstance.setAddressSpace(addressSpaceInstance);
                                    
                                    JsonNode addressPrefixesArray = addressSpaceValue.get("addressPrefixes");
                                    if (addressPrefixesArray != null && addressPrefixesArray instanceof NullNode == false) {
                                        for (JsonNode addressPrefixesValue : ((ArrayNode) addressPrefixesArray)) {
                                            addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                        }
                                    }
                                }
                                
                                JsonNode dhcpOptionsValue = propertiesValue.get("dhcpOptions");
                                if (dhcpOptionsValue != null && dhcpOptionsValue instanceof NullNode == false) {
                                    DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                                    virtualNetworkJsonFormatInstance.setDhcpOptions(dhcpOptionsInstance);
                                    
                                    JsonNode dnsServersArray = dhcpOptionsValue.get("dnsServers");
                                    if (dnsServersArray != null && dnsServersArray instanceof NullNode == false) {
                                        for (JsonNode dnsServersValue : ((ArrayNode) dnsServersArray)) {
                                            dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                }
                                
                                JsonNode subnetsArray = propertiesValue.get("subnets");
                                if (subnetsArray != null && subnetsArray instanceof NullNode == false) {
                                    for (JsonNode subnetsValue : ((ArrayNode) subnetsArray)) {
                                        Subnet subnetJsonFormatInstance = new Subnet();
                                        virtualNetworkJsonFormatInstance.getSubnets().add(subnetJsonFormatInstance);
                                        
                                        JsonNode propertiesValue2 = subnetsValue.get("properties");
                                        if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                            JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                            if (addressPrefixValue != null && addressPrefixValue instanceof NullNode == false) {
                                                String addressPrefixInstance;
                                                addressPrefixInstance = addressPrefixValue.getTextValue();
                                                subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                            }
                                            
                                            JsonNode networkSecurityGroupValue = propertiesValue2.get("networkSecurityGroup");
                                            if (networkSecurityGroupValue != null && networkSecurityGroupValue instanceof NullNode == false) {
                                                ResourceId networkSecurityGroupInstance = new ResourceId();
                                                subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                                
                                                JsonNode idValue = networkSecurityGroupValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    networkSecurityGroupInstance.setId(idInstance);
                                                }
                                            }
                                            
                                            JsonNode routeTableValue = propertiesValue2.get("routeTable");
                                            if (routeTableValue != null && routeTableValue instanceof NullNode == false) {
                                                ResourceId routeTableInstance = new ResourceId();
                                                subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                                
                                                JsonNode idValue2 = routeTableValue.get("id");
                                                if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                    String idInstance2;
                                                    idInstance2 = idValue2.getTextValue();
                                                    routeTableInstance.setId(idInstance2);
                                                }
                                            }
                                            
                                            JsonNode ipConfigurationsArray = propertiesValue2.get("ipConfigurations");
                                            if (ipConfigurationsArray != null && ipConfigurationsArray instanceof NullNode == false) {
                                                for (JsonNode ipConfigurationsValue : ((ArrayNode) ipConfigurationsArray)) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                                    
                                                    JsonNode idValue3 = ipConfigurationsValue.get("id");
                                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                                        String idInstance3;
                                                        idInstance3 = idValue3.getTextValue();
                                                        resourceIdInstance.setId(idInstance3);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                                            if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                                String provisioningStateInstance;
                                                provisioningStateInstance = provisioningStateValue.getTextValue();
                                                subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        
                                        JsonNode nameValue = subnetsValue.get("name");
                                        if (nameValue != null && nameValue instanceof NullNode == false) {
                                            String nameInstance;
                                            nameInstance = nameValue.getTextValue();
                                            subnetJsonFormatInstance.setName(nameInstance);
                                        }
                                        
                                        JsonNode etagValue = subnetsValue.get("etag");
                                        if (etagValue != null && etagValue instanceof NullNode == false) {
                                            String etagInstance;
                                            etagInstance = etagValue.getTextValue();
                                            subnetJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        
                                        JsonNode idValue4 = subnetsValue.get("id");
                                        if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                            String idInstance4;
                                            idInstance4 = idValue4.getTextValue();
                                            subnetJsonFormatInstance.setId(idInstance4);
                                        }
                                    }
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualNetworkJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            
                            JsonNode etagValue2 = valueValue.get("etag");
                            if (etagValue2 != null && etagValue2 instanceof NullNode == false) {
                                String etagInstance2;
                                etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setEtag(etagInstance2);
                            }
                            
                            JsonNode idValue5 = valueValue.get("id");
                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                String idInstance5;
                                idInstance5 = idValue5.getTextValue();
                                virtualNetworkJsonFormatInstance.setId(idInstance5);
                            }
                            
                            JsonNode nameValue2 = valueValue.get("name");
                            if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                String nameInstance2;
                                nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setName(nameInstance2);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    virtualNetworkJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
