/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Backend Address Pool of application gateway
*/
public class ApplicationGatewayBackendAddressPool extends ChildResource {
    private ArrayList<ApplicationGatewayBackendAddress> backendAddresses;
    
    /**
    * Optional. Gets or sets the backend addresses
    * @return The BackendAddresses value.
    */
    public ArrayList<ApplicationGatewayBackendAddress> getBackendAddresses() {
        return this.backendAddresses;
    }
    
    /**
    * Optional. Gets or sets the backend addresses
    * @param backendAddressesValue The BackendAddresses value.
    */
    public void setBackendAddresses(final ArrayList<ApplicationGatewayBackendAddress> backendAddressesValue) {
        this.backendAddresses = backendAddressesValue;
    }
    
    private ArrayList<ResourceId> backendIPConfigurations;
    
    /**
    * Optional. Gets or sets backendIPConfiguration of application gateway
    * @return The BackendIPConfigurations value.
    */
    public ArrayList<ResourceId> getBackendIPConfigurations() {
        return this.backendIPConfigurations;
    }
    
    /**
    * Optional. Gets or sets backendIPConfiguration of application gateway
    * @param backendIPConfigurationsValue The BackendIPConfigurations value.
    */
    public void setBackendIPConfigurations(final ArrayList<ResourceId> backendIPConfigurationsValue) {
        this.backendIPConfigurations = backendIPConfigurationsValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the backend address pool
    * resource Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the backend address pool
    * resource Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    /**
    * Initializes a new instance of the ApplicationGatewayBackendAddressPool
    * class.
    *
    */
    public ApplicationGatewayBackendAddressPool() {
        super();
        this.setBackendAddresses(new LazyArrayList<ApplicationGatewayBackendAddress>());
        this.setBackendIPConfigurations(new LazyArrayList<ResourceId>());
    }
}
