/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

/**
* Frontend IP configuration of application gateway
*/
public class ApplicationGatewayFrontendIPConfiguration extends ChildResource {
    private String privateIPAddress;
    
    /**
    * Optional. Gets or sets the privateIPAddress of the Network Interface IP
    * Configuration
    * @return The PrivateIPAddress value.
    */
    public String getPrivateIPAddress() {
        return this.privateIPAddress;
    }
    
    /**
    * Optional. Gets or sets the privateIPAddress of the Network Interface IP
    * Configuration
    * @param privateIPAddressValue The PrivateIPAddress value.
    */
    public void setPrivateIPAddress(final String privateIPAddressValue) {
        this.privateIPAddress = privateIPAddressValue;
    }
    
    private String privateIPAllocationMethod;
    
    /**
    * Optional. Gets or sets PrivateIP allocation method (Static/Dynamic)
    * @return The PrivateIPAllocationMethod value.
    */
    public String getPrivateIPAllocationMethod() {
        return this.privateIPAllocationMethod;
    }
    
    /**
    * Optional. Gets or sets PrivateIP allocation method (Static/Dynamic)
    * @param privateIPAllocationMethodValue The PrivateIPAllocationMethod value.
    */
    public void setPrivateIPAllocationMethod(final String privateIPAllocationMethodValue) {
        this.privateIPAllocationMethod = privateIPAllocationMethodValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private ResourceId publicIPAddress;
    
    /**
    * Optional. Gets or sets the reference of the PublicIP resource
    * @return The PublicIPAddress value.
    */
    public ResourceId getPublicIPAddress() {
        return this.publicIPAddress;
    }
    
    /**
    * Optional. Gets or sets the reference of the PublicIP resource
    * @param publicIPAddressValue The PublicIPAddress value.
    */
    public void setPublicIPAddress(final ResourceId publicIPAddressValue) {
        this.publicIPAddress = publicIPAddressValue;
    }
    
    private ResourceId subnet;
    
    /**
    * Optional. Gets or sets the reference of the subnet resource
    * @return The Subnet value.
    */
    public ResourceId getSubnet() {
        return this.subnet;
    }
    
    /**
    * Optional. Gets or sets the reference of the subnet resource
    * @param subnetValue The Subnet value.
    */
    public void setSubnet(final ResourceId subnetValue) {
        this.subnet = subnetValue;
    }
}
