/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

/**
* Http listener of application gateway
*/
public class ApplicationGatewayHttpListener extends ChildResource {
    private ResourceId frontendIPConfiguration;
    
    /**
    * Optional. Gets or sets frontend IP configuration resource of application
    * gateway
    * @return The FrontendIPConfiguration value.
    */
    public ResourceId getFrontendIPConfiguration() {
        return this.frontendIPConfiguration;
    }
    
    /**
    * Optional. Gets or sets frontend IP configuration resource of application
    * gateway
    * @param frontendIPConfigurationValue The FrontendIPConfiguration value.
    */
    public void setFrontendIPConfiguration(final ResourceId frontendIPConfigurationValue) {
        this.frontendIPConfiguration = frontendIPConfigurationValue;
    }
    
    private ResourceId frontendPort;
    
    /**
    * Optional. Gets or sets frontend port resource of application gateway
    * @return The FrontendPort value.
    */
    public ResourceId getFrontendPort() {
        return this.frontendPort;
    }
    
    /**
    * Optional. Gets or sets frontend port resource of application gateway
    * @param frontendPortValue The FrontendPort value.
    */
    public void setFrontendPort(final ResourceId frontendPortValue) {
        this.frontendPort = frontendPortValue;
    }
    
    private String protocol;
    
    /**
    * Optional. Gets or sets the protocol
    * @return The Protocol value.
    */
    public String getProtocol() {
        return this.protocol;
    }
    
    /**
    * Optional. Gets or sets the protocol
    * @param protocolValue The Protocol value.
    */
    public void setProtocol(final String protocolValue) {
        this.protocol = protocolValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the http listener resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the http listener resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private ResourceId sslCertificate;
    
    /**
    * Optional. Gets or sets ssl certificate resource of application gateway
    * @return The SslCertificate value.
    */
    public ResourceId getSslCertificate() {
        return this.sslCertificate;
    }
    
    /**
    * Optional. Gets or sets ssl certificate resource of application gateway
    * @param sslCertificateValue The SslCertificate value.
    */
    public void setSslCertificate(final ResourceId sslCertificateValue) {
        this.sslCertificate = sslCertificateValue;
    }
}
