/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

/**
* Request routing rule of application gateway
*/
public class ApplicationGatewayRequestRoutingRule extends ChildResource {
    private ResourceId backendAddressPool;
    
    /**
    * Optional. Gets or sets backend address pool resource of application
    * gateway
    * @return The BackendAddressPool value.
    */
    public ResourceId getBackendAddressPool() {
        return this.backendAddressPool;
    }
    
    /**
    * Optional. Gets or sets backend address pool resource of application
    * gateway
    * @param backendAddressPoolValue The BackendAddressPool value.
    */
    public void setBackendAddressPool(final ResourceId backendAddressPoolValue) {
        this.backendAddressPool = backendAddressPoolValue;
    }
    
    private ResourceId backendHttpSettings;
    
    /**
    * Optional. Gets or sets frontend port resource of application gateway
    * @return The BackendHttpSettings value.
    */
    public ResourceId getBackendHttpSettings() {
        return this.backendHttpSettings;
    }
    
    /**
    * Optional. Gets or sets frontend port resource of application gateway
    * @param backendHttpSettingsValue The BackendHttpSettings value.
    */
    public void setBackendHttpSettings(final ResourceId backendHttpSettingsValue) {
        this.backendHttpSettings = backendHttpSettingsValue;
    }
    
    private ResourceId httpListener;
    
    /**
    * Optional. Gets or sets http listener resource of application gateway
    * @return The HttpListener value.
    */
    public ResourceId getHttpListener() {
        return this.httpListener;
    }
    
    /**
    * Optional. Gets or sets http listener resource of application gateway
    * @param httpListenerValue The HttpListener value.
    */
    public void setHttpListener(final ResourceId httpListenerValue) {
        this.httpListener = httpListenerValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the request routing rule
    * resource Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the request routing rule
    * resource Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private String ruleType;
    
    /**
    * Optional. Gets or sets the rule type
    * @return The RuleType value.
    */
    public String getRuleType() {
        return this.ruleType;
    }
    
    /**
    * Optional. Gets or sets the rule type
    * @param ruleTypeValue The RuleType value.
    */
    public void setRuleType(final String ruleTypeValue) {
        this.ruleType = ruleTypeValue;
    }
}
