/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Pool of backend IP addresseses
*/
public class BackendAddressPool extends ChildResource {
    private ArrayList<ResourceId> backendIpConfigurations;
    
    /**
    * Optional. Gets collection of references to IPs defined in NICs
    * @return The BackendIpConfigurations value.
    */
    public ArrayList<ResourceId> getBackendIpConfigurations() {
        return this.backendIpConfigurations;
    }
    
    /**
    * Optional. Gets collection of references to IPs defined in NICs
    * @param backendIpConfigurationsValue The BackendIpConfigurations value.
    */
    public void setBackendIpConfigurations(final ArrayList<ResourceId> backendIpConfigurationsValue) {
        this.backendIpConfigurations = backendIpConfigurationsValue;
    }
    
    private ArrayList<ResourceId> loadBalancingRules;
    
    /**
    * Optional. Gets Load Balancing rules that use this Backend Address Pool
    * @return The LoadBalancingRules value.
    */
    public ArrayList<ResourceId> getLoadBalancingRules() {
        return this.loadBalancingRules;
    }
    
    /**
    * Optional. Gets Load Balancing rules that use this Backend Address Pool
    * @param loadBalancingRulesValue The LoadBalancingRules value.
    */
    public void setLoadBalancingRules(final ArrayList<ResourceId> loadBalancingRulesValue) {
        this.loadBalancingRules = loadBalancingRulesValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    /**
    * Initializes a new instance of the BackendAddressPool class.
    *
    */
    public BackendAddressPool() {
        super();
        this.setBackendIpConfigurations(new LazyArrayList<ResourceId>());
        this.setLoadBalancingRules(new LazyArrayList<ResourceId>());
    }
}
