/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

/**
* A common class for general resource information
*/
public class LocalNetworkGateway extends TopLevelResource {
    private String gatewayIpAddress;
    
    /**
    * Optional. IP address of local network gateway.
    * @return The GatewayIpAddress value.
    */
    public String getGatewayIpAddress() {
        return this.gatewayIpAddress;
    }
    
    /**
    * Optional. IP address of local network gateway.
    * @param gatewayIpAddressValue The GatewayIpAddress value.
    */
    public void setGatewayIpAddress(final String gatewayIpAddressValue) {
        this.gatewayIpAddress = gatewayIpAddressValue;
    }
    
    private AddressSpace localNetworkAddressSpace;
    
    /**
    * Optional. Local network site Address space
    * @return The LocalNetworkAddressSpace value.
    */
    public AddressSpace getLocalNetworkAddressSpace() {
        return this.localNetworkAddressSpace;
    }
    
    /**
    * Optional. Local network site Address space
    * @param localNetworkAddressSpaceValue The LocalNetworkAddressSpace value.
    */
    public void setLocalNetworkAddressSpace(final AddressSpace localNetworkAddressSpaceValue) {
        this.localNetworkAddressSpace = localNetworkAddressSpaceValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the LocalNetworkGateway
    * resource Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the LocalNetworkGateway
    * resource Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    /**
    * Initializes a new instance of the LocalNetworkGateway class.
    *
    */
    public LocalNetworkGateway() {
        super();
    }
    
    /**
    * Initializes a new instance of the LocalNetworkGateway class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public LocalNetworkGateway(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
