/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* NetworkSecurityGroup resource
*/
public class NetworkSecurityGroup extends TopLevelResource {
    private ArrayList<SecurityRule> defaultSecurityRules;
    
    /**
    * Optional. Gets or sets Default security rules of network security group
    * @return The DefaultSecurityRules value.
    */
    public ArrayList<SecurityRule> getDefaultSecurityRules() {
        return this.defaultSecurityRules;
    }
    
    /**
    * Optional. Gets or sets Default security rules of network security group
    * @param defaultSecurityRulesValue The DefaultSecurityRules value.
    */
    public void setDefaultSecurityRules(final ArrayList<SecurityRule> defaultSecurityRulesValue) {
        this.defaultSecurityRules = defaultSecurityRulesValue;
    }
    
    private ArrayList<ResourceId> networkInterfaces;
    
    /**
    * Optional. Gets collection of references to Network Interfaces
    * @return The NetworkInterfaces value.
    */
    public ArrayList<ResourceId> getNetworkInterfaces() {
        return this.networkInterfaces;
    }
    
    /**
    * Optional. Gets collection of references to Network Interfaces
    * @param networkInterfacesValue The NetworkInterfaces value.
    */
    public void setNetworkInterfaces(final ArrayList<ResourceId> networkInterfacesValue) {
        this.networkInterfaces = networkInterfacesValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private ArrayList<SecurityRule> securityRules;
    
    /**
    * Optional. Gets or sets Security rules of network security group
    * @return The SecurityRules value.
    */
    public ArrayList<SecurityRule> getSecurityRules() {
        return this.securityRules;
    }
    
    /**
    * Optional. Gets or sets Security rules of network security group
    * @param securityRulesValue The SecurityRules value.
    */
    public void setSecurityRules(final ArrayList<SecurityRule> securityRulesValue) {
        this.securityRules = securityRulesValue;
    }
    
    private ArrayList<ResourceId> subnets;
    
    /**
    * Optional. Gets collection of references to subnets
    * @return The Subnets value.
    */
    public ArrayList<ResourceId> getSubnets() {
        return this.subnets;
    }
    
    /**
    * Optional. Gets collection of references to subnets
    * @param subnetsValue The Subnets value.
    */
    public void setSubnets(final ArrayList<ResourceId> subnetsValue) {
        this.subnets = subnetsValue;
    }
    
    /**
    * Initializes a new instance of the NetworkSecurityGroup class.
    *
    */
    public NetworkSecurityGroup() {
        super();
        this.setDefaultSecurityRules(new LazyArrayList<SecurityRule>());
        this.setNetworkInterfaces(new LazyArrayList<ResourceId>());
        this.setSecurityRules(new LazyArrayList<SecurityRule>());
        this.setSubnets(new LazyArrayList<ResourceId>());
    }
    
    /**
    * Initializes a new instance of the NetworkSecurityGroup class with
    * required arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public NetworkSecurityGroup(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
