/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Load balancer Probe
*/
public class Probe extends ChildResource {
    private int intervalInSeconds;
    
    /**
    * Optional. Gets or sets the interval, in seconds, for how frequently to
    * probe the endpoint for health status. Typically, the interval is
    * slightly less than half the allocated timeout period (in seconds) which
    * allows two full probes before taking the instance out of rotation. The
    * default value is 15, the minimum value is 5
    * @return The IntervalInSeconds value.
    */
    public int getIntervalInSeconds() {
        return this.intervalInSeconds;
    }
    
    /**
    * Optional. Gets or sets the interval, in seconds, for how frequently to
    * probe the endpoint for health status. Typically, the interval is
    * slightly less than half the allocated timeout period (in seconds) which
    * allows two full probes before taking the instance out of rotation. The
    * default value is 15, the minimum value is 5
    * @param intervalInSecondsValue The IntervalInSeconds value.
    */
    public void setIntervalInSeconds(final int intervalInSecondsValue) {
        this.intervalInSeconds = intervalInSecondsValue;
    }
    
    private ArrayList<ResourceId> loadBalancingRules;
    
    /**
    * Optional. Gets Load balancer rules that use this probe
    * @return The LoadBalancingRules value.
    */
    public ArrayList<ResourceId> getLoadBalancingRules() {
        return this.loadBalancingRules;
    }
    
    /**
    * Optional. Gets Load balancer rules that use this probe
    * @param loadBalancingRulesValue The LoadBalancingRules value.
    */
    public void setLoadBalancingRules(final ArrayList<ResourceId> loadBalancingRulesValue) {
        this.loadBalancingRules = loadBalancingRulesValue;
    }
    
    private int numberOfProbes;
    
    /**
    * Optional. Gets or sets the number of probes where if no response, will
    * result in stopping further traffic from being delivered to the endpoint.
    * This values allows endponints to be taken out of rotation faster or
    * slower than the typical times used in Azure.
    * @return The NumberOfProbes value.
    */
    public int getNumberOfProbes() {
        return this.numberOfProbes;
    }
    
    /**
    * Optional. Gets or sets the number of probes where if no response, will
    * result in stopping further traffic from being delivered to the endpoint.
    * This values allows endponints to be taken out of rotation faster or
    * slower than the typical times used in Azure.
    * @param numberOfProbesValue The NumberOfProbes value.
    */
    public void setNumberOfProbes(final int numberOfProbesValue) {
        this.numberOfProbes = numberOfProbesValue;
    }
    
    private int port;
    
    /**
    * Required. Gets or sets Port for communicating the probe. Possible values
    * range from 1 to 65535, inclusive.
    * @return The Port value.
    */
    public int getPort() {
        return this.port;
    }
    
    /**
    * Required. Gets or sets Port for communicating the probe. Possible values
    * range from 1 to 65535, inclusive.
    * @param portValue The Port value.
    */
    public void setPort(final int portValue) {
        this.port = portValue;
    }
    
    private String protocol;
    
    /**
    * Required. Gets or sets the protocol of the end point. Possible values are
    * http pr Tcp. If Tcp is specified, a received ACK is required for the
    * probe to be successful. If http is specified,a 200 OK response from the
    * specifies URI is required for the probe to be successful
    * @return The Protocol value.
    */
    public String getProtocol() {
        return this.protocol;
    }
    
    /**
    * Required. Gets or sets the protocol of the end point. Possible values are
    * http pr Tcp. If Tcp is specified, a received ACK is required for the
    * probe to be successful. If http is specified,a 200 OK response from the
    * specifies URI is required for the probe to be successful
    * @param protocolValue The Protocol value.
    */
    public void setProtocol(final String protocolValue) {
        this.protocol = protocolValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private String requestPath;
    
    /**
    * Optional. Gets or sets the URI used for requesting health status from the
    * VM. Path is required if a protocol is set to http. Otherwise, it is not
    * allowed. There is no default value
    * @return The RequestPath value.
    */
    public String getRequestPath() {
        return this.requestPath;
    }
    
    /**
    * Optional. Gets or sets the URI used for requesting health status from the
    * VM. Path is required if a protocol is set to http. Otherwise, it is not
    * allowed. There is no default value
    * @param requestPathValue The RequestPath value.
    */
    public void setRequestPath(final String requestPathValue) {
        this.requestPath = requestPathValue;
    }
    
    /**
    * Initializes a new instance of the Probe class.
    *
    */
    public Probe() {
        super();
        this.setLoadBalancingRules(new LazyArrayList<ResourceId>());
    }
    
    /**
    * Initializes a new instance of the Probe class with required arguments.
    *
    * @param protocol Gets or sets the protocol of the end point. Possible
    * values are http pr Tcp. If Tcp is specified, a received ACK is required
    * for the probe to be successful. If http is specified,a 200 OK response
    * from the specifies URI is required for the probe to be successful
    * @param port Gets or sets Port for communicating the probe. Possible
    * values range from 1 to 65535, inclusive.
    */
    public Probe(String protocol, int port) {
        this();
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        this.setProtocol(protocol);
        this.setPort(port);
    }
}
