/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* RouteTable resource
*/
public class RouteTable extends TopLevelResource {
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private ArrayList<Route> routes;
    
    /**
    * Optional. Gets or sets Routes in a Route Table
    * @return The Routes value.
    */
    public ArrayList<Route> getRoutes() {
        return this.routes;
    }
    
    /**
    * Optional. Gets or sets Routes in a Route Table
    * @param routesValue The Routes value.
    */
    public void setRoutes(final ArrayList<Route> routesValue) {
        this.routes = routesValue;
    }
    
    private ArrayList<ResourceId> subnets;
    
    /**
    * Optional. Gets collection of references to subnets
    * @return The Subnets value.
    */
    public ArrayList<ResourceId> getSubnets() {
        return this.subnets;
    }
    
    /**
    * Optional. Gets collection of references to subnets
    * @param subnetsValue The Subnets value.
    */
    public void setSubnets(final ArrayList<ResourceId> subnetsValue) {
        this.subnets = subnetsValue;
    }
    
    /**
    * Initializes a new instance of the RouteTable class.
    *
    */
    public RouteTable() {
        super();
        this.setRoutes(new LazyArrayList<Route>());
        this.setSubnets(new LazyArrayList<ResourceId>());
    }
    
    /**
    * Initializes a new instance of the RouteTable class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public RouteTable(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
