/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

/**
* Network security rule
*/
public class SecurityRule extends ChildResource {
    private String access;
    
    /**
    * Required. Gets or sets network traffic is allowed or denied. Possible
    * values are “Allow” and “Deny”
    * @return The Access value.
    */
    public String getAccess() {
        return this.access;
    }
    
    /**
    * Required. Gets or sets network traffic is allowed or denied. Possible
    * values are “Allow” and “Deny”
    * @param accessValue The Access value.
    */
    public void setAccess(final String accessValue) {
        this.access = accessValue;
    }
    
    private String description;
    
    /**
    * Optional. Gets or sets a description for this rule. Restricted to 140
    * chars.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Optional. Gets or sets a description for this rule. Restricted to 140
    * chars.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private String destinationAddressPrefix;
    
    /**
    * Required. Gets or sets destination address prefix. CIDR or source IP
    * range. Asterix “*” can also be used to match all source IPs. Default
    * tags such as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can
    * also be used.
    * @return The DestinationAddressPrefix value.
    */
    public String getDestinationAddressPrefix() {
        return this.destinationAddressPrefix;
    }
    
    /**
    * Required. Gets or sets destination address prefix. CIDR or source IP
    * range. Asterix “*” can also be used to match all source IPs. Default
    * tags such as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can
    * also be used.
    * @param destinationAddressPrefixValue The DestinationAddressPrefix value.
    */
    public void setDestinationAddressPrefix(final String destinationAddressPrefixValue) {
        this.destinationAddressPrefix = destinationAddressPrefixValue;
    }
    
    private String destinationPortRange;
    
    /**
    * Optional. Gets or sets Destination Port or Range. Integer or range
    * between 0 and 65535. Asterix “*” can also be used to match all ports.
    * @return The DestinationPortRange value.
    */
    public String getDestinationPortRange() {
        return this.destinationPortRange;
    }
    
    /**
    * Optional. Gets or sets Destination Port or Range. Integer or range
    * between 0 and 65535. Asterix “*” can also be used to match all ports.
    * @param destinationPortRangeValue The DestinationPortRange value.
    */
    public void setDestinationPortRange(final String destinationPortRangeValue) {
        this.destinationPortRange = destinationPortRangeValue;
    }
    
    private String direction;
    
    /**
    * Required. Gets or sets the direction of the rule.InBound or Outbound. The
    * direction specifies if rule will be evaluated on incoming or outcoming
    * traffic.
    * @return The Direction value.
    */
    public String getDirection() {
        return this.direction;
    }
    
    /**
    * Required. Gets or sets the direction of the rule.InBound or Outbound. The
    * direction specifies if rule will be evaluated on incoming or outcoming
    * traffic.
    * @param directionValue The Direction value.
    */
    public void setDirection(final String directionValue) {
        this.direction = directionValue;
    }
    
    private int priority;
    
    /**
    * Optional. Gets or sets the priority of the rule. The value can be between
    * 100 and 4096. The priority number must be unique for each rule in the
    * collection. The lower the priority number, the higher the priority of
    * the rule.
    * @return The Priority value.
    */
    public int getPriority() {
        return this.priority;
    }
    
    /**
    * Optional. Gets or sets the priority of the rule. The value can be between
    * 100 and 4096. The priority number must be unique for each rule in the
    * collection. The lower the priority number, the higher the priority of
    * the rule.
    * @param priorityValue The Priority value.
    */
    public void setPriority(final int priorityValue) {
        this.priority = priorityValue;
    }
    
    private String protocol;
    
    /**
    * Required. Gets or sets Network protocol this rule applies to. Can be Tcp,
    * Udp or All(*).
    * @return The Protocol value.
    */
    public String getProtocol() {
        return this.protocol;
    }
    
    /**
    * Required. Gets or sets Network protocol this rule applies to. Can be Tcp,
    * Udp or All(*).
    * @param protocolValue The Protocol value.
    */
    public void setProtocol(final String protocolValue) {
        this.protocol = protocolValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private String sourceAddressPrefix;
    
    /**
    * Required. Gets or sets source address prefix. CIDR or source IP range.
    * Asterix “*” can also be used to match all source IPs. Default tags such
    * as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be
    * used. If this is an ingress rule, specifies where network traffic
    * originates from.
    * @return The SourceAddressPrefix value.
    */
    public String getSourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }
    
    /**
    * Required. Gets or sets source address prefix. CIDR or source IP range.
    * Asterix “*” can also be used to match all source IPs. Default tags such
    * as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be
    * used. If this is an ingress rule, specifies where network traffic
    * originates from.
    * @param sourceAddressPrefixValue The SourceAddressPrefix value.
    */
    public void setSourceAddressPrefix(final String sourceAddressPrefixValue) {
        this.sourceAddressPrefix = sourceAddressPrefixValue;
    }
    
    private String sourcePortRange;
    
    /**
    * Optional. Gets or sets Source Port or Range. Integer or range between 0
    * and 65535. Asterix “*” can also be used to match all ports.
    * @return The SourcePortRange value.
    */
    public String getSourcePortRange() {
        return this.sourcePortRange;
    }
    
    /**
    * Optional. Gets or sets Source Port or Range. Integer or range between 0
    * and 65535. Asterix “*” can also be used to match all ports.
    * @param sourcePortRangeValue The SourcePortRange value.
    */
    public void setSourcePortRange(final String sourcePortRangeValue) {
        this.sourcePortRange = sourcePortRangeValue;
    }
}
