/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Subnet in a VirtualNework resource
*/
public class Subnet extends ChildResource {
    private String addressPrefix;
    
    /**
    * Required. Gets or sets Address prefix for the subnet.
    * @return The AddressPrefix value.
    */
    public String getAddressPrefix() {
        return this.addressPrefix;
    }
    
    /**
    * Required. Gets or sets Address prefix for the subnet.
    * @param addressPrefixValue The AddressPrefix value.
    */
    public void setAddressPrefix(final String addressPrefixValue) {
        this.addressPrefix = addressPrefixValue;
    }
    
    private ArrayList<ResourceId> ipConfigurations;
    
    /**
    * Optional. Gets array of references to the network interface IP
    * configurations using subnet
    * @return The IpConfigurations value.
    */
    public ArrayList<ResourceId> getIpConfigurations() {
        return this.ipConfigurations;
    }
    
    /**
    * Optional. Gets array of references to the network interface IP
    * configurations using subnet
    * @param ipConfigurationsValue The IpConfigurations value.
    */
    public void setIpConfigurations(final ArrayList<ResourceId> ipConfigurationsValue) {
        this.ipConfigurations = ipConfigurationsValue;
    }
    
    private ResourceId networkSecurityGroup;
    
    /**
    * Optional. Gets or sets the reference of the NetworkSecurityGroup resource
    * @return The NetworkSecurityGroup value.
    */
    public ResourceId getNetworkSecurityGroup() {
        return this.networkSecurityGroup;
    }
    
    /**
    * Optional. Gets or sets the reference of the NetworkSecurityGroup resource
    * @param networkSecurityGroupValue The NetworkSecurityGroup value.
    */
    public void setNetworkSecurityGroup(final ResourceId networkSecurityGroupValue) {
        this.networkSecurityGroup = networkSecurityGroupValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private ResourceId routeTable;
    
    /**
    * Optional. Gets or sets the reference of the RouteTable resource
    * @return The RouteTable value.
    */
    public ResourceId getRouteTable() {
        return this.routeTable;
    }
    
    /**
    * Optional. Gets or sets the reference of the RouteTable resource
    * @param routeTableValue The RouteTable value.
    */
    public void setRouteTable(final ResourceId routeTableValue) {
        this.routeTable = routeTableValue;
    }
    
    /**
    * Initializes a new instance of the Subnet class.
    *
    */
    public Subnet() {
        super();
        this.setIpConfigurations(new LazyArrayList<ResourceId>());
    }
    
    /**
    * Initializes a new instance of the Subnet class with required arguments.
    *
    * @param addressPrefix Gets or sets Address prefix for the subnet.
    */
    public Subnet(String addressPrefix) {
        this();
        if (addressPrefix == null) {
            throw new NullPointerException("addressPrefix");
        }
        this.setAddressPrefix(addressPrefix);
    }
}
