/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

/**
* A common class for general resource information
*/
public class TopLevelResource extends ResourceBaseExtended {
    private String etag;
    
    /**
    * Optional. Gets a unique read-only string that changes whenever the
    * resource is updated
    * @return The Etag value.
    */
    public String getEtag() {
        return this.etag;
    }
    
    /**
    * Optional. Gets a unique read-only string that changes whenever the
    * resource is updated
    * @param etagValue The Etag value.
    */
    public void setEtag(final String etagValue) {
        this.etag = etagValue;
    }
    
    /**
    * Initializes a new instance of the TopLevelResource class.
    *
    */
    public TopLevelResource() {
        super();
    }
    
    /**
    * Initializes a new instance of the TopLevelResource class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public TopLevelResource(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
