/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Virtual Network resource
*/
public class VirtualNetwork extends TopLevelResource {
    private AddressSpace addressSpace;
    
    /**
    * Optional. Gets or sets AddressSpace that contains an array of IP address
    * ranges that can be used by subnets
    * @return The AddressSpace value.
    */
    public AddressSpace getAddressSpace() {
        return this.addressSpace;
    }
    
    /**
    * Optional. Gets or sets AddressSpace that contains an array of IP address
    * ranges that can be used by subnets
    * @param addressSpaceValue The AddressSpace value.
    */
    public void setAddressSpace(final AddressSpace addressSpaceValue) {
        this.addressSpace = addressSpaceValue;
    }
    
    private DhcpOptions dhcpOptions;
    
    /**
    * Optional. Gets or sets DHCPOptions that contains an array of DNS servers
    * available to VMs deployed in the virtual network
    * @return The DhcpOptions value.
    */
    public DhcpOptions getDhcpOptions() {
        return this.dhcpOptions;
    }
    
    /**
    * Optional. Gets or sets DHCPOptions that contains an array of DNS servers
    * available to VMs deployed in the virtual network
    * @param dhcpOptionsValue The DhcpOptions value.
    */
    public void setDhcpOptions(final DhcpOptions dhcpOptionsValue) {
        this.dhcpOptions = dhcpOptionsValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the PublicIP resource
    * Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private ArrayList<Subnet> subnets;
    
    /**
    * Optional. Gets or sets List of subnets in a VirtualNetwork
    * @return The Subnets value.
    */
    public ArrayList<Subnet> getSubnets() {
        return this.subnets;
    }
    
    /**
    * Optional. Gets or sets List of subnets in a VirtualNetwork
    * @param subnetsValue The Subnets value.
    */
    public void setSubnets(final ArrayList<Subnet> subnetsValue) {
        this.subnets = subnetsValue;
    }
    
    /**
    * Initializes a new instance of the VirtualNetwork class.
    *
    */
    public VirtualNetwork() {
        super();
        this.setSubnets(new LazyArrayList<Subnet>());
    }
    
    /**
    * Initializes a new instance of the VirtualNetwork class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public VirtualNetwork(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
