/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* A common class for general resource information
*/
public class VirtualNetworkGateway extends TopLevelResource {
    private boolean enableBgp;
    
    /**
    * Optional. EnableBgp Flag
    * @return The EnableBgp value.
    */
    public boolean isEnableBgp() {
        return this.enableBgp;
    }
    
    /**
    * Optional. EnableBgp Flag
    * @param enableBgpValue The EnableBgp value.
    */
    public void setEnableBgp(final boolean enableBgpValue) {
        this.enableBgp = enableBgpValue;
    }
    
    private String gatewayType;
    
    /**
    * Optional. The type of this virtual network gateway.
    * @return The GatewayType value.
    */
    public String getGatewayType() {
        return this.gatewayType;
    }
    
    /**
    * Optional. The type of this virtual network gateway.
    * @param gatewayTypeValue The GatewayType value.
    */
    public void setGatewayType(final String gatewayTypeValue) {
        this.gatewayType = gatewayTypeValue;
    }
    
    private ArrayList<VirtualNetworkGatewayIpConfiguration> ipConfigurations;
    
    /**
    * Optional. IpConfigurations for Virtual network gateway.
    * @return The IpConfigurations value.
    */
    public ArrayList<VirtualNetworkGatewayIpConfiguration> getIpConfigurations() {
        return this.ipConfigurations;
    }
    
    /**
    * Optional. IpConfigurations for Virtual network gateway.
    * @param ipConfigurationsValue The IpConfigurations value.
    */
    public void setIpConfigurations(final ArrayList<VirtualNetworkGatewayIpConfiguration> ipConfigurationsValue) {
        this.ipConfigurations = ipConfigurationsValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the VirtualNetworkGateway
    * resource Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the VirtualNetworkGateway
    * resource Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private String vpnType;
    
    /**
    * Optional. The type of this virtual network gateway.
    * @return The VpnType value.
    */
    public String getVpnType() {
        return this.vpnType;
    }
    
    /**
    * Optional. The type of this virtual network gateway.
    * @param vpnTypeValue The VpnType value.
    */
    public void setVpnType(final String vpnTypeValue) {
        this.vpnType = vpnTypeValue;
    }
    
    /**
    * Initializes a new instance of the VirtualNetworkGateway class.
    *
    */
    public VirtualNetworkGateway() {
        super();
        this.setIpConfigurations(new LazyArrayList<VirtualNetworkGatewayIpConfiguration>());
    }
    
    /**
    * Initializes a new instance of the VirtualNetworkGateway class with
    * required arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public VirtualNetworkGateway(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
