/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.network.models;

/**
* A common class for general resource information
*/
public class VirtualNetworkGatewayConnection extends TopLevelResource {
    private String connectionType;
    
    /**
    * Optional. Gateway connection type -Ipsec/Dedicated/VpnClient/Vnet2Vnet
    * @return The ConnectionType value.
    */
    public String getConnectionType() {
        return this.connectionType;
    }
    
    /**
    * Optional. Gateway connection type -Ipsec/Dedicated/VpnClient/Vnet2Vnet
    * @param connectionTypeValue The ConnectionType value.
    */
    public void setConnectionType(final String connectionTypeValue) {
        this.connectionType = connectionTypeValue;
    }
    
    private LocalNetworkGateway localNetworkGateway2;
    
    /**
    * Optional.
    * @return The LocalNetworkGateway2 value.
    */
    public LocalNetworkGateway getLocalNetworkGateway2() {
        return this.localNetworkGateway2;
    }
    
    /**
    * Optional.
    * @param localNetworkGateway2Value The LocalNetworkGateway2 value.
    */
    public void setLocalNetworkGateway2(final LocalNetworkGateway localNetworkGateway2Value) {
        this.localNetworkGateway2 = localNetworkGateway2Value;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets Provisioning state of the
    * VirtualNetworkGatewayConnection resource Updating/Deleting/Failed
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets Provisioning state of the
    * VirtualNetworkGatewayConnection resource Updating/Deleting/Failed
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private int routingWeight;
    
    /**
    * Optional. The Routing weight.
    * @return The RoutingWeight value.
    */
    public int getRoutingWeight() {
        return this.routingWeight;
    }
    
    /**
    * Optional. The Routing weight.
    * @param routingWeightValue The RoutingWeight value.
    */
    public void setRoutingWeight(final int routingWeightValue) {
        this.routingWeight = routingWeightValue;
    }
    
    private String sharedKey;
    
    /**
    * Optional. The Ipsec share key.
    * @return The SharedKey value.
    */
    public String getSharedKey() {
        return this.sharedKey;
    }
    
    /**
    * Optional. The Ipsec share key.
    * @param sharedKeyValue The SharedKey value.
    */
    public void setSharedKey(final String sharedKeyValue) {
        this.sharedKey = sharedKeyValue;
    }
    
    private VirtualNetworkGateway virtualNetworkGateway1;
    
    /**
    * Optional.
    * @return The VirtualNetworkGateway1 value.
    */
    public VirtualNetworkGateway getVirtualNetworkGateway1() {
        return this.virtualNetworkGateway1;
    }
    
    /**
    * Optional.
    * @param virtualNetworkGateway1Value The VirtualNetworkGateway1 value.
    */
    public void setVirtualNetworkGateway1(final VirtualNetworkGateway virtualNetworkGateway1Value) {
        this.virtualNetworkGateway1 = virtualNetworkGateway1Value;
    }
    
    private VirtualNetworkGateway virtualNetworkGateway2;
    
    /**
    * Optional.
    * @return The VirtualNetworkGateway2 value.
    */
    public VirtualNetworkGateway getVirtualNetworkGateway2() {
        return this.virtualNetworkGateway2;
    }
    
    /**
    * Optional.
    * @param virtualNetworkGateway2Value The VirtualNetworkGateway2 value.
    */
    public void setVirtualNetworkGateway2(final VirtualNetworkGateway virtualNetworkGateway2Value) {
        this.virtualNetworkGateway2 = virtualNetworkGateway2Value;
    }
    
    /**
    * Initializes a new instance of the VirtualNetworkGatewayConnection class.
    *
    */
    public VirtualNetworkGatewayConnection() {
        super();
    }
    
    /**
    * Initializes a new instance of the VirtualNetworkGatewayConnection class
    * with required arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public VirtualNetworkGatewayConnection(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
