/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs;

import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityParameters;
import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityResponse;
import com.microsoft.azure.management.notificationhubs.models.LongRunningOperationResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceCreateOrUpdateParameters;
import com.microsoft.azure.management.notificationhubs.models.NamespaceCreateOrUpdateResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceGetResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceListResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceLongRunningResponse;
import com.microsoft.azure.management.notificationhubs.models.ResourceListKeys;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleCreateOrUpdateParameters;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleCreateOrUpdateResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleGetResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleListResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Management API includes operations for managing NotificationHub only
* namespaces.
*/
public interface NamespaceOperations {
    /**
    * Deletes an existing namespace. This operation also removes all associated
    * notificationHubs under the namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856296.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    NamespaceLongRunningResponse beginDelete(String resourceGroupName, String namespaceName) throws IOException, ServiceException;
    
    /**
    * Deletes an existing namespace. This operation also removes all associated
    * notificationHubs under the namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856296.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    Future<NamespaceLongRunningResponse> beginDeleteAsync(String resourceGroupName, String namespaceName);
    
    /**
    * Checks the availability of the given service namespace across all Windows
    * Azure subscriptions. This is useful because the domain name is created
    * based on the service namespace name.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx for
    * more information)
    *
    * @param parameters Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the Check NameAvailability operation.
    */
    CheckAvailabilityResponse checkAvailability(CheckAvailabilityParameters parameters) throws IOException, ServiceException;
    
    /**
    * Checks the availability of the given service namespace across all Windows
    * Azure subscriptions. This is useful because the domain name is created
    * based on the service namespace name.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx for
    * more information)
    *
    * @param parameters Required. The namespace name.
    * @return Response of the Check NameAvailability operation.
    */
    Future<CheckAvailabilityResponse> checkAvailabilityAsync(CheckAvailabilityParameters parameters);
    
    /**
    * Creates/Updates a service namespace. Once created, this namespace's
    * resource manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the CreateOrUpdate Namespace.
    */
    NamespaceCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String namespaceName, NamespaceCreateOrUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Creates/Updates a service namespace. Once created, this namespace's
    * resource manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @return The response of the CreateOrUpdate Namespace.
    */
    Future<NamespaceCreateOrUpdateResponse> createOrUpdateAsync(String resourceGroupName, String namespaceName, NamespaceCreateOrUpdateParameters parameters);
    
    /**
    * The create namespace authorization rule operation creates an
    * authorization rule for a namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @param parameters Required. The shared access authorization rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the CreateOrUpdate operation on the AuthorizationRules
    */
    SharedAccessAuthorizationRuleCreateOrUpdateResponse createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * The create namespace authorization rule operation creates an
    * authorization rule for a namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @param parameters Required. The shared access authorization rule.
    * @return Response of the CreateOrUpdate operation on the AuthorizationRules
    */
    Future<SharedAccessAuthorizationRuleCreateOrUpdateResponse> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters);
    
    /**
    * Delete existing Namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The name of the namespace.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    NamespaceLongRunningResponse delete(String resourceGroupName, String namespaceName) throws InterruptedException, ExecutionException, IOException, ServiceException;
    
    /**
    * Delete existing Namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The name of the namespace.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    Future<NamespaceLongRunningResponse> deleteAsync(String resourceGroupName, String namespaceName);
    
    /**
    * The delete a namespace authorization rule operation
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse deleteAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) throws IOException, ServiceException;
    
    /**
    * The delete a namespace authorization rule operation
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName);
    
    /**
    * Returns the description for the specified namespace.  (see
    * http://msdn.microsoft.com/library/azure/dn140232.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the Get Namespace operation.
    */
    NamespaceGetResponse get(String resourceGroupName, String namespaceName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Returns the description for the specified namespace.  (see
    * http://msdn.microsoft.com/library/azure/dn140232.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @return The response of the Get Namespace operation.
    */
    Future<NamespaceGetResponse> getAsync(String resourceGroupName, String namespaceName);
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * namespace by name.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param authorizationRuleName Required. The entity name to get the
    * authorization rule for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the Get Namespace operation.
    */
    SharedAccessAuthorizationRuleGetResponse getAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) throws IOException, ServiceException;
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * namespace by name.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param authorizationRuleName Required. The entity name to get the
    * authorization rule for.
    * @return The response of the Get Namespace operation.
    */
    Future<SharedAccessAuthorizationRuleGetResponse> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName);
    
    /**
    * The Get namespace Delete Operation Status operation returns the status of
    * the delete operation. After calling the operation, you can call Get
    * namespace Delete Operation Status to determine whether the operation has
    * succeeded, failed, or is still in progress. This method differs from
    * GetLongRunningOperationStatus in providing NotificationHub service
    * resource description.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    NamespaceLongRunningResponse getDeleteNamespaceOperationStatus(String operationStatusLink) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * The Get namespace Delete Operation Status operation returns the status of
    * the delete operation. After calling the operation, you can call Get
    * namespace Delete Operation Status to determine whether the operation has
    * succeeded, failed, or is still in progress. This method differs from
    * GetLongRunningOperationStatus in providing NotificationHub service
    * resource description.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    Future<NamespaceLongRunningResponse> getDeleteNamespaceOperationStatusAsync(String operationStatusLink);
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response for long running operations.
    */
    LongRunningOperationResponse getLongRunningOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return A standard service response for long running operations.
    */
    Future<LongRunningOperationResponse> getLongRunningOperationStatusAsync(String operationStatusLink);
    
    /**
    * Lists the available namespaces within a resourceGroup.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group. If
    * resourceGroupName value is null the method lists all the namespaces
    * within subscription
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the List Namespace operation.
    */
    NamespaceListResponse list(String resourceGroupName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Lists the available namespaces within a resourceGroup.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group. If
    * resourceGroupName value is null the method lists all the namespaces
    * within subscription
    * @return The response of the List Namespace operation.
    */
    Future<NamespaceListResponse> listAsync(String resourceGroupName);
    
    /**
    * Lists all the available namespaces within the subscription irrespective
    * of the resourceGroups.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the List Namespace operation.
    */
    NamespaceListResponse listAll() throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Lists all the available namespaces within the subscription irrespective
    * of the resourceGroups.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @return The response of the List Namespace operation.
    */
    Future<NamespaceListResponse> listAllAsync();
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the List Namespace operation.
    */
    SharedAccessAuthorizationRuleListResponse listAuthorizationRules(String resourceGroupName, String namespaceName) throws IOException, ServiceException;
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @return The response of the List Namespace operation.
    */
    Future<SharedAccessAuthorizationRuleListResponse> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName);
    
    /**
    * Gets the Primary and Secondary ConnectionStrings to the namespace   (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The connection string of the
    * namespace for the specified authorizationRule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Namespace/NotificationHub Connection String
    */
    ResourceListKeys listKeys(String resourceGroupName, String namespaceName, String authorizationRuleName) throws IOException, ServiceException;
    
    /**
    * Gets the Primary and Secondary ConnectionStrings to the namespace   (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The connection string of the
    * namespace for the specified authorizationRule.
    * @return Namespace/NotificationHub Connection String
    */
    Future<ResourceListKeys> listKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName);
}
