/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs;

import com.microsoft.azure.management.notificationhubs.models.AccessRights;
import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityParameters;
import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityResource;
import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityResponse;
import com.microsoft.azure.management.notificationhubs.models.LongRunningOperationResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceCreateOrUpdateParameters;
import com.microsoft.azure.management.notificationhubs.models.NamespaceCreateOrUpdateResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceGetResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceListResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceLongRunningResponse;
import com.microsoft.azure.management.notificationhubs.models.NamespaceProperties;
import com.microsoft.azure.management.notificationhubs.models.NamespaceResource;
import com.microsoft.azure.management.notificationhubs.models.NamespaceType;
import com.microsoft.azure.management.notificationhubs.models.ResourceError;
import com.microsoft.azure.management.notificationhubs.models.ResourceListKeys;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleCreateOrUpdateParameters;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleCreateOrUpdateResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleGetResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleListResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleProperties;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleResource;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Management API includes operations for managing NotificationHub only
* namespaces.
*/
public class NamespaceOperationsImpl implements ServiceOperations<NotificationHubsManagementClientImpl>, NamespaceOperations {
    /**
    * Initializes a new instance of the NamespaceOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    NamespaceOperationsImpl(NotificationHubsManagementClientImpl client) {
        this.client = client;
    }
    
    private NotificationHubsManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.notificationhubs.NotificationHubsManagementClientImpl.
    * @return The Client value.
    */
    public NotificationHubsManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Deletes an existing namespace. This operation also removes all associated
    * notificationHubs under the namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856296.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    @Override
    public Future<NamespaceLongRunningResponse> beginDeleteAsync(final String resourceGroupName, final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<NamespaceLongRunningResponse>() { 
            @Override
            public NamespaceLongRunningResponse call() throws Exception {
                return beginDelete(resourceGroupName, namespaceName);
            }
         });
    }
    
    /**
    * Deletes an existing namespace. This operation also removes all associated
    * notificationHubs under the namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856296.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    @Override
    public NamespaceLongRunningResponse beginDelete(String resourceGroupName, String namespaceName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "beginDeleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NamespaceLongRunningResponse result = null;
            // Deserialize Response
            result = new NamespaceLongRunningResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_BAD_REQUEST) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == HttpStatus.SC_OK) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Checks the availability of the given service namespace across all Windows
    * Azure subscriptions. This is useful because the domain name is created
    * based on the service namespace name.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx for
    * more information)
    *
    * @param parameters Required. The namespace name.
    * @return Response of the Check NameAvailability operation.
    */
    @Override
    public Future<CheckAvailabilityResponse> checkAvailabilityAsync(final CheckAvailabilityParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<CheckAvailabilityResponse>() { 
            @Override
            public CheckAvailabilityResponse call() throws Exception {
                return checkAvailability(parameters);
            }
         });
    }
    
    /**
    * Checks the availability of the given service namespace across all Windows
    * Azure subscriptions. This is useful because the domain name is created
    * based on the service namespace name.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx for
    * more information)
    *
    * @param parameters Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the Check NameAvailability operation.
    */
    @Override
    public CheckAvailabilityResponse checkAvailability(CheckAvailabilityParameters parameters) throws IOException, ServiceException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "checkAvailabilityAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/checkNamespaceAvailability";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode checkAvailabilityParametersValue = objectMapper.createObjectNode();
        requestDoc = checkAvailabilityParametersValue;
        
        ((ObjectNode) checkAvailabilityParametersValue).put("name", parameters.getName());
        
        if (parameters.getLocation() != null) {
            ((ObjectNode) checkAvailabilityParametersValue).put("location", parameters.getLocation());
        }
        
        if (parameters.getTags() != null) {
            if (parameters.getTags() instanceof LazyCollection == false || ((LazyCollection) parameters.getTags()).isInitialized()) {
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                    String tagsKey = entry.getKey();
                    String tagsValue = entry.getValue();
                    ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
                }
                ((ObjectNode) checkAvailabilityParametersValue).put("tags", tagsDictionary);
            }
        }
        
        ((ObjectNode) checkAvailabilityParametersValue).put("isAvailiable", parameters.isAvailable());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            CheckAvailabilityResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new CheckAvailabilityResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    CheckAvailabilityResource valueInstance = new CheckAvailabilityResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode isAvailiableValue = responseDoc.get("isAvailiable");
                    if (isAvailiableValue != null && isAvailiableValue instanceof NullNode == false) {
                        boolean isAvailiableInstance;
                        isAvailiableInstance = isAvailiableValue.getBooleanValue();
                        valueInstance.setIsAvailable(isAvailiableInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates/Updates a service namespace. Once created, this namespace's
    * resource manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @return The response of the CreateOrUpdate Namespace.
    */
    @Override
    public Future<NamespaceCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final String namespaceName, final NamespaceCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<NamespaceCreateOrUpdateResponse>() { 
            @Override
            public NamespaceCreateOrUpdateResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, namespaceName, parameters);
            }
         });
    }
    
    /**
    * Creates/Updates a service namespace. Once created, this namespace's
    * resource manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the CreateOrUpdate Namespace.
    */
    @Override
    public NamespaceCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String namespaceName, NamespaceCreateOrUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode namespaceCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = namespaceCreateOrUpdateParametersValue;
        
        ((ObjectNode) namespaceCreateOrUpdateParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            if (parameters.getTags() instanceof LazyCollection == false || ((LazyCollection) parameters.getTags()).isInitialized()) {
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                    String tagsKey = entry.getKey();
                    String tagsValue = entry.getValue();
                    ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
                }
                ((ObjectNode) namespaceCreateOrUpdateParametersValue).put("tags", tagsDictionary);
            }
        }
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) namespaceCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getName() != null) {
            ((ObjectNode) propertiesValue).put("name", parameters.getProperties().getName());
        }
        
        if (parameters.getProperties().getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProperties().getProvisioningState());
        }
        
        if (parameters.getProperties().getRegion() != null) {
            ((ObjectNode) propertiesValue).put("region", parameters.getProperties().getRegion());
        }
        
        if (parameters.getProperties().getStatus() != null) {
            ((ObjectNode) propertiesValue).put("status", parameters.getProperties().getStatus());
        }
        
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        ((ObjectNode) propertiesValue).put("createdAt", simpleDateFormat.format(parameters.getProperties().getCreatedAt().getTime()));
        
        if (parameters.getProperties().getServiceBusEndpoint() != null) {
            ((ObjectNode) propertiesValue).put("serviceBusEndpoint", parameters.getProperties().getServiceBusEndpoint().toString());
        }
        
        if (parameters.getProperties().getSubscriptionId() != null) {
            ((ObjectNode) propertiesValue).put("subscriptionId", parameters.getProperties().getSubscriptionId());
        }
        
        if (parameters.getProperties().getScaleUnit() != null) {
            ((ObjectNode) propertiesValue).put("scaleUnit", parameters.getProperties().getScaleUnit());
        }
        
        ((ObjectNode) propertiesValue).put("enabled", parameters.getProperties().isEnabled());
        
        ((ObjectNode) propertiesValue).put("critical", parameters.getProperties().isCritical());
        
        if (parameters.getProperties().getNamespaceType() != null) {
            ((ObjectNode) propertiesValue).put("namespaceType", parameters.getProperties().getNamespaceType().toString());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NamespaceCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NamespaceCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NamespaceResource valueInstance = new NamespaceResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        NamespaceProperties propertiesInstance = new NamespaceProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode nameValue2 = propertiesValue2.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            propertiesInstance.setName(nameInstance2);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode regionValue = propertiesValue2.get("region");
                        if (regionValue != null && regionValue instanceof NullNode == false) {
                            String regionInstance;
                            regionInstance = regionValue.getTextValue();
                            propertiesInstance.setRegion(regionInstance);
                        }
                        
                        JsonNode statusValue = propertiesValue2.get("status");
                        if (statusValue != null && statusValue instanceof NullNode == false) {
                            String statusInstance;
                            statusInstance = statusValue.getTextValue();
                            propertiesInstance.setStatus(statusInstance);
                        }
                        
                        JsonNode createdAtValue = propertiesValue2.get("createdAt");
                        if (createdAtValue != null && createdAtValue instanceof NullNode == false) {
                            Calendar createdAtInstance;
                            createdAtInstance = DatatypeConverter.parseDateTime(createdAtValue.getTextValue());
                            propertiesInstance.setCreatedAt(createdAtInstance);
                        }
                        
                        JsonNode serviceBusEndpointValue = propertiesValue2.get("serviceBusEndpoint");
                        if (serviceBusEndpointValue != null && serviceBusEndpointValue instanceof NullNode == false) {
                            URI serviceBusEndpointInstance;
                            serviceBusEndpointInstance = new URI(serviceBusEndpointValue.getTextValue());
                            propertiesInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                        }
                        
                        JsonNode subscriptionIdValue = propertiesValue2.get("subscriptionId");
                        if (subscriptionIdValue != null && subscriptionIdValue instanceof NullNode == false) {
                            String subscriptionIdInstance;
                            subscriptionIdInstance = subscriptionIdValue.getTextValue();
                            propertiesInstance.setSubscriptionId(subscriptionIdInstance);
                        }
                        
                        JsonNode scaleUnitValue = propertiesValue2.get("scaleUnit");
                        if (scaleUnitValue != null && scaleUnitValue instanceof NullNode == false) {
                            String scaleUnitInstance;
                            scaleUnitInstance = scaleUnitValue.getTextValue();
                            propertiesInstance.setScaleUnit(scaleUnitInstance);
                        }
                        
                        JsonNode enabledValue = propertiesValue2.get("enabled");
                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                            boolean enabledInstance;
                            enabledInstance = enabledValue.getBooleanValue();
                            propertiesInstance.setEnabled(enabledInstance);
                        }
                        
                        JsonNode criticalValue = propertiesValue2.get("critical");
                        if (criticalValue != null && criticalValue instanceof NullNode == false) {
                            boolean criticalInstance;
                            criticalInstance = criticalValue.getBooleanValue();
                            propertiesInstance.setCritical(criticalInstance);
                        }
                        
                        JsonNode namespaceTypeValue = propertiesValue2.get("namespaceType");
                        if (namespaceTypeValue != null && namespaceTypeValue instanceof NullNode == false) {
                            NamespaceType namespaceTypeInstance;
                            namespaceTypeInstance = Enum.valueOf(NamespaceType.class, namespaceTypeValue.getTextValue());
                            propertiesInstance.setNamespaceType(namespaceTypeInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The create namespace authorization rule operation creates an
    * authorization rule for a namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @param parameters Required. The shared access authorization rule.
    * @return Response of the CreateOrUpdate operation on the AuthorizationRules
    */
    @Override
    public Future<SharedAccessAuthorizationRuleCreateOrUpdateResponse> createOrUpdateAuthorizationRuleAsync(final String resourceGroupName, final String namespaceName, final String authorizationRuleName, final SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<SharedAccessAuthorizationRuleCreateOrUpdateResponse>() { 
            @Override
            public SharedAccessAuthorizationRuleCreateOrUpdateResponse call() throws Exception {
                return createOrUpdateAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName, parameters);
            }
         });
    }
    
    /**
    * The create namespace authorization rule operation creates an
    * authorization rule for a namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @param parameters Required. The shared access authorization rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the CreateOrUpdate operation on the AuthorizationRules
    */
    @Override
    public SharedAccessAuthorizationRuleCreateOrUpdateResponse createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode sharedAccessAuthorizationRuleCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = sharedAccessAuthorizationRuleCreateOrUpdateParametersValue;
        
        if (parameters.getLocation() != null) {
            ((ObjectNode) sharedAccessAuthorizationRuleCreateOrUpdateParametersValue).put("location", parameters.getLocation());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) sharedAccessAuthorizationRuleCreateOrUpdateParametersValue).put("name", parameters.getName());
        }
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) sharedAccessAuthorizationRuleCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getPrimaryKey() != null) {
            ((ObjectNode) propertiesValue).put("primaryKey", parameters.getProperties().getPrimaryKey());
        }
        
        if (parameters.getProperties().getSecondaryKey() != null) {
            ((ObjectNode) propertiesValue).put("secondaryKey", parameters.getProperties().getSecondaryKey());
        }
        
        if (parameters.getProperties().getKeyName() != null) {
            ((ObjectNode) propertiesValue).put("keyName", parameters.getProperties().getKeyName());
        }
        
        if (parameters.getProperties().getClaimType() != null) {
            ((ObjectNode) propertiesValue).put("claimType", parameters.getProperties().getClaimType());
        }
        
        if (parameters.getProperties().getClaimValue() != null) {
            ((ObjectNode) propertiesValue).put("claimValue", parameters.getProperties().getClaimValue());
        }
        
        if (parameters.getProperties().getRights() != null) {
            ArrayNode rightsArray = objectMapper.createArrayNode();
            for (AccessRights rightsItem : parameters.getProperties().getRights()) {
                rightsArray.add(rightsItem.toString());
            }
            ((ObjectNode) propertiesValue).put("rights", rightsArray);
        }
        
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        ((ObjectNode) propertiesValue).put("createdTime", simpleDateFormat.format(parameters.getProperties().getCreatedTime().getTime()));
        
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        ((ObjectNode) propertiesValue).put("modifiedTime", simpleDateFormat2.format(parameters.getProperties().getModifiedTime().getTime()));
        
        ((ObjectNode) propertiesValue).put("revision", parameters.getProperties().getRevision());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SharedAccessAuthorizationRuleCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SharedAccessAuthorizationRuleCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SharedAccessAuthorizationRuleResource valueInstance = new SharedAccessAuthorizationRuleResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        SharedAccessAuthorizationRuleProperties propertiesInstance = new SharedAccessAuthorizationRuleProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode primaryKeyValue = propertiesValue2.get("primaryKey");
                        if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                            String primaryKeyInstance;
                            primaryKeyInstance = primaryKeyValue.getTextValue();
                            propertiesInstance.setPrimaryKey(primaryKeyInstance);
                        }
                        
                        JsonNode secondaryKeyValue = propertiesValue2.get("secondaryKey");
                        if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                            String secondaryKeyInstance;
                            secondaryKeyInstance = secondaryKeyValue.getTextValue();
                            propertiesInstance.setSecondaryKey(secondaryKeyInstance);
                        }
                        
                        JsonNode keyNameValue = propertiesValue2.get("keyName");
                        if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                            String keyNameInstance;
                            keyNameInstance = keyNameValue.getTextValue();
                            propertiesInstance.setKeyName(keyNameInstance);
                        }
                        
                        JsonNode claimTypeValue = propertiesValue2.get("claimType");
                        if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                            String claimTypeInstance;
                            claimTypeInstance = claimTypeValue.getTextValue();
                            propertiesInstance.setClaimType(claimTypeInstance);
                        }
                        
                        JsonNode claimValueValue = propertiesValue2.get("claimValue");
                        if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                            String claimValueInstance;
                            claimValueInstance = claimValueValue.getTextValue();
                            propertiesInstance.setClaimValue(claimValueInstance);
                        }
                        
                        JsonNode rightsArray2 = propertiesValue2.get("rights");
                        if (rightsArray2 != null && rightsArray2 instanceof NullNode == false) {
                            for (JsonNode rightsValue : ((ArrayNode) rightsArray2)) {
                                propertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                            }
                        }
                        
                        JsonNode createdTimeValue = propertiesValue2.get("createdTime");
                        if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                            Calendar createdTimeInstance;
                            createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                            propertiesInstance.setCreatedTime(createdTimeInstance);
                        }
                        
                        JsonNode modifiedTimeValue = propertiesValue2.get("modifiedTime");
                        if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                            Calendar modifiedTimeInstance;
                            modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                            propertiesInstance.setModifiedTime(modifiedTimeInstance);
                        }
                        
                        JsonNode revisionValue = propertiesValue2.get("revision");
                        if (revisionValue != null && revisionValue instanceof NullNode == false) {
                            int revisionInstance;
                            revisionInstance = revisionValue.getIntValue();
                            propertiesInstance.setRevision(revisionInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Delete existing Namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The name of the namespace.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    @Override
    public Future<NamespaceLongRunningResponse> deleteAsync(final String resourceGroupName, final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<NamespaceLongRunningResponse>() { 
            @Override
            public NamespaceLongRunningResponse call() throws Exception {
                return delete(resourceGroupName, namespaceName);
            }
         });
    }
    
    /**
    * Delete existing Namespace
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The name of the namespace.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    @Override
    public NamespaceLongRunningResponse delete(String resourceGroupName, String namespaceName) throws InterruptedException, ExecutionException, IOException, ServiceException {
        NotificationHubsManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            NamespaceLongRunningResponse response = client2.getNamespacesOperations().beginDeleteAsync(resourceGroupName, namespaceName).get();
            if (response.getStatus() == OperationStatus.Succeeded) {
                return response;
            }
            NamespaceLongRunningResponse result = client2.getNamespacesOperations().getDeleteNamespaceOperationStatusAsync(response.getOperationStatusLink()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 60;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getNamespacesOperations().getDeleteNamespaceOperationStatusAsync(response.getOperationStatusLink()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 60;
                }
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The delete a namespace authorization rule operation
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAuthorizationRuleAsync(final String resourceGroupName, final String namespaceName, final String authorizationRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName);
            }
         });
    }
    
    /**
    * The delete a namespace authorization rule operation
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            CloudTracing.enter(invocationId, this, "deleteAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns the description for the specified namespace.  (see
    * http://msdn.microsoft.com/library/azure/dn140232.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @return The response of the Get Namespace operation.
    */
    @Override
    public Future<NamespaceGetResponse> getAsync(final String resourceGroupName, final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<NamespaceGetResponse>() { 
            @Override
            public NamespaceGetResponse call() throws Exception {
                return get(resourceGroupName, namespaceName);
            }
         });
    }
    
    /**
    * Returns the description for the specified namespace.  (see
    * http://msdn.microsoft.com/library/azure/dn140232.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the Get Namespace operation.
    */
    @Override
    public NamespaceGetResponse get(String resourceGroupName, String namespaceName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NamespaceGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NamespaceGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NamespaceResource valueInstance = new NamespaceResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        NamespaceProperties propertiesInstance = new NamespaceProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode nameValue2 = propertiesValue.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            propertiesInstance.setName(nameInstance2);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode regionValue = propertiesValue.get("region");
                        if (regionValue != null && regionValue instanceof NullNode == false) {
                            String regionInstance;
                            regionInstance = regionValue.getTextValue();
                            propertiesInstance.setRegion(regionInstance);
                        }
                        
                        JsonNode statusValue = propertiesValue.get("status");
                        if (statusValue != null && statusValue instanceof NullNode == false) {
                            String statusInstance;
                            statusInstance = statusValue.getTextValue();
                            propertiesInstance.setStatus(statusInstance);
                        }
                        
                        JsonNode createdAtValue = propertiesValue.get("createdAt");
                        if (createdAtValue != null && createdAtValue instanceof NullNode == false) {
                            Calendar createdAtInstance;
                            createdAtInstance = DatatypeConverter.parseDateTime(createdAtValue.getTextValue());
                            propertiesInstance.setCreatedAt(createdAtInstance);
                        }
                        
                        JsonNode serviceBusEndpointValue = propertiesValue.get("serviceBusEndpoint");
                        if (serviceBusEndpointValue != null && serviceBusEndpointValue instanceof NullNode == false) {
                            URI serviceBusEndpointInstance;
                            serviceBusEndpointInstance = new URI(serviceBusEndpointValue.getTextValue());
                            propertiesInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                        }
                        
                        JsonNode subscriptionIdValue = propertiesValue.get("subscriptionId");
                        if (subscriptionIdValue != null && subscriptionIdValue instanceof NullNode == false) {
                            String subscriptionIdInstance;
                            subscriptionIdInstance = subscriptionIdValue.getTextValue();
                            propertiesInstance.setSubscriptionId(subscriptionIdInstance);
                        }
                        
                        JsonNode scaleUnitValue = propertiesValue.get("scaleUnit");
                        if (scaleUnitValue != null && scaleUnitValue instanceof NullNode == false) {
                            String scaleUnitInstance;
                            scaleUnitInstance = scaleUnitValue.getTextValue();
                            propertiesInstance.setScaleUnit(scaleUnitInstance);
                        }
                        
                        JsonNode enabledValue = propertiesValue.get("enabled");
                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                            boolean enabledInstance;
                            enabledInstance = enabledValue.getBooleanValue();
                            propertiesInstance.setEnabled(enabledInstance);
                        }
                        
                        JsonNode criticalValue = propertiesValue.get("critical");
                        if (criticalValue != null && criticalValue instanceof NullNode == false) {
                            boolean criticalInstance;
                            criticalInstance = criticalValue.getBooleanValue();
                            propertiesInstance.setCritical(criticalInstance);
                        }
                        
                        JsonNode namespaceTypeValue = propertiesValue.get("namespaceType");
                        if (namespaceTypeValue != null && namespaceTypeValue instanceof NullNode == false) {
                            NamespaceType namespaceTypeInstance;
                            namespaceTypeInstance = Enum.valueOf(NamespaceType.class, namespaceTypeValue.getTextValue());
                            propertiesInstance.setNamespaceType(namespaceTypeInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * namespace by name.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param authorizationRuleName Required. The entity name to get the
    * authorization rule for.
    * @return The response of the Get Namespace operation.
    */
    @Override
    public Future<SharedAccessAuthorizationRuleGetResponse> getAuthorizationRuleAsync(final String resourceGroupName, final String namespaceName, final String authorizationRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<SharedAccessAuthorizationRuleGetResponse>() { 
            @Override
            public SharedAccessAuthorizationRuleGetResponse call() throws Exception {
                return getAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName);
            }
         });
    }
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * namespace by name.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param authorizationRuleName Required. The entity name to get the
    * authorization rule for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the Get Namespace operation.
    */
    @Override
    public SharedAccessAuthorizationRuleGetResponse getAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            CloudTracing.enter(invocationId, this, "getAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SharedAccessAuthorizationRuleGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SharedAccessAuthorizationRuleGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SharedAccessAuthorizationRuleResource valueInstance = new SharedAccessAuthorizationRuleResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        SharedAccessAuthorizationRuleProperties propertiesInstance = new SharedAccessAuthorizationRuleProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode primaryKeyValue = propertiesValue.get("primaryKey");
                        if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                            String primaryKeyInstance;
                            primaryKeyInstance = primaryKeyValue.getTextValue();
                            propertiesInstance.setPrimaryKey(primaryKeyInstance);
                        }
                        
                        JsonNode secondaryKeyValue = propertiesValue.get("secondaryKey");
                        if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                            String secondaryKeyInstance;
                            secondaryKeyInstance = secondaryKeyValue.getTextValue();
                            propertiesInstance.setSecondaryKey(secondaryKeyInstance);
                        }
                        
                        JsonNode keyNameValue = propertiesValue.get("keyName");
                        if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                            String keyNameInstance;
                            keyNameInstance = keyNameValue.getTextValue();
                            propertiesInstance.setKeyName(keyNameInstance);
                        }
                        
                        JsonNode claimTypeValue = propertiesValue.get("claimType");
                        if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                            String claimTypeInstance;
                            claimTypeInstance = claimTypeValue.getTextValue();
                            propertiesInstance.setClaimType(claimTypeInstance);
                        }
                        
                        JsonNode claimValueValue = propertiesValue.get("claimValue");
                        if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                            String claimValueInstance;
                            claimValueInstance = claimValueValue.getTextValue();
                            propertiesInstance.setClaimValue(claimValueInstance);
                        }
                        
                        JsonNode rightsArray = propertiesValue.get("rights");
                        if (rightsArray != null && rightsArray instanceof NullNode == false) {
                            for (JsonNode rightsValue : ((ArrayNode) rightsArray)) {
                                propertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                            }
                        }
                        
                        JsonNode createdTimeValue = propertiesValue.get("createdTime");
                        if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                            Calendar createdTimeInstance;
                            createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                            propertiesInstance.setCreatedTime(createdTimeInstance);
                        }
                        
                        JsonNode modifiedTimeValue = propertiesValue.get("modifiedTime");
                        if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                            Calendar modifiedTimeInstance;
                            modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                            propertiesInstance.setModifiedTime(modifiedTimeInstance);
                        }
                        
                        JsonNode revisionValue = propertiesValue.get("revision");
                        if (revisionValue != null && revisionValue instanceof NullNode == false) {
                            int revisionInstance;
                            revisionInstance = revisionValue.getIntValue();
                            propertiesInstance.setRevision(revisionInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get namespace Delete Operation Status operation returns the status of
    * the delete operation. After calling the operation, you can call Get
    * namespace Delete Operation Status to determine whether the operation has
    * succeeded, failed, or is still in progress. This method differs from
    * GetLongRunningOperationStatus in providing NotificationHub service
    * resource description.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    @Override
    public Future<NamespaceLongRunningResponse> getDeleteNamespaceOperationStatusAsync(final String operationStatusLink) {
        return this.getClient().getExecutorService().submit(new Callable<NamespaceLongRunningResponse>() { 
            @Override
            public NamespaceLongRunningResponse call() throws Exception {
                return getDeleteNamespaceOperationStatus(operationStatusLink);
            }
         });
    }
    
    /**
    * The Get namespace Delete Operation Status operation returns the status of
    * the delete operation. After calling the operation, you can call Get
    * namespace Delete Operation Status to determine whether the operation has
    * succeeded, failed, or is still in progress. This method differs from
    * GetLongRunningOperationStatus in providing NotificationHub service
    * resource description.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the CreateOrUpdate Api Management service long
    * running operation.
    */
    @Override
    public NamespaceLongRunningResponse getDeleteNamespaceOperationStatus(String operationStatusLink) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter(invocationId, this, "getDeleteNamespaceOperationStatusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-09-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NOT_FOUND) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NamespaceLongRunningResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_ACCEPTED || statusCode == HttpStatus.SC_NOT_FOUND) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NamespaceLongRunningResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NamespaceResource valueInstance = new NamespaceResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        NamespaceProperties propertiesInstance = new NamespaceProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode nameValue2 = propertiesValue.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            propertiesInstance.setName(nameInstance2);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode regionValue = propertiesValue.get("region");
                        if (regionValue != null && regionValue instanceof NullNode == false) {
                            String regionInstance;
                            regionInstance = regionValue.getTextValue();
                            propertiesInstance.setRegion(regionInstance);
                        }
                        
                        JsonNode statusValue = propertiesValue.get("status");
                        if (statusValue != null && statusValue instanceof NullNode == false) {
                            String statusInstance;
                            statusInstance = statusValue.getTextValue();
                            propertiesInstance.setStatus(statusInstance);
                        }
                        
                        JsonNode createdAtValue = propertiesValue.get("createdAt");
                        if (createdAtValue != null && createdAtValue instanceof NullNode == false) {
                            Calendar createdAtInstance;
                            createdAtInstance = DatatypeConverter.parseDateTime(createdAtValue.getTextValue());
                            propertiesInstance.setCreatedAt(createdAtInstance);
                        }
                        
                        JsonNode serviceBusEndpointValue = propertiesValue.get("serviceBusEndpoint");
                        if (serviceBusEndpointValue != null && serviceBusEndpointValue instanceof NullNode == false) {
                            URI serviceBusEndpointInstance;
                            serviceBusEndpointInstance = new URI(serviceBusEndpointValue.getTextValue());
                            propertiesInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                        }
                        
                        JsonNode subscriptionIdValue = propertiesValue.get("subscriptionId");
                        if (subscriptionIdValue != null && subscriptionIdValue instanceof NullNode == false) {
                            String subscriptionIdInstance;
                            subscriptionIdInstance = subscriptionIdValue.getTextValue();
                            propertiesInstance.setSubscriptionId(subscriptionIdInstance);
                        }
                        
                        JsonNode scaleUnitValue = propertiesValue.get("scaleUnit");
                        if (scaleUnitValue != null && scaleUnitValue instanceof NullNode == false) {
                            String scaleUnitInstance;
                            scaleUnitInstance = scaleUnitValue.getTextValue();
                            propertiesInstance.setScaleUnit(scaleUnitInstance);
                        }
                        
                        JsonNode enabledValue = propertiesValue.get("enabled");
                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                            boolean enabledInstance;
                            enabledInstance = enabledValue.getBooleanValue();
                            propertiesInstance.setEnabled(enabledInstance);
                        }
                        
                        JsonNode criticalValue = propertiesValue.get("critical");
                        if (criticalValue != null && criticalValue instanceof NullNode == false) {
                            boolean criticalInstance;
                            criticalInstance = criticalValue.getBooleanValue();
                            propertiesInstance.setCritical(criticalInstance);
                        }
                        
                        JsonNode namespaceTypeValue = propertiesValue.get("namespaceType");
                        if (namespaceTypeValue != null && namespaceTypeValue instanceof NullNode == false) {
                            NamespaceType namespaceTypeInstance;
                            namespaceTypeInstance = Enum.valueOf(NamespaceType.class, namespaceTypeValue.getTextValue());
                            propertiesInstance.setNamespaceType(namespaceTypeInstance);
                        }
                    }
                    
                    ResourceError errorInstance = new ResourceError();
                    result.setError(errorInstance);
                    
                    JsonNode codeValue = responseDoc.get("code");
                    if (codeValue != null && codeValue instanceof NullNode == false) {
                        String codeInstance;
                        codeInstance = codeValue.getTextValue();
                        errorInstance.setCode(codeInstance);
                    }
                    
                    JsonNode messageValue = responseDoc.get("message");
                    if (messageValue != null && messageValue instanceof NullNode == false) {
                        String messageInstance;
                        messageInstance = messageValue.getTextValue();
                        errorInstance.setMessage(messageInstance);
                    }
                    
                    JsonNode detailsSequenceElement = ((JsonNode) responseDoc.get("details"));
                    if (detailsSequenceElement != null && detailsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr2 = detailsSequenceElement.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry<String, JsonNode> property2 = itr2.next();
                            String detailsKey = property2.getKey();
                            String detailsValue = property2.getValue().getTextValue();
                            errorInstance.getDetails().put(detailsKey, detailsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_BAD_REQUEST) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == HttpStatus.SC_OK) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (statusCode == HttpStatus.SC_NOT_FOUND) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return A standard service response for long running operations.
    */
    @Override
    public Future<LongRunningOperationResponse> getLongRunningOperationStatusAsync(final String operationStatusLink) {
        return this.getClient().getExecutorService().submit(new Callable<LongRunningOperationResponse>() { 
            @Override
            public LongRunningOperationResponse call() throws Exception {
                return getLongRunningOperationStatus(operationStatusLink);
            }
         });
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response for long running operations.
    */
    @Override
    public LongRunningOperationResponse getLongRunningOperationStatus(String operationStatusLink) throws IOException, ServiceException {
        // Validate
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter(invocationId, this, "getLongRunningOperationStatusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-09-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NOT_FOUND) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            LongRunningOperationResponse result = null;
            // Deserialize Response
            result = new LongRunningOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt(httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_BAD_REQUEST) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == HttpStatus.SC_OK) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (statusCode == HttpStatus.SC_NOT_FOUND) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists the available namespaces within a resourceGroup.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group. If
    * resourceGroupName value is null the method lists all the namespaces
    * within subscription
    * @return The response of the List Namespace operation.
    */
    @Override
    public Future<NamespaceListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<NamespaceListResponse>() { 
            @Override
            public NamespaceListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * Lists the available namespaces within a resourceGroup.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @param resourceGroupName Required. The name of the resource group. If
    * resourceGroupName value is null the method lists all the namespaces
    * within subscription
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the List Namespace operation.
    */
    @Override
    public NamespaceListResponse list(String resourceGroupName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NamespaceListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NamespaceListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            NamespaceResource namespaceResourceInstance = new NamespaceResource();
                            result.getValue().add(namespaceResourceInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                namespaceResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                namespaceResourceInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                namespaceResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                namespaceResourceInstance.setType(typeInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    namespaceResourceInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                NamespaceProperties propertiesInstance = new NamespaceProperties();
                                namespaceResourceInstance.setProperties(propertiesInstance);
                                
                                JsonNode nameValue2 = propertiesValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    propertiesInstance.setName(nameInstance2);
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    propertiesInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode regionValue = propertiesValue.get("region");
                                if (regionValue != null && regionValue instanceof NullNode == false) {
                                    String regionInstance;
                                    regionInstance = regionValue.getTextValue();
                                    propertiesInstance.setRegion(regionInstance);
                                }
                                
                                JsonNode statusValue = propertiesValue.get("status");
                                if (statusValue != null && statusValue instanceof NullNode == false) {
                                    String statusInstance;
                                    statusInstance = statusValue.getTextValue();
                                    propertiesInstance.setStatus(statusInstance);
                                }
                                
                                JsonNode createdAtValue = propertiesValue.get("createdAt");
                                if (createdAtValue != null && createdAtValue instanceof NullNode == false) {
                                    Calendar createdAtInstance;
                                    createdAtInstance = DatatypeConverter.parseDateTime(createdAtValue.getTextValue());
                                    propertiesInstance.setCreatedAt(createdAtInstance);
                                }
                                
                                JsonNode serviceBusEndpointValue = propertiesValue.get("serviceBusEndpoint");
                                if (serviceBusEndpointValue != null && serviceBusEndpointValue instanceof NullNode == false) {
                                    URI serviceBusEndpointInstance;
                                    serviceBusEndpointInstance = new URI(serviceBusEndpointValue.getTextValue());
                                    propertiesInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                                }
                                
                                JsonNode subscriptionIdValue = propertiesValue.get("subscriptionId");
                                if (subscriptionIdValue != null && subscriptionIdValue instanceof NullNode == false) {
                                    String subscriptionIdInstance;
                                    subscriptionIdInstance = subscriptionIdValue.getTextValue();
                                    propertiesInstance.setSubscriptionId(subscriptionIdInstance);
                                }
                                
                                JsonNode scaleUnitValue = propertiesValue.get("scaleUnit");
                                if (scaleUnitValue != null && scaleUnitValue instanceof NullNode == false) {
                                    String scaleUnitInstance;
                                    scaleUnitInstance = scaleUnitValue.getTextValue();
                                    propertiesInstance.setScaleUnit(scaleUnitInstance);
                                }
                                
                                JsonNode enabledValue = propertiesValue.get("enabled");
                                if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                    boolean enabledInstance;
                                    enabledInstance = enabledValue.getBooleanValue();
                                    propertiesInstance.setEnabled(enabledInstance);
                                }
                                
                                JsonNode criticalValue = propertiesValue.get("critical");
                                if (criticalValue != null && criticalValue instanceof NullNode == false) {
                                    boolean criticalInstance;
                                    criticalInstance = criticalValue.getBooleanValue();
                                    propertiesInstance.setCritical(criticalInstance);
                                }
                                
                                JsonNode namespaceTypeValue = propertiesValue.get("namespaceType");
                                if (namespaceTypeValue != null && namespaceTypeValue instanceof NullNode == false) {
                                    NamespaceType namespaceTypeInstance;
                                    namespaceTypeInstance = Enum.valueOf(NamespaceType.class, namespaceTypeValue.getTextValue());
                                    propertiesInstance.setNamespaceType(namespaceTypeInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists all the available namespaces within the subscription irrespective
    * of the resourceGroups.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @return The response of the List Namespace operation.
    */
    @Override
    public Future<NamespaceListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<NamespaceListResponse>() { 
            @Override
            public NamespaceListResponse call() throws Exception {
                return listAll();
            }
         });
    }
    
    /**
    * Lists all the available namespaces within the subscription irrespective
    * of the resourceGroups.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the List Namespace operation.
    */
    @Override
    public NamespaceListResponse listAll() throws IOException, ServiceException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NamespaceListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NamespaceListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            NamespaceResource namespaceResourceInstance = new NamespaceResource();
                            result.getValue().add(namespaceResourceInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                namespaceResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                namespaceResourceInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                namespaceResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                namespaceResourceInstance.setType(typeInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    namespaceResourceInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                NamespaceProperties propertiesInstance = new NamespaceProperties();
                                namespaceResourceInstance.setProperties(propertiesInstance);
                                
                                JsonNode nameValue2 = propertiesValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    propertiesInstance.setName(nameInstance2);
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    propertiesInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode regionValue = propertiesValue.get("region");
                                if (regionValue != null && regionValue instanceof NullNode == false) {
                                    String regionInstance;
                                    regionInstance = regionValue.getTextValue();
                                    propertiesInstance.setRegion(regionInstance);
                                }
                                
                                JsonNode statusValue = propertiesValue.get("status");
                                if (statusValue != null && statusValue instanceof NullNode == false) {
                                    String statusInstance;
                                    statusInstance = statusValue.getTextValue();
                                    propertiesInstance.setStatus(statusInstance);
                                }
                                
                                JsonNode createdAtValue = propertiesValue.get("createdAt");
                                if (createdAtValue != null && createdAtValue instanceof NullNode == false) {
                                    Calendar createdAtInstance;
                                    createdAtInstance = DatatypeConverter.parseDateTime(createdAtValue.getTextValue());
                                    propertiesInstance.setCreatedAt(createdAtInstance);
                                }
                                
                                JsonNode serviceBusEndpointValue = propertiesValue.get("serviceBusEndpoint");
                                if (serviceBusEndpointValue != null && serviceBusEndpointValue instanceof NullNode == false) {
                                    URI serviceBusEndpointInstance;
                                    serviceBusEndpointInstance = new URI(serviceBusEndpointValue.getTextValue());
                                    propertiesInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                                }
                                
                                JsonNode subscriptionIdValue = propertiesValue.get("subscriptionId");
                                if (subscriptionIdValue != null && subscriptionIdValue instanceof NullNode == false) {
                                    String subscriptionIdInstance;
                                    subscriptionIdInstance = subscriptionIdValue.getTextValue();
                                    propertiesInstance.setSubscriptionId(subscriptionIdInstance);
                                }
                                
                                JsonNode scaleUnitValue = propertiesValue.get("scaleUnit");
                                if (scaleUnitValue != null && scaleUnitValue instanceof NullNode == false) {
                                    String scaleUnitInstance;
                                    scaleUnitInstance = scaleUnitValue.getTextValue();
                                    propertiesInstance.setScaleUnit(scaleUnitInstance);
                                }
                                
                                JsonNode enabledValue = propertiesValue.get("enabled");
                                if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                    boolean enabledInstance;
                                    enabledInstance = enabledValue.getBooleanValue();
                                    propertiesInstance.setEnabled(enabledInstance);
                                }
                                
                                JsonNode criticalValue = propertiesValue.get("critical");
                                if (criticalValue != null && criticalValue instanceof NullNode == false) {
                                    boolean criticalInstance;
                                    criticalInstance = criticalValue.getBooleanValue();
                                    propertiesInstance.setCritical(criticalInstance);
                                }
                                
                                JsonNode namespaceTypeValue = propertiesValue.get("namespaceType");
                                if (namespaceTypeValue != null && namespaceTypeValue instanceof NullNode == false) {
                                    NamespaceType namespaceTypeInstance;
                                    namespaceTypeInstance = Enum.valueOf(NamespaceType.class, namespaceTypeValue.getTextValue());
                                    propertiesInstance.setNamespaceType(namespaceTypeInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @return The response of the List Namespace operation.
    */
    @Override
    public Future<SharedAccessAuthorizationRuleListResponse> listAuthorizationRulesAsync(final String resourceGroupName, final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<SharedAccessAuthorizationRuleListResponse>() { 
            @Override
            public SharedAccessAuthorizationRuleListResponse call() throws Exception {
                return listAuthorizationRules(resourceGroupName, namespaceName);
            }
         });
    }
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the List Namespace operation.
    */
    @Override
    public SharedAccessAuthorizationRuleListResponse listAuthorizationRules(String resourceGroupName, String namespaceName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "listAuthorizationRulesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SharedAccessAuthorizationRuleListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SharedAccessAuthorizationRuleListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            SharedAccessAuthorizationRuleResource sharedAccessAuthorizationRuleResourceInstance = new SharedAccessAuthorizationRuleResource();
                            result.getValue().add(sharedAccessAuthorizationRuleResourceInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setType(typeInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    sharedAccessAuthorizationRuleResourceInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                SharedAccessAuthorizationRuleProperties propertiesInstance = new SharedAccessAuthorizationRuleProperties();
                                sharedAccessAuthorizationRuleResourceInstance.setProperties(propertiesInstance);
                                
                                JsonNode primaryKeyValue = propertiesValue.get("primaryKey");
                                if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                                    String primaryKeyInstance;
                                    primaryKeyInstance = primaryKeyValue.getTextValue();
                                    propertiesInstance.setPrimaryKey(primaryKeyInstance);
                                }
                                
                                JsonNode secondaryKeyValue = propertiesValue.get("secondaryKey");
                                if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                                    String secondaryKeyInstance;
                                    secondaryKeyInstance = secondaryKeyValue.getTextValue();
                                    propertiesInstance.setSecondaryKey(secondaryKeyInstance);
                                }
                                
                                JsonNode keyNameValue = propertiesValue.get("keyName");
                                if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                                    String keyNameInstance;
                                    keyNameInstance = keyNameValue.getTextValue();
                                    propertiesInstance.setKeyName(keyNameInstance);
                                }
                                
                                JsonNode claimTypeValue = propertiesValue.get("claimType");
                                if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                                    String claimTypeInstance;
                                    claimTypeInstance = claimTypeValue.getTextValue();
                                    propertiesInstance.setClaimType(claimTypeInstance);
                                }
                                
                                JsonNode claimValueValue = propertiesValue.get("claimValue");
                                if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                                    String claimValueInstance;
                                    claimValueInstance = claimValueValue.getTextValue();
                                    propertiesInstance.setClaimValue(claimValueInstance);
                                }
                                
                                JsonNode rightsArray = propertiesValue.get("rights");
                                if (rightsArray != null && rightsArray instanceof NullNode == false) {
                                    for (JsonNode rightsValue : ((ArrayNode) rightsArray)) {
                                        propertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                                    }
                                }
                                
                                JsonNode createdTimeValue = propertiesValue.get("createdTime");
                                if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                                    Calendar createdTimeInstance;
                                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                                    propertiesInstance.setCreatedTime(createdTimeInstance);
                                }
                                
                                JsonNode modifiedTimeValue = propertiesValue.get("modifiedTime");
                                if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                                    Calendar modifiedTimeInstance;
                                    modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                                    propertiesInstance.setModifiedTime(modifiedTimeInstance);
                                }
                                
                                JsonNode revisionValue = propertiesValue.get("revision");
                                if (revisionValue != null && revisionValue instanceof NullNode == false) {
                                    int revisionInstance;
                                    revisionInstance = revisionValue.getIntValue();
                                    propertiesInstance.setRevision(revisionInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the Primary and Secondary ConnectionStrings to the namespace   (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The connection string of the
    * namespace for the specified authorizationRule.
    * @return Namespace/NotificationHub Connection String
    */
    @Override
    public Future<ResourceListKeys> listKeysAsync(final String resourceGroupName, final String namespaceName, final String authorizationRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceListKeys>() { 
            @Override
            public ResourceListKeys call() throws Exception {
                return listKeys(resourceGroupName, namespaceName, authorizationRuleName);
            }
         });
    }
    
    /**
    * Gets the Primary and Secondary ConnectionStrings to the namespace   (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param authorizationRuleName Required. The connection string of the
    * namespace for the specified authorizationRule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Namespace/NotificationHub Connection String
    */
    @Override
    public ResourceListKeys listKeys(String resourceGroupName, String namespaceName, String authorizationRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            CloudTracing.enter(invocationId, this, "listKeysAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        url = url + "/listKeys";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceListKeys result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceListKeys();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode primaryConnectionStringValue = responseDoc.get("primaryConnectionString");
                    if (primaryConnectionStringValue != null && primaryConnectionStringValue instanceof NullNode == false) {
                        String primaryConnectionStringInstance;
                        primaryConnectionStringInstance = primaryConnectionStringValue.getTextValue();
                        result.setPrimaryConnectionString(primaryConnectionStringInstance);
                    }
                    
                    JsonNode secondaryConnectionStringValue = responseDoc.get("secondaryConnectionString");
                    if (secondaryConnectionStringValue != null && secondaryConnectionStringValue instanceof NullNode == false) {
                        String secondaryConnectionStringInstance;
                        secondaryConnectionStringInstance = secondaryConnectionStringValue.getTextValue();
                        result.setSecondaryConnectionString(secondaryConnectionStringInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
