/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs;

import com.microsoft.azure.management.notificationhubs.models.AccessRights;
import com.microsoft.azure.management.notificationhubs.models.AdmCredential;
import com.microsoft.azure.management.notificationhubs.models.AdmCredentialProperties;
import com.microsoft.azure.management.notificationhubs.models.ApnsCredential;
import com.microsoft.azure.management.notificationhubs.models.ApnsCredentialProperties;
import com.microsoft.azure.management.notificationhubs.models.BaiduCredential;
import com.microsoft.azure.management.notificationhubs.models.BaiduCredentialProperties;
import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityParameters;
import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityResource;
import com.microsoft.azure.management.notificationhubs.models.CheckAvailabilityResponse;
import com.microsoft.azure.management.notificationhubs.models.GcmCredential;
import com.microsoft.azure.management.notificationhubs.models.GcmCredentialProperties;
import com.microsoft.azure.management.notificationhubs.models.MpnsCredential;
import com.microsoft.azure.management.notificationhubs.models.MpnsCredentialProperties;
import com.microsoft.azure.management.notificationhubs.models.NotificationHubCreateOrUpdateParameters;
import com.microsoft.azure.management.notificationhubs.models.NotificationHubCreateOrUpdateResponse;
import com.microsoft.azure.management.notificationhubs.models.NotificationHubGetResponse;
import com.microsoft.azure.management.notificationhubs.models.NotificationHubListResponse;
import com.microsoft.azure.management.notificationhubs.models.NotificationHubProperties;
import com.microsoft.azure.management.notificationhubs.models.NotificationHubResource;
import com.microsoft.azure.management.notificationhubs.models.ResourceListKeys;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleCreateOrUpdateParameters;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleCreateOrUpdateResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleGetResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleListResponse;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleProperties;
import com.microsoft.azure.management.notificationhubs.models.SharedAccessAuthorizationRuleResource;
import com.microsoft.azure.management.notificationhubs.models.WnsCredential;
import com.microsoft.azure.management.notificationhubs.models.WnsCredentialProperties;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Management API includes operations for managing notification hubs.
*/
public class NotificationHubOperationsImpl implements ServiceOperations<NotificationHubsManagementClientImpl>, NotificationHubOperations {
    /**
    * Initializes a new instance of the NotificationHubOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    NotificationHubOperationsImpl(NotificationHubsManagementClientImpl client) {
        this.client = client;
    }
    
    private NotificationHubsManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.notificationhubs.NotificationHubsManagementClientImpl.
    * @return The Client value.
    */
    public NotificationHubsManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Checks the availability of the given notificationHub in a namespace.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param parameters Required. The notificationHub name.
    * @return Response of the Check NameAvailability operation.
    */
    @Override
    public Future<CheckAvailabilityResponse> checkAvailabilityAsync(final String resourceGroupName, final String namespaceName, final CheckAvailabilityParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<CheckAvailabilityResponse>() { 
            @Override
            public CheckAvailabilityResponse call() throws Exception {
                return checkAvailability(resourceGroupName, namespaceName, parameters);
            }
         });
    }
    
    /**
    * Checks the availability of the given notificationHub in a namespace.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx
    * for more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param parameters Required. The notificationHub name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the Check NameAvailability operation.
    */
    @Override
    public CheckAvailabilityResponse checkAvailability(String resourceGroupName, String namespaceName, CheckAvailabilityParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "checkAvailabilityAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/checkNotificationHubAvailability";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode checkAvailabilityParametersValue = objectMapper.createObjectNode();
        requestDoc = checkAvailabilityParametersValue;
        
        ((ObjectNode) checkAvailabilityParametersValue).put("name", parameters.getName());
        
        if (parameters.getLocation() != null) {
            ((ObjectNode) checkAvailabilityParametersValue).put("location", parameters.getLocation());
        }
        
        if (parameters.getTags() != null) {
            if (parameters.getTags() instanceof LazyCollection == false || ((LazyCollection) parameters.getTags()).isInitialized()) {
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                    String tagsKey = entry.getKey();
                    String tagsValue = entry.getValue();
                    ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
                }
                ((ObjectNode) checkAvailabilityParametersValue).put("tags", tagsDictionary);
            }
        }
        
        ((ObjectNode) checkAvailabilityParametersValue).put("isAvailiable", parameters.isAvailable());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            CheckAvailabilityResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new CheckAvailabilityResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    CheckAvailabilityResource valueInstance = new CheckAvailabilityResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode isAvailiableValue = responseDoc.get("isAvailiable");
                    if (isAvailiableValue != null && isAvailiableValue instanceof NullNode == false) {
                        boolean isAvailiableInstance;
                        isAvailiableInstance = isAvailiableValue.getBooleanValue();
                        valueInstance.setIsAvailable(isAvailiableInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates a new NotificationHub in a namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @return Response of the CreateOrUpdate operation on the NotificationHub
    */
    @Override
    public Future<NotificationHubCreateOrUpdateResponse> createAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName, final NotificationHubCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<NotificationHubCreateOrUpdateResponse>() { 
            @Override
            public NotificationHubCreateOrUpdateResponse call() throws Exception {
                return create(resourceGroupName, namespaceName, notificationHubName, parameters);
            }
         });
    }
    
    /**
    * Creates a new NotificationHub in a namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the CreateOrUpdate operation on the NotificationHub
    */
    @Override
    public NotificationHubCreateOrUpdateResponse create(String resourceGroupName, String namespaceName, String notificationHubName, NotificationHubCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode notificationHubCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = notificationHubCreateOrUpdateParametersValue;
        
        ((ObjectNode) notificationHubCreateOrUpdateParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            if (parameters.getTags() instanceof LazyCollection == false || ((LazyCollection) parameters.getTags()).isInitialized()) {
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                    String tagsKey = entry.getKey();
                    String tagsValue = entry.getValue();
                    ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
                }
                ((ObjectNode) notificationHubCreateOrUpdateParametersValue).put("tags", tagsDictionary);
            }
        }
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) notificationHubCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getName() != null) {
            ((ObjectNode) propertiesValue).put("name", parameters.getProperties().getName());
        }
        
        if (parameters.getProperties().getRegistrationTtl() != null) {
            ((ObjectNode) propertiesValue).put("registrationTtl", parameters.getProperties().getRegistrationTtl());
        }
        
        if (parameters.getProperties().getAuthorizationRules() != null) {
            if (parameters.getProperties().getAuthorizationRules() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getAuthorizationRules()).isInitialized()) {
                ArrayNode authorizationRulesArray = objectMapper.createArrayNode();
                for (SharedAccessAuthorizationRuleProperties authorizationRulesItem : parameters.getProperties().getAuthorizationRules()) {
                    if (authorizationRulesItem.getPrimaryKey() != null) {
                        requestDoc = authorizationRulesItem.getPrimaryKey();
                    }
                    
                    if (authorizationRulesItem.getSecondaryKey() != null) {
                        requestDoc = authorizationRulesItem.getSecondaryKey();
                    }
                    
                    if (authorizationRulesItem.getKeyName() != null) {
                        requestDoc = authorizationRulesItem.getKeyName();
                    }
                    
                    if (authorizationRulesItem.getClaimType() != null) {
                        requestDoc = authorizationRulesItem.getClaimType();
                    }
                    
                    if (authorizationRulesItem.getClaimValue() != null) {
                        requestDoc = authorizationRulesItem.getClaimValue();
                    }
                    
                    if (authorizationRulesItem.getRights() != null) {
                        ArrayNode rightsArray = objectMapper.createArrayNode();
                        for (AccessRights rightsItem : authorizationRulesItem.getRights()) {
                            rightsArray.add(rightsItem.toString());
                        }
                        requestDoc = rightsArray;
                    }
                    
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    requestDoc = simpleDateFormat.format(authorizationRulesItem.getCreatedTime().getTime());
                    
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    requestDoc = simpleDateFormat2.format(authorizationRulesItem.getModifiedTime().getTime());
                    
                    requestDoc = authorizationRulesItem.getRevision();
                }
                ((ObjectNode) propertiesValue).put("authorizationRules", authorizationRulesArray);
            }
        }
        
        if (parameters.getProperties().getApnsCredential() != null) {
            ObjectNode apnsCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("apnsCredential", apnsCredentialValue);
            
            if (parameters.getProperties().getApnsCredential().getProperties() != null) {
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                ((ObjectNode) apnsCredentialValue).put("properties", propertiesValue2);
                
                if (parameters.getProperties().getApnsCredential().getProperties().getApnsCertificate() != null) {
                    ((ObjectNode) propertiesValue2).put("apnsCertificate", parameters.getProperties().getApnsCredential().getProperties().getApnsCertificate());
                }
                
                if (parameters.getProperties().getApnsCredential().getProperties().getCertificateKey() != null) {
                    ((ObjectNode) propertiesValue2).put("certificateKey", parameters.getProperties().getApnsCredential().getProperties().getCertificateKey());
                }
                
                if (parameters.getProperties().getApnsCredential().getProperties().getEndpoint() != null) {
                    ((ObjectNode) propertiesValue2).put("endpoint", parameters.getProperties().getApnsCredential().getProperties().getEndpoint());
                }
                
                if (parameters.getProperties().getApnsCredential().getProperties().getThumbprint() != null) {
                    ((ObjectNode) propertiesValue2).put("thumbprint", parameters.getProperties().getApnsCredential().getProperties().getThumbprint());
                }
            }
        }
        
        if (parameters.getProperties().getWnsCredential() != null) {
            ObjectNode wnsCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("wnsCredential", wnsCredentialValue);
            
            if (parameters.getProperties().getWnsCredential().getProperties() != null) {
                ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                ((ObjectNode) wnsCredentialValue).put("properties", propertiesValue3);
                
                if (parameters.getProperties().getWnsCredential().getProperties().getPackageSid() != null) {
                    ((ObjectNode) propertiesValue3).put("packageSid", parameters.getProperties().getWnsCredential().getProperties().getPackageSid());
                }
                
                if (parameters.getProperties().getWnsCredential().getProperties().getSecretKey() != null) {
                    ((ObjectNode) propertiesValue3).put("secretKey", parameters.getProperties().getWnsCredential().getProperties().getSecretKey());
                }
                
                if (parameters.getProperties().getWnsCredential().getProperties().getWindowsLiveEndpoint() != null) {
                    ((ObjectNode) propertiesValue3).put("windowsLiveEndpoint", parameters.getProperties().getWnsCredential().getProperties().getWindowsLiveEndpoint());
                }
            }
        }
        
        if (parameters.getProperties().getGcmCredential() != null) {
            ObjectNode gcmCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("gcmCredential", gcmCredentialValue);
            
            if (parameters.getProperties().getGcmCredential().getProperties() != null) {
                ObjectNode propertiesValue4 = objectMapper.createObjectNode();
                ((ObjectNode) gcmCredentialValue).put("properties", propertiesValue4);
                
                if (parameters.getProperties().getGcmCredential().getProperties().getGcmEndpoint() != null) {
                    ((ObjectNode) propertiesValue4).put("gcmEndpoint", parameters.getProperties().getGcmCredential().getProperties().getGcmEndpoint());
                }
                
                if (parameters.getProperties().getGcmCredential().getProperties().getGoogleApiKey() != null) {
                    ((ObjectNode) propertiesValue4).put("googleApiKey", parameters.getProperties().getGcmCredential().getProperties().getGoogleApiKey());
                }
            }
        }
        
        if (parameters.getProperties().getMpnsCredential() != null) {
            ObjectNode mpnsCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("mpnsCredential", mpnsCredentialValue);
            
            if (parameters.getProperties().getMpnsCredential().getProperties() != null) {
                ObjectNode propertiesValue5 = objectMapper.createObjectNode();
                ((ObjectNode) mpnsCredentialValue).put("properties", propertiesValue5);
                
                if (parameters.getProperties().getMpnsCredential().getProperties().getMpnsCertificate() != null) {
                    ((ObjectNode) propertiesValue5).put("mpnsCertificate", parameters.getProperties().getMpnsCredential().getProperties().getMpnsCertificate());
                }
                
                if (parameters.getProperties().getMpnsCredential().getProperties().getCertificateKey() != null) {
                    ((ObjectNode) propertiesValue5).put("certificateKey", parameters.getProperties().getMpnsCredential().getProperties().getCertificateKey());
                }
                
                if (parameters.getProperties().getMpnsCredential().getProperties().getThumbprint() != null) {
                    ((ObjectNode) propertiesValue5).put("thumbprint", parameters.getProperties().getMpnsCredential().getProperties().getThumbprint());
                }
            }
        }
        
        if (parameters.getProperties().getAdmCredential() != null) {
            ObjectNode admCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("admCredential", admCredentialValue);
            
            if (parameters.getProperties().getAdmCredential().getProperties() != null) {
                ObjectNode propertiesValue6 = objectMapper.createObjectNode();
                ((ObjectNode) admCredentialValue).put("properties", propertiesValue6);
                
                if (parameters.getProperties().getAdmCredential().getProperties().getClientId() != null) {
                    ((ObjectNode) propertiesValue6).put("clientId", parameters.getProperties().getAdmCredential().getProperties().getClientId());
                }
                
                if (parameters.getProperties().getAdmCredential().getProperties().getClientSecret() != null) {
                    ((ObjectNode) propertiesValue6).put("clientSecret", parameters.getProperties().getAdmCredential().getProperties().getClientSecret());
                }
                
                if (parameters.getProperties().getAdmCredential().getProperties().getAuthTokenUrl() != null) {
                    ((ObjectNode) propertiesValue6).put("authTokenUrl", parameters.getProperties().getAdmCredential().getProperties().getAuthTokenUrl());
                }
            }
        }
        
        if (parameters.getProperties().getBaiduCredential() != null) {
            ObjectNode baiduCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("baiduCredential", baiduCredentialValue);
            
            if (parameters.getProperties().getBaiduCredential().getProperties() != null) {
                ObjectNode propertiesValue7 = objectMapper.createObjectNode();
                ((ObjectNode) baiduCredentialValue).put("properties", propertiesValue7);
                
                if (parameters.getProperties().getBaiduCredential().getProperties().getBaiduApiKey() != null) {
                    ((ObjectNode) propertiesValue7).put("baiduApiKey", parameters.getProperties().getBaiduCredential().getProperties().getBaiduApiKey());
                }
                
                if (parameters.getProperties().getBaiduCredential().getProperties().getBaiduEndPoint() != null) {
                    ((ObjectNode) propertiesValue7).put("baiduEndPoint", parameters.getProperties().getBaiduCredential().getProperties().getBaiduEndPoint());
                }
                
                if (parameters.getProperties().getBaiduCredential().getProperties().getBaiduSecretKey() != null) {
                    ((ObjectNode) propertiesValue7).put("baiduSecretKey", parameters.getProperties().getBaiduCredential().getProperties().getBaiduSecretKey());
                }
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NotificationHubCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NotificationHubCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NotificationHubResource valueInstance = new NotificationHubResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode propertiesValue8 = responseDoc.get("properties");
                    if (propertiesValue8 != null && propertiesValue8 instanceof NullNode == false) {
                        NotificationHubProperties propertiesInstance = new NotificationHubProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode nameValue2 = propertiesValue8.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            propertiesInstance.setName(nameInstance2);
                        }
                        
                        JsonNode registrationTtlValue = propertiesValue8.get("registrationTtl");
                        if (registrationTtlValue != null && registrationTtlValue instanceof NullNode == false) {
                            String registrationTtlInstance;
                            registrationTtlInstance = registrationTtlValue.getTextValue();
                            propertiesInstance.setRegistrationTtl(registrationTtlInstance);
                        }
                        
                        JsonNode authorizationRulesArray2 = propertiesValue8.get("authorizationRules");
                        if (authorizationRulesArray2 != null && authorizationRulesArray2 instanceof NullNode == false) {
                            for (JsonNode authorizationRulesValue : ((ArrayNode) authorizationRulesArray2)) {
                                SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRulePropertiesInstance = new SharedAccessAuthorizationRuleProperties();
                                propertiesInstance.getAuthorizationRules().add(sharedAccessAuthorizationRulePropertiesInstance);
                                
                                JsonNode primaryKeyValue = authorizationRulesValue.get("primaryKey");
                                if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                                    String primaryKeyInstance;
                                    primaryKeyInstance = primaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setPrimaryKey(primaryKeyInstance);
                                }
                                
                                JsonNode secondaryKeyValue = authorizationRulesValue.get("secondaryKey");
                                if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                                    String secondaryKeyInstance;
                                    secondaryKeyInstance = secondaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setSecondaryKey(secondaryKeyInstance);
                                }
                                
                                JsonNode keyNameValue = authorizationRulesValue.get("keyName");
                                if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                                    String keyNameInstance;
                                    keyNameInstance = keyNameValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setKeyName(keyNameInstance);
                                }
                                
                                JsonNode claimTypeValue = authorizationRulesValue.get("claimType");
                                if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                                    String claimTypeInstance;
                                    claimTypeInstance = claimTypeValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimType(claimTypeInstance);
                                }
                                
                                JsonNode claimValueValue = authorizationRulesValue.get("claimValue");
                                if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                                    String claimValueInstance;
                                    claimValueInstance = claimValueValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimValue(claimValueInstance);
                                }
                                
                                JsonNode rightsArray2 = authorizationRulesValue.get("rights");
                                if (rightsArray2 != null && rightsArray2 instanceof NullNode == false) {
                                    for (JsonNode rightsValue : ((ArrayNode) rightsArray2)) {
                                        sharedAccessAuthorizationRulePropertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                                    }
                                }
                                
                                JsonNode createdTimeValue = authorizationRulesValue.get("createdTime");
                                if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                                    Calendar createdTimeInstance;
                                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setCreatedTime(createdTimeInstance);
                                }
                                
                                JsonNode modifiedTimeValue = authorizationRulesValue.get("modifiedTime");
                                if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                                    Calendar modifiedTimeInstance;
                                    modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setModifiedTime(modifiedTimeInstance);
                                }
                                
                                JsonNode revisionValue = authorizationRulesValue.get("revision");
                                if (revisionValue != null && revisionValue instanceof NullNode == false) {
                                    int revisionInstance;
                                    revisionInstance = revisionValue.getIntValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setRevision(revisionInstance);
                                }
                            }
                        }
                        
                        JsonNode apnsCredentialValue2 = propertiesValue8.get("apnsCredential");
                        if (apnsCredentialValue2 != null && apnsCredentialValue2 instanceof NullNode == false) {
                            ApnsCredential apnsCredentialInstance = new ApnsCredential();
                            propertiesInstance.setApnsCredential(apnsCredentialInstance);
                            
                            JsonNode propertiesValue9 = apnsCredentialValue2.get("properties");
                            if (propertiesValue9 != null && propertiesValue9 instanceof NullNode == false) {
                                ApnsCredentialProperties propertiesInstance2 = new ApnsCredentialProperties();
                                apnsCredentialInstance.setProperties(propertiesInstance2);
                                
                                JsonNode apnsCertificateValue = propertiesValue9.get("apnsCertificate");
                                if (apnsCertificateValue != null && apnsCertificateValue instanceof NullNode == false) {
                                    String apnsCertificateInstance;
                                    apnsCertificateInstance = apnsCertificateValue.getTextValue();
                                    propertiesInstance2.setApnsCertificate(apnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue = propertiesValue9.get("certificateKey");
                                if (certificateKeyValue != null && certificateKeyValue instanceof NullNode == false) {
                                    String certificateKeyInstance;
                                    certificateKeyInstance = certificateKeyValue.getTextValue();
                                    propertiesInstance2.setCertificateKey(certificateKeyInstance);
                                }
                                
                                JsonNode endpointValue = propertiesValue9.get("endpoint");
                                if (endpointValue != null && endpointValue instanceof NullNode == false) {
                                    String endpointInstance;
                                    endpointInstance = endpointValue.getTextValue();
                                    propertiesInstance2.setEndpoint(endpointInstance);
                                }
                                
                                JsonNode thumbprintValue = propertiesValue9.get("thumbprint");
                                if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                    String thumbprintInstance;
                                    thumbprintInstance = thumbprintValue.getTextValue();
                                    propertiesInstance2.setThumbprint(thumbprintInstance);
                                }
                            }
                        }
                        
                        JsonNode wnsCredentialValue2 = propertiesValue8.get("wnsCredential");
                        if (wnsCredentialValue2 != null && wnsCredentialValue2 instanceof NullNode == false) {
                            WnsCredential wnsCredentialInstance = new WnsCredential();
                            propertiesInstance.setWnsCredential(wnsCredentialInstance);
                            
                            JsonNode propertiesValue10 = wnsCredentialValue2.get("properties");
                            if (propertiesValue10 != null && propertiesValue10 instanceof NullNode == false) {
                                WnsCredentialProperties propertiesInstance3 = new WnsCredentialProperties();
                                wnsCredentialInstance.setProperties(propertiesInstance3);
                                
                                JsonNode packageSidValue = propertiesValue10.get("packageSid");
                                if (packageSidValue != null && packageSidValue instanceof NullNode == false) {
                                    String packageSidInstance;
                                    packageSidInstance = packageSidValue.getTextValue();
                                    propertiesInstance3.setPackageSid(packageSidInstance);
                                }
                                
                                JsonNode secretKeyValue = propertiesValue10.get("secretKey");
                                if (secretKeyValue != null && secretKeyValue instanceof NullNode == false) {
                                    String secretKeyInstance;
                                    secretKeyInstance = secretKeyValue.getTextValue();
                                    propertiesInstance3.setSecretKey(secretKeyInstance);
                                }
                                
                                JsonNode windowsLiveEndpointValue = propertiesValue10.get("windowsLiveEndpoint");
                                if (windowsLiveEndpointValue != null && windowsLiveEndpointValue instanceof NullNode == false) {
                                    String windowsLiveEndpointInstance;
                                    windowsLiveEndpointInstance = windowsLiveEndpointValue.getTextValue();
                                    propertiesInstance3.setWindowsLiveEndpoint(windowsLiveEndpointInstance);
                                }
                            }
                        }
                        
                        JsonNode gcmCredentialValue2 = propertiesValue8.get("gcmCredential");
                        if (gcmCredentialValue2 != null && gcmCredentialValue2 instanceof NullNode == false) {
                            GcmCredential gcmCredentialInstance = new GcmCredential();
                            propertiesInstance.setGcmCredential(gcmCredentialInstance);
                            
                            JsonNode propertiesValue11 = gcmCredentialValue2.get("properties");
                            if (propertiesValue11 != null && propertiesValue11 instanceof NullNode == false) {
                                GcmCredentialProperties propertiesInstance4 = new GcmCredentialProperties();
                                gcmCredentialInstance.setProperties(propertiesInstance4);
                                
                                JsonNode gcmEndpointValue = propertiesValue11.get("gcmEndpoint");
                                if (gcmEndpointValue != null && gcmEndpointValue instanceof NullNode == false) {
                                    String gcmEndpointInstance;
                                    gcmEndpointInstance = gcmEndpointValue.getTextValue();
                                    propertiesInstance4.setGcmEndpoint(gcmEndpointInstance);
                                }
                                
                                JsonNode googleApiKeyValue = propertiesValue11.get("googleApiKey");
                                if (googleApiKeyValue != null && googleApiKeyValue instanceof NullNode == false) {
                                    String googleApiKeyInstance;
                                    googleApiKeyInstance = googleApiKeyValue.getTextValue();
                                    propertiesInstance4.setGoogleApiKey(googleApiKeyInstance);
                                }
                            }
                        }
                        
                        JsonNode mpnsCredentialValue2 = propertiesValue8.get("mpnsCredential");
                        if (mpnsCredentialValue2 != null && mpnsCredentialValue2 instanceof NullNode == false) {
                            MpnsCredential mpnsCredentialInstance = new MpnsCredential();
                            propertiesInstance.setMpnsCredential(mpnsCredentialInstance);
                            
                            JsonNode propertiesValue12 = mpnsCredentialValue2.get("properties");
                            if (propertiesValue12 != null && propertiesValue12 instanceof NullNode == false) {
                                MpnsCredentialProperties propertiesInstance5 = new MpnsCredentialProperties();
                                mpnsCredentialInstance.setProperties(propertiesInstance5);
                                
                                JsonNode mpnsCertificateValue = propertiesValue12.get("mpnsCertificate");
                                if (mpnsCertificateValue != null && mpnsCertificateValue instanceof NullNode == false) {
                                    String mpnsCertificateInstance;
                                    mpnsCertificateInstance = mpnsCertificateValue.getTextValue();
                                    propertiesInstance5.setMpnsCertificate(mpnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue2 = propertiesValue12.get("certificateKey");
                                if (certificateKeyValue2 != null && certificateKeyValue2 instanceof NullNode == false) {
                                    String certificateKeyInstance2;
                                    certificateKeyInstance2 = certificateKeyValue2.getTextValue();
                                    propertiesInstance5.setCertificateKey(certificateKeyInstance2);
                                }
                                
                                JsonNode thumbprintValue2 = propertiesValue12.get("thumbprint");
                                if (thumbprintValue2 != null && thumbprintValue2 instanceof NullNode == false) {
                                    String thumbprintInstance2;
                                    thumbprintInstance2 = thumbprintValue2.getTextValue();
                                    propertiesInstance5.setThumbprint(thumbprintInstance2);
                                }
                            }
                        }
                        
                        JsonNode admCredentialValue2 = propertiesValue8.get("admCredential");
                        if (admCredentialValue2 != null && admCredentialValue2 instanceof NullNode == false) {
                            AdmCredential admCredentialInstance = new AdmCredential();
                            propertiesInstance.setAdmCredential(admCredentialInstance);
                            
                            JsonNode propertiesValue13 = admCredentialValue2.get("properties");
                            if (propertiesValue13 != null && propertiesValue13 instanceof NullNode == false) {
                                AdmCredentialProperties propertiesInstance6 = new AdmCredentialProperties();
                                admCredentialInstance.setProperties(propertiesInstance6);
                                
                                JsonNode clientIdValue = propertiesValue13.get("clientId");
                                if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                    String clientIdInstance;
                                    clientIdInstance = clientIdValue.getTextValue();
                                    propertiesInstance6.setClientId(clientIdInstance);
                                }
                                
                                JsonNode clientSecretValue = propertiesValue13.get("clientSecret");
                                if (clientSecretValue != null && clientSecretValue instanceof NullNode == false) {
                                    String clientSecretInstance;
                                    clientSecretInstance = clientSecretValue.getTextValue();
                                    propertiesInstance6.setClientSecret(clientSecretInstance);
                                }
                                
                                JsonNode authTokenUrlValue = propertiesValue13.get("authTokenUrl");
                                if (authTokenUrlValue != null && authTokenUrlValue instanceof NullNode == false) {
                                    String authTokenUrlInstance;
                                    authTokenUrlInstance = authTokenUrlValue.getTextValue();
                                    propertiesInstance6.setAuthTokenUrl(authTokenUrlInstance);
                                }
                            }
                        }
                        
                        JsonNode baiduCredentialValue2 = propertiesValue8.get("baiduCredential");
                        if (baiduCredentialValue2 != null && baiduCredentialValue2 instanceof NullNode == false) {
                            BaiduCredential baiduCredentialInstance = new BaiduCredential();
                            propertiesInstance.setBaiduCredential(baiduCredentialInstance);
                            
                            JsonNode propertiesValue14 = baiduCredentialValue2.get("properties");
                            if (propertiesValue14 != null && propertiesValue14 instanceof NullNode == false) {
                                BaiduCredentialProperties propertiesInstance7 = new BaiduCredentialProperties();
                                baiduCredentialInstance.setProperties(propertiesInstance7);
                                
                                JsonNode baiduApiKeyValue = propertiesValue14.get("baiduApiKey");
                                if (baiduApiKeyValue != null && baiduApiKeyValue instanceof NullNode == false) {
                                    String baiduApiKeyInstance;
                                    baiduApiKeyInstance = baiduApiKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduApiKey(baiduApiKeyInstance);
                                }
                                
                                JsonNode baiduEndPointValue = propertiesValue14.get("baiduEndPoint");
                                if (baiduEndPointValue != null && baiduEndPointValue instanceof NullNode == false) {
                                    String baiduEndPointInstance;
                                    baiduEndPointInstance = baiduEndPointValue.getTextValue();
                                    propertiesInstance7.setBaiduEndPoint(baiduEndPointInstance);
                                }
                                
                                JsonNode baiduSecretKeyValue = propertiesValue14.get("baiduSecretKey");
                                if (baiduSecretKeyValue != null && baiduSecretKeyValue instanceof NullNode == false) {
                                    String baiduSecretKeyInstance;
                                    baiduSecretKeyInstance = baiduSecretKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduSecretKey(baiduSecretKeyInstance);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The create NotificationHub authorization rule operation creates an
    * authorization rule for a NotificationHub
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @param parameters Required. The shared access authorization rule.
    * @return Response of the CreateOrUpdate operation on the AuthorizationRules
    */
    @Override
    public Future<SharedAccessAuthorizationRuleCreateOrUpdateResponse> createOrUpdateAuthorizationRuleAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName, final String authorizationRuleName, final SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<SharedAccessAuthorizationRuleCreateOrUpdateResponse>() { 
            @Override
            public SharedAccessAuthorizationRuleCreateOrUpdateResponse call() throws Exception {
                return createOrUpdateAuthorizationRule(resourceGroupName, namespaceName, notificationHubName, authorizationRuleName, parameters);
            }
         });
    }
    
    /**
    * The create NotificationHub authorization rule operation creates an
    * authorization rule for a NotificationHub
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @param parameters Required. The shared access authorization rule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the CreateOrUpdate operation on the AuthorizationRules
    */
    @Override
    public SharedAccessAuthorizationRuleCreateOrUpdateResponse createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String notificationHubName, String authorizationRuleName, SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode sharedAccessAuthorizationRuleCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = sharedAccessAuthorizationRuleCreateOrUpdateParametersValue;
        
        if (parameters.getLocation() != null) {
            ((ObjectNode) sharedAccessAuthorizationRuleCreateOrUpdateParametersValue).put("location", parameters.getLocation());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) sharedAccessAuthorizationRuleCreateOrUpdateParametersValue).put("name", parameters.getName());
        }
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) sharedAccessAuthorizationRuleCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getPrimaryKey() != null) {
            ((ObjectNode) propertiesValue).put("primaryKey", parameters.getProperties().getPrimaryKey());
        }
        
        if (parameters.getProperties().getSecondaryKey() != null) {
            ((ObjectNode) propertiesValue).put("secondaryKey", parameters.getProperties().getSecondaryKey());
        }
        
        if (parameters.getProperties().getKeyName() != null) {
            ((ObjectNode) propertiesValue).put("keyName", parameters.getProperties().getKeyName());
        }
        
        if (parameters.getProperties().getClaimType() != null) {
            ((ObjectNode) propertiesValue).put("claimType", parameters.getProperties().getClaimType());
        }
        
        if (parameters.getProperties().getClaimValue() != null) {
            ((ObjectNode) propertiesValue).put("claimValue", parameters.getProperties().getClaimValue());
        }
        
        if (parameters.getProperties().getRights() != null) {
            ArrayNode rightsArray = objectMapper.createArrayNode();
            for (AccessRights rightsItem : parameters.getProperties().getRights()) {
                rightsArray.add(rightsItem.toString());
            }
            ((ObjectNode) propertiesValue).put("rights", rightsArray);
        }
        
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        ((ObjectNode) propertiesValue).put("createdTime", simpleDateFormat.format(parameters.getProperties().getCreatedTime().getTime()));
        
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        ((ObjectNode) propertiesValue).put("modifiedTime", simpleDateFormat2.format(parameters.getProperties().getModifiedTime().getTime()));
        
        ((ObjectNode) propertiesValue).put("revision", parameters.getProperties().getRevision());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SharedAccessAuthorizationRuleCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SharedAccessAuthorizationRuleCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SharedAccessAuthorizationRuleResource valueInstance = new SharedAccessAuthorizationRuleResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        SharedAccessAuthorizationRuleProperties propertiesInstance = new SharedAccessAuthorizationRuleProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode primaryKeyValue = propertiesValue2.get("primaryKey");
                        if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                            String primaryKeyInstance;
                            primaryKeyInstance = primaryKeyValue.getTextValue();
                            propertiesInstance.setPrimaryKey(primaryKeyInstance);
                        }
                        
                        JsonNode secondaryKeyValue = propertiesValue2.get("secondaryKey");
                        if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                            String secondaryKeyInstance;
                            secondaryKeyInstance = secondaryKeyValue.getTextValue();
                            propertiesInstance.setSecondaryKey(secondaryKeyInstance);
                        }
                        
                        JsonNode keyNameValue = propertiesValue2.get("keyName");
                        if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                            String keyNameInstance;
                            keyNameInstance = keyNameValue.getTextValue();
                            propertiesInstance.setKeyName(keyNameInstance);
                        }
                        
                        JsonNode claimTypeValue = propertiesValue2.get("claimType");
                        if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                            String claimTypeInstance;
                            claimTypeInstance = claimTypeValue.getTextValue();
                            propertiesInstance.setClaimType(claimTypeInstance);
                        }
                        
                        JsonNode claimValueValue = propertiesValue2.get("claimValue");
                        if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                            String claimValueInstance;
                            claimValueInstance = claimValueValue.getTextValue();
                            propertiesInstance.setClaimValue(claimValueInstance);
                        }
                        
                        JsonNode rightsArray2 = propertiesValue2.get("rights");
                        if (rightsArray2 != null && rightsArray2 instanceof NullNode == false) {
                            for (JsonNode rightsValue : ((ArrayNode) rightsArray2)) {
                                propertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                            }
                        }
                        
                        JsonNode createdTimeValue = propertiesValue2.get("createdTime");
                        if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                            Calendar createdTimeInstance;
                            createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                            propertiesInstance.setCreatedTime(createdTimeInstance);
                        }
                        
                        JsonNode modifiedTimeValue = propertiesValue2.get("modifiedTime");
                        if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                            Calendar modifiedTimeInstance;
                            modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                            propertiesInstance.setModifiedTime(modifiedTimeInstance);
                        }
                        
                        JsonNode revisionValue = propertiesValue2.get("revision");
                        if (revisionValue != null && revisionValue instanceof NullNode == false) {
                            int revisionInstance;
                            revisionInstance = revisionValue.getIntValue();
                            propertiesInstance.setRevision(revisionInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes a notification hub associated with a namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, namespaceName, notificationHubName);
            }
         });
    }
    
    /**
    * Deletes a notification hub associated with a namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String namespaceName, String notificationHubName) throws InterruptedException, ExecutionException, IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete a notificationHub authorization rule operation
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAuthorizationRuleAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName, final String authorizationRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteAuthorizationRule(resourceGroupName, namespaceName, notificationHubName, authorizationRuleName);
            }
         });
    }
    
    /**
    * The delete a notificationHub authorization rule operation
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The namespace
    * authorizationRuleName name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteAuthorizationRule(String resourceGroupName, String namespaceName, String notificationHubName, String authorizationRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            CloudTracing.enter(invocationId, this, "deleteAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists the notification hubs associated with a namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @return The response of the Get NotificationHub operation.
    */
    @Override
    public Future<NotificationHubGetResponse> getAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName) {
        return this.getClient().getExecutorService().submit(new Callable<NotificationHubGetResponse>() { 
            @Override
            public NotificationHubGetResponse call() throws Exception {
                return get(resourceGroupName, namespaceName, notificationHubName);
            }
         });
    }
    
    /**
    * Lists the notification hubs associated with a namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the Get NotificationHub operation.
    */
    @Override
    public NotificationHubGetResponse get(String resourceGroupName, String namespaceName, String notificationHubName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NotificationHubGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NotificationHubGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NotificationHubResource valueInstance = new NotificationHubResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        NotificationHubProperties propertiesInstance = new NotificationHubProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode nameValue2 = propertiesValue.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            propertiesInstance.setName(nameInstance2);
                        }
                        
                        JsonNode registrationTtlValue = propertiesValue.get("registrationTtl");
                        if (registrationTtlValue != null && registrationTtlValue instanceof NullNode == false) {
                            String registrationTtlInstance;
                            registrationTtlInstance = registrationTtlValue.getTextValue();
                            propertiesInstance.setRegistrationTtl(registrationTtlInstance);
                        }
                        
                        JsonNode authorizationRulesArray = propertiesValue.get("authorizationRules");
                        if (authorizationRulesArray != null && authorizationRulesArray instanceof NullNode == false) {
                            for (JsonNode authorizationRulesValue : ((ArrayNode) authorizationRulesArray)) {
                                SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRulePropertiesInstance = new SharedAccessAuthorizationRuleProperties();
                                propertiesInstance.getAuthorizationRules().add(sharedAccessAuthorizationRulePropertiesInstance);
                                
                                JsonNode primaryKeyValue = authorizationRulesValue.get("primaryKey");
                                if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                                    String primaryKeyInstance;
                                    primaryKeyInstance = primaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setPrimaryKey(primaryKeyInstance);
                                }
                                
                                JsonNode secondaryKeyValue = authorizationRulesValue.get("secondaryKey");
                                if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                                    String secondaryKeyInstance;
                                    secondaryKeyInstance = secondaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setSecondaryKey(secondaryKeyInstance);
                                }
                                
                                JsonNode keyNameValue = authorizationRulesValue.get("keyName");
                                if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                                    String keyNameInstance;
                                    keyNameInstance = keyNameValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setKeyName(keyNameInstance);
                                }
                                
                                JsonNode claimTypeValue = authorizationRulesValue.get("claimType");
                                if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                                    String claimTypeInstance;
                                    claimTypeInstance = claimTypeValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimType(claimTypeInstance);
                                }
                                
                                JsonNode claimValueValue = authorizationRulesValue.get("claimValue");
                                if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                                    String claimValueInstance;
                                    claimValueInstance = claimValueValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimValue(claimValueInstance);
                                }
                                
                                JsonNode rightsArray = authorizationRulesValue.get("rights");
                                if (rightsArray != null && rightsArray instanceof NullNode == false) {
                                    for (JsonNode rightsValue : ((ArrayNode) rightsArray)) {
                                        sharedAccessAuthorizationRulePropertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                                    }
                                }
                                
                                JsonNode createdTimeValue = authorizationRulesValue.get("createdTime");
                                if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                                    Calendar createdTimeInstance;
                                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setCreatedTime(createdTimeInstance);
                                }
                                
                                JsonNode modifiedTimeValue = authorizationRulesValue.get("modifiedTime");
                                if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                                    Calendar modifiedTimeInstance;
                                    modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setModifiedTime(modifiedTimeInstance);
                                }
                                
                                JsonNode revisionValue = authorizationRulesValue.get("revision");
                                if (revisionValue != null && revisionValue instanceof NullNode == false) {
                                    int revisionInstance;
                                    revisionInstance = revisionValue.getIntValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setRevision(revisionInstance);
                                }
                            }
                        }
                        
                        JsonNode apnsCredentialValue = propertiesValue.get("apnsCredential");
                        if (apnsCredentialValue != null && apnsCredentialValue instanceof NullNode == false) {
                            ApnsCredential apnsCredentialInstance = new ApnsCredential();
                            propertiesInstance.setApnsCredential(apnsCredentialInstance);
                            
                            JsonNode propertiesValue2 = apnsCredentialValue.get("properties");
                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                ApnsCredentialProperties propertiesInstance2 = new ApnsCredentialProperties();
                                apnsCredentialInstance.setProperties(propertiesInstance2);
                                
                                JsonNode apnsCertificateValue = propertiesValue2.get("apnsCertificate");
                                if (apnsCertificateValue != null && apnsCertificateValue instanceof NullNode == false) {
                                    String apnsCertificateInstance;
                                    apnsCertificateInstance = apnsCertificateValue.getTextValue();
                                    propertiesInstance2.setApnsCertificate(apnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue = propertiesValue2.get("certificateKey");
                                if (certificateKeyValue != null && certificateKeyValue instanceof NullNode == false) {
                                    String certificateKeyInstance;
                                    certificateKeyInstance = certificateKeyValue.getTextValue();
                                    propertiesInstance2.setCertificateKey(certificateKeyInstance);
                                }
                                
                                JsonNode endpointValue = propertiesValue2.get("endpoint");
                                if (endpointValue != null && endpointValue instanceof NullNode == false) {
                                    String endpointInstance;
                                    endpointInstance = endpointValue.getTextValue();
                                    propertiesInstance2.setEndpoint(endpointInstance);
                                }
                                
                                JsonNode thumbprintValue = propertiesValue2.get("thumbprint");
                                if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                    String thumbprintInstance;
                                    thumbprintInstance = thumbprintValue.getTextValue();
                                    propertiesInstance2.setThumbprint(thumbprintInstance);
                                }
                            }
                        }
                        
                        JsonNode wnsCredentialValue = propertiesValue.get("wnsCredential");
                        if (wnsCredentialValue != null && wnsCredentialValue instanceof NullNode == false) {
                            WnsCredential wnsCredentialInstance = new WnsCredential();
                            propertiesInstance.setWnsCredential(wnsCredentialInstance);
                            
                            JsonNode propertiesValue3 = wnsCredentialValue.get("properties");
                            if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                WnsCredentialProperties propertiesInstance3 = new WnsCredentialProperties();
                                wnsCredentialInstance.setProperties(propertiesInstance3);
                                
                                JsonNode packageSidValue = propertiesValue3.get("packageSid");
                                if (packageSidValue != null && packageSidValue instanceof NullNode == false) {
                                    String packageSidInstance;
                                    packageSidInstance = packageSidValue.getTextValue();
                                    propertiesInstance3.setPackageSid(packageSidInstance);
                                }
                                
                                JsonNode secretKeyValue = propertiesValue3.get("secretKey");
                                if (secretKeyValue != null && secretKeyValue instanceof NullNode == false) {
                                    String secretKeyInstance;
                                    secretKeyInstance = secretKeyValue.getTextValue();
                                    propertiesInstance3.setSecretKey(secretKeyInstance);
                                }
                                
                                JsonNode windowsLiveEndpointValue = propertiesValue3.get("windowsLiveEndpoint");
                                if (windowsLiveEndpointValue != null && windowsLiveEndpointValue instanceof NullNode == false) {
                                    String windowsLiveEndpointInstance;
                                    windowsLiveEndpointInstance = windowsLiveEndpointValue.getTextValue();
                                    propertiesInstance3.setWindowsLiveEndpoint(windowsLiveEndpointInstance);
                                }
                            }
                        }
                        
                        JsonNode gcmCredentialValue = propertiesValue.get("gcmCredential");
                        if (gcmCredentialValue != null && gcmCredentialValue instanceof NullNode == false) {
                            GcmCredential gcmCredentialInstance = new GcmCredential();
                            propertiesInstance.setGcmCredential(gcmCredentialInstance);
                            
                            JsonNode propertiesValue4 = gcmCredentialValue.get("properties");
                            if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                GcmCredentialProperties propertiesInstance4 = new GcmCredentialProperties();
                                gcmCredentialInstance.setProperties(propertiesInstance4);
                                
                                JsonNode gcmEndpointValue = propertiesValue4.get("gcmEndpoint");
                                if (gcmEndpointValue != null && gcmEndpointValue instanceof NullNode == false) {
                                    String gcmEndpointInstance;
                                    gcmEndpointInstance = gcmEndpointValue.getTextValue();
                                    propertiesInstance4.setGcmEndpoint(gcmEndpointInstance);
                                }
                                
                                JsonNode googleApiKeyValue = propertiesValue4.get("googleApiKey");
                                if (googleApiKeyValue != null && googleApiKeyValue instanceof NullNode == false) {
                                    String googleApiKeyInstance;
                                    googleApiKeyInstance = googleApiKeyValue.getTextValue();
                                    propertiesInstance4.setGoogleApiKey(googleApiKeyInstance);
                                }
                            }
                        }
                        
                        JsonNode mpnsCredentialValue = propertiesValue.get("mpnsCredential");
                        if (mpnsCredentialValue != null && mpnsCredentialValue instanceof NullNode == false) {
                            MpnsCredential mpnsCredentialInstance = new MpnsCredential();
                            propertiesInstance.setMpnsCredential(mpnsCredentialInstance);
                            
                            JsonNode propertiesValue5 = mpnsCredentialValue.get("properties");
                            if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                MpnsCredentialProperties propertiesInstance5 = new MpnsCredentialProperties();
                                mpnsCredentialInstance.setProperties(propertiesInstance5);
                                
                                JsonNode mpnsCertificateValue = propertiesValue5.get("mpnsCertificate");
                                if (mpnsCertificateValue != null && mpnsCertificateValue instanceof NullNode == false) {
                                    String mpnsCertificateInstance;
                                    mpnsCertificateInstance = mpnsCertificateValue.getTextValue();
                                    propertiesInstance5.setMpnsCertificate(mpnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue2 = propertiesValue5.get("certificateKey");
                                if (certificateKeyValue2 != null && certificateKeyValue2 instanceof NullNode == false) {
                                    String certificateKeyInstance2;
                                    certificateKeyInstance2 = certificateKeyValue2.getTextValue();
                                    propertiesInstance5.setCertificateKey(certificateKeyInstance2);
                                }
                                
                                JsonNode thumbprintValue2 = propertiesValue5.get("thumbprint");
                                if (thumbprintValue2 != null && thumbprintValue2 instanceof NullNode == false) {
                                    String thumbprintInstance2;
                                    thumbprintInstance2 = thumbprintValue2.getTextValue();
                                    propertiesInstance5.setThumbprint(thumbprintInstance2);
                                }
                            }
                        }
                        
                        JsonNode admCredentialValue = propertiesValue.get("admCredential");
                        if (admCredentialValue != null && admCredentialValue instanceof NullNode == false) {
                            AdmCredential admCredentialInstance = new AdmCredential();
                            propertiesInstance.setAdmCredential(admCredentialInstance);
                            
                            JsonNode propertiesValue6 = admCredentialValue.get("properties");
                            if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                AdmCredentialProperties propertiesInstance6 = new AdmCredentialProperties();
                                admCredentialInstance.setProperties(propertiesInstance6);
                                
                                JsonNode clientIdValue = propertiesValue6.get("clientId");
                                if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                    String clientIdInstance;
                                    clientIdInstance = clientIdValue.getTextValue();
                                    propertiesInstance6.setClientId(clientIdInstance);
                                }
                                
                                JsonNode clientSecretValue = propertiesValue6.get("clientSecret");
                                if (clientSecretValue != null && clientSecretValue instanceof NullNode == false) {
                                    String clientSecretInstance;
                                    clientSecretInstance = clientSecretValue.getTextValue();
                                    propertiesInstance6.setClientSecret(clientSecretInstance);
                                }
                                
                                JsonNode authTokenUrlValue = propertiesValue6.get("authTokenUrl");
                                if (authTokenUrlValue != null && authTokenUrlValue instanceof NullNode == false) {
                                    String authTokenUrlInstance;
                                    authTokenUrlInstance = authTokenUrlValue.getTextValue();
                                    propertiesInstance6.setAuthTokenUrl(authTokenUrlInstance);
                                }
                            }
                        }
                        
                        JsonNode baiduCredentialValue = propertiesValue.get("baiduCredential");
                        if (baiduCredentialValue != null && baiduCredentialValue instanceof NullNode == false) {
                            BaiduCredential baiduCredentialInstance = new BaiduCredential();
                            propertiesInstance.setBaiduCredential(baiduCredentialInstance);
                            
                            JsonNode propertiesValue7 = baiduCredentialValue.get("properties");
                            if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                BaiduCredentialProperties propertiesInstance7 = new BaiduCredentialProperties();
                                baiduCredentialInstance.setProperties(propertiesInstance7);
                                
                                JsonNode baiduApiKeyValue = propertiesValue7.get("baiduApiKey");
                                if (baiduApiKeyValue != null && baiduApiKeyValue instanceof NullNode == false) {
                                    String baiduApiKeyInstance;
                                    baiduApiKeyInstance = baiduApiKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduApiKey(baiduApiKeyInstance);
                                }
                                
                                JsonNode baiduEndPointValue = propertiesValue7.get("baiduEndPoint");
                                if (baiduEndPointValue != null && baiduEndPointValue instanceof NullNode == false) {
                                    String baiduEndPointInstance;
                                    baiduEndPointInstance = baiduEndPointValue.getTextValue();
                                    propertiesInstance7.setBaiduEndPoint(baiduEndPointInstance);
                                }
                                
                                JsonNode baiduSecretKeyValue = propertiesValue7.get("baiduSecretKey");
                                if (baiduSecretKeyValue != null && baiduSecretKeyValue instanceof NullNode == false) {
                                    String baiduSecretKeyInstance;
                                    baiduSecretKeyInstance = baiduSecretKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduSecretKey(baiduSecretKeyInstance);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * NotificationHub by name.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The entity name to get the
    * authorization rule for.
    * @return The response of the Get Namespace operation.
    */
    @Override
    public Future<SharedAccessAuthorizationRuleGetResponse> getAuthorizationRuleAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName, final String authorizationRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<SharedAccessAuthorizationRuleGetResponse>() { 
            @Override
            public SharedAccessAuthorizationRuleGetResponse call() throws Exception {
                return getAuthorizationRule(resourceGroupName, namespaceName, notificationHubName, authorizationRuleName);
            }
         });
    }
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * NotificationHub by name.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The entity name to get the
    * authorization rule for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the Get Namespace operation.
    */
    @Override
    public SharedAccessAuthorizationRuleGetResponse getAuthorizationRule(String resourceGroupName, String namespaceName, String notificationHubName, String authorizationRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            CloudTracing.enter(invocationId, this, "getAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SharedAccessAuthorizationRuleGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SharedAccessAuthorizationRuleGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    SharedAccessAuthorizationRuleResource valueInstance = new SharedAccessAuthorizationRuleResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        SharedAccessAuthorizationRuleProperties propertiesInstance = new SharedAccessAuthorizationRuleProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode primaryKeyValue = propertiesValue.get("primaryKey");
                        if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                            String primaryKeyInstance;
                            primaryKeyInstance = primaryKeyValue.getTextValue();
                            propertiesInstance.setPrimaryKey(primaryKeyInstance);
                        }
                        
                        JsonNode secondaryKeyValue = propertiesValue.get("secondaryKey");
                        if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                            String secondaryKeyInstance;
                            secondaryKeyInstance = secondaryKeyValue.getTextValue();
                            propertiesInstance.setSecondaryKey(secondaryKeyInstance);
                        }
                        
                        JsonNode keyNameValue = propertiesValue.get("keyName");
                        if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                            String keyNameInstance;
                            keyNameInstance = keyNameValue.getTextValue();
                            propertiesInstance.setKeyName(keyNameInstance);
                        }
                        
                        JsonNode claimTypeValue = propertiesValue.get("claimType");
                        if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                            String claimTypeInstance;
                            claimTypeInstance = claimTypeValue.getTextValue();
                            propertiesInstance.setClaimType(claimTypeInstance);
                        }
                        
                        JsonNode claimValueValue = propertiesValue.get("claimValue");
                        if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                            String claimValueInstance;
                            claimValueInstance = claimValueValue.getTextValue();
                            propertiesInstance.setClaimValue(claimValueInstance);
                        }
                        
                        JsonNode rightsArray = propertiesValue.get("rights");
                        if (rightsArray != null && rightsArray instanceof NullNode == false) {
                            for (JsonNode rightsValue : ((ArrayNode) rightsArray)) {
                                propertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                            }
                        }
                        
                        JsonNode createdTimeValue = propertiesValue.get("createdTime");
                        if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                            Calendar createdTimeInstance;
                            createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                            propertiesInstance.setCreatedTime(createdTimeInstance);
                        }
                        
                        JsonNode modifiedTimeValue = propertiesValue.get("modifiedTime");
                        if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                            Calendar modifiedTimeInstance;
                            modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                            propertiesInstance.setModifiedTime(modifiedTimeInstance);
                        }
                        
                        JsonNode revisionValue = propertiesValue.get("revision");
                        if (revisionValue != null && revisionValue instanceof NullNode == false) {
                            int revisionInstance;
                            revisionInstance = revisionValue.getIntValue();
                            propertiesInstance.setRevision(revisionInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists the PNS Credentials associated with a notification hub .
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @return The response of the Get NotificationHub operation.
    */
    @Override
    public Future<NotificationHubGetResponse> getPnsCredentialsAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName) {
        return this.getClient().getExecutorService().submit(new Callable<NotificationHubGetResponse>() { 
            @Override
            public NotificationHubGetResponse call() throws Exception {
                return getPnsCredentials(resourceGroupName, namespaceName, notificationHubName);
            }
         });
    }
    
    /**
    * Lists the PNS Credentials associated with a notification hub .
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the Get NotificationHub operation.
    */
    @Override
    public NotificationHubGetResponse getPnsCredentials(String resourceGroupName, String namespaceName, String notificationHubName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            CloudTracing.enter(invocationId, this, "getPnsCredentialsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        url = url + "/pnsCredentials";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NotificationHubGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NotificationHubGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NotificationHubResource valueInstance = new NotificationHubResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        NotificationHubProperties propertiesInstance = new NotificationHubProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode nameValue2 = propertiesValue.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            propertiesInstance.setName(nameInstance2);
                        }
                        
                        JsonNode registrationTtlValue = propertiesValue.get("registrationTtl");
                        if (registrationTtlValue != null && registrationTtlValue instanceof NullNode == false) {
                            String registrationTtlInstance;
                            registrationTtlInstance = registrationTtlValue.getTextValue();
                            propertiesInstance.setRegistrationTtl(registrationTtlInstance);
                        }
                        
                        JsonNode authorizationRulesArray = propertiesValue.get("authorizationRules");
                        if (authorizationRulesArray != null && authorizationRulesArray instanceof NullNode == false) {
                            for (JsonNode authorizationRulesValue : ((ArrayNode) authorizationRulesArray)) {
                                SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRulePropertiesInstance = new SharedAccessAuthorizationRuleProperties();
                                propertiesInstance.getAuthorizationRules().add(sharedAccessAuthorizationRulePropertiesInstance);
                                
                                JsonNode primaryKeyValue = authorizationRulesValue.get("primaryKey");
                                if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                                    String primaryKeyInstance;
                                    primaryKeyInstance = primaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setPrimaryKey(primaryKeyInstance);
                                }
                                
                                JsonNode secondaryKeyValue = authorizationRulesValue.get("secondaryKey");
                                if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                                    String secondaryKeyInstance;
                                    secondaryKeyInstance = secondaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setSecondaryKey(secondaryKeyInstance);
                                }
                                
                                JsonNode keyNameValue = authorizationRulesValue.get("keyName");
                                if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                                    String keyNameInstance;
                                    keyNameInstance = keyNameValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setKeyName(keyNameInstance);
                                }
                                
                                JsonNode claimTypeValue = authorizationRulesValue.get("claimType");
                                if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                                    String claimTypeInstance;
                                    claimTypeInstance = claimTypeValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimType(claimTypeInstance);
                                }
                                
                                JsonNode claimValueValue = authorizationRulesValue.get("claimValue");
                                if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                                    String claimValueInstance;
                                    claimValueInstance = claimValueValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimValue(claimValueInstance);
                                }
                                
                                JsonNode rightsArray = authorizationRulesValue.get("rights");
                                if (rightsArray != null && rightsArray instanceof NullNode == false) {
                                    for (JsonNode rightsValue : ((ArrayNode) rightsArray)) {
                                        sharedAccessAuthorizationRulePropertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                                    }
                                }
                                
                                JsonNode createdTimeValue = authorizationRulesValue.get("createdTime");
                                if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                                    Calendar createdTimeInstance;
                                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setCreatedTime(createdTimeInstance);
                                }
                                
                                JsonNode modifiedTimeValue = authorizationRulesValue.get("modifiedTime");
                                if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                                    Calendar modifiedTimeInstance;
                                    modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setModifiedTime(modifiedTimeInstance);
                                }
                                
                                JsonNode revisionValue = authorizationRulesValue.get("revision");
                                if (revisionValue != null && revisionValue instanceof NullNode == false) {
                                    int revisionInstance;
                                    revisionInstance = revisionValue.getIntValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setRevision(revisionInstance);
                                }
                            }
                        }
                        
                        JsonNode apnsCredentialValue = propertiesValue.get("apnsCredential");
                        if (apnsCredentialValue != null && apnsCredentialValue instanceof NullNode == false) {
                            ApnsCredential apnsCredentialInstance = new ApnsCredential();
                            propertiesInstance.setApnsCredential(apnsCredentialInstance);
                            
                            JsonNode propertiesValue2 = apnsCredentialValue.get("properties");
                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                ApnsCredentialProperties propertiesInstance2 = new ApnsCredentialProperties();
                                apnsCredentialInstance.setProperties(propertiesInstance2);
                                
                                JsonNode apnsCertificateValue = propertiesValue2.get("apnsCertificate");
                                if (apnsCertificateValue != null && apnsCertificateValue instanceof NullNode == false) {
                                    String apnsCertificateInstance;
                                    apnsCertificateInstance = apnsCertificateValue.getTextValue();
                                    propertiesInstance2.setApnsCertificate(apnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue = propertiesValue2.get("certificateKey");
                                if (certificateKeyValue != null && certificateKeyValue instanceof NullNode == false) {
                                    String certificateKeyInstance;
                                    certificateKeyInstance = certificateKeyValue.getTextValue();
                                    propertiesInstance2.setCertificateKey(certificateKeyInstance);
                                }
                                
                                JsonNode endpointValue = propertiesValue2.get("endpoint");
                                if (endpointValue != null && endpointValue instanceof NullNode == false) {
                                    String endpointInstance;
                                    endpointInstance = endpointValue.getTextValue();
                                    propertiesInstance2.setEndpoint(endpointInstance);
                                }
                                
                                JsonNode thumbprintValue = propertiesValue2.get("thumbprint");
                                if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                    String thumbprintInstance;
                                    thumbprintInstance = thumbprintValue.getTextValue();
                                    propertiesInstance2.setThumbprint(thumbprintInstance);
                                }
                            }
                        }
                        
                        JsonNode wnsCredentialValue = propertiesValue.get("wnsCredential");
                        if (wnsCredentialValue != null && wnsCredentialValue instanceof NullNode == false) {
                            WnsCredential wnsCredentialInstance = new WnsCredential();
                            propertiesInstance.setWnsCredential(wnsCredentialInstance);
                            
                            JsonNode propertiesValue3 = wnsCredentialValue.get("properties");
                            if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                WnsCredentialProperties propertiesInstance3 = new WnsCredentialProperties();
                                wnsCredentialInstance.setProperties(propertiesInstance3);
                                
                                JsonNode packageSidValue = propertiesValue3.get("packageSid");
                                if (packageSidValue != null && packageSidValue instanceof NullNode == false) {
                                    String packageSidInstance;
                                    packageSidInstance = packageSidValue.getTextValue();
                                    propertiesInstance3.setPackageSid(packageSidInstance);
                                }
                                
                                JsonNode secretKeyValue = propertiesValue3.get("secretKey");
                                if (secretKeyValue != null && secretKeyValue instanceof NullNode == false) {
                                    String secretKeyInstance;
                                    secretKeyInstance = secretKeyValue.getTextValue();
                                    propertiesInstance3.setSecretKey(secretKeyInstance);
                                }
                                
                                JsonNode windowsLiveEndpointValue = propertiesValue3.get("windowsLiveEndpoint");
                                if (windowsLiveEndpointValue != null && windowsLiveEndpointValue instanceof NullNode == false) {
                                    String windowsLiveEndpointInstance;
                                    windowsLiveEndpointInstance = windowsLiveEndpointValue.getTextValue();
                                    propertiesInstance3.setWindowsLiveEndpoint(windowsLiveEndpointInstance);
                                }
                            }
                        }
                        
                        JsonNode gcmCredentialValue = propertiesValue.get("gcmCredential");
                        if (gcmCredentialValue != null && gcmCredentialValue instanceof NullNode == false) {
                            GcmCredential gcmCredentialInstance = new GcmCredential();
                            propertiesInstance.setGcmCredential(gcmCredentialInstance);
                            
                            JsonNode propertiesValue4 = gcmCredentialValue.get("properties");
                            if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                GcmCredentialProperties propertiesInstance4 = new GcmCredentialProperties();
                                gcmCredentialInstance.setProperties(propertiesInstance4);
                                
                                JsonNode gcmEndpointValue = propertiesValue4.get("gcmEndpoint");
                                if (gcmEndpointValue != null && gcmEndpointValue instanceof NullNode == false) {
                                    String gcmEndpointInstance;
                                    gcmEndpointInstance = gcmEndpointValue.getTextValue();
                                    propertiesInstance4.setGcmEndpoint(gcmEndpointInstance);
                                }
                                
                                JsonNode googleApiKeyValue = propertiesValue4.get("googleApiKey");
                                if (googleApiKeyValue != null && googleApiKeyValue instanceof NullNode == false) {
                                    String googleApiKeyInstance;
                                    googleApiKeyInstance = googleApiKeyValue.getTextValue();
                                    propertiesInstance4.setGoogleApiKey(googleApiKeyInstance);
                                }
                            }
                        }
                        
                        JsonNode mpnsCredentialValue = propertiesValue.get("mpnsCredential");
                        if (mpnsCredentialValue != null && mpnsCredentialValue instanceof NullNode == false) {
                            MpnsCredential mpnsCredentialInstance = new MpnsCredential();
                            propertiesInstance.setMpnsCredential(mpnsCredentialInstance);
                            
                            JsonNode propertiesValue5 = mpnsCredentialValue.get("properties");
                            if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                MpnsCredentialProperties propertiesInstance5 = new MpnsCredentialProperties();
                                mpnsCredentialInstance.setProperties(propertiesInstance5);
                                
                                JsonNode mpnsCertificateValue = propertiesValue5.get("mpnsCertificate");
                                if (mpnsCertificateValue != null && mpnsCertificateValue instanceof NullNode == false) {
                                    String mpnsCertificateInstance;
                                    mpnsCertificateInstance = mpnsCertificateValue.getTextValue();
                                    propertiesInstance5.setMpnsCertificate(mpnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue2 = propertiesValue5.get("certificateKey");
                                if (certificateKeyValue2 != null && certificateKeyValue2 instanceof NullNode == false) {
                                    String certificateKeyInstance2;
                                    certificateKeyInstance2 = certificateKeyValue2.getTextValue();
                                    propertiesInstance5.setCertificateKey(certificateKeyInstance2);
                                }
                                
                                JsonNode thumbprintValue2 = propertiesValue5.get("thumbprint");
                                if (thumbprintValue2 != null && thumbprintValue2 instanceof NullNode == false) {
                                    String thumbprintInstance2;
                                    thumbprintInstance2 = thumbprintValue2.getTextValue();
                                    propertiesInstance5.setThumbprint(thumbprintInstance2);
                                }
                            }
                        }
                        
                        JsonNode admCredentialValue = propertiesValue.get("admCredential");
                        if (admCredentialValue != null && admCredentialValue instanceof NullNode == false) {
                            AdmCredential admCredentialInstance = new AdmCredential();
                            propertiesInstance.setAdmCredential(admCredentialInstance);
                            
                            JsonNode propertiesValue6 = admCredentialValue.get("properties");
                            if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                AdmCredentialProperties propertiesInstance6 = new AdmCredentialProperties();
                                admCredentialInstance.setProperties(propertiesInstance6);
                                
                                JsonNode clientIdValue = propertiesValue6.get("clientId");
                                if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                    String clientIdInstance;
                                    clientIdInstance = clientIdValue.getTextValue();
                                    propertiesInstance6.setClientId(clientIdInstance);
                                }
                                
                                JsonNode clientSecretValue = propertiesValue6.get("clientSecret");
                                if (clientSecretValue != null && clientSecretValue instanceof NullNode == false) {
                                    String clientSecretInstance;
                                    clientSecretInstance = clientSecretValue.getTextValue();
                                    propertiesInstance6.setClientSecret(clientSecretInstance);
                                }
                                
                                JsonNode authTokenUrlValue = propertiesValue6.get("authTokenUrl");
                                if (authTokenUrlValue != null && authTokenUrlValue instanceof NullNode == false) {
                                    String authTokenUrlInstance;
                                    authTokenUrlInstance = authTokenUrlValue.getTextValue();
                                    propertiesInstance6.setAuthTokenUrl(authTokenUrlInstance);
                                }
                            }
                        }
                        
                        JsonNode baiduCredentialValue = propertiesValue.get("baiduCredential");
                        if (baiduCredentialValue != null && baiduCredentialValue instanceof NullNode == false) {
                            BaiduCredential baiduCredentialInstance = new BaiduCredential();
                            propertiesInstance.setBaiduCredential(baiduCredentialInstance);
                            
                            JsonNode propertiesValue7 = baiduCredentialValue.get("properties");
                            if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                BaiduCredentialProperties propertiesInstance7 = new BaiduCredentialProperties();
                                baiduCredentialInstance.setProperties(propertiesInstance7);
                                
                                JsonNode baiduApiKeyValue = propertiesValue7.get("baiduApiKey");
                                if (baiduApiKeyValue != null && baiduApiKeyValue instanceof NullNode == false) {
                                    String baiduApiKeyInstance;
                                    baiduApiKeyInstance = baiduApiKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduApiKey(baiduApiKeyInstance);
                                }
                                
                                JsonNode baiduEndPointValue = propertiesValue7.get("baiduEndPoint");
                                if (baiduEndPointValue != null && baiduEndPointValue instanceof NullNode == false) {
                                    String baiduEndPointInstance;
                                    baiduEndPointInstance = baiduEndPointValue.getTextValue();
                                    propertiesInstance7.setBaiduEndPoint(baiduEndPointInstance);
                                }
                                
                                JsonNode baiduSecretKeyValue = propertiesValue7.get("baiduSecretKey");
                                if (baiduSecretKeyValue != null && baiduSecretKeyValue instanceof NullNode == false) {
                                    String baiduSecretKeyInstance;
                                    baiduSecretKeyInstance = baiduSecretKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduSecretKey(baiduSecretKeyInstance);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists the notification hubs associated with a namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @return The response of the List NotificationHub operation.
    */
    @Override
    public Future<NotificationHubListResponse> listAsync(final String resourceGroupName, final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<NotificationHubListResponse>() { 
            @Override
            public NotificationHubListResponse call() throws Exception {
                return list(resourceGroupName, namespaceName);
            }
         });
    }
    
    /**
    * Lists the notification hubs associated with a namespace.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response of the List NotificationHub operation.
    */
    @Override
    public NotificationHubListResponse list(String resourceGroupName, String namespaceName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NotificationHubListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NotificationHubListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            NotificationHubResource notificationHubResourceInstance = new NotificationHubResource();
                            result.getValue().add(notificationHubResourceInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                notificationHubResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                notificationHubResourceInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                notificationHubResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                notificationHubResourceInstance.setType(typeInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    notificationHubResourceInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                NotificationHubProperties propertiesInstance = new NotificationHubProperties();
                                notificationHubResourceInstance.setProperties(propertiesInstance);
                                
                                JsonNode nameValue2 = propertiesValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    propertiesInstance.setName(nameInstance2);
                                }
                                
                                JsonNode registrationTtlValue = propertiesValue.get("registrationTtl");
                                if (registrationTtlValue != null && registrationTtlValue instanceof NullNode == false) {
                                    String registrationTtlInstance;
                                    registrationTtlInstance = registrationTtlValue.getTextValue();
                                    propertiesInstance.setRegistrationTtl(registrationTtlInstance);
                                }
                                
                                JsonNode authorizationRulesArray = propertiesValue.get("authorizationRules");
                                if (authorizationRulesArray != null && authorizationRulesArray instanceof NullNode == false) {
                                    for (JsonNode authorizationRulesValue : ((ArrayNode) authorizationRulesArray)) {
                                        SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRulePropertiesInstance = new SharedAccessAuthorizationRuleProperties();
                                        propertiesInstance.getAuthorizationRules().add(sharedAccessAuthorizationRulePropertiesInstance);
                                        
                                        JsonNode primaryKeyValue = authorizationRulesValue.get("primaryKey");
                                        if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                                            String primaryKeyInstance;
                                            primaryKeyInstance = primaryKeyValue.getTextValue();
                                            sharedAccessAuthorizationRulePropertiesInstance.setPrimaryKey(primaryKeyInstance);
                                        }
                                        
                                        JsonNode secondaryKeyValue = authorizationRulesValue.get("secondaryKey");
                                        if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                                            String secondaryKeyInstance;
                                            secondaryKeyInstance = secondaryKeyValue.getTextValue();
                                            sharedAccessAuthorizationRulePropertiesInstance.setSecondaryKey(secondaryKeyInstance);
                                        }
                                        
                                        JsonNode keyNameValue = authorizationRulesValue.get("keyName");
                                        if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                                            String keyNameInstance;
                                            keyNameInstance = keyNameValue.getTextValue();
                                            sharedAccessAuthorizationRulePropertiesInstance.setKeyName(keyNameInstance);
                                        }
                                        
                                        JsonNode claimTypeValue = authorizationRulesValue.get("claimType");
                                        if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                                            String claimTypeInstance;
                                            claimTypeInstance = claimTypeValue.getTextValue();
                                            sharedAccessAuthorizationRulePropertiesInstance.setClaimType(claimTypeInstance);
                                        }
                                        
                                        JsonNode claimValueValue = authorizationRulesValue.get("claimValue");
                                        if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                                            String claimValueInstance;
                                            claimValueInstance = claimValueValue.getTextValue();
                                            sharedAccessAuthorizationRulePropertiesInstance.setClaimValue(claimValueInstance);
                                        }
                                        
                                        JsonNode rightsArray = authorizationRulesValue.get("rights");
                                        if (rightsArray != null && rightsArray instanceof NullNode == false) {
                                            for (JsonNode rightsValue : ((ArrayNode) rightsArray)) {
                                                sharedAccessAuthorizationRulePropertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                                            }
                                        }
                                        
                                        JsonNode createdTimeValue = authorizationRulesValue.get("createdTime");
                                        if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                                            Calendar createdTimeInstance;
                                            createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                                            sharedAccessAuthorizationRulePropertiesInstance.setCreatedTime(createdTimeInstance);
                                        }
                                        
                                        JsonNode modifiedTimeValue = authorizationRulesValue.get("modifiedTime");
                                        if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                                            Calendar modifiedTimeInstance;
                                            modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                                            sharedAccessAuthorizationRulePropertiesInstance.setModifiedTime(modifiedTimeInstance);
                                        }
                                        
                                        JsonNode revisionValue = authorizationRulesValue.get("revision");
                                        if (revisionValue != null && revisionValue instanceof NullNode == false) {
                                            int revisionInstance;
                                            revisionInstance = revisionValue.getIntValue();
                                            sharedAccessAuthorizationRulePropertiesInstance.setRevision(revisionInstance);
                                        }
                                    }
                                }
                                
                                JsonNode apnsCredentialValue = propertiesValue.get("apnsCredential");
                                if (apnsCredentialValue != null && apnsCredentialValue instanceof NullNode == false) {
                                    ApnsCredential apnsCredentialInstance = new ApnsCredential();
                                    propertiesInstance.setApnsCredential(apnsCredentialInstance);
                                    
                                    JsonNode propertiesValue2 = apnsCredentialValue.get("properties");
                                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                        ApnsCredentialProperties propertiesInstance2 = new ApnsCredentialProperties();
                                        apnsCredentialInstance.setProperties(propertiesInstance2);
                                        
                                        JsonNode apnsCertificateValue = propertiesValue2.get("apnsCertificate");
                                        if (apnsCertificateValue != null && apnsCertificateValue instanceof NullNode == false) {
                                            String apnsCertificateInstance;
                                            apnsCertificateInstance = apnsCertificateValue.getTextValue();
                                            propertiesInstance2.setApnsCertificate(apnsCertificateInstance);
                                        }
                                        
                                        JsonNode certificateKeyValue = propertiesValue2.get("certificateKey");
                                        if (certificateKeyValue != null && certificateKeyValue instanceof NullNode == false) {
                                            String certificateKeyInstance;
                                            certificateKeyInstance = certificateKeyValue.getTextValue();
                                            propertiesInstance2.setCertificateKey(certificateKeyInstance);
                                        }
                                        
                                        JsonNode endpointValue = propertiesValue2.get("endpoint");
                                        if (endpointValue != null && endpointValue instanceof NullNode == false) {
                                            String endpointInstance;
                                            endpointInstance = endpointValue.getTextValue();
                                            propertiesInstance2.setEndpoint(endpointInstance);
                                        }
                                        
                                        JsonNode thumbprintValue = propertiesValue2.get("thumbprint");
                                        if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                            String thumbprintInstance;
                                            thumbprintInstance = thumbprintValue.getTextValue();
                                            propertiesInstance2.setThumbprint(thumbprintInstance);
                                        }
                                    }
                                }
                                
                                JsonNode wnsCredentialValue = propertiesValue.get("wnsCredential");
                                if (wnsCredentialValue != null && wnsCredentialValue instanceof NullNode == false) {
                                    WnsCredential wnsCredentialInstance = new WnsCredential();
                                    propertiesInstance.setWnsCredential(wnsCredentialInstance);
                                    
                                    JsonNode propertiesValue3 = wnsCredentialValue.get("properties");
                                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                        WnsCredentialProperties propertiesInstance3 = new WnsCredentialProperties();
                                        wnsCredentialInstance.setProperties(propertiesInstance3);
                                        
                                        JsonNode packageSidValue = propertiesValue3.get("packageSid");
                                        if (packageSidValue != null && packageSidValue instanceof NullNode == false) {
                                            String packageSidInstance;
                                            packageSidInstance = packageSidValue.getTextValue();
                                            propertiesInstance3.setPackageSid(packageSidInstance);
                                        }
                                        
                                        JsonNode secretKeyValue = propertiesValue3.get("secretKey");
                                        if (secretKeyValue != null && secretKeyValue instanceof NullNode == false) {
                                            String secretKeyInstance;
                                            secretKeyInstance = secretKeyValue.getTextValue();
                                            propertiesInstance3.setSecretKey(secretKeyInstance);
                                        }
                                        
                                        JsonNode windowsLiveEndpointValue = propertiesValue3.get("windowsLiveEndpoint");
                                        if (windowsLiveEndpointValue != null && windowsLiveEndpointValue instanceof NullNode == false) {
                                            String windowsLiveEndpointInstance;
                                            windowsLiveEndpointInstance = windowsLiveEndpointValue.getTextValue();
                                            propertiesInstance3.setWindowsLiveEndpoint(windowsLiveEndpointInstance);
                                        }
                                    }
                                }
                                
                                JsonNode gcmCredentialValue = propertiesValue.get("gcmCredential");
                                if (gcmCredentialValue != null && gcmCredentialValue instanceof NullNode == false) {
                                    GcmCredential gcmCredentialInstance = new GcmCredential();
                                    propertiesInstance.setGcmCredential(gcmCredentialInstance);
                                    
                                    JsonNode propertiesValue4 = gcmCredentialValue.get("properties");
                                    if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                                        GcmCredentialProperties propertiesInstance4 = new GcmCredentialProperties();
                                        gcmCredentialInstance.setProperties(propertiesInstance4);
                                        
                                        JsonNode gcmEndpointValue = propertiesValue4.get("gcmEndpoint");
                                        if (gcmEndpointValue != null && gcmEndpointValue instanceof NullNode == false) {
                                            String gcmEndpointInstance;
                                            gcmEndpointInstance = gcmEndpointValue.getTextValue();
                                            propertiesInstance4.setGcmEndpoint(gcmEndpointInstance);
                                        }
                                        
                                        JsonNode googleApiKeyValue = propertiesValue4.get("googleApiKey");
                                        if (googleApiKeyValue != null && googleApiKeyValue instanceof NullNode == false) {
                                            String googleApiKeyInstance;
                                            googleApiKeyInstance = googleApiKeyValue.getTextValue();
                                            propertiesInstance4.setGoogleApiKey(googleApiKeyInstance);
                                        }
                                    }
                                }
                                
                                JsonNode mpnsCredentialValue = propertiesValue.get("mpnsCredential");
                                if (mpnsCredentialValue != null && mpnsCredentialValue instanceof NullNode == false) {
                                    MpnsCredential mpnsCredentialInstance = new MpnsCredential();
                                    propertiesInstance.setMpnsCredential(mpnsCredentialInstance);
                                    
                                    JsonNode propertiesValue5 = mpnsCredentialValue.get("properties");
                                    if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                        MpnsCredentialProperties propertiesInstance5 = new MpnsCredentialProperties();
                                        mpnsCredentialInstance.setProperties(propertiesInstance5);
                                        
                                        JsonNode mpnsCertificateValue = propertiesValue5.get("mpnsCertificate");
                                        if (mpnsCertificateValue != null && mpnsCertificateValue instanceof NullNode == false) {
                                            String mpnsCertificateInstance;
                                            mpnsCertificateInstance = mpnsCertificateValue.getTextValue();
                                            propertiesInstance5.setMpnsCertificate(mpnsCertificateInstance);
                                        }
                                        
                                        JsonNode certificateKeyValue2 = propertiesValue5.get("certificateKey");
                                        if (certificateKeyValue2 != null && certificateKeyValue2 instanceof NullNode == false) {
                                            String certificateKeyInstance2;
                                            certificateKeyInstance2 = certificateKeyValue2.getTextValue();
                                            propertiesInstance5.setCertificateKey(certificateKeyInstance2);
                                        }
                                        
                                        JsonNode thumbprintValue2 = propertiesValue5.get("thumbprint");
                                        if (thumbprintValue2 != null && thumbprintValue2 instanceof NullNode == false) {
                                            String thumbprintInstance2;
                                            thumbprintInstance2 = thumbprintValue2.getTextValue();
                                            propertiesInstance5.setThumbprint(thumbprintInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode admCredentialValue = propertiesValue.get("admCredential");
                                if (admCredentialValue != null && admCredentialValue instanceof NullNode == false) {
                                    AdmCredential admCredentialInstance = new AdmCredential();
                                    propertiesInstance.setAdmCredential(admCredentialInstance);
                                    
                                    JsonNode propertiesValue6 = admCredentialValue.get("properties");
                                    if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                        AdmCredentialProperties propertiesInstance6 = new AdmCredentialProperties();
                                        admCredentialInstance.setProperties(propertiesInstance6);
                                        
                                        JsonNode clientIdValue = propertiesValue6.get("clientId");
                                        if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                            String clientIdInstance;
                                            clientIdInstance = clientIdValue.getTextValue();
                                            propertiesInstance6.setClientId(clientIdInstance);
                                        }
                                        
                                        JsonNode clientSecretValue = propertiesValue6.get("clientSecret");
                                        if (clientSecretValue != null && clientSecretValue instanceof NullNode == false) {
                                            String clientSecretInstance;
                                            clientSecretInstance = clientSecretValue.getTextValue();
                                            propertiesInstance6.setClientSecret(clientSecretInstance);
                                        }
                                        
                                        JsonNode authTokenUrlValue = propertiesValue6.get("authTokenUrl");
                                        if (authTokenUrlValue != null && authTokenUrlValue instanceof NullNode == false) {
                                            String authTokenUrlInstance;
                                            authTokenUrlInstance = authTokenUrlValue.getTextValue();
                                            propertiesInstance6.setAuthTokenUrl(authTokenUrlInstance);
                                        }
                                    }
                                }
                                
                                JsonNode baiduCredentialValue = propertiesValue.get("baiduCredential");
                                if (baiduCredentialValue != null && baiduCredentialValue instanceof NullNode == false) {
                                    BaiduCredential baiduCredentialInstance = new BaiduCredential();
                                    propertiesInstance.setBaiduCredential(baiduCredentialInstance);
                                    
                                    JsonNode propertiesValue7 = baiduCredentialValue.get("properties");
                                    if (propertiesValue7 != null && propertiesValue7 instanceof NullNode == false) {
                                        BaiduCredentialProperties propertiesInstance7 = new BaiduCredentialProperties();
                                        baiduCredentialInstance.setProperties(propertiesInstance7);
                                        
                                        JsonNode baiduApiKeyValue = propertiesValue7.get("baiduApiKey");
                                        if (baiduApiKeyValue != null && baiduApiKeyValue instanceof NullNode == false) {
                                            String baiduApiKeyInstance;
                                            baiduApiKeyInstance = baiduApiKeyValue.getTextValue();
                                            propertiesInstance7.setBaiduApiKey(baiduApiKeyInstance);
                                        }
                                        
                                        JsonNode baiduEndPointValue = propertiesValue7.get("baiduEndPoint");
                                        if (baiduEndPointValue != null && baiduEndPointValue instanceof NullNode == false) {
                                            String baiduEndPointInstance;
                                            baiduEndPointInstance = baiduEndPointValue.getTextValue();
                                            propertiesInstance7.setBaiduEndPoint(baiduEndPointInstance);
                                        }
                                        
                                        JsonNode baiduSecretKeyValue = propertiesValue7.get("baiduSecretKey");
                                        if (baiduSecretKeyValue != null && baiduSecretKeyValue instanceof NullNode == false) {
                                            String baiduSecretKeyInstance;
                                            baiduSecretKeyInstance = baiduSecretKeyValue.getTextValue();
                                            propertiesInstance7.setBaiduSecretKey(baiduSecretKeyInstance);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * NotificationHub.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The NotificationHub to get the
    * authorization rule for.
    * @param notificationHubName Required. The notification hub name.
    * @return The response of the List Namespace operation.
    */
    @Override
    public Future<SharedAccessAuthorizationRuleListResponse> listAuthorizationRulesAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName) {
        return this.getClient().getExecutorService().submit(new Callable<SharedAccessAuthorizationRuleListResponse>() { 
            @Override
            public SharedAccessAuthorizationRuleListResponse call() throws Exception {
                return listAuthorizationRules(resourceGroupName, namespaceName, notificationHubName);
            }
         });
    }
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * NotificationHub.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The NotificationHub to get the
    * authorization rule for.
    * @param notificationHubName Required. The notification hub name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response of the List Namespace operation.
    */
    @Override
    public SharedAccessAuthorizationRuleListResponse listAuthorizationRules(String resourceGroupName, String namespaceName, String notificationHubName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            CloudTracing.enter(invocationId, this, "listAuthorizationRulesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        url = url + "/AuthorizationRules";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SharedAccessAuthorizationRuleListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SharedAccessAuthorizationRuleListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            SharedAccessAuthorizationRuleResource sharedAccessAuthorizationRuleResourceInstance = new SharedAccessAuthorizationRuleResource();
                            result.getValue().add(sharedAccessAuthorizationRuleResourceInstance);
                            
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                sharedAccessAuthorizationRuleResourceInstance.setType(typeInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    sharedAccessAuthorizationRuleResourceInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                SharedAccessAuthorizationRuleProperties propertiesInstance = new SharedAccessAuthorizationRuleProperties();
                                sharedAccessAuthorizationRuleResourceInstance.setProperties(propertiesInstance);
                                
                                JsonNode primaryKeyValue = propertiesValue.get("primaryKey");
                                if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                                    String primaryKeyInstance;
                                    primaryKeyInstance = primaryKeyValue.getTextValue();
                                    propertiesInstance.setPrimaryKey(primaryKeyInstance);
                                }
                                
                                JsonNode secondaryKeyValue = propertiesValue.get("secondaryKey");
                                if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                                    String secondaryKeyInstance;
                                    secondaryKeyInstance = secondaryKeyValue.getTextValue();
                                    propertiesInstance.setSecondaryKey(secondaryKeyInstance);
                                }
                                
                                JsonNode keyNameValue = propertiesValue.get("keyName");
                                if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                                    String keyNameInstance;
                                    keyNameInstance = keyNameValue.getTextValue();
                                    propertiesInstance.setKeyName(keyNameInstance);
                                }
                                
                                JsonNode claimTypeValue = propertiesValue.get("claimType");
                                if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                                    String claimTypeInstance;
                                    claimTypeInstance = claimTypeValue.getTextValue();
                                    propertiesInstance.setClaimType(claimTypeInstance);
                                }
                                
                                JsonNode claimValueValue = propertiesValue.get("claimValue");
                                if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                                    String claimValueInstance;
                                    claimValueInstance = claimValueValue.getTextValue();
                                    propertiesInstance.setClaimValue(claimValueInstance);
                                }
                                
                                JsonNode rightsArray = propertiesValue.get("rights");
                                if (rightsArray != null && rightsArray instanceof NullNode == false) {
                                    for (JsonNode rightsValue : ((ArrayNode) rightsArray)) {
                                        propertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                                    }
                                }
                                
                                JsonNode createdTimeValue = propertiesValue.get("createdTime");
                                if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                                    Calendar createdTimeInstance;
                                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                                    propertiesInstance.setCreatedTime(createdTimeInstance);
                                }
                                
                                JsonNode modifiedTimeValue = propertiesValue.get("modifiedTime");
                                if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                                    Calendar modifiedTimeInstance;
                                    modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                                    propertiesInstance.setModifiedTime(modifiedTimeInstance);
                                }
                                
                                JsonNode revisionValue = propertiesValue.get("revision");
                                if (revisionValue != null && revisionValue instanceof NullNode == false) {
                                    int revisionInstance;
                                    revisionInstance = revisionValue.getIntValue();
                                    propertiesInstance.setRevision(revisionInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the Primary and Secondary ConnectionStrings to the NotificationHub
    * (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The connection string of the
    * NotificationHub for the specified authorizationRule.
    * @return Namespace/NotificationHub Connection String
    */
    @Override
    public Future<ResourceListKeys> listKeysAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName, final String authorizationRuleName) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceListKeys>() { 
            @Override
            public ResourceListKeys call() throws Exception {
                return listKeys(resourceGroupName, namespaceName, notificationHubName, authorizationRuleName);
            }
         });
    }
    
    /**
    * Gets the Primary and Secondary ConnectionStrings to the NotificationHub
    * (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param authorizationRuleName Required. The connection string of the
    * NotificationHub for the specified authorizationRule.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Namespace/NotificationHub Connection String
    */
    @Override
    public ResourceListKeys listKeys(String resourceGroupName, String namespaceName, String notificationHubName, String authorizationRuleName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        if (authorizationRuleName == null) {
            throw new NullPointerException("authorizationRuleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            tracingParameters.put("authorizationRuleName", authorizationRuleName);
            CloudTracing.enter(invocationId, this, "listKeysAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(authorizationRuleName, "UTF-8");
        url = url + "/listKeys";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ResourceListKeys result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceListKeys();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode primaryConnectionStringValue = responseDoc.get("primaryConnectionString");
                    if (primaryConnectionStringValue != null && primaryConnectionStringValue instanceof NullNode == false) {
                        String primaryConnectionStringInstance;
                        primaryConnectionStringInstance = primaryConnectionStringValue.getTextValue();
                        result.setPrimaryConnectionString(primaryConnectionStringInstance);
                    }
                    
                    JsonNode secondaryConnectionStringValue = responseDoc.get("secondaryConnectionString");
                    if (secondaryConnectionStringValue != null && secondaryConnectionStringValue instanceof NullNode == false) {
                        String secondaryConnectionStringInstance;
                        secondaryConnectionStringInstance = secondaryConnectionStringValue.getTextValue();
                        result.setSecondaryConnectionString(secondaryConnectionStringInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates a new NotificationHub in a namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @return Response of the CreateOrUpdate operation on the NotificationHub
    */
    @Override
    public Future<NotificationHubCreateOrUpdateResponse> updateAsync(final String resourceGroupName, final String namespaceName, final String notificationHubName, final NotificationHubCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<NotificationHubCreateOrUpdateResponse>() { 
            @Override
            public NotificationHubCreateOrUpdateResponse call() throws Exception {
                return update(resourceGroupName, namespaceName, notificationHubName, parameters);
            }
         });
    }
    
    /**
    * Creates a new NotificationHub in a namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param namespaceName Required. The namespace name.
    * @param notificationHubName Required. The notification hub name.
    * @param parameters Required. Parameters supplied to the create a Namespace
    * Resource.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Response of the CreateOrUpdate operation on the NotificationHub
    */
    @Override
    public NotificationHubCreateOrUpdateResponse update(String resourceGroupName, String namespaceName, String notificationHubName, NotificationHubCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (notificationHubName == null) {
            throw new NullPointerException("notificationHubName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProperties() == null) {
            throw new NullPointerException("parameters.Properties");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("notificationHubName", notificationHubName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.NotificationHubs";
        url = url + "/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/notificationHubs/";
        url = url + URLEncoder.encode(notificationHubName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-09-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("if-match", "*");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode notificationHubCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = notificationHubCreateOrUpdateParametersValue;
        
        ((ObjectNode) notificationHubCreateOrUpdateParametersValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            if (parameters.getTags() instanceof LazyCollection == false || ((LazyCollection) parameters.getTags()).isInitialized()) {
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                    String tagsKey = entry.getKey();
                    String tagsValue = entry.getValue();
                    ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
                }
                ((ObjectNode) notificationHubCreateOrUpdateParametersValue).put("tags", tagsDictionary);
            }
        }
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) notificationHubCreateOrUpdateParametersValue).put("properties", propertiesValue);
        
        if (parameters.getProperties().getName() != null) {
            ((ObjectNode) propertiesValue).put("name", parameters.getProperties().getName());
        }
        
        if (parameters.getProperties().getRegistrationTtl() != null) {
            ((ObjectNode) propertiesValue).put("registrationTtl", parameters.getProperties().getRegistrationTtl());
        }
        
        if (parameters.getProperties().getAuthorizationRules() != null) {
            if (parameters.getProperties().getAuthorizationRules() instanceof LazyCollection == false || ((LazyCollection) parameters.getProperties().getAuthorizationRules()).isInitialized()) {
                ArrayNode authorizationRulesArray = objectMapper.createArrayNode();
                for (SharedAccessAuthorizationRuleProperties authorizationRulesItem : parameters.getProperties().getAuthorizationRules()) {
                    if (authorizationRulesItem.getPrimaryKey() != null) {
                        requestDoc = authorizationRulesItem.getPrimaryKey();
                    }
                    
                    if (authorizationRulesItem.getSecondaryKey() != null) {
                        requestDoc = authorizationRulesItem.getSecondaryKey();
                    }
                    
                    if (authorizationRulesItem.getKeyName() != null) {
                        requestDoc = authorizationRulesItem.getKeyName();
                    }
                    
                    if (authorizationRulesItem.getClaimType() != null) {
                        requestDoc = authorizationRulesItem.getClaimType();
                    }
                    
                    if (authorizationRulesItem.getClaimValue() != null) {
                        requestDoc = authorizationRulesItem.getClaimValue();
                    }
                    
                    if (authorizationRulesItem.getRights() != null) {
                        ArrayNode rightsArray = objectMapper.createArrayNode();
                        for (AccessRights rightsItem : authorizationRulesItem.getRights()) {
                            rightsArray.add(rightsItem.toString());
                        }
                        requestDoc = rightsArray;
                    }
                    
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    requestDoc = simpleDateFormat.format(authorizationRulesItem.getCreatedTime().getTime());
                    
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    requestDoc = simpleDateFormat2.format(authorizationRulesItem.getModifiedTime().getTime());
                    
                    requestDoc = authorizationRulesItem.getRevision();
                }
                ((ObjectNode) propertiesValue).put("authorizationRules", authorizationRulesArray);
            }
        }
        
        if (parameters.getProperties().getApnsCredential() != null) {
            ObjectNode apnsCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("apnsCredential", apnsCredentialValue);
            
            if (parameters.getProperties().getApnsCredential().getProperties() != null) {
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                ((ObjectNode) apnsCredentialValue).put("properties", propertiesValue2);
                
                if (parameters.getProperties().getApnsCredential().getProperties().getApnsCertificate() != null) {
                    ((ObjectNode) propertiesValue2).put("apnsCertificate", parameters.getProperties().getApnsCredential().getProperties().getApnsCertificate());
                }
                
                if (parameters.getProperties().getApnsCredential().getProperties().getCertificateKey() != null) {
                    ((ObjectNode) propertiesValue2).put("certificateKey", parameters.getProperties().getApnsCredential().getProperties().getCertificateKey());
                }
                
                if (parameters.getProperties().getApnsCredential().getProperties().getEndpoint() != null) {
                    ((ObjectNode) propertiesValue2).put("endpoint", parameters.getProperties().getApnsCredential().getProperties().getEndpoint());
                }
                
                if (parameters.getProperties().getApnsCredential().getProperties().getThumbprint() != null) {
                    ((ObjectNode) propertiesValue2).put("thumbprint", parameters.getProperties().getApnsCredential().getProperties().getThumbprint());
                }
            }
        }
        
        if (parameters.getProperties().getWnsCredential() != null) {
            ObjectNode wnsCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("wnsCredential", wnsCredentialValue);
            
            if (parameters.getProperties().getWnsCredential().getProperties() != null) {
                ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                ((ObjectNode) wnsCredentialValue).put("properties", propertiesValue3);
                
                if (parameters.getProperties().getWnsCredential().getProperties().getPackageSid() != null) {
                    ((ObjectNode) propertiesValue3).put("packageSid", parameters.getProperties().getWnsCredential().getProperties().getPackageSid());
                }
                
                if (parameters.getProperties().getWnsCredential().getProperties().getSecretKey() != null) {
                    ((ObjectNode) propertiesValue3).put("secretKey", parameters.getProperties().getWnsCredential().getProperties().getSecretKey());
                }
                
                if (parameters.getProperties().getWnsCredential().getProperties().getWindowsLiveEndpoint() != null) {
                    ((ObjectNode) propertiesValue3).put("windowsLiveEndpoint", parameters.getProperties().getWnsCredential().getProperties().getWindowsLiveEndpoint());
                }
            }
        }
        
        if (parameters.getProperties().getGcmCredential() != null) {
            ObjectNode gcmCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("gcmCredential", gcmCredentialValue);
            
            if (parameters.getProperties().getGcmCredential().getProperties() != null) {
                ObjectNode propertiesValue4 = objectMapper.createObjectNode();
                ((ObjectNode) gcmCredentialValue).put("properties", propertiesValue4);
                
                if (parameters.getProperties().getGcmCredential().getProperties().getGcmEndpoint() != null) {
                    ((ObjectNode) propertiesValue4).put("gcmEndpoint", parameters.getProperties().getGcmCredential().getProperties().getGcmEndpoint());
                }
                
                if (parameters.getProperties().getGcmCredential().getProperties().getGoogleApiKey() != null) {
                    ((ObjectNode) propertiesValue4).put("googleApiKey", parameters.getProperties().getGcmCredential().getProperties().getGoogleApiKey());
                }
            }
        }
        
        if (parameters.getProperties().getMpnsCredential() != null) {
            ObjectNode mpnsCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("mpnsCredential", mpnsCredentialValue);
            
            if (parameters.getProperties().getMpnsCredential().getProperties() != null) {
                ObjectNode propertiesValue5 = objectMapper.createObjectNode();
                ((ObjectNode) mpnsCredentialValue).put("properties", propertiesValue5);
                
                if (parameters.getProperties().getMpnsCredential().getProperties().getMpnsCertificate() != null) {
                    ((ObjectNode) propertiesValue5).put("mpnsCertificate", parameters.getProperties().getMpnsCredential().getProperties().getMpnsCertificate());
                }
                
                if (parameters.getProperties().getMpnsCredential().getProperties().getCertificateKey() != null) {
                    ((ObjectNode) propertiesValue5).put("certificateKey", parameters.getProperties().getMpnsCredential().getProperties().getCertificateKey());
                }
                
                if (parameters.getProperties().getMpnsCredential().getProperties().getThumbprint() != null) {
                    ((ObjectNode) propertiesValue5).put("thumbprint", parameters.getProperties().getMpnsCredential().getProperties().getThumbprint());
                }
            }
        }
        
        if (parameters.getProperties().getAdmCredential() != null) {
            ObjectNode admCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("admCredential", admCredentialValue);
            
            if (parameters.getProperties().getAdmCredential().getProperties() != null) {
                ObjectNode propertiesValue6 = objectMapper.createObjectNode();
                ((ObjectNode) admCredentialValue).put("properties", propertiesValue6);
                
                if (parameters.getProperties().getAdmCredential().getProperties().getClientId() != null) {
                    ((ObjectNode) propertiesValue6).put("clientId", parameters.getProperties().getAdmCredential().getProperties().getClientId());
                }
                
                if (parameters.getProperties().getAdmCredential().getProperties().getClientSecret() != null) {
                    ((ObjectNode) propertiesValue6).put("clientSecret", parameters.getProperties().getAdmCredential().getProperties().getClientSecret());
                }
                
                if (parameters.getProperties().getAdmCredential().getProperties().getAuthTokenUrl() != null) {
                    ((ObjectNode) propertiesValue6).put("authTokenUrl", parameters.getProperties().getAdmCredential().getProperties().getAuthTokenUrl());
                }
            }
        }
        
        if (parameters.getProperties().getBaiduCredential() != null) {
            ObjectNode baiduCredentialValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("baiduCredential", baiduCredentialValue);
            
            if (parameters.getProperties().getBaiduCredential().getProperties() != null) {
                ObjectNode propertiesValue7 = objectMapper.createObjectNode();
                ((ObjectNode) baiduCredentialValue).put("properties", propertiesValue7);
                
                if (parameters.getProperties().getBaiduCredential().getProperties().getBaiduApiKey() != null) {
                    ((ObjectNode) propertiesValue7).put("baiduApiKey", parameters.getProperties().getBaiduCredential().getProperties().getBaiduApiKey());
                }
                
                if (parameters.getProperties().getBaiduCredential().getProperties().getBaiduEndPoint() != null) {
                    ((ObjectNode) propertiesValue7).put("baiduEndPoint", parameters.getProperties().getBaiduCredential().getProperties().getBaiduEndPoint());
                }
                
                if (parameters.getProperties().getBaiduCredential().getProperties().getBaiduSecretKey() != null) {
                    ((ObjectNode) propertiesValue7).put("baiduSecretKey", parameters.getProperties().getBaiduCredential().getProperties().getBaiduSecretKey());
                }
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            NotificationHubCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new NotificationHubCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    NotificationHubResource valueInstance = new NotificationHubResource();
                    result.setValue(valueInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        valueInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        valueInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        valueInstance.setType(typeInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            valueInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    
                    JsonNode propertiesValue8 = responseDoc.get("properties");
                    if (propertiesValue8 != null && propertiesValue8 instanceof NullNode == false) {
                        NotificationHubProperties propertiesInstance = new NotificationHubProperties();
                        valueInstance.setProperties(propertiesInstance);
                        
                        JsonNode nameValue2 = propertiesValue8.get("name");
                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                            String nameInstance2;
                            nameInstance2 = nameValue2.getTextValue();
                            propertiesInstance.setName(nameInstance2);
                        }
                        
                        JsonNode registrationTtlValue = propertiesValue8.get("registrationTtl");
                        if (registrationTtlValue != null && registrationTtlValue instanceof NullNode == false) {
                            String registrationTtlInstance;
                            registrationTtlInstance = registrationTtlValue.getTextValue();
                            propertiesInstance.setRegistrationTtl(registrationTtlInstance);
                        }
                        
                        JsonNode authorizationRulesArray2 = propertiesValue8.get("authorizationRules");
                        if (authorizationRulesArray2 != null && authorizationRulesArray2 instanceof NullNode == false) {
                            for (JsonNode authorizationRulesValue : ((ArrayNode) authorizationRulesArray2)) {
                                SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRulePropertiesInstance = new SharedAccessAuthorizationRuleProperties();
                                propertiesInstance.getAuthorizationRules().add(sharedAccessAuthorizationRulePropertiesInstance);
                                
                                JsonNode primaryKeyValue = authorizationRulesValue.get("primaryKey");
                                if (primaryKeyValue != null && primaryKeyValue instanceof NullNode == false) {
                                    String primaryKeyInstance;
                                    primaryKeyInstance = primaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setPrimaryKey(primaryKeyInstance);
                                }
                                
                                JsonNode secondaryKeyValue = authorizationRulesValue.get("secondaryKey");
                                if (secondaryKeyValue != null && secondaryKeyValue instanceof NullNode == false) {
                                    String secondaryKeyInstance;
                                    secondaryKeyInstance = secondaryKeyValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setSecondaryKey(secondaryKeyInstance);
                                }
                                
                                JsonNode keyNameValue = authorizationRulesValue.get("keyName");
                                if (keyNameValue != null && keyNameValue instanceof NullNode == false) {
                                    String keyNameInstance;
                                    keyNameInstance = keyNameValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setKeyName(keyNameInstance);
                                }
                                
                                JsonNode claimTypeValue = authorizationRulesValue.get("claimType");
                                if (claimTypeValue != null && claimTypeValue instanceof NullNode == false) {
                                    String claimTypeInstance;
                                    claimTypeInstance = claimTypeValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimType(claimTypeInstance);
                                }
                                
                                JsonNode claimValueValue = authorizationRulesValue.get("claimValue");
                                if (claimValueValue != null && claimValueValue instanceof NullNode == false) {
                                    String claimValueInstance;
                                    claimValueInstance = claimValueValue.getTextValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setClaimValue(claimValueInstance);
                                }
                                
                                JsonNode rightsArray2 = authorizationRulesValue.get("rights");
                                if (rightsArray2 != null && rightsArray2 instanceof NullNode == false) {
                                    for (JsonNode rightsValue : ((ArrayNode) rightsArray2)) {
                                        sharedAccessAuthorizationRulePropertiesInstance.getRights().add(Enum.valueOf(AccessRights.class, rightsValue.getTextValue()));
                                    }
                                }
                                
                                JsonNode createdTimeValue = authorizationRulesValue.get("createdTime");
                                if (createdTimeValue != null && createdTimeValue instanceof NullNode == false) {
                                    Calendar createdTimeInstance;
                                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setCreatedTime(createdTimeInstance);
                                }
                                
                                JsonNode modifiedTimeValue = authorizationRulesValue.get("modifiedTime");
                                if (modifiedTimeValue != null && modifiedTimeValue instanceof NullNode == false) {
                                    Calendar modifiedTimeInstance;
                                    modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeValue.getTextValue());
                                    sharedAccessAuthorizationRulePropertiesInstance.setModifiedTime(modifiedTimeInstance);
                                }
                                
                                JsonNode revisionValue = authorizationRulesValue.get("revision");
                                if (revisionValue != null && revisionValue instanceof NullNode == false) {
                                    int revisionInstance;
                                    revisionInstance = revisionValue.getIntValue();
                                    sharedAccessAuthorizationRulePropertiesInstance.setRevision(revisionInstance);
                                }
                            }
                        }
                        
                        JsonNode apnsCredentialValue2 = propertiesValue8.get("apnsCredential");
                        if (apnsCredentialValue2 != null && apnsCredentialValue2 instanceof NullNode == false) {
                            ApnsCredential apnsCredentialInstance = new ApnsCredential();
                            propertiesInstance.setApnsCredential(apnsCredentialInstance);
                            
                            JsonNode propertiesValue9 = apnsCredentialValue2.get("properties");
                            if (propertiesValue9 != null && propertiesValue9 instanceof NullNode == false) {
                                ApnsCredentialProperties propertiesInstance2 = new ApnsCredentialProperties();
                                apnsCredentialInstance.setProperties(propertiesInstance2);
                                
                                JsonNode apnsCertificateValue = propertiesValue9.get("apnsCertificate");
                                if (apnsCertificateValue != null && apnsCertificateValue instanceof NullNode == false) {
                                    String apnsCertificateInstance;
                                    apnsCertificateInstance = apnsCertificateValue.getTextValue();
                                    propertiesInstance2.setApnsCertificate(apnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue = propertiesValue9.get("certificateKey");
                                if (certificateKeyValue != null && certificateKeyValue instanceof NullNode == false) {
                                    String certificateKeyInstance;
                                    certificateKeyInstance = certificateKeyValue.getTextValue();
                                    propertiesInstance2.setCertificateKey(certificateKeyInstance);
                                }
                                
                                JsonNode endpointValue = propertiesValue9.get("endpoint");
                                if (endpointValue != null && endpointValue instanceof NullNode == false) {
                                    String endpointInstance;
                                    endpointInstance = endpointValue.getTextValue();
                                    propertiesInstance2.setEndpoint(endpointInstance);
                                }
                                
                                JsonNode thumbprintValue = propertiesValue9.get("thumbprint");
                                if (thumbprintValue != null && thumbprintValue instanceof NullNode == false) {
                                    String thumbprintInstance;
                                    thumbprintInstance = thumbprintValue.getTextValue();
                                    propertiesInstance2.setThumbprint(thumbprintInstance);
                                }
                            }
                        }
                        
                        JsonNode wnsCredentialValue2 = propertiesValue8.get("wnsCredential");
                        if (wnsCredentialValue2 != null && wnsCredentialValue2 instanceof NullNode == false) {
                            WnsCredential wnsCredentialInstance = new WnsCredential();
                            propertiesInstance.setWnsCredential(wnsCredentialInstance);
                            
                            JsonNode propertiesValue10 = wnsCredentialValue2.get("properties");
                            if (propertiesValue10 != null && propertiesValue10 instanceof NullNode == false) {
                                WnsCredentialProperties propertiesInstance3 = new WnsCredentialProperties();
                                wnsCredentialInstance.setProperties(propertiesInstance3);
                                
                                JsonNode packageSidValue = propertiesValue10.get("packageSid");
                                if (packageSidValue != null && packageSidValue instanceof NullNode == false) {
                                    String packageSidInstance;
                                    packageSidInstance = packageSidValue.getTextValue();
                                    propertiesInstance3.setPackageSid(packageSidInstance);
                                }
                                
                                JsonNode secretKeyValue = propertiesValue10.get("secretKey");
                                if (secretKeyValue != null && secretKeyValue instanceof NullNode == false) {
                                    String secretKeyInstance;
                                    secretKeyInstance = secretKeyValue.getTextValue();
                                    propertiesInstance3.setSecretKey(secretKeyInstance);
                                }
                                
                                JsonNode windowsLiveEndpointValue = propertiesValue10.get("windowsLiveEndpoint");
                                if (windowsLiveEndpointValue != null && windowsLiveEndpointValue instanceof NullNode == false) {
                                    String windowsLiveEndpointInstance;
                                    windowsLiveEndpointInstance = windowsLiveEndpointValue.getTextValue();
                                    propertiesInstance3.setWindowsLiveEndpoint(windowsLiveEndpointInstance);
                                }
                            }
                        }
                        
                        JsonNode gcmCredentialValue2 = propertiesValue8.get("gcmCredential");
                        if (gcmCredentialValue2 != null && gcmCredentialValue2 instanceof NullNode == false) {
                            GcmCredential gcmCredentialInstance = new GcmCredential();
                            propertiesInstance.setGcmCredential(gcmCredentialInstance);
                            
                            JsonNode propertiesValue11 = gcmCredentialValue2.get("properties");
                            if (propertiesValue11 != null && propertiesValue11 instanceof NullNode == false) {
                                GcmCredentialProperties propertiesInstance4 = new GcmCredentialProperties();
                                gcmCredentialInstance.setProperties(propertiesInstance4);
                                
                                JsonNode gcmEndpointValue = propertiesValue11.get("gcmEndpoint");
                                if (gcmEndpointValue != null && gcmEndpointValue instanceof NullNode == false) {
                                    String gcmEndpointInstance;
                                    gcmEndpointInstance = gcmEndpointValue.getTextValue();
                                    propertiesInstance4.setGcmEndpoint(gcmEndpointInstance);
                                }
                                
                                JsonNode googleApiKeyValue = propertiesValue11.get("googleApiKey");
                                if (googleApiKeyValue != null && googleApiKeyValue instanceof NullNode == false) {
                                    String googleApiKeyInstance;
                                    googleApiKeyInstance = googleApiKeyValue.getTextValue();
                                    propertiesInstance4.setGoogleApiKey(googleApiKeyInstance);
                                }
                            }
                        }
                        
                        JsonNode mpnsCredentialValue2 = propertiesValue8.get("mpnsCredential");
                        if (mpnsCredentialValue2 != null && mpnsCredentialValue2 instanceof NullNode == false) {
                            MpnsCredential mpnsCredentialInstance = new MpnsCredential();
                            propertiesInstance.setMpnsCredential(mpnsCredentialInstance);
                            
                            JsonNode propertiesValue12 = mpnsCredentialValue2.get("properties");
                            if (propertiesValue12 != null && propertiesValue12 instanceof NullNode == false) {
                                MpnsCredentialProperties propertiesInstance5 = new MpnsCredentialProperties();
                                mpnsCredentialInstance.setProperties(propertiesInstance5);
                                
                                JsonNode mpnsCertificateValue = propertiesValue12.get("mpnsCertificate");
                                if (mpnsCertificateValue != null && mpnsCertificateValue instanceof NullNode == false) {
                                    String mpnsCertificateInstance;
                                    mpnsCertificateInstance = mpnsCertificateValue.getTextValue();
                                    propertiesInstance5.setMpnsCertificate(mpnsCertificateInstance);
                                }
                                
                                JsonNode certificateKeyValue2 = propertiesValue12.get("certificateKey");
                                if (certificateKeyValue2 != null && certificateKeyValue2 instanceof NullNode == false) {
                                    String certificateKeyInstance2;
                                    certificateKeyInstance2 = certificateKeyValue2.getTextValue();
                                    propertiesInstance5.setCertificateKey(certificateKeyInstance2);
                                }
                                
                                JsonNode thumbprintValue2 = propertiesValue12.get("thumbprint");
                                if (thumbprintValue2 != null && thumbprintValue2 instanceof NullNode == false) {
                                    String thumbprintInstance2;
                                    thumbprintInstance2 = thumbprintValue2.getTextValue();
                                    propertiesInstance5.setThumbprint(thumbprintInstance2);
                                }
                            }
                        }
                        
                        JsonNode admCredentialValue2 = propertiesValue8.get("admCredential");
                        if (admCredentialValue2 != null && admCredentialValue2 instanceof NullNode == false) {
                            AdmCredential admCredentialInstance = new AdmCredential();
                            propertiesInstance.setAdmCredential(admCredentialInstance);
                            
                            JsonNode propertiesValue13 = admCredentialValue2.get("properties");
                            if (propertiesValue13 != null && propertiesValue13 instanceof NullNode == false) {
                                AdmCredentialProperties propertiesInstance6 = new AdmCredentialProperties();
                                admCredentialInstance.setProperties(propertiesInstance6);
                                
                                JsonNode clientIdValue = propertiesValue13.get("clientId");
                                if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                    String clientIdInstance;
                                    clientIdInstance = clientIdValue.getTextValue();
                                    propertiesInstance6.setClientId(clientIdInstance);
                                }
                                
                                JsonNode clientSecretValue = propertiesValue13.get("clientSecret");
                                if (clientSecretValue != null && clientSecretValue instanceof NullNode == false) {
                                    String clientSecretInstance;
                                    clientSecretInstance = clientSecretValue.getTextValue();
                                    propertiesInstance6.setClientSecret(clientSecretInstance);
                                }
                                
                                JsonNode authTokenUrlValue = propertiesValue13.get("authTokenUrl");
                                if (authTokenUrlValue != null && authTokenUrlValue instanceof NullNode == false) {
                                    String authTokenUrlInstance;
                                    authTokenUrlInstance = authTokenUrlValue.getTextValue();
                                    propertiesInstance6.setAuthTokenUrl(authTokenUrlInstance);
                                }
                            }
                        }
                        
                        JsonNode baiduCredentialValue2 = propertiesValue8.get("baiduCredential");
                        if (baiduCredentialValue2 != null && baiduCredentialValue2 instanceof NullNode == false) {
                            BaiduCredential baiduCredentialInstance = new BaiduCredential();
                            propertiesInstance.setBaiduCredential(baiduCredentialInstance);
                            
                            JsonNode propertiesValue14 = baiduCredentialValue2.get("properties");
                            if (propertiesValue14 != null && propertiesValue14 instanceof NullNode == false) {
                                BaiduCredentialProperties propertiesInstance7 = new BaiduCredentialProperties();
                                baiduCredentialInstance.setProperties(propertiesInstance7);
                                
                                JsonNode baiduApiKeyValue = propertiesValue14.get("baiduApiKey");
                                if (baiduApiKeyValue != null && baiduApiKeyValue instanceof NullNode == false) {
                                    String baiduApiKeyInstance;
                                    baiduApiKeyInstance = baiduApiKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduApiKey(baiduApiKeyInstance);
                                }
                                
                                JsonNode baiduEndPointValue = propertiesValue14.get("baiduEndPoint");
                                if (baiduEndPointValue != null && baiduEndPointValue instanceof NullNode == false) {
                                    String baiduEndPointInstance;
                                    baiduEndPointInstance = baiduEndPointValue.getTextValue();
                                    propertiesInstance7.setBaiduEndPoint(baiduEndPointInstance);
                                }
                                
                                JsonNode baiduSecretKeyValue = propertiesValue14.get("baiduSecretKey");
                                if (baiduSecretKeyValue != null && baiduSecretKeyValue instanceof NullNode == false) {
                                    String baiduSecretKeyInstance;
                                    baiduSecretKeyInstance = baiduSecretKeyValue.getTextValue();
                                    propertiesInstance7.setBaiduSecretKey(baiduSecretKeyInstance);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
