/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* Parameters supplied to the CreateOrUpdate Namespace operation.
*/
public class NamespaceCreateOrUpdateParameters {
    private String location;
    
    /**
    * Required. Gets or sets Namespace data center location.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Required. Gets or sets Namespace data center location.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private NamespaceProperties properties;
    
    /**
    * Required. Gets or sets properties of the Namespace.
    * @return The Properties value.
    */
    public NamespaceProperties getProperties() {
        return this.properties;
    }
    
    /**
    * Required. Gets or sets properties of the Namespace.
    * @param propertiesValue The Properties value.
    */
    public void setProperties(final NamespaceProperties propertiesValue) {
        this.properties = propertiesValue;
    }
    
    private HashMap<String, String> tags;
    
    /**
    * Optional. Gets or sets Namespace tags.
    * @return The Tags value.
    */
    public HashMap<String, String> getTags() {
        return this.tags;
    }
    
    /**
    * Optional. Gets or sets Namespace tags.
    * @param tagsValue The Tags value.
    */
    public void setTags(final HashMap<String, String> tagsValue) {
        this.tags = tagsValue;
    }
    
    /**
    * Initializes a new instance of the NamespaceCreateOrUpdateParameters class.
    *
    */
    public NamespaceCreateOrUpdateParameters() {
        this.setTags(new LazyHashMap<String, String>());
    }
    
    /**
    * Initializes a new instance of the NamespaceCreateOrUpdateParameters class
    * with required arguments.
    *
    * @param location Gets or sets Namespace data center location.
    * @param properties Gets or sets properties of the Namespace.
    */
    public NamespaceCreateOrUpdateParameters(String location, NamespaceProperties properties) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.setLocation(location);
        this.setProperties(properties);
    }
}
