/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* NotificationHub properties.
*/
public class NotificationHubProperties {
    private AdmCredential admCredential;
    
    /**
    * Optional. The AdmCredential of the created NotificationHub
    * @return The AdmCredential value.
    */
    public AdmCredential getAdmCredential() {
        return this.admCredential;
    }
    
    /**
    * Optional. The AdmCredential of the created NotificationHub
    * @param admCredentialValue The AdmCredential value.
    */
    public void setAdmCredential(final AdmCredential admCredentialValue) {
        this.admCredential = admCredentialValue;
    }
    
    private ApnsCredential apnsCredential;
    
    /**
    * Optional. The ApnsCredential of the created NotificationHub
    * @return The ApnsCredential value.
    */
    public ApnsCredential getApnsCredential() {
        return this.apnsCredential;
    }
    
    /**
    * Optional. The ApnsCredential of the created NotificationHub
    * @param apnsCredentialValue The ApnsCredential value.
    */
    public void setApnsCredential(final ApnsCredential apnsCredentialValue) {
        this.apnsCredential = apnsCredentialValue;
    }
    
    private ArrayList<SharedAccessAuthorizationRuleProperties> authorizationRules;
    
    /**
    * Optional. The AuthorizationRules of the created NotificationHub
    * @return The AuthorizationRules value.
    */
    public ArrayList<SharedAccessAuthorizationRuleProperties> getAuthorizationRules() {
        return this.authorizationRules;
    }
    
    /**
    * Optional. The AuthorizationRules of the created NotificationHub
    * @param authorizationRulesValue The AuthorizationRules value.
    */
    public void setAuthorizationRules(final ArrayList<SharedAccessAuthorizationRuleProperties> authorizationRulesValue) {
        this.authorizationRules = authorizationRulesValue;
    }
    
    private BaiduCredential baiduCredential;
    
    /**
    * Optional. The BaiduCredential of the created NotificationHub
    * @return The BaiduCredential value.
    */
    public BaiduCredential getBaiduCredential() {
        return this.baiduCredential;
    }
    
    /**
    * Optional. The BaiduCredential of the created NotificationHub
    * @param baiduCredentialValue The BaiduCredential value.
    */
    public void setBaiduCredential(final BaiduCredential baiduCredentialValue) {
        this.baiduCredential = baiduCredentialValue;
    }
    
    private GcmCredential gcmCredential;
    
    /**
    * Optional. The GcmCredential of the created NotificationHub
    * @return The GcmCredential value.
    */
    public GcmCredential getGcmCredential() {
        return this.gcmCredential;
    }
    
    /**
    * Optional. The GcmCredential of the created NotificationHub
    * @param gcmCredentialValue The GcmCredential value.
    */
    public void setGcmCredential(final GcmCredential gcmCredentialValue) {
        this.gcmCredential = gcmCredentialValue;
    }
    
    private MpnsCredential mpnsCredential;
    
    /**
    * Optional. The MpnsCredential of the created NotificationHub
    * @return The MpnsCredential value.
    */
    public MpnsCredential getMpnsCredential() {
        return this.mpnsCredential;
    }
    
    /**
    * Optional. The MpnsCredential of the created NotificationHub
    * @param mpnsCredentialValue The MpnsCredential value.
    */
    public void setMpnsCredential(final MpnsCredential mpnsCredentialValue) {
        this.mpnsCredential = mpnsCredentialValue;
    }
    
    private String name;
    
    /**
    * Optional. The NotificationHub name.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. The NotificationHub name.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String registrationTtl;
    
    /**
    * Optional. The RegistrationTtl of the created NotificationHub
    * @return The RegistrationTtl value.
    */
    public String getRegistrationTtl() {
        return this.registrationTtl;
    }
    
    /**
    * Optional. The RegistrationTtl of the created NotificationHub
    * @param registrationTtlValue The RegistrationTtl value.
    */
    public void setRegistrationTtl(final String registrationTtlValue) {
        this.registrationTtl = registrationTtlValue;
    }
    
    private WnsCredential wnsCredential;
    
    /**
    * Optional. The WnsCredential of the created NotificationHub
    * @return The WnsCredential value.
    */
    public WnsCredential getWnsCredential() {
        return this.wnsCredential;
    }
    
    /**
    * Optional. The WnsCredential of the created NotificationHub
    * @param wnsCredentialValue The WnsCredential value.
    */
    public void setWnsCredential(final WnsCredential wnsCredentialValue) {
        this.wnsCredential = wnsCredentialValue;
    }
    
    /**
    * Initializes a new instance of the NotificationHubProperties class.
    *
    */
    public NotificationHubProperties() {
        this.setAuthorizationRules(new LazyArrayList<SharedAccessAuthorizationRuleProperties>());
    }
}
