/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* Description of a NotificatioHub Resource.
*/
public class NotificationHubResource {
    private String id;
    
    /**
    * Optional. Gets or sets the id of the created NotificatioHub.
    * @return The Id value.
    */
    public String getId() {
        return this.id;
    }
    
    /**
    * Optional. Gets or sets the id of the created NotificatioHub.
    * @param idValue The Id value.
    */
    public void setId(final String idValue) {
        this.id = idValue;
    }
    
    private String location;
    
    /**
    * Optional. Gets or sets datacenter location of the NotificatioHub.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Optional. Gets or sets datacenter location of the NotificatioHub.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private String name;
    
    /**
    * Optional. Gets or sets name of the NotificatioHub.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets or sets name of the NotificatioHub.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private NotificationHubProperties properties;
    
    /**
    * Optional. Gets or sets properties of the NotificatioHub.
    * @return The Properties value.
    */
    public NotificationHubProperties getProperties() {
        return this.properties;
    }
    
    /**
    * Optional. Gets or sets properties of the NotificatioHub.
    * @param propertiesValue The Properties value.
    */
    public void setProperties(final NotificationHubProperties propertiesValue) {
        this.properties = propertiesValue;
    }
    
    private HashMap<String, String> tags;
    
    /**
    * Optional. Gets or sets tags of the NotificatioHub.
    * @return The Tags value.
    */
    public HashMap<String, String> getTags() {
        return this.tags;
    }
    
    /**
    * Optional. Gets or sets tags of the NotificatioHub.
    * @param tagsValue The Tags value.
    */
    public void setTags(final HashMap<String, String> tagsValue) {
        this.tags = tagsValue;
    }
    
    private String type;
    
    /**
    * Optional. Gets or sets resource type of the NotificatioHub.
    * @return The Type value.
    */
    public String getType() {
        return this.type;
    }
    
    /**
    * Optional. Gets or sets resource type of the NotificatioHub.
    * @param typeValue The Type value.
    */
    public void setType(final String typeValue) {
        this.type = typeValue;
    }
    
    /**
    * Initializes a new instance of the NotificationHubResource class.
    *
    */
    public NotificationHubResource() {
        this.setTags(new LazyHashMap<String, String>());
    }
}
