/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* Description of a standard NotificationHub service response error.
*/
public class ResourceError {
    private String code;
    
    /**
    * Required. Gets or sets the error code returned from the service.
    * @return The Code value.
    */
    public String getCode() {
        return this.code;
    }
    
    /**
    * Required. Gets or sets the error code returned from the service.
    * @param codeValue The Code value.
    */
    public void setCode(final String codeValue) {
        this.code = codeValue;
    }
    
    private HashMap<String, String> details;
    
    /**
    * Optional. Gets or sets the error detais.
    * @return The Details value.
    */
    public HashMap<String, String> getDetails() {
        return this.details;
    }
    
    /**
    * Optional. Gets or sets the error detais.
    * @param detailsValue The Details value.
    */
    public void setDetails(final HashMap<String, String> detailsValue) {
        this.details = detailsValue;
    }
    
    private String message;
    
    /**
    * Required. Gets or sets the error message returned from the service.
    * @return The Message value.
    */
    public String getMessage() {
        return this.message;
    }
    
    /**
    * Required. Gets or sets the error message returned from the service.
    * @param messageValue The Message value.
    */
    public void setMessage(final String messageValue) {
        this.message = messageValue;
    }
    
    /**
    * Initializes a new instance of the ResourceError class.
    *
    */
    public ResourceError() {
        this.setDetails(new LazyHashMap<String, String>());
    }
    
    /**
    * Initializes a new instance of the ResourceError class with required
    * arguments.
    *
    * @param code Gets or sets the error code returned from the service.
    * @param message Gets or sets the error message returned from the service.
    */
    public ResourceError(String code, String message) {
        this();
        if (code == null) {
            throw new NullPointerException("code");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.setCode(code);
        this.setMessage(message);
    }
}
