/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.notificationhubs.models;

/**
* Parameters supplied to the CreateOrUpdate Namespace AuthorizationRules.
*/
public class SharedAccessAuthorizationRuleCreateOrUpdateParameters {
    private String location;
    
    /**
    * Optional. Gets or sets Namespace data center location.
    * @return The Location value.
    */
    public String getLocation() {
        return this.location;
    }
    
    /**
    * Optional. Gets or sets Namespace data center location.
    * @param locationValue The Location value.
    */
    public void setLocation(final String locationValue) {
        this.location = locationValue;
    }
    
    private String name;
    
    /**
    * Optional. Gets or sets Name of the Namespace AuthorizationRule.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets or sets Name of the Namespace AuthorizationRule.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private SharedAccessAuthorizationRuleProperties properties;
    
    /**
    * Required. Gets or sets properties of the Namespace AuthorizationRules.
    * @return The Properties value.
    */
    public SharedAccessAuthorizationRuleProperties getProperties() {
        return this.properties;
    }
    
    /**
    * Required. Gets or sets properties of the Namespace AuthorizationRules.
    * @param propertiesValue The Properties value.
    */
    public void setProperties(final SharedAccessAuthorizationRuleProperties propertiesValue) {
        this.properties = propertiesValue;
    }
    
    /**
    * Initializes a new instance of the
    * SharedAccessAuthorizationRuleCreateOrUpdateParameters class.
    *
    */
    public SharedAccessAuthorizationRuleCreateOrUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the
    * SharedAccessAuthorizationRuleCreateOrUpdateParameters class with
    * required arguments.
    *
    * @param properties Gets or sets properties of the Namespace
    * AuthorizationRules.
    */
    public SharedAccessAuthorizationRuleCreateOrUpdateParameters(SharedAccessAuthorizationRuleProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.setProperties(properties);
    }
}
