/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.models.DeploymentOperationsGetResult;
import com.microsoft.azure.management.resources.models.DeploymentOperationsListParameters;
import com.microsoft.azure.management.resources.models.DeploymentOperationsListResult;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

/**
* Operations for managing deployment operations.
*/
public interface DeploymentOperationOperations {
    /**
    * Get a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param operationId Required. Operation Id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return Deployment operation.
    */
    DeploymentOperationsGetResult get(String resourceGroupName, String deploymentName, String operationId) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param operationId Required. Operation Id.
    * @return Deployment operation.
    */
    Future<DeploymentOperationsGetResult> getAsync(String resourceGroupName, String deploymentName, String operationId);
    
    /**
    * Gets a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Optional. Query parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployment operations.
    */
    DeploymentOperationsListResult list(String resourceGroupName, String deploymentName, DeploymentOperationsListParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Gets a list of deployments operations.
    *
    * @param resourceGroupName Required. The name of the resource group. The
    * name is case insensitive.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Optional. Query parameters.
    * @return List of deployment operations.
    */
    Future<DeploymentOperationsListResult> listAsync(String resourceGroupName, String deploymentName, DeploymentOperationsListParameters parameters);
    
    /**
    * Gets a next list of deployments operations.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return List of deployment operations.
    */
    DeploymentOperationsListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Gets a next list of deployments operations.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return List of deployment operations.
    */
    Future<DeploymentOperationsListResult> listNextAsync(String nextLink);
}
